/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.service.MessageListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public class MessageListeners
extends EscObject
implements MessageListener {
    private MessageListener[] objects;

    public static MessageListener add(MessageListener currentObject, MessageListener newObject) {
        if (currentObject == null) {
            return newObject;
        }
        if (newObject == null) {
            return currentObject;
        }
        return new MessageListeners(currentObject, newObject);
    }

    public static MessageListener remove(MessageListener currentObject, MessageListener removeObject) {
        if (currentObject == removeObject) {
            return null;
        }
        if (currentObject instanceof MessageListeners) {
            return ((MessageListeners)currentObject).remove(removeObject);
        }
        return currentObject;
    }

    public MessageListeners(MessageListener currentObject, MessageListener newObject) {
        if (currentObject instanceof MessageListeners) {
            MessageListeners currentMulticaster = (MessageListeners)currentObject;
            MessageListener[] oldList = currentMulticaster.getObjects();
            this.objects = new MessageListener[oldList.length + 1];
            System.arraycopy(oldList, 0, this.objects, 0, oldList.length);
            this.objects[oldList.length] = newObject;
        } else {
            this.objects = new MessageListener[]{currentObject, newObject};
        }
    }

    public MessageListeners(MessageListener[] objects) {
        this.setObjects(objects);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].errorOccurred(source, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    public MessageListener[] getObjects() {
        return this.objects;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        int length = this.objects.length;
        int i = 0;
        while (i < length) {
            try {
                this.objects[i].messageReceived(transportService, timestamp, message);
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
            ++i;
        }
    }

    protected MessageListener remove(MessageListener removeHandler) {
        MessageListener[] oldList = this.getObjects();
        switch (oldList.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (oldList[0] != removeHandler) break;
                return null;
            }
            case 2: {
                if (oldList[1] == removeHandler) {
                    return oldList[0];
                }
                if (oldList[0] != removeHandler) break;
                return oldList[1];
            }
            default: {
                int index = oldList.length - 1;
                while (index >= 0) {
                    if (oldList[index] == removeHandler) {
                        MessageListener[] newList = new MessageListener[oldList.length - 1];
                        if (index == oldList.length - 1) {
                            System.arraycopy(oldList, 0, newList, 0, newList.length);
                        } else {
                            if (index > 0) {
                                System.arraycopy(oldList, 0, newList, 0, index);
                            }
                            System.arraycopy(oldList, index + 1, newList, index, newList.length - index);
                        }
                        return new MessageListeners(newList);
                    }
                    --index;
                }
                break block0;
            }
        }
        return this;
    }

    private void setObjects(MessageListener[] objects) {
        this.objects = objects;
    }
}

