/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.dk.transport.service.TunnelTransportService;

public class TunnelTransport
extends Transport
implements TunnelTransportService,
TransportListener {
    private TransportService transport;

    public TunnelTransport(TransportService transport, short style) {
        super(style);
        this.setTransport(transport);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
    }

    public void fireTransportChanged(TransportService source, Object timestamp, int newState, int oldState) {
        int combinedState = this.getCombinedState();
        if (newState != combinedState) {
            super.fireTransportChanged(source, timestamp, combinedState, oldState);
        }
    }

    public int getCombinedState() {
        int myState;
        int transportState = 2;
        TransportService transport = this.getTransport();
        if (transport != null) {
            transportState = transport.getState();
        }
        if ((myState = this.getState()) > transportState) {
            return transportState;
        }
        return myState;
    }

    public TransportService getTransport() {
        return this.transport;
    }

    public void getTransport(TransportService transport) {
        this.transport = transport;
    }

    public boolean isActive() {
        return super.isActive() && this.getTransport() != null;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        this.fireMessageReceived(timestamp, message);
    }

    public void register(TransportService transport) {
        if (transport != null) {
            transport.addTransportListener((TransportListener)this);
        }
    }

    public void setTransport(TransportService transport) {
        if (this.getState() >= 2) {
            this.stop();
            this.unregister(this.transport);
            this.transport = transport;
            this.start();
        } else {
            this.unregister(this.transport);
            this.transport = transport;
        }
        if (this.transport != null) {
            this.register(this.transport);
        }
    }

    public void start() {
        if (!this.isActive()) {
            super.start();
            TransportService transport = this.getTransport();
            if (transport != null) {
                transport.start();
            }
        }
    }

    public void stop() {
        TransportService transport = this.getTransport();
        if (transport != null) {
            transport.stop();
        }
        super.stop();
    }

    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        this.fireTransportChanged(transportService, timestamp, newState, oldState);
    }

    public void unregister(TransportService transport) {
        if (transport != null) {
            transport.removeTransportListener((TransportListener)this);
        }
    }

    public void write(byte[] bytes) throws Exception {
        if (this.transport != null) {
            this.transport.write(bytes);
        }
    }

    protected void write(MessageService message) throws Exception {
        if (this.transport != null) {
            this.transport.send(message);
        }
    }
}

