/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.url.connection;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.url.connection.service.UrlConnectionService;

public class UrlConnection
extends StreamConnection
implements ConnectionService,
UrlConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.url.connection.UrlConnection";
    protected static final char[] TOSTRING_NAME = "UrlConnection[".toCharArray();
    private URLConnection urlConnection;
    private String name;

    public UrlConnection(ConfigurationService configuration) {
        this(configuration.getString("url", "http://localhost"));
    }

    public UrlConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public UrlConnection(String name) {
        this.name = name;
    }

    public synchronized void close() throws IOException {
        super.close();
        if (this.urlConnection != null) {
            this.urlConnection = null;
            this.handleError(null, 1002, this.toString());
        }
    }

    public synchronized void open() throws IOException {
        URL theUrl = new URL(this.name);
        this.urlConnection = theUrl.openConnection();
        this.setInputStream(this.urlConnection.getInputStream());
        super.open();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(TOSTRING_NAME);
        buffer.append(this.urlConnection);
        buffer.append(']');
        return buffer.toString();
    }
}

