/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle.log.test;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.junit.internal.bundle.Activator;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.service.LogReaderAggregatorService;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class LogReaderAggregatorTestCase
extends AbstractServiceTestCase {
    private static final String LOG_READER_SERVICE_NAME;
    private IExportServiceRecord logReaderService1;
    private IExportServiceRecord logReaderService2;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.log.LogReaderService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_READER_SERVICE_NAME = clazz.getName();
    }

    public static Test suite() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.framework.bundle.log.test.LogReaderAggregatorTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public LogReaderAggregatorTestCase(String name) {
        super(name);
    }

    private List asListOfMessages(Enumeration enumeration) {
        ArrayList<String> list = new ArrayList<String>(100);
        while (enumeration.hasMoreElements()) {
            LogEntry entry = (LogEntry)enumeration.nextElement();
            String message = entry.getMessage();
            list.add(message);
        }
        list.trimToSize();
        return list;
    }

    private Runnable createLoggingRunnable(final Log log, final int count) {
        return new Runnable(){

            public void run() {
                LogReaderAggregatorTestCase.this.process(log, count);
            }
        };
    }

    private void drain(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Log getLog(IExportServiceRecord record) {
        Log log = null;
        LogReaderAggregatorTestCase logReaderAggregatorTestCase = this;
        synchronized (logReaderAggregatorTestCase) {
            if (record != null) {
                log = (Log)record.getService();
            }
        }
        return log;
    }

    private Log getLog1() {
        return this.getLog(this.logReaderService1);
    }

    private Log getLog2() {
        return this.getLog(this.logReaderService2);
    }

    private LogReaderAggregatorService getLogReaderAggregatorService() {
        return Activator.LOG_READER_AGGREGATOR_SERVICE;
    }

    private void joinWithLoggingThreads(List threads) throws InterruptedException {
        Iterator iterator = threads.iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            thread.join();
        }
    }

    private void process(Log log, int count) {
        int i = 0;
        while (i < count) {
            String message = String.valueOf(count);
            log.log(3, message);
            Thread.yield();
            ++i;
        }
    }

    private IExportServiceRecord registerLogReaderService(Log log) {
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IExportServiceRecord record = utility.createExportServiceRecord(bundleContext, LOG_READER_SERVICE_NAME, (Object)log, null);
        record.register();
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLogReaderService1() {
        LogReaderAggregatorTestCase logReaderAggregatorTestCase = this;
        synchronized (logReaderAggregatorTestCase) {
            if (this.logReaderService1 != null) {
                return;
            }
            Log log = new Log();
            this.logReaderService1 = this.registerLogReaderService(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLogReaderService2() {
        LogReaderAggregatorTestCase logReaderAggregatorTestCase = this;
        synchronized (logReaderAggregatorTestCase) {
            if (this.logReaderService2 != null) {
                return;
            }
            Log log = new Log();
            this.logReaderService2 = this.registerLogReaderService(log);
        }
    }

    private Thread startLoggingThread(int id, Log log, int count) {
        Runnable runnable = this.createLoggingRunnable(log, count);
        String name = "LoggingThread-" + id;
        Thread thread = new Thread(runnable, name);
        thread.start();
        return thread;
    }

    private List startLoggingThreads(Log log, int count, int threadCount) {
        ArrayList<Thread> threads = new ArrayList<Thread>(threadCount);
        int i = 0;
        while (i < threadCount) {
            Thread thread = this.startLoggingThread(i, log, count);
            threads.add(thread);
            ++i;
        }
        return threads;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_addLogListener() {
        final ValueHolder holder = ValueHolder.zeroValue();
        LogListener listener1 = new LogListener(){

            public void logged(LogEntry entry) {
                String message = entry.getMessage();
                boolean match = "message".equals(message);
                if (!match) {
                    return;
                }
                holder.increment();
            }
        };
        boolean state = holder.isZero();
        Assert.assertTrue((boolean)state);
        LogReaderAggregatorService aggregator = this.getLogReaderAggregatorService();
        try {
            this.registerLogReaderService1();
            aggregator.addLogListener(listener1);
            aggregator.addLogListener(listener1);
            Log log = this.getLog1();
            log.log(3, "message");
            int expectedValue = 1;
            int actualValue = holder.getIntValue();
            Assert.assertEquals((int)expectedValue, (int)actualValue);
            holder.setZero();
            aggregator.removeLogListener(listener1);
            log.log(3, "message");
            state = holder.isZero();
            Assert.assertTrue((boolean)state);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            aggregator.removeLogListener(listener1);
            this.unregisterLogReaderService1();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        aggregator.removeLogListener(listener1);
        this.unregisterLogReaderService1();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_concurrent() throws Exception {
        final ValueHolder holder = ValueHolder.zeroValue();
        LogListener listener = new LogListener(){

            public void logged(LogEntry entry) {
                holder.increment();
            }
        };
        LogReaderAggregatorService aggregator = this.getLogReaderAggregatorService();
        try {
            this.registerLogReaderService1();
            Log log = this.getLog1();
            aggregator.addLogListener(listener);
            int count = 150;
            int threadCount = 3;
            List threads = this.startLoggingThreads(log, count, threadCount);
            this.joinWithLoggingThreads(threads);
            int expected = count * threadCount;
            int actual = holder.getIntValue();
            Assert.assertTrue((actual >= expected ? 1 : 0) != 0);
            aggregator.removeLogListener(listener);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            aggregator.removeLogListener(listener);
            this.unregisterLogReaderService1();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        aggregator.removeLogListener(listener);
        this.unregisterLogReaderService1();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_count() {
        final ValueHolder holder = ValueHolder.zeroValue();
        LogListener listener = new LogListener(){

            public void logged(LogEntry entry) {
                holder.increment();
            }
        };
        LogReaderAggregatorService aggregator = this.getLogReaderAggregatorService();
        try {
            this.registerLogReaderService1();
            Log log = this.getLog1();
            aggregator.addLogListener(listener);
            log.log(3, "one");
            log.log(3, "two");
            log.log(3, "three");
            log.log(3, "four");
            int expected = 4;
            int actual = holder.getIntValue();
            Assert.assertTrue((actual >= expected ? 1 : 0) != 0);
            aggregator.removeLogListener(listener);
            holder.setZero();
            aggregator.addLogListener(listener);
            boolean state = holder.isZero();
            Assert.assertTrue((boolean)state);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            aggregator.removeLogListener(listener);
            this.unregisterLogReaderService1();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        aggregator.removeLogListener(listener);
        this.unregisterLogReaderService1();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_drain() {
        LogReaderAggregatorService aggregator;
        LogListener listener;
        block4: {
            Log log = new Log();
            log.log(3, "one");
            log.log(3, "two");
            log.log(3, "three");
            log.log(3, "four");
            final ValueHolder holder = ValueHolder.zeroValue();
            listener = new LogListener(){

                public void logged(LogEntry entry) {
                    holder.increment();
                }
            };
            aggregator = this.getLogReaderAggregatorService();
            IExportServiceRecord record = null;
            try {
                aggregator.addLogListener(listener);
                record = this.registerLogReaderService(log);
                int expected = 4;
                int actual = holder.getIntValue();
                Assert.assertTrue((actual >= expected ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (record != null) {
                    record.unregister();
                }
                aggregator.removeLogListener(listener);
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (record == null) break block4;
            }
            record.unregister();
        }
        aggregator.removeLogListener(listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_getLog() {
        LogReaderAggregatorService aggregator = this.getLogReaderAggregatorService();
        Enumeration enumeration = aggregator.getLog();
        this.drain(enumeration);
        try {
            this.registerLogReaderService1();
            this.registerLogReaderService2();
            Log log1 = this.getLog1();
            Log log2 = this.getLog1();
            log1.log(3, "one");
            log2.log(3, "two");
            log1.log(3, "three");
            log2.log(3, "four");
            enumeration = aggregator.getLog();
            List messages = this.asListOfMessages(enumeration);
            boolean exists = messages.contains("four");
            Assert.assertTrue((boolean)exists);
            exists = messages.contains("three");
            Assert.assertTrue((boolean)exists);
            exists = messages.contains("two");
            Assert.assertTrue((boolean)exists);
            exists = messages.contains("one");
            Assert.assertTrue((boolean)exists);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.unregisterLogReaderService2();
            this.unregisterLogReaderService1();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.unregisterLogReaderService2();
            this.unregisterLogReaderService1();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_getLogInOrder() {
        LogReaderAggregatorService aggregator = this.getLogReaderAggregatorService();
        Enumeration enumeration = aggregator.getLogInOrder();
        try {
            this.registerLogReaderService1();
            this.registerLogReaderService2();
            Log log1 = this.getLog1();
            Log log2 = this.getLog1();
            log1.log(3, "one");
            log2.log(3, "two");
            log1.log(3, "three");
            log2.log(3, "four");
            enumeration = aggregator.getLogInOrder();
            List messages = this.asListOfMessages(enumeration);
            boolean empty = messages.isEmpty();
            Assert.assertFalse((boolean)empty);
            int indexOfOne = messages.indexOf("one");
            int indexOfTwo = messages.indexOf("two");
            int indexOfThree = messages.indexOf("three");
            int indexOfFour = messages.indexOf("four");
            Assert.assertTrue((indexOfOne != -1 ? 1 : 0) != 0);
            Assert.assertTrue((indexOfTwo != -1 ? 1 : 0) != 0);
            Assert.assertTrue((indexOfThree != -1 ? 1 : 0) != 0);
            Assert.assertTrue((indexOfFour != -1 ? 1 : 0) != 0);
            Assert.assertTrue((indexOfOne < indexOfTwo ? 1 : 0) != 0);
            Assert.assertTrue((indexOfTwo < indexOfThree ? 1 : 0) != 0);
            Assert.assertTrue((indexOfThree < indexOfFour ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.unregisterLogReaderService2();
            this.unregisterLogReaderService1();
            throw throwable;
        }
        {
            Object var11_13 = null;
            this.unregisterLogReaderService2();
            this.unregisterLogReaderService1();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_multipleListeners() {
        final ValueHolder valueHolder1 = ValueHolder.falseValue();
        LogListener listener1 = new LogListener(){

            public void logged(LogEntry entry) {
                String message = entry.getMessage();
                boolean state = message.equals("test");
                valueHolder1.setValue(state);
            }
        };
        final ValueHolder valueHolder2 = ValueHolder.falseValue();
        LogListener listener2 = new LogListener(){

            public void logged(LogEntry entry) {
                String message = entry.getMessage();
                boolean state = message.equals("test");
                valueHolder2.setValue(state);
            }
        };
        LogReaderAggregatorService aggregator = this.getLogReaderAggregatorService();
        try {
            this.registerLogReaderService1();
            Log log = this.getLog1();
            aggregator.addLogListener(listener1);
            aggregator.addLogListener(listener2);
            log.log(3, "test");
            boolean state = valueHolder1.isTrue();
            Assert.assertTrue((boolean)state);
            state = valueHolder2.isTrue();
            Assert.assertTrue((boolean)state);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.unregisterLogReaderService1();
            aggregator.removeLogListener(listener2);
            aggregator.removeLogListener(listener1);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.unregisterLogReaderService1();
        }
        aggregator.removeLogListener(listener2);
        aggregator.removeLogListener(listener1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_multipleLogs() {
        final ArrayList messages = new ArrayList(6);
        LogListener listener = new LogListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void logged(LogEntry entry) {
                List list = messages;
                synchronized (list) {
                    String message = entry.getMessage();
                    messages.add(message);
                }
            }
        };
        LogReaderAggregatorService aggregator = this.getLogReaderAggregatorService();
        Log log1 = null;
        Log log2 = null;
        try {
            this.registerLogReaderService1();
            this.registerLogReaderService2();
            log1 = this.getLog1();
            log2 = this.getLog2();
            aggregator.addLogListener(listener);
            log1.log(3, "one");
            log1.log(3, "two");
            log2.log(3, "three");
            log2.log(3, "four");
            boolean state = messages.contains("one");
            Assert.assertTrue((boolean)state);
            state = messages.contains("two");
            Assert.assertTrue((boolean)state);
            state = messages.contains("three");
            Assert.assertTrue((boolean)state);
            state = messages.contains("four");
            Assert.assertTrue((boolean)state);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.unregisterLogReaderService2();
            this.unregisterLogReaderService1();
            aggregator.removeLogListener(listener);
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.unregisterLogReaderService2();
            this.unregisterLogReaderService1();
        }
        aggregator.removeLogListener(listener);
        int expectedSize = 4;
        int actualSize = messages.size();
        Assert.assertTrue((actualSize >= expectedSize ? 1 : 0) != 0);
        expectedSize = actualSize;
        log1.log(3, "info3");
        log2.log(3, "info4");
        actualSize = messages.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_simple() {
        try {
            this.registerLogReaderService1();
            Log log = this.getLog1();
            Enumeration enumeration = log.getLog();
            boolean state = enumeration.hasMoreElements();
            Assert.assertFalse((boolean)state);
            log.log(3, "test");
            enumeration = log.getLog();
            state = enumeration.hasMoreElements();
            Assert.assertTrue((boolean)state);
            LogEntry entry = (LogEntry)enumeration.nextElement();
            Assert.assertNotNull((Object)entry);
            String expectedMessage = "test";
            String actualMessage = entry.getMessage();
            Assert.assertEquals((String)expectedMessage, (String)actualMessage);
            int expectedLevel = 3;
            int actualLevel = entry.getLevel();
            Assert.assertEquals((int)expectedLevel, (int)actualLevel);
            long now = System.currentTimeMillis();
            long actualTime = entry.getTime();
            boolean beforeNow = actualTime <= now;
            Assert.assertTrue((boolean)beforeNow);
            state = enumeration.hasMoreElements();
            Assert.assertFalse((boolean)state);
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            this.unregisterLogReaderService1();
            throw throwable;
        }
        {
            Object var14_14 = null;
            this.unregisterLogReaderService1();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_simpleException() {
        try {
            this.registerLogReaderService1();
            Log log = this.getLog1();
            Enumeration enumeration = log.getLog();
            boolean state = enumeration.hasMoreElements();
            Assert.assertFalse((boolean)state);
            RuntimeException exception = new RuntimeException();
            log.log(3, "error", exception);
            enumeration = log.getLog();
            state = enumeration.hasMoreElements();
            Assert.assertTrue((boolean)state);
            LogEntry entry = (LogEntry)enumeration.nextElement();
            Assert.assertNotNull((Object)entry);
            Throwable actualException = entry.getException();
            Assert.assertSame((Object)exception, (Object)actualException);
            state = enumeration.hasMoreElements();
            Assert.assertFalse((boolean)state);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.unregisterLogReaderService1();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.unregisterLogReaderService1();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterLogReaderService1() {
        LogReaderAggregatorTestCase logReaderAggregatorTestCase = this;
        synchronized (logReaderAggregatorTestCase) {
            if (this.logReaderService1 == null) {
                return;
            }
            this.logReaderService1.unregister();
            this.logReaderService1 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterLogReaderService2() {
        LogReaderAggregatorTestCase logReaderAggregatorTestCase = this;
        synchronized (logReaderAggregatorTestCase) {
            if (this.logReaderService2 == null) {
                return;
            }
            this.logReaderService2.unregister();
            this.logReaderService2 = null;
        }
    }

    private static class Log
    implements LogService,
    LogReaderService {
        private List entries = new ArrayList(100);
        private List listeners = new ArrayList(5);

        private Log() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLogListener(LogListener listener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        private LogEntry createLogEntry(ServiceReference reference, int level, String message, Throwable exception) {
            long now = System.currentTimeMillis();
            return new LogEntry(this, reference, exception, level, message, now){
                final /* synthetic */ Log this$1;
                private final /* synthetic */ ServiceReference val$reference;
                private final /* synthetic */ Throwable val$exception;
                private final /* synthetic */ int val$level;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ long val$now;
                {
                    this.this$1 = log;
                    this.val$reference = serviceReference;
                    this.val$exception = throwable;
                    this.val$level = n;
                    this.val$message = string;
                    this.val$now = l;
                }

                public Bundle getBundle() {
                    if (this.val$reference == null) {
                        return null;
                    }
                    Bundle bundle = this.val$reference.getBundle();
                    return bundle;
                }

                public Throwable getException() {
                    return this.val$exception;
                }

                public int getLevel() {
                    return this.val$level;
                }

                public String getMessage() {
                    return this.val$message;
                }

                public ServiceReference getServiceReference() {
                    return this.val$reference;
                }

                public long getTime() {
                    return this.val$now;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration getLog() {
            Log log = this;
            synchronized (log) {
                int size = this.entries.size();
                Vector<LogEntry> vector = new Vector<LogEntry>(size);
                int i = size - 1;
                while (i >= 0) {
                    LogEntry entry = (LogEntry)this.entries.get(i);
                    vector.add(entry);
                    --i;
                }
                Enumeration enumeration = vector.elements();
                return enumeration;
            }
        }

        public void log(int level, String message) {
            this.log(null, level, message, null);
        }

        public void log(int level, String message, Throwable exception) {
            this.log(null, level, message, exception);
        }

        public void log(ServiceReference reference, int level, String message) {
            this.log(reference, level, message, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(ServiceReference reference, int level, String message, Throwable exception) {
            LogEntry entry = this.createLogEntry(reference, level, message, exception);
            Log log = this;
            synchronized (log) {
                this.entries.add(entry);
            }
            this.notifyListeners(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(LogEntry entry) {
            List list = this.listeners;
            synchronized (list) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    LogListener listener = (LogListener)iterator.next();
                    listener.logged(entry);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLogListener(LogListener listener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

