/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManagerOwner;
import org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleDependencyManager;
import org.eclipse.soda.sat.core.internal.framework.bundle.BundleUninstallManager;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.WarningMessageUtility;
import org.eclipse.soda.sat.core.record.container.interfaces.IExportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerLenientOwner;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerOwner;
import org.eclipse.soda.sat.core.record.container.interfaces.IServiceRecordAction;
import org.eclipse.soda.sat.core.record.interfaces.IExportProxyServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.eclipse.soda.sat.core.util.CollectionUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.startlevel.StartLevel;

public class BundleActivationManager
implements IBundleActivationManager {
    private static final String ASYNC_START_UP_KEY = "BundleActivationManager.AsyncStartUp";
    private static final String ASYNC_START_UP_THREAD_HAS_STOPPED_KEY = "BundleActivationManager.AsyncStartUpThreadHasStopped";
    private static final String BUNDLE_ACTIVATION_MANAGER_IS_NOT_STARTED_KEY = "BundleActivationManager.BundleActivationManagerIsNotStarted";
    private static final String BUNDLES_SHOULD_BE_TRANSIENT_OR_UNINSTALLABLE_NOT_BOTH_KEY = "BundleActivationManager.BundleShouldBeTransientOrUninstallableNotBoth";
    private static final String CLASS_KEY = "BundleActivationManager.Class";
    private static IServiceRecordAction collectExportedServicesAction;
    private static IServiceRecordAction collectImportedServicesAction;
    private static final String FAILED_TO_ACQUIRE_THE_FOLLOWING_SERVICES_KEY = "BundleActivationManager.FailedToAcquireTheFollowingServices";
    private static final String FAILED_TO_GET_IMPORTED_SERVICE_KEY = "BundleActivationManager.FailedToGetImportedService";
    private static final String FAILED_TO_GET_PROPERTIES_KEY = "BundleActivationManager.FailedToGetProperties";
    private static final String FRAMEWORK_RESTARTED_BY_KEY = "BundleActivationManager.FrameworkRestartedBy";
    private static final String FRAMEWORK_SHUTDOWN_BY_KEY = "BundleActivationManager.FrameworkShutdownBy";
    private static final String INVALID_LDAP_FILTER_KEY = "BundleActivationManager.InvalidLdapFilter";
    private static final String SAT_CORE_KEY = "Common.SatCore";
    private static final String SERVICE_KEY = "Common.Service";
    private static final String NO_ID = "$NO_ID$";
    private static final String UNKNOWN_BUNDLE_CONTEXT_KEY = "Common.UnknownBundleContext";
    private static final String WAITING_FOR_ASYNC_START_UP_THREAD_TO_STOP_KEY = "BundleActivationManager.WaitingForAsyncStartUpThreadToStop";
    private boolean activated;
    private final Object activationLock = new Object();
    private Thread asyncStartThread;
    private BundleContext bundleContext;
    private IExportServiceRecordContainer exportServiceRecords;
    private String id;
    private Map importedServiceFilters;
    private IImportServiceRecordContainer importServiceRecords;
    private Map optionalImportedServiceFilters;
    private IImportServiceRecordContainer optionalImportServiceRecords;
    private IBundleActivationManagerOwner owner;
    private Properties properties;
    private final Object startLock = new Object();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static void collectServices(IExportServiceRecord record, Map map) {
        String[] names = record.getNames();
        Object service = record.getService();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            ArrayList<Object> value = (ArrayList<Object>)map.get(name);
            if (value == null) {
                value = new ArrayList<Object>(3);
                map.put(name, value);
            }
            value.add(service);
            ++i;
        }
    }

    private static void collectServices(IImportServiceRecord record, Map map) {
        String name = record.getName();
        Object service = record.getService();
        map.put(name, service);
    }

    private static IServiceRecordAction createCollectExportedServicesAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IExportServiceRecord exportServiceRecord = (IExportServiceRecord)record;
                Map map = (Map)parameter;
                BundleActivationManager.collectServices(exportServiceRecord, map);
                return true;
            }
        };
    }

    private static IServiceRecordAction createCollectImportedServicesAction() {
        return new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                IImportServiceRecord importServiceRecord = (IImportServiceRecord)record;
                Map map = (Map)parameter;
                BundleActivationManager.collectServices(importServiceRecord, map);
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getCollectExportedServicesAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.framework.bundle.BundleActivationManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (collectExportedServicesAction == null) {
                BundleActivationManager.setCollectExportedServicesAction(BundleActivationManager.createCollectExportedServicesAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return collectExportedServicesAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IServiceRecordAction getCollectImportedServicesAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.framework.bundle.BundleActivationManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (collectImportedServicesAction == null) {
                BundleActivationManager.setCollectImportedServicesAction(BundleActivationManager.createCollectImportedServicesAction());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return collectImportedServicesAction;
        }
    }

    private static void setCollectExportedServicesAction(IServiceRecordAction collectExportedServicesAction) {
        BundleActivationManager.collectExportedServicesAction = collectExportedServicesAction;
    }

    private static void setCollectImportedServicesAction(IServiceRecordAction collectImportedServicesAction) {
        BundleActivationManager.collectImportedServicesAction = collectImportedServicesAction;
    }

    public BundleActivationManager() {
        this.setActivated(false);
    }

    public BundleActivationManager(String id) {
        this();
        this.setId(id);
    }

    public Object acquireImportedService(String name) {
        IImportServiceRecord record = this.getImportServiceRecord(name);
        Object service = this.acquireImportServiceRecord(record);
        return service;
    }

    public void acquireImportedServices() {
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        container.acquire();
        this.logTraceOfUnacquiredImportedServices();
    }

    private Object acquireImportServiceRecord(IImportServiceRecord record) {
        if (record == null) {
            return null;
        }
        record.acquire();
        Object service = record.getService();
        return service;
    }

    private void acquireImportServiceRecords() {
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        IImportServiceRecordContainerOwner owner = this.createImportServiceRecordContainerOwner();
        container.setOwner(owner);
        this.acquireImportedServices();
    }

    public Object acquireOptionalImportedService(String name) {
        IImportServiceRecord record = this.getOptionalImportServiceRecord(name);
        Object service = this.acquireImportServiceRecord(record);
        return service;
    }

    public void acquireOptionalImportedServices() {
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        container.acquire();
    }

    private void acquireOptionalImportServiceRecords() {
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        IImportServiceRecordContainerOwner owner = this.createOptionalImportServiceRecordContainerOwner();
        container.setOwner(owner);
        this.acquireOptionalImportedServices();
    }

    private void activate() {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.activate();
    }

    public void addExportedProxyService(Class interfaceType, IProxyServiceHandler handler, Dictionary properties) {
        IExportProxyServiceRecord record = this.createExportProxyServiceRecord(interfaceType, handler, properties);
        this.addExportServiceRecord(record);
    }

    public void addExportedProxyServices(Class[] interfaceTypes, IProxyServiceHandler handler, Dictionary properties) {
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IExportProxyServiceRecord record = factory.createExportProxyServiceRecord(bundleContext, interfaceTypes, handler, properties);
        this.addExportServiceRecord(record);
    }

    public void addExportedService(String name, Object service, Dictionary properties) {
        IExportServiceRecord record = this.createExportServiceRecord(name, service, properties);
        this.addExportServiceRecord(record);
    }

    public void addExportedServices(String[] names, Object service, Dictionary properties) {
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IExportServiceRecord record = factory.createExportServiceRecord(bundleContext, names, service, properties);
        this.addExportServiceRecord(record);
    }

    public void addExportServiceRecord(IExportServiceRecord record) {
        this.checkIsStarted();
        this.checkExportedServiceRecord(record);
        IExportServiceRecordContainer container = this.getExportServiceRecords();
        boolean added = container.add(record);
        if (!added) {
            return;
        }
        boolean register = this.isActivated();
        if (!register) {
            return;
        }
        record.register();
    }

    public void addExportServiceRecords(IExportServiceRecord[] records) {
        this.checkExportServiceRecords(records);
        int size = records.length;
        if (size == 0) {
            return;
        }
        IExportServiceRecordContainer container = this.getExportServiceRecords();
        int i = 0;
        while (i < size) {
            IExportServiceRecord record = records[i];
            container.add(record);
            ++i;
        }
        boolean register = this.isActivated();
        if (!register) {
            return;
        }
        this.registerExportServiceRecords(records);
    }

    public void addImportedServiceFilter(String name, String filterString) {
        Map filters = this.getImportedServiceFilters();
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        this.addImportedServiceFilter(name, filterString, filters, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImportedServiceFilter(String name, String filterString, Map filters, IImportServiceRecordContainer container) {
        Assertion.checkArgumentIsNotNull(name, "name");
        Assertion.checkArgumentIsNotNull(filterString, "filterString");
        this.checkIsStarted();
        BundleContext bundleContext = this.getBundleContext();
        try {
            Filter filter = bundleContext.createFilter(filterString);
            Map map = filters;
            synchronized (map) {
                filters.put(name, filter);
            }
            IImportServiceRecord record = (IImportServiceRecord)container.get(name);
            if (record == null) {
                return;
            }
            record.setFilter(filter);
        }
        catch (InvalidSyntaxException exception) {
            String pattern = Messages.getString(INVALID_LDAP_FILTER_KEY);
            String message = MessageFormatter.format(pattern, filterString);
            LogUtility.logError(this, message, exception);
        }
    }

    public void addImportServiceRecord(IImportServiceRecord record) {
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        boolean exists = container.contains(record);
        if (exists) {
            return;
        }
        container.add(record);
    }

    public void addOptionalImportedServiceFilter(String name, String filterString) {
        Map filters = this.getOptionalImportedServiceFilters();
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        this.addImportedServiceFilter(name, filterString, filters, container);
    }

    private void checkExportedServiceRecord(IExportServiceRecord record) {
        Assertion.checkArgumentIsNotNull(record, "record");
        BundleContext bundleContext = this.getBundleContext();
        BundleContext recordBundleContext = record.getBundleContext();
        boolean match = recordBundleContext.equals(bundleContext);
        if (match) {
            return;
        }
        String message = Messages.getString(UNKNOWN_BUNDLE_CONTEXT_KEY);
        throw new IllegalArgumentException(message);
    }

    private void checkExportServiceRecords(IExportServiceRecord[] records) {
        Assertion.checkArgumentIsNotNull(records, "records");
        int i = 0;
        while (i < records.length) {
            IExportServiceRecord record = records[i];
            this.checkExportedServiceRecord(record);
            ++i;
        }
    }

    private void checkImportedServiceIsNotNull(String name, Object service) {
        if (service != null) {
            return;
        }
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        String component = Messages.getString(SAT_CORE_KEY);
        String source = this.getBundleSymbolicName();
        String label = Messages.getString(SERVICE_KEY);
        String warning = Messages.getString(FAILED_TO_GET_IMPORTED_SERVICE_KEY);
        utility.warn(component, source, warning, label, name);
    }

    private void checkIsStarted() {
        boolean started = this.isStarted();
        if (started) {
            return;
        }
        String message = Messages.getString(BUNDLE_ACTIVATION_MANAGER_IS_NOT_STARTED_KEY);
        throw new RuntimeException(message);
    }

    private void checkUninstallPolicy() {
        WarningMessageUtility utility = WarningMessageUtility.getInstance();
        boolean warn = utility.isOn();
        if (!warn) {
            return;
        }
        boolean uninstallable = this.isUninstallable();
        boolean transientFlag = this.isTransient();
        if (!uninstallable || !transientFlag) {
            return;
        }
        String component = Messages.getString(SAT_CORE_KEY);
        Bundle bundle = this.getBundle();
        String source = bundle.getSymbolicName();
        Class<?> clazz = this.getClass();
        String className = clazz.getName();
        String message = Messages.getString(BUNDLES_SHOULD_BE_TRANSIENT_OR_UNINSTALLABLE_NOT_BOTH_KEY);
        String label = Messages.getString(CLASS_KEY);
        utility.warn(component, source, message, label, className);
    }

    private Object[] collectServices(IServiceRecord[] records) {
        int length = records.length;
        Object[] services = new Object[length];
        int i = 0;
        while (i < length) {
            Object service;
            IServiceRecord record = records[i];
            services[i] = service = record.getService();
            ++i;
        }
        return services;
    }

    private IExportProxyServiceRecord createExportProxyServiceRecord(Class interfaceType, IProxyServiceHandler handler, Dictionary properties) {
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IExportProxyServiceRecord record = factory.createExportProxyServiceRecord(bundleContext, interfaceType, handler, properties);
        return record;
    }

    private IExportServiceRecord createExportServiceRecord(String name, Object service, Dictionary properties) {
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IExportServiceRecord record = factory.createExportServiceRecord(bundleContext, name, service, properties);
        return record;
    }

    private IExportServiceRecordContainer createExportServiceRecordContainer() {
        FactoryUtility factory = FactoryUtility.getInstance();
        IExportServiceRecordContainer container = factory.createExportServiceRecordContainer();
        return container;
    }

    private IImportServiceRecordContainer createImportServiceRecordContainer() {
        FactoryUtility factory = FactoryUtility.getInstance();
        IImportServiceRecordContainer container = factory.createImportServiceRecordContainer();
        return container;
    }

    private IImportServiceRecordContainerOwner createImportServiceRecordContainerOwner() {
        return new IImportServiceRecordContainerOwner(){

            public void acquired(IImportServiceRecordContainer container) {
                BundleActivationManager.this.performActivation();
            }

            public void released(IImportServiceRecordContainer container) {
                BundleActivationManager.this.performDeactivation();
            }
        };
    }

    private void createImportServiceRecords() {
        String[] names = this.getImportedServiceNames();
        if (names == null || names.length == 0) {
            return;
        }
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            Filter filter = this.getImportedServiceFilter(name);
            IImportServiceRecord record = factory.createImportServiceRecord(bundleContext, name, filter);
            container.add(record);
            ++i;
        }
    }

    private IImportServiceRecordContainerOwner createOptionalImportServiceRecordContainerOwner() {
        return new IImportServiceRecordContainerLenientOwner(){

            public void acquired(IImportServiceRecordContainer container) {
            }

            public void released(IImportServiceRecordContainer container) {
            }

            public void serviceAcquired(IImportServiceRecordContainer container, IImportServiceRecord record) {
                BundleActivationManager.this.handleAcquiredOptionalImportedService(record);
            }

            public void serviceReleased(IImportServiceRecordContainer container, IImportServiceRecord record) {
                BundleActivationManager.this.handleReleasedOptionalImportedService(record);
            }
        };
    }

    private void createOptionalImportServiceRecords() {
        String[] names = this.getOptionalImportedServiceNames();
        if (names == null || names.length == 0) {
            return;
        }
        FactoryUtility factory = FactoryUtility.getInstance();
        BundleContext bundleContext = this.getBundleContext();
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            Filter filter = this.getOptionalImportedServiceFilter(name);
            IImportServiceRecord record = factory.createImportServiceRecord(bundleContext, name, filter);
            container.add(record);
            ++i;
        }
    }

    private Runnable createStartAsyncRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        BundleActivationManager.this.startSync();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    BundleActivationManager.this.setAsyncStartThread(null);
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                BundleActivationManager.this.setAsyncStartThread(null);
            }
        };
    }

    private void deactivate() {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.deactivate();
    }

    private void destroyExportServiceRecords() {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        records.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyImportedServiceFilters() {
        Map map;
        Map map2 = map = this.getImportedServiceFilters();
        synchronized (map2) {
            map.clear();
        }
    }

    private void destroyImportedServiceRecords() {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        records.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyOptionalImportedServiceFilters() {
        Map map;
        Map map2 = map = this.getOptionalImportedServiceFilters();
        synchronized (map2) {
            map.clear();
        }
    }

    private void destroyOptionalImportedServiceRecords() {
        IImportServiceRecordContainer records = this.getOptionalImportServiceRecords();
        records.empty();
    }

    private int estimateHashedCollectionSize(int capacity) {
        CollectionUtility utility = CollectionUtility.getInstance();
        int size = utility.estimateHashedCollectionSize(capacity);
        return size;
    }

    private Object getActivationLock() {
        return this.activationLock;
    }

    private int getAsyncStartPriority() {
        IBundleActivationManagerOwner owner = this.getOwner();
        int priority = owner.getAsyncStartPriority();
        return priority;
    }

    private Thread getAsyncStartThread() {
        return this.asyncStartThread;
    }

    public Bundle getBundle() {
        this.checkIsStarted();
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        return bundle;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getBundleSymbolicName() {
        Bundle bundle = this.getBundle();
        String symbolicName = bundle.getSymbolicName();
        return symbolicName;
    }

    public File getDataDirectory() {
        String name = new String();
        File file = this.getDataFile(name);
        return file;
    }

    public File getDataFile(String filename) {
        Assertion.checkArgumentIsNotNull(filename, "filename");
        this.checkIsStarted();
        BundleContext bundleContext = this.getBundleContext();
        File file = bundleContext.getDataFile(filename);
        return file;
    }

    private String getDefaultPropertiesFilename() {
        String symbolicName = this.getBundleSymbolicName();
        int length = symbolicName.length() + 11;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(symbolicName);
        buffer.append(".properties");
        String filename = buffer.toString();
        return filename;
    }

    public Object getExportedService(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name);
        if (record == null) {
            return null;
        }
        Object service = record.getService();
        return service;
    }

    public String[] getExportedServiceNamesFromManifest() {
        Bundle bundle = this.getBundle();
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String[] names = utility.getExportServices(bundle);
        return names;
    }

    public Dictionary getExportedServiceProperties(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name);
        if (record == null) {
            return null;
        }
        Dictionary properties = record.getProperties();
        return properties;
    }

    public Dictionary getExportedServiceProperties(String name, Object service) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name, service);
        if (record == null) {
            return null;
        }
        Dictionary properties = record.getProperties();
        return properties;
    }

    public Map getExportedServices() {
        IExportServiceRecordContainer container = this.getExportServiceRecords();
        IServiceRecordAction action = BundleActivationManager.getCollectExportedServicesAction();
        int size = container.size();
        int capacity = this.estimateHashedCollectionSize(size);
        HashMap map = new HashMap(capacity);
        container.doForEach(action, map);
        return map;
    }

    public Object[] getExportedServices(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IServiceRecord[] matches = records.getAll(name);
        Object[] services = this.collectServices(matches);
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExportServiceRecordContainer getExportServiceRecords() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.exportServiceRecords == null) {
                this.exportServiceRecords = this.createExportServiceRecordContainer();
                this.setExportServiceRecords(this.exportServiceRecords);
            }
            return this.exportServiceRecords;
        }
    }

    public InputStream getFilePropertiesInputStream() throws IOException {
        String filename = this.getDefaultPropertiesFilename();
        InputStream stream = this.getFilePropertiesInputStream(filename);
        return stream;
    }

    public InputStream getFilePropertiesInputStream(String filename) throws IOException {
        Assertion.checkArgumentIsNotNull(filename, "filename");
        File file = new File(filename);
        boolean exists = file.exists();
        InputStream stream = null;
        if (exists) {
            stream = new FileInputStream(file);
            stream = new BufferedInputStream(stream);
        } else {
            this.handleFailedToFindProperties(filename);
        }
        return stream;
    }

    private String getFrameworkVendor() {
        BundleContext context = this.getBundleContext();
        String vendor = context.getProperty("org.osgi.framework.vendor");
        return vendor;
    }

    String getId() {
        if (this.id == NO_ID) {
            return null;
        }
        if (this.id != null) {
            return this.id;
        }
        boolean started = this.isStarted();
        String value = started ? this.getBundleSymbolicName() : null;
        return value;
    }

    public Object getImportedService(String name) {
        Object service = null;
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        IServiceRecord record = records.get(name);
        if (record != null) {
            service = record.getService();
            if (service != null) {
                return service;
            }
            service = this.acquireImportedService(name);
        }
        this.checkImportedServiceIsNotNull(name, service);
        return service;
    }

    public Filter getImportedServiceFilter(String name) {
        Map map = this.getImportedServiceFilters();
        Filter filter = (Filter)map.get(name);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getImportedServiceFilters() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.importedServiceFilters == null) {
                HashMap map = new HashMap(17);
                this.setImportedServiceFilters(map);
            }
            return this.importedServiceFilters;
        }
    }

    public String[] getImportedServiceNames() {
        IBundleActivationManagerOwner owner = this.getOwner();
        String[] names = owner.getImportedServiceNames();
        return names;
    }

    public String[] getImportedServiceNamesFromManifest() {
        Bundle bundle = this.getBundle();
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String[] names = utility.getImportServices(bundle);
        return names;
    }

    public Object getImportedServiceProperty(String name, String key) {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        IServiceRecord record = records.get(name);
        Object value = record.getProperty(key);
        return value;
    }

    public String[] getImportedServicePropertyKeys(String name) {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        IServiceRecord record = records.get(name);
        String[] keys = record.getPropertyKeys();
        return keys;
    }

    public Map getImportedServices() {
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        IServiceRecordAction action = BundleActivationManager.getCollectImportedServicesAction();
        int size = container.size();
        int capacity = this.estimateHashedCollectionSize(size);
        HashMap map = new HashMap(capacity);
        container.doForEach(action, map);
        return map;
    }

    private IImportServiceRecord getImportServiceRecord(String name) {
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        IImportServiceRecord record = (IImportServiceRecord)container.get(name);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImportServiceRecordContainer getImportServiceRecords() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.importServiceRecords == null) {
                IImportServiceRecordContainer container = this.createImportServiceRecordContainer();
                this.setImportServiceRecords(container);
            }
            return this.importServiceRecords;
        }
    }

    public Object getOptionalImportedService(String name) {
        IImportServiceRecordContainer records = this.getOptionalImportServiceRecords();
        IServiceRecord record = records.get(name);
        if (record == null) {
            return null;
        }
        Object service = record.getService();
        if (service != null) {
            return service;
        }
        service = this.acquireOptionalImportedService(name);
        return service;
    }

    public Filter getOptionalImportedServiceFilter(String name) {
        Map map = this.getOptionalImportedServiceFilters();
        Filter filter = (Filter)map.get(name);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getOptionalImportedServiceFilters() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.optionalImportedServiceFilters == null) {
                HashMap map = new HashMap(7);
                this.setOptionalImportedServiceFilters(map);
            }
            return this.optionalImportedServiceFilters;
        }
    }

    public String[] getOptionalImportedServiceNames() {
        IBundleActivationManagerOwner owner = this.getOwner();
        String[] names = owner.getOptionalImportedServiceNames();
        return names;
    }

    public Object getOptionalImportedServiceProperty(String name, String key) {
        IImportServiceRecordContainer records = this.getOptionalImportServiceRecords();
        IServiceRecord record = records.get(name);
        Object value = record.getProperty(key);
        return value;
    }

    public String[] getOptionalImportedServicePropertyKeys(String name) {
        IImportServiceRecordContainer records = this.getOptionalImportServiceRecords();
        IServiceRecord record = records.get(name);
        String[] keys = record.getPropertyKeys();
        return keys;
    }

    public Map getOptionalImportedServices() {
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        IServiceRecordAction action = BundleActivationManager.getCollectImportedServicesAction();
        int size = container.size();
        int capacity = this.estimateHashedCollectionSize(size);
        HashMap map = new HashMap(capacity);
        container.doForEach(action, map);
        return map;
    }

    private IImportServiceRecord getOptionalImportServiceRecord(String name) {
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        IImportServiceRecord record = (IImportServiceRecord)container.get(name);
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImportServiceRecordContainer getOptionalImportServiceRecords() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.optionalImportServiceRecords == null) {
                IImportServiceRecordContainer container = this.createImportServiceRecordContainer();
                this.setOptionalImportServiceRecords(container);
            }
            return this.optionalImportServiceRecords;
        }
    }

    private IBundleActivationManagerOwner getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() {
        BundleActivationManager bundleActivationManager = this;
        synchronized (bundleActivationManager) {
            if (this.properties == null) {
                Properties properties = this.loadProperties();
                this.setProperties(properties);
            }
            return this.properties;
        }
    }

    private InputStream getPropertiesInputStream() throws IOException {
        IBundleActivationManagerOwner owner = this.getOwner();
        InputStream stream = owner.getPropertiesInputStream();
        return stream;
    }

    public String getProperty(String key, String defaultValue) {
        Assertion.checkArgumentIsNotNull(key, "key");
        String value = System.getProperty(key);
        if (value == null) {
            Properties properties = this.getProperties();
            value = properties.getProperty(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private String getStartAsynchThreadName() {
        String pattern = Messages.getString(ASYNC_START_UP_KEY);
        String symbolicName = this.getBundleSymbolicName();
        String name = MessageFormatter.format(pattern, symbolicName);
        return name;
    }

    private Object getStartLock() {
        return this.startLock;
    }

    private Bundle getSystemBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle(0L);
        return bundle;
    }

    public String[] getUnacquiredImportedServiceNames() {
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        String[] names = container.getUnacquiredServiceNames();
        return names;
    }

    public String[] getUnacquiredOptionalImportedServiceNames() {
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        String[] names = container.getUnacquiredServiceNames();
        return names;
    }

    private void handleAcquiredOptionalImportedService(IImportServiceRecord record) {
        String name = record.getName();
        Object service = record.getService();
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.handleAcquiredOptionalImportedService(name, service);
    }

    private boolean handleException(Exception exception) {
        boolean result = true;
        IBundleActivationManagerOwner owner = this.getOwner();
        if (owner == null) {
            String message = exception.getMessage();
            LogUtility.logError(this, message, exception);
        } else {
            result = owner.handleException(exception);
        }
        return result;
    }

    private void handleFailedToFindProperties(String filename) {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.handleFailedToFindProperties(filename);
    }

    private void handleReleasedOptionalImportedService(IImportServiceRecord record) {
        String name = record.getName();
        Object service = record.getService();
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.handleReleasedOptionalImportedService(name, service);
    }

    private void interruptAndJoinWithAsyncThread() {
        boolean async = this.isStartAsync();
        if (!async) {
            return;
        }
        Thread thread = this.getAsyncStartThread();
        if (thread == null) {
            return;
        }
        String name = thread.getName();
        String pattern = Messages.getString(WAITING_FOR_ASYNC_START_UP_THREAD_TO_STOP_KEY);
        String waitingForThreadToStop = MessageFormatter.format(pattern, name);
        pattern = Messages.getString(ASYNC_START_UP_THREAD_HAS_STOPPED_KEY);
        String threadHasStopped = MessageFormatter.format(pattern, name);
        LogUtility.logInfo(this, waitingForThreadToStop);
        thread.interrupt();
        try {
            thread.join();
            LogUtility.logInfo(this, threadHasStopped);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean isActivated() {
        return this.activated;
    }

    private boolean isStartAsync() {
        IBundleActivationManagerOwner owner = this.getOwner();
        boolean startAsynchronously = owner.isStartAsync();
        return startAsynchronously;
    }

    private boolean isStarted() {
        BundleContext bundleContext = this.getBundleContext();
        boolean started = bundleContext != null;
        return started;
    }

    private boolean isTransient() {
        IBundleActivationManagerOwner owner = this.getOwner();
        boolean result = owner.isTransient();
        return result;
    }

    private boolean isUninstallable() {
        IBundleActivationManagerOwner owner = this.getOwner();
        boolean result = owner.isUninstallable();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties() {
        Properties properties = new Properties();
        try {
            InputStream stream = this.getPropertiesInputStream();
            if (stream == null) return properties;
            try {
                properties.load(stream);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var3_6 = null;
                stream.close();
                return properties;
            }
        }
        catch (IOException exception) {
            String message = Messages.getString(FAILED_TO_GET_PROPERTIES_KEY);
            LogUtility.logWarning(message, exception);
        }
        return properties;
    }

    private void logTraceOfUnacquiredImportedServices() {
        boolean tracing = LogUtility.isTracing();
        if (!tracing) {
            return;
        }
        String[] names = this.getUnacquiredImportedServiceNames();
        int size = names.length;
        if (size == 0) {
            return;
        }
        String bundleSymbolicName = this.getBundleSymbolicName();
        String pattern = Messages.getString(FAILED_TO_ACQUIRE_THE_FOLLOWING_SERVICES_KEY);
        String message = MessageFormatter.format(pattern, bundleSymbolicName);
        char newLine = '\n';
        char tab = '\t';
        StringBuffer buffer = new StringBuffer(500);
        buffer.append(message);
        buffer.append(newLine);
        int i = 0;
        while (i < size) {
            String name = names[i];
            buffer.append(tab);
            buffer.append(name);
            buffer.append(newLine);
            ++i;
        }
        String value = buffer.toString();
        String component = Messages.getString(SAT_CORE_KEY);
        LogUtility.logTrace((Object)component, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performActivation() {
        Object startLock;
        Object object = startLock = this.getStartLock();
        synchronized (object) {
            Object activationLock;
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            Object object2 = activationLock = this.getActivationLock();
            synchronized (object2) {
                boolean activated = this.isActivated();
                if (activated) {
                    return;
                }
                this.setActivated(true);
                this.activate();
                activated = this.isActivated();
                if (!activated) {
                    return;
                }
                this.registerExportedServices();
                this.registerWithBundleUninstallManager();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDeactivation() {
        Object startLock;
        Object object = startLock = this.getStartLock();
        synchronized (object) {
            Object activationLock;
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            Object object2 = activationLock = this.getActivationLock();
            synchronized (object2) {
                boolean activated = this.isActivated();
                if (!activated) {
                    return;
                }
                this.setActivated(false);
                this.unregisterExportServices();
                this.deactivate();
                this.destroyExportServiceRecords();
            }
        }
    }

    private void registerAsUninstallable() {
        boolean uninstallable = this.isUninstallable();
        if (!uninstallable) {
            return;
        }
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        Bundle bundle = this.getBundle();
        manager.addUninstallableBundle(bundle);
    }

    private void registerExportedServices() {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        records.register();
    }

    private void registerExportServiceRecords(IExportServiceRecord[] records) {
        int i = 0;
        while (i < records.length) {
            IExportServiceRecord record = records[i];
            record.register();
            ++i;
        }
    }

    private void registerWithBundleDependencyManager() {
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        manager.addBundleActivationManager(this);
        this.registerAsUninstallable();
    }

    private void registerWithBundleUninstallManager() {
        boolean transientFlag = this.isTransient();
        if (!transientFlag) {
            return;
        }
        BundleUninstallManager uninstaller = BundleUninstallManager.getInstance();
        Bundle bundle = this.getBundle();
        uninstaller.uninstall(bundle);
    }

    public void releaseImportedService(String name) {
        IImportServiceRecord record = this.getImportServiceRecord(name);
        if (record == null) {
            return;
        }
        record.release();
    }

    public void releaseImportedServices() {
        IImportServiceRecordContainer records = this.getImportServiceRecords();
        records.release();
    }

    public void releaseOptionalImportedService(String name) {
        IImportServiceRecord record = this.getOptionalImportServiceRecord(name);
        if (record == null) {
            return;
        }
        record.release();
    }

    public void releaseOptionalImportedServices() {
        IImportServiceRecordContainer records = this.getOptionalImportServiceRecords();
        records.release();
    }

    public void removeExportedService(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name);
        if (record == null) {
            return;
        }
        this.removeExportServiceRecord(record);
    }

    public void removeExportedService(String name, Object service) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name, service);
        if (record == null) {
            return;
        }
        this.removeExportServiceRecord(record);
    }

    public void removeExportedServices(String name) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IServiceRecord[] matches = records.getAll(name);
        if (matches == null) {
            return;
        }
        int count = matches.length;
        int i = 0;
        while (i < count) {
            IExportServiceRecord record = (IExportServiceRecord)matches[i];
            records.remove(record);
            ++i;
        }
    }

    public void removeExportServiceRecord(IExportServiceRecord record) {
        this.checkExportedServiceRecord(record);
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        boolean removed = records.remove(record);
        if (!removed) {
            return;
        }
        boolean unregister = this.isActivated();
        if (!unregister) {
            return;
        }
        record.unregister();
    }

    public void removeImportedServiceFilter(String name) {
        Map filters = this.getImportedServiceFilters();
        IImportServiceRecordContainer container = this.getImportServiceRecords();
        this.removeImportedServiceFilter(name, filters, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeImportedServiceFilter(String name, Map filters, IImportServiceRecordContainer container) {
        Object value = null;
        Map map = filters;
        synchronized (map) {
            value = filters.remove(name);
        }
        if (value == null) {
            return;
        }
        IImportServiceRecord record = (IImportServiceRecord)container.get(name);
        if (record == null) {
            return;
        }
        record.setFilter(null);
    }

    public void removeOptionalImportedServiceFilter(String name) {
        Map filters = this.getOptionalImportedServiceFilters();
        IImportServiceRecordContainer container = this.getOptionalImportServiceRecords();
        this.removeImportedServiceFilter(name, filters, container);
    }

    public void restartFramework() throws BundleException {
        this.checkIsStarted();
        String pattern = Messages.getString(FRAMEWORK_RESTARTED_BY_KEY);
        String symbolicName = this.getBundleSymbolicName();
        String message = MessageFormatter.format(pattern, symbolicName);
        LogUtility.logInfo(message);
        String frameworkVendor = this.getFrameworkVendor();
        boolean broken = "Eclipse".equals(frameworkVendor);
        if (broken) {
            FactoryUtility utility = FactoryUtility.getInstance();
            BundleContext context = this.getBundleContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.osgi.service.startlevel.StartLevel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String name = clazz.getName();
            IImportServiceRecord record = utility.createImportServiceRecord(context, name, null);
            record.acquire();
            StartLevel startLevel = (StartLevel)record.getService();
            int current = startLevel != null ? startLevel.getStartLevel() : 6;
            record.release();
            String value = String.valueOf(current);
            Properties properties = System.getProperties();
            properties.put("osgi.framework.beginningstartlevel", value);
        }
        Bundle bundle = this.getSystemBundle();
        bundle.update();
    }

    private void setActivated(boolean activated) {
        this.activated = activated;
    }

    private void setAsyncStartThread(Thread asyncStartThread) {
        this.asyncStartThread = asyncStartThread;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setExportedServiceProperties(String name, Dictionary properties) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name);
        if (record == null) {
            return;
        }
        record.setProperties(properties);
    }

    public void setExportedServiceProperties(String name, Object service, Dictionary properties) {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        IExportServiceRecord record = (IExportServiceRecord)records.get(name, service);
        if (record == null) {
            return;
        }
        record.setProperties(properties);
    }

    private void setExportServiceRecords(IExportServiceRecordContainer exportServiceRecords) {
        this.exportServiceRecords = exportServiceRecords;
    }

    void setId(String id) {
        this.id = id == null ? NO_ID : id;
    }

    private void setImportedServiceFilters(Map importedServiceFilters) {
        this.importedServiceFilters = importedServiceFilters;
    }

    private void setImportServiceRecords(IImportServiceRecordContainer importServiceRecords) {
        this.importServiceRecords = importServiceRecords;
    }

    private void setOptionalImportedServiceFilters(Map optionalImportedServiceFilters) {
        this.optionalImportedServiceFilters = optionalImportedServiceFilters;
    }

    private void setOptionalImportServiceRecords(IImportServiceRecordContainer optionalImportServiceRecords) {
        this.optionalImportServiceRecords = optionalImportServiceRecords;
    }

    private void setOwner(IBundleActivationManagerOwner owner) {
        this.owner = owner;
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void shutdownFramework() throws BundleException {
        this.checkIsStarted();
        String pattern = Messages.getString(FRAMEWORK_SHUTDOWN_BY_KEY);
        String symbolicName = this.getBundleSymbolicName();
        String message = MessageFormatter.format(pattern, symbolicName);
        LogUtility.logInfo(message);
        Bundle bundle = this.getSystemBundle();
        bundle.stop();
    }

    private void start() throws Exception {
        IBundleActivationManagerOwner owner = this.getOwner();
        owner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext, IBundleActivationManagerOwner owner) throws Exception {
        Object lock;
        Assertion.checkArgumentIsNotNull(bundleContext, "bundleContext");
        Assertion.checkArgumentIsNotNull(owner, "owner");
        Object object = lock = this.getStartLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setBundleContext(bundleContext);
            this.setOwner(owner);
            this.checkUninstallPolicy();
            this.registerWithBundleDependencyManager();
            boolean async = this.isStartAsync();
            if (async) {
                this.startAsync();
            } else {
                this.startSync();
            }
        }
    }

    private void startAsync() {
        Runnable runnable = this.createStartAsyncRunnable();
        String name = this.getStartAsynchThreadName();
        Thread thread = new Thread(runnable, name);
        this.setAsyncStartThread(thread);
        int priority = this.getAsyncStartPriority();
        thread.setPriority(priority);
        thread.start();
    }

    private void startSync() throws Exception {
        try {
            this.start();
            this.createOptionalImportServiceRecords();
            this.createImportServiceRecords();
            this.acquireOptionalImportServiceRecords();
            this.acquireImportServiceRecords();
        }
        catch (Exception exception) {
            boolean handled = this.handleException(exception);
            if (handled) {
                return;
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws Exception {
        Object lock = this.getStartLock();
        try {
            Object object = lock;
            synchronized (object) {
                boolean started = this.isStarted();
                if (!started) {
                    return;
                }
                try {
                    this.interruptAndJoinWithAsyncThread();
                    this.releaseImportedServices();
                    this.destroyImportedServiceFilters();
                    this.destroyImportedServiceRecords();
                    this.releaseOptionalImportedServices();
                    this.destroyOptionalImportedServiceFilters();
                    this.destroyOptionalImportedServiceRecords();
                    this.unregisterWithBundleDependencyManager();
                    IBundleActivationManagerOwner owner = this.getOwner();
                    owner.stop();
                    Object var5_9 = null;
                    this.setOwner(null);
                    this.setBundleContext(null);
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.setOwner(null);
                    this.setBundleContext(null);
                    throw throwable;
                }
            }
        }
        catch (Exception exception) {
            boolean handled = this.handleException(exception);
            if (!handled) throw exception;
            return;
        }
    }

    private void unregisterAsUninstallable() {
        boolean uninstallable = this.isUninstallable();
        if (!uninstallable) {
            return;
        }
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        Bundle bundle = this.getBundle();
        manager.removeUninstallableBundle(bundle);
    }

    private void unregisterExportServices() {
        IExportServiceRecordContainer records = this.getExportServiceRecords();
        records.unregister();
    }

    private void unregisterWithBundleDependencyManager() {
        this.unregisterAsUninstallable();
        BundleDependencyManager manager = BundleDependencyManager.getInstance();
        manager.removeBundleActivationManager(this);
    }
}

