/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.interfaces.ITokenizer;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.BundleManifestUtility;
import org.eclipse.soda.sat.core.util.CollectionUtility;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LazyBundeActivatorProperties {
    private static final String DUPLICATE_PROPERTY_PARAMETER_KEY = "LazyBundleActivatorProperties.DuplicatePropertyParameter";
    private static final String FAILED_TO_FIND_PROPERTIES_FILE_KEY = "LazyBundleActivatorProperties.FailedToFindPropertiesFile";
    private static final String FAILED_TO_FIND_PROPERTY_KEY = "LazyBundleActivatorProperties.FailedToFindProperty";
    private static final String BUNDLE_ACTIVATOR_PROPERTIES_KEY = "Bundle-Activator";
    private static final String IMPORTED_SERVICES_PROPERTIES_KEY = "Imported-Services";
    private static final char ASSIGNMENT_OPERATOR = '=';
    private static final char PARAMETER_SEPARATOR = ';';
    private static final String FILTER = "filter";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String PROPERTIES_HEADER_PREFIX = "SAT";
    private BundleContext bundleContext;
    private String bundleActivator;
    private List importedServiceNames;
    private Map importedServiceFilters;
    static /* synthetic */ Class class$0;

    public LazyBundeActivatorProperties(BundleContext bundleContext) {
        this.setBundleContext(bundleContext);
        this.initialize();
    }

    private String createDuplicatePropertyParameterMessage(String property, String key) {
        String pattern = Messages.getString(DUPLICATE_PROPERTY_PARAMETER_KEY);
        String path = this.getPropertiesPath();
        String symbolicName = this.getBundleSymbolicName();
        Object[] values = new Object[]{property, path, symbolicName, key};
        String message = MessageFormatter.format(pattern, values);
        return message;
    }

    private String createFailedToFindPropertiesFileMessage() {
        String pattern = Messages.getString(FAILED_TO_FIND_PROPERTIES_FILE_KEY);
        String path = this.getPropertiesPath();
        String symbolicName = this.getBundleSymbolicName();
        Object[] values = new Object[]{path, symbolicName};
        String message = MessageFormatter.format(pattern, values);
        return message;
    }

    private String createFailedToFindPropertyMessage(String key) {
        String pattern = Messages.getString(FAILED_TO_FIND_PROPERTY_KEY);
        String path = this.getPropertiesPath();
        String symbolicName = this.getBundleSymbolicName();
        Object[] values = new Object[]{key, path, symbolicName};
        String message = MessageFormatter.format(pattern, values);
        return message;
    }

    private ITokenizer createTokenizer(String value) {
        FactoryUtility utility = this.getFactoryUtility();
        ITokenizer tokenizer = utility.createTokenizer(value);
        return tokenizer;
    }

    private ITokenizer createTokenizer(String value, char delimiter) {
        FactoryUtility utility = this.getFactoryUtility();
        ITokenizer tokenizer = utility.createTokenizer(value, delimiter);
        return tokenizer;
    }

    private int estimateHashedCollectionSize(int capacity) {
        CollectionUtility utility = CollectionUtility.getInstance();
        int size = utility.estimateHashedCollectionSize(capacity);
        return size;
    }

    private Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        return bundle;
    }

    public String getBundleActivator() {
        return this.bundleActivator;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private URL getBundleEntry(String path) {
        Bundle bundle = this.getBundle();
        URL url = bundle.getEntry(path);
        return url;
    }

    private String getBundleSymbolicName() {
        Bundle bundle = this.getBundle();
        String symbolicName = bundle.getSymbolicName();
        return symbolicName;
    }

    private String getClassName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.framework.LazyBundleActivator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String value = clazz.getName();
        int index = value.lastIndexOf(46) + 1;
        value = value.substring(index);
        return value;
    }

    private String getDefaultPropertiesPath() {
        String className = this.getClassName();
        String path = String.valueOf(className) + PROPERTIES_EXTENSION;
        return path;
    }

    private FactoryUtility getFactoryUtility() {
        return FactoryUtility.getInstance();
    }

    public String getImportedServiceFilter(String name) {
        Assertion.checkArgumentIsNotNull(name, "name");
        Map filters = this.getImportedServiceFilters();
        String filter = (String)filters.get(name);
        return filter;
    }

    private Map getImportedServiceFilters() {
        return this.importedServiceFilters;
    }

    private List getImportedServiceLines(String value) {
        ITokenizer tokenizer = this.createTokenizer(value);
        ArrayList<String> lines = new ArrayList<String>(10);
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            lines.add(line);
        }
        lines.trimToSize();
        return lines;
    }

    public List getImportedServiceNames() {
        return this.importedServiceNames;
    }

    private String getParameterKey(String parameter) {
        int index = parameter.indexOf(61);
        String key = index == -1 ? parameter : parameter.substring(0, index);
        key = key.trim();
        return key;
    }

    private Map getParameters(String property, String value) {
        int size = this.estimateHashedCollectionSize(3);
        HashMap<String, String> map = new HashMap<String, String>(size);
        ITokenizer tokenizer = this.createTokenizer(value, ';');
        while (tokenizer.hasMoreTokens()) {
            String parameter = tokenizer.nextToken();
            String parameterKey = this.getParameterKey(parameter);
            String parameterValue = this.getParameterValue(parameter);
            boolean exists = map.containsKey(parameterKey);
            if (exists) {
                String message = this.createDuplicatePropertyParameterMessage(property, parameterKey);
                throw new RuntimeException(message);
            }
            map.put(parameterKey, parameterValue);
        }
        return map;
    }

    private String getParameterValue(String parameter) {
        int index = parameter.indexOf(61);
        String value = index == -1 ? parameter : parameter.substring(index + 1);
        value = value.trim();
        return value;
    }

    private String getPropertiesHeader() {
        String className = this.getClassName();
        String header = "SAT-" + className;
        return header;
    }

    private InputStream getPropertiesInputStream() throws IOException {
        String path = this.getPropertiesPath();
        URL url = this.getBundleEntry(path);
        if (url == null) {
            String message = this.createFailedToFindPropertiesFileMessage();
            throw new RuntimeException(message);
        }
        InputStream stream = url.openStream();
        return stream;
    }

    private String getPropertiesPath() {
        String header;
        Bundle bundle;
        BundleManifestUtility utility = BundleManifestUtility.getInstance();
        String path = utility.getHeader(bundle = this.getBundle(), header = this.getPropertiesHeader());
        if (path == null) {
            path = this.getDefaultPropertiesPath();
        }
        return path;
    }

    private String getProperty(String key, Properties properties) {
        String lowerCaseKey = key.toLowerCase();
        String value = properties.getProperty(lowerCaseKey);
        if (value != null) {
            value = value.trim();
        }
        if (value == null || value.length() == 0) {
            String message = this.createFailedToFindPropertyMessage(key);
            throw new RuntimeException(message);
        }
        return value;
    }

    private void initialize() {
        Properties properties = this.loadProperties();
        this.processProperties(properties);
    }

    /*
     * Exception decompiling
     */
    private Properties loadProperties() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 51->57)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processBundleActivatorProperty(Properties properties) {
        String bundleActivator = this.getProperty(BUNDLE_ACTIVATOR_PROPERTIES_KEY, properties);
        this.setBundleActivator(bundleActivator);
    }

    private void processImportedService(String line) {
        String name;
        String filterString = null;
        int index = line.indexOf(59);
        if (index == -1) {
            name = line;
        } else {
            name = line.substring(0, index);
            String parameters = line.substring(index + 1);
            Map map = this.getParameters(IMPORTED_SERVICES_PROPERTIES_KEY, parameters);
            filterString = (String)map.get(FILTER);
        }
        List names = this.getImportedServiceNames();
        names.add(name);
        if (filterString != null) {
            Map filters = this.getImportedServiceFilters();
            filters.put(name, filterString);
        }
    }

    private void processImportedServicesProperty(Properties properties) {
        String value = this.getProperty(IMPORTED_SERVICES_PROPERTIES_KEY, properties);
        List lines = this.getImportedServiceLines(value);
        int numberOfImportedServices = lines.size();
        ArrayList names = new ArrayList(numberOfImportedServices);
        this.setImportedServiceNames(names);
        int size = this.estimateHashedCollectionSize(numberOfImportedServices);
        HashMap filters = new HashMap(size);
        this.setImportedServiceFilters(filters);
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            this.processImportedService(line);
        }
    }

    private void processProperties(Properties properties) {
        this.processBundleActivatorProperty(properties);
        this.processImportedServicesProperty(properties);
    }

    private void setBundleActivator(String bundleActivator) {
        this.bundleActivator = bundleActivator;
    }

    private void setBundleContext(BundleContext bundleContext) {
        Assertion.checkArgumentIsNotNull(bundleContext, "bundleContext");
        this.bundleContext = bundleContext;
    }

    private void setImportedServiceFilters(Map importedServiceFilters) {
        this.importedServiceFilters = importedServiceFilters;
    }

    private void setImportedServiceNames(List importedServiceNames) {
        this.importedServiceNames = importedServiceNames;
    }

    private Properties toLowerCaseKeys(Properties properties) {
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = entries.iterator();
        Properties lowerCasePropertyKeys = new Properties();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            key = key.toLowerCase();
            String value = (String)entry.getValue();
            lowerCasePropertyKeys.put(key, value);
        }
        return lowerCasePropertyKeys;
    }
}

