/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle.cm;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.soda.sat.core.framework.BundleActivationManagerOwnerAdapter;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManagerOwner;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryActivationManager;
import org.eclipse.soda.sat.core.framework.interfaces.IManagedServiceFactoryAdvisor;
import org.eclipse.soda.sat.core.internal.framework.bundle.cm.ConfigurationData;
import org.eclipse.soda.sat.core.internal.nls.MessageFormatter;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.CollectionUtility;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;

public class ManagedServiceFactoryActivationManager
implements IManagedServiceFactoryActivationManager {
    private static final String FAILED_TO_CREATE_IMPORTED_SERVICE_FILTER_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToCreateImportedServiceFilterForPid";
    private static final String FAILED_TO_CREATE_OBJECT_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToCreateObjectForPid";
    private static final String FAILED_TO_DELETE_CONFIGURATION_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToDeleteConfigurationForPid";
    private static final String FAILED_TO_DESTROY_OBJECT_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToDestroyObjectForPid";
    private static final String FAILED_TO_HANDLE_ACQUIRED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToHandleAcquiredOptionalImportedServiceServiceForPid";
    private static final String FAILED_TO_HANDLE_RELEASED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToHandleReleasedOptionalImportedServiceServiceForPid";
    private static final String FAILED_TO_START_BUNDLE_ACTIVATION_MANAGER_KEY = "ManagedServiceFactoryActivationManager.FailedToStartBundleActivationManager";
    private static final String FAILED_TO_STOP_BUNDLE_ACTIVATION_MANAGER_KEY = "ManagedServiceFactoryActivationManager.ManagedServiceFactoryActivationManager.FailedToStopBundleActivationManager";
    private static final String FAILED_TO_UPDATE_OBJECT_FOR_PID_KEY = "ManagedServiceFactoryActivationManager.FailedToUpdateObjectForPid";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private IManagedServiceFactoryAdvisor advisor;
    private BundleContext bundleContext;
    private Map configurationDataMap;
    private String name;
    private final Object lock = new Object();

    public ManagedServiceFactoryActivationManager(String name, IManagedServiceFactoryAdvisor advisor) {
        this(name, advisor, 5);
    }

    public ManagedServiceFactoryActivationManager(String name, IManagedServiceFactoryAdvisor advisor, int numberOfConfigurationHint) {
        this.setName(name);
        this.setAdvisor(advisor);
        this.setConfigurationDataMap(this.createConfigurationDataMap(numberOfConfigurationHint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationData addConfigurationData(String pid, Dictionary properties) {
        ConfigurationData data;
        Map map;
        Map map2 = map = this.getConfigurationDataMap();
        synchronized (map2) {
            data = new ConfigurationData(properties);
            map.put(pid, data);
        }
        return data;
    }

    private void create(String pid) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        ConfigurationData data = this.getConfigurationData(pid);
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            Object object = advisor.create(pid, properties, manager);
            data.setObject(object);
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_CREATE_OBJECT_FOR_PID_KEY);
        }
    }

    private IBundleActivationManagerOwner createBundleActivationManagerOwner(final String pid) {
        return new BundleActivationManagerOwnerAdapter(){

            public void activate() {
                ManagedServiceFactoryActivationManager.this.create(pid);
            }

            public void deactivate() {
                ManagedServiceFactoryActivationManager.this.destroy(pid);
            }

            public String[] getImportedServiceNames() {
                return ManagedServiceFactoryActivationManager.this.getImportedServiceNames(pid);
            }

            public String[] getOptionalImportedServiceNames() {
                return ManagedServiceFactoryActivationManager.this.getOptionalImportedServiceNames(pid);
            }

            public void handleAcquiredOptionalImportedService(String serviceName, Object service) {
                ManagedServiceFactoryActivationManager.this.handleAcquiredOptionalImportedService(pid, serviceName, service);
            }

            public void handleReleasedOptionalImportedService(String serviceName, Object service) {
                ManagedServiceFactoryActivationManager.this.handleReleasedOptionalImportedService(pid, serviceName, service);
            }

            public void start() {
                ManagedServiceFactoryActivationManager.this.createImportedServiceFilters(pid);
            }
        };
    }

    private Map createConfigurationDataMap(int numberOfConfigurationHint) {
        int initialCapacity = this.estimateHashedCollectionSize(numberOfConfigurationHint);
        HashMap map = new HashMap(initialCapacity);
        return map;
    }

    private Object createImportedServiceFilters(String pid) {
        Object object = null;
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        ConfigurationData data = this.getConfigurationData(pid);
        Dictionary oldProperties = data.getOldProperties();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            advisor.createImportedServiceFilters(pid, oldProperties, properties, manager);
            object = data.getObject();
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_CREATE_IMPORTED_SERVICE_FILTER_FOR_PID_KEY);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(String pid) {
        try {
            Object lock;
            Object object = lock = this.getLock();
            synchronized (object) {
                this.stopBundleActivationManager(pid);
                this.removeFactoryConfigurationData(pid);
            }
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_DELETE_CONFIGURATION_FOR_PID_KEY);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void destroy(String pid) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        ConfigurationData data = this.getConfigurationData(pid);
        Object object = data.getObject();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            try {
                advisor.destroy(pid, object, properties, manager);
            }
            catch (Throwable throwable) {
                this.logError(pid, throwable, FAILED_TO_DESTROY_OBJECT_FOR_PID_KEY);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            data.setObject(null);
            throw throwable;
        }
        {
            Object var8_10 = null;
            data.setObject(null);
            return;
        }
    }

    private boolean equal(Dictionary dictionary1, Dictionary dictionary2) {
        int size2;
        boolean equal;
        if (dictionary1 == dictionary2) {
            return true;
        }
        if (dictionary1 == null || dictionary2 == null) {
            return false;
        }
        int size1 = dictionary1.size();
        boolean bl = equal = size1 == (size2 = dictionary2.size());
        if (!equal) {
            return false;
        }
        Enumeration keys = dictionary1.keys();
        while (equal && keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value1 = dictionary1.get(key);
            Object value2 = dictionary2.get(key);
            equal = value1.equals(value2);
        }
        return equal;
    }

    private int estimateHashedCollectionSize(int capacity) {
        CollectionUtility utility = CollectionUtility.getInstance();
        int size = utility.estimateHashedCollectionSize(capacity);
        return size;
    }

    private IManagedServiceFactoryAdvisor getAdvisor() {
        return this.advisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAllObjects() {
        Map map = this.getConfigurationDataMap();
        int size = map.size();
        int capacity = this.estimateHashedCollectionSize(size);
        HashMap<String, Object> result = new HashMap<String, Object>(capacity);
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = this.getAllPids();
            while (iterator.hasNext()) {
                String pid = (String)iterator.next();
                ConfigurationData data = (ConfigurationData)map.get(pid);
                Object object = data.getObject();
                if (object == null) continue;
                result.put(pid, object);
            }
        }
        return result;
    }

    private Iterator getAllPids() {
        Map map = this.getConfigurationDataMap();
        Set keys = map.keySet();
        Iterator iterator = keys.iterator();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAllProperties() {
        Map map = this.getConfigurationDataMap();
        int size = map.size();
        int capacity = this.estimateHashedCollectionSize(size);
        HashMap<String, Dictionary> result = new HashMap<String, Dictionary>(capacity);
        Map map2 = map;
        synchronized (map2) {
            Iterator iterator = this.getAllPids();
            while (iterator.hasNext()) {
                String pid = (String)iterator.next();
                ConfigurationData data = (ConfigurationData)map.get(pid);
                Dictionary properties = data.getProperties();
                result.put(pid, properties);
            }
        }
        return result;
    }

    private BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private String getBundleSymbolicName() {
        BundleContext context = this.getBundleContext();
        Bundle bundle = context.getBundle();
        String symbolicName = bundle.getSymbolicName();
        return symbolicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationData getConfigurationData(String pid) {
        ConfigurationData data;
        Map map;
        Map map2 = map = this.getConfigurationDataMap();
        synchronized (map2) {
            data = (ConfigurationData)map.get(pid);
        }
        return data;
    }

    private Map getConfigurationDataMap() {
        return this.configurationDataMap;
    }

    private String[] getImportedServiceNames(String pid) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        ConfigurationData data = this.getConfigurationData(pid);
        Dictionary oldProperties = data.getOldProperties();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        String[] names = advisor.getImportedServiceNames(pid, oldProperties, properties, manager);
        return names;
    }

    private Object getLock() {
        return this.lock;
    }

    public String getName() {
        return this.name;
    }

    private String[] getOptionalImportedServiceNames(String pid) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        ConfigurationData data = this.getConfigurationData(pid);
        Dictionary oldProperties = data.getOldProperties();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        String[] names = advisor.getOptionalImportedServiceNames(pid, oldProperties, properties, manager);
        return names;
    }

    private void handleAcquiredOptionalImportedService(String pid, String importedServiceName, Object importedService) {
        ConfigurationData data = this.getConfigurationData(pid);
        Object object = data.getObject();
        if (object == null) {
            return;
        }
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            advisor.handleAcquiredOptionalImportedService(pid, object, importedServiceName, importedService, manager);
        }
        catch (Throwable throwable) {
            String pattern = Messages.getString(FAILED_TO_HANDLE_ACQUIRED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY);
            Object[] values = new Object[]{importedService, pid};
            String message = MessageFormatter.format(pattern, values);
            this.logError(message, throwable);
        }
    }

    private void handleReleasedOptionalImportedService(String pid, String importedServiceName, Object importedService) {
        ConfigurationData data = this.getConfigurationData(pid);
        Object object = data.getObject();
        if (object == null) {
            return;
        }
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            advisor.handleReleasedOptionalImportedService(pid, object, importedServiceName, importedService, manager);
        }
        catch (Throwable throwable) {
            String pattern = Messages.getString(FAILED_TO_HANDLE_RELEASED_OPTIONAL_IMPORTED_SERVICE_FOR_PID_KEY);
            Object[] values = new Object[]{importedService, pid};
            String message = MessageFormatter.format(pattern, values);
            this.logError(message, throwable);
        }
    }

    private boolean isStarted() {
        BundleContext bundleContext = this.getBundleContext();
        boolean started = bundleContext != null;
        return started;
    }

    private void logError(String message, Throwable throwable) {
        LogUtility.logError(this, message, throwable);
    }

    private void logError(String pid, Throwable throwable, String key) {
        String pattern = Messages.getString(key);
        String message = MessageFormatter.format(pattern, pid);
        this.logError(message, throwable);
    }

    private void printConfigurationOn(StringBuffer buffer, String pid, Object object, Dictionary properties) {
        Enumeration enumeration = properties.keys();
        buffer.append('\t');
        buffer.append("Persistent ID: ");
        buffer.append(pid);
        buffer.append(LINE_SEPARATOR);
        buffer.append('\t');
        buffer.append('\t');
        buffer.append("Object: ");
        buffer.append(object);
        buffer.append(LINE_SEPARATOR);
        buffer.append('\t');
        buffer.append('\t');
        buffer.append("Properties:");
        buffer.append(LINE_SEPARATOR);
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = properties.get(key);
            buffer.append('\t');
            buffer.append('\t');
            buffer.append('\t');
            buffer.append("Key=");
            buffer.append(key);
            buffer.append(", Value=");
            buffer.append(value);
            buffer.append(LINE_SEPARATOR);
        }
        buffer.append(LINE_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printConfigurationsOn(StringBuffer buffer) {
        Map map;
        Map map2 = map = this.getConfigurationDataMap();
        synchronized (map2) {
            Iterator pids = this.getAllPids();
            Map objects = this.getAllObjects();
            Map props = this.getAllProperties();
            while (pids.hasNext()) {
                String pid = (String)pids.next();
                Object object = objects.get(pid);
                Dictionary properties = (Dictionary)props.get(pid);
                this.printConfigurationOn(buffer, pid, object, properties);
            }
        }
    }

    private void printOn(StringBuffer buffer) {
        String value = super.toString();
        buffer.append(value);
        String bundleSymbolicName = this.getBundleSymbolicName();
        buffer.append(", bundleSymbolicName=");
        buffer.append(bundleSymbolicName);
        String name = this.getName();
        buffer.append(", name=");
        buffer.append(name);
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        buffer.append(", advisor=");
        buffer.append(advisor);
        buffer.append(LINE_SEPARATOR);
        this.printConfigurationsOn(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFactoryConfigurationData(String pid) {
        Map map;
        Map map2 = map = this.getConfigurationDataMap();
        synchronized (map2) {
            map.remove(pid);
        }
    }

    private void setAdvisor(IManagedServiceFactoryAdvisor advisor) {
        Assertion.checkArgumentIsNotNull(advisor, "advisor");
        this.advisor = advisor;
    }

    private void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void setConfigurationDataMap(Map configurationDataMap) {
        this.configurationDataMap = configurationDataMap;
    }

    private void setName(String name) {
        Assertion.checkArgumentIsNotNull(name, "name");
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) {
        Object lock;
        Assertion.checkArgumentIsNotNull(bundleContext, "bundleContext");
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (started) {
                return;
            }
            this.setBundleContext(bundleContext);
        }
    }

    private void startBundleActivationManager(String pid) {
        ConfigurationData data = this.getConfigurationData(pid);
        IBundleActivationManager manager = data.getBundleActivationManager();
        BundleContext bundleContext = this.getBundleContext();
        IBundleActivationManagerOwner owner = this.createBundleActivationManagerOwner(pid);
        try {
            manager.start(bundleContext, owner);
        }
        catch (Exception exception) {
            this.logError(pid, exception, FAILED_TO_START_BUNDLE_ACTIVATION_MANAGER_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            boolean started = this.isStarted();
            if (!started) {
                return;
            }
            this.stopBundleActivationManagers();
            this.setBundleContext(null);
        }
    }

    private void stopBundleActivationManager(String pid) {
        ConfigurationData data = this.getConfigurationData(pid);
        if (data == null) {
            return;
        }
        IBundleActivationManager manager = data.getBundleActivationManager();
        try {
            manager.stop();
        }
        catch (Exception exception) {
            this.logError(pid, exception, FAILED_TO_STOP_BUNDLE_ACTIVATION_MANAGER_KEY);
        }
    }

    private void stopBundleActivationManagers() {
        HashMap map = (HashMap)this.getConfigurationDataMap();
        Map clone = (Map)map.clone();
        Set keys = clone.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String pid = (String)iterator.next();
            this.stopBundleActivationManager(pid);
            this.removeFactoryConfigurationData(pid);
        }
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(350);
        this.printOn(buffer);
        String result = buffer.toString();
        return result;
    }

    private void update(String pid, ConfigurationData data) {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        Object object = data.getObject();
        Dictionary oldProperties = data.getOldProperties();
        Dictionary properties = data.getProperties();
        IBundleActivationManager manager = data.getBundleActivationManager();
        Object updatedObject = advisor.update(pid, object, oldProperties, properties, manager);
        data.setObject(updatedObject);
    }

    private void update(String pid, Dictionary properties, ConfigurationData data) {
        boolean update;
        Dictionary currentProperties = data.getProperties();
        boolean match = this.equal(currentProperties, properties);
        if (match) {
            return;
        }
        data.setProperties(properties);
        Object object = data.getObject();
        Object newObject = this.createImportedServiceFilters(pid);
        boolean bl = update = object != null && object == newObject;
        if (!update) {
            return;
        }
        this.update(pid, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        try {
            Object lock;
            Object object = lock = this.getLock();
            synchronized (object) {
                boolean started = this.isStarted();
                if (!started) {
                    return;
                }
                this.validateConfiguration(pid, properties);
                ConfigurationData data = this.getConfigurationData(pid);
                if (data == null) {
                    this.addConfigurationData(pid, properties);
                    this.startBundleActivationManager(pid);
                } else {
                    this.update(pid, properties, data);
                }
            }
        }
        catch (Throwable throwable) {
            this.logError(pid, throwable, FAILED_TO_UPDATE_OBJECT_FOR_PID_KEY);
        }
    }

    private void validateConfiguration(String pid, Dictionary properties) throws ConfigurationException {
        IManagedServiceFactoryAdvisor advisor = this.getAdvisor();
        advisor.validateConfiguration(pid, properties);
    }
}

