/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.framework.interfaces.IDependencyTracker;
import org.eclipse.soda.sat.core.util.Assertion;

class DependencyTrackerXmlConverter {
    public static final String INDENT = "  ";
    public static final String NEWLINE = System.getProperty("line.separator");
    private IDependencyTracker model;
    private String name;
    private IDependencyTracker.IXmlProvider xmlProvider;

    DependencyTrackerXmlConverter(IDependencyTracker dependencyTracker, String name) {
        this(dependencyTracker, name, new DefaultXmlProvider());
    }

    DependencyTrackerXmlConverter(IDependencyTracker dependencyTracker, String name, IDependencyTracker.IXmlProvider xmlProvider) {
        this.setModel(dependencyTracker);
        this.setName(name);
        this.setXmlProvider(xmlProvider);
    }

    private IDependencyTracker getModel() {
        return this.model;
    }

    private String getName() {
        return this.name;
    }

    private IDependencyTracker.IXmlProvider getXmlProvider() {
        return this.xmlProvider;
    }

    private void printIndentOn(StringBuffer buffer, int level) {
        this.printNewLineOn(buffer);
        int i = 0;
        while (i < level) {
            buffer.append(INDENT);
            ++i;
        }
    }

    private void printNewLineOn(StringBuffer buffer) {
        buffer.append(NEWLINE);
    }

    private void printXmlBodyOn(StringBuffer buffer, int indent) {
        IDependencyTracker dependencyTracker = this.getModel();
        List prerequisites = dependencyTracker.getPrerequisites();
        Iterator iterator = prerequisites.iterator();
        while (iterator.hasNext()) {
            Object prerequisite = iterator.next();
            List dependents = dependencyTracker.getDependents(prerequisite);
            this.printXmlOn(buffer, indent, prerequisite, dependents);
        }
    }

    private void printXmlFooterOn(StringBuffer buffer, int indent) {
        this.printIndentOn(buffer, indent);
        buffer.append("</dependencyTracker>");
    }

    private void printXmlHeaderOn(StringBuffer buffer, int indent) {
        String name = this.getName();
        this.printIndentOn(buffer, indent);
        buffer.append('<');
        buffer.append("dependencyTracker");
        if (name != null) {
            buffer.append(' ');
            buffer.append("name");
            buffer.append('=');
            buffer.append('\"');
            buffer.append(name);
            buffer.append('\"');
        }
        buffer.append('>');
    }

    private void printXmlOn(StringBuffer buffer, int indent) {
        this.printXmlHeaderOn(buffer, indent);
        this.printXmlBodyOn(buffer, indent);
        this.printXmlFooterOn(buffer, indent);
    }

    private void printXmlOn(StringBuffer buffer, int indent, Object prerequisite, List dependents) {
        IDependencyTracker.IXmlProvider xmlProvider = this.getXmlProvider();
        this.printIndentOn(buffer, indent + 1);
        buffer.append("<prerequisite>");
        this.printIndentOn(buffer, indent + 2);
        String convertedPrerequisite = xmlProvider.convertPrerequisiteToXml(prerequisite, indent + 2);
        buffer.append((Object)convertedPrerequisite);
        Iterator iterator = dependents.iterator();
        while (iterator.hasNext()) {
            Object dependent = iterator.next();
            this.printIndentOn(buffer, indent + 2);
            buffer.append("<dependent>");
            this.printIndentOn(buffer, indent + 3);
            String convertedDependents = xmlProvider.convertDependentToXml(dependent, indent + 3);
            buffer.append((Object)convertedDependents);
            this.printIndentOn(buffer, indent + 2);
            buffer.append("</dependent>");
        }
        this.printIndentOn(buffer, indent + 1);
        buffer.append("</prerequisite>");
    }

    private void setModel(IDependencyTracker model) {
        Assertion.checkArgumentIsNotNull(model, "model");
        this.model = model;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setXmlProvider(IDependencyTracker.IXmlProvider xmlProvider) {
        Assertion.checkArgumentIsNotNull(xmlProvider, "xmlProvider");
        this.xmlProvider = xmlProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toXml(int indent) {
        IDependencyTracker dependencyTracker;
        IDependencyTracker iDependencyTracker = dependencyTracker = this.getModel();
        synchronized (iDependencyTracker) {
            int size = dependencyTracker.size() * 500;
            StringBuffer buffer = new StringBuffer(size);
            this.printXmlOn(buffer, indent);
            String result = buffer.toString();
            return result;
        }
    }

    private static class DefaultXmlProvider
    implements IDependencyTracker.IXmlProvider {
        private DefaultXmlProvider() {
        }

        public String convertDependentToXml(Object dependent, int indent) {
            return this.convertToXml(dependent);
        }

        public String convertPrerequisiteToXml(Object prerequisite, int indent) {
            return this.convertToXml(prerequisite);
        }

        private String convertToXml(Object object) {
            String value = String.valueOf(object);
            int size = value.length() + 12;
            StringBuffer buffer = new StringBuffer(size);
            this.printXmlOn(value, buffer);
            String xml = buffer.toString();
            return xml;
        }

        private void printXmlOn(Object object, StringBuffer buffer) {
            buffer.append("<![CDATA[");
            buffer.append(object);
            buffer.append("]]>");
        }
    }
}

