/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.LogProxy;
import org.eclipse.soda.sat.core.util.MiscUtility;
import org.osgi.service.log.LogService;

public final class LogUtility {
    private static final String LOG_LEVEL_PROPERTY = "org.eclipse.soda.sat.core.util.logLevel";
    private static final String TRACE_PROPERTY = "org.eclipse.soda.sat.core.util.trace";
    private static final String LOG_LEVEL_DEBUG_KEY = "Common.LogLevelDebug";
    private static final String LOG_LEVEL_ERROR_KEY = "Common.LogLevelError";
    private static final String LOG_LEVEL_INFO_KEY = "Common.LogLevelInfo";
    private static final String LOG_LEVEL_WARNING_KEY = "Common.LogLevelWarning";
    private static final String LOG_LEVEL_ERROR_VALUE = Messages.getString("Common.LogLevelError");
    private static final String LOG_LEVEL_WARNING_VALUE = Messages.getString("Common.LogLevelWarning");
    private static final String LOG_LEVEL_INFO_VALUE = Messages.getString("Common.LogLevelInfo");
    private static final String LOG_LEVEL_DEBUG_VALUE;
    private static final String DEFAULT_LOG_LEVEL;
    private static final boolean DEFAULT_TRACE = false;
    private static final String INITIAL_LOG_LEVEL;
    private static boolean TRACING;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final LogUtility INSTANCE;
    private StringBuffer buffer;
    private LogProxy proxy;

    static {
        DEFAULT_LOG_LEVEL = LOG_LEVEL_DEBUG_VALUE = Messages.getString(LOG_LEVEL_DEBUG_KEY);
        INITIAL_LOG_LEVEL = System.getProperty(LOG_LEVEL_PROPERTY, DEFAULT_LOG_LEVEL);
        TRACING = LogUtility.getBooleanProperty(TRACE_PROPERTY, false);
        INSTANCE = new LogUtility();
    }

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        MiscUtility utility = MiscUtility.getInstance();
        boolean value = utility.getBooleanProperty(key, defaultValue);
        return value;
    }

    private static int getInitialLogLevelValue() {
        if (INITIAL_LOG_LEVEL.equalsIgnoreCase(LOG_LEVEL_ERROR_VALUE)) {
            return 1;
        }
        if (INITIAL_LOG_LEVEL.equalsIgnoreCase(LOG_LEVEL_WARNING_VALUE)) {
            return 2;
        }
        if (INITIAL_LOG_LEVEL.equalsIgnoreCase(LOG_LEVEL_INFO_VALUE)) {
            return 3;
        }
        if (INITIAL_LOG_LEVEL.equalsIgnoreCase(LOG_LEVEL_DEBUG_VALUE)) {
            return 4;
        }
        return 4;
    }

    public static LogUtility getInstance() {
        return INSTANCE;
    }

    public static int getLoggingLevel() {
        LogUtility instance = LogUtility.getInstance();
        int level = instance.getLogLevel();
        return level;
    }

    private static boolean isLogging(int level) {
        LogUtility instance = LogUtility.getInstance();
        int threshold = instance.getLogLevel();
        boolean logging = threshold >= level;
        return logging;
    }

    public static boolean isLoggingDebug() {
        return LogUtility.isLogging(4);
    }

    public static boolean isLoggingError() {
        return LogUtility.isLogging(1);
    }

    public static boolean isLoggingInfo() {
        return LogUtility.isLogging(3);
    }

    public static boolean isLoggingWarning() {
        return LogUtility.isLogging(2);
    }

    public static boolean isTracing() {
        return TRACING;
    }

    private static void log(int level, Object id, String message, Throwable throwable) {
        boolean logging = LogUtility.isLogging(level);
        if (!logging) {
            return;
        }
        LogUtility instance = LogUtility.getInstance();
        LogService log = instance.getLog();
        String formattedMessage = instance.formatMessage(id, message);
        log.log(level, formattedMessage, throwable);
    }

    public static void logDebug(Object id, String message) {
        LogUtility.logDebug(id, message, null);
    }

    public static void logDebug(Object id, String message, Throwable throwable) {
        LogUtility.log(4, id, message, throwable);
    }

    public static void logDebug(String message) {
        LogUtility.logDebug(null, message, null);
    }

    public static void logDebug(String message, Throwable throwable) {
        LogUtility.logDebug(null, message, throwable);
    }

    public static void logError(Object id, String message) {
        LogUtility.logError(id, message, null);
    }

    public static void logError(Object id, String message, Throwable throwable) {
        LogUtility.log(1, id, message, throwable);
    }

    public static void logError(String message) {
        LogUtility.logError(null, message, null);
    }

    public static void logError(String message, Throwable throwable) {
        LogUtility.logError(null, message, throwable);
    }

    public static void logInfo(Object id, String message) {
        LogUtility.logInfo(id, message, null);
    }

    public static void logInfo(Object id, String message, Throwable throwable) {
        LogUtility.log(3, id, message, throwable);
    }

    public static void logInfo(String message) {
        LogUtility.logInfo(null, message, null);
    }

    public static void logInfo(String message, Throwable throwable) {
        LogUtility.logInfo(null, message, throwable);
    }

    public static void logTrace(Object id, String message) {
        LogUtility.logTrace(id, message, null);
    }

    public static void logTrace(Object id, String message, Throwable throwable) {
        boolean tracing = LogUtility.isTracing();
        if (!tracing) {
            return;
        }
        LogUtility.log(4, id, message, throwable);
    }

    public static void logTrace(String message) {
        LogUtility.logTrace(null, message, null);
    }

    public static void logTrace(String message, Throwable throwable) {
        LogUtility.logTrace(null, message, throwable);
    }

    public static void logWarning(Object id, String message) {
        LogUtility.logWarning(id, message, null);
    }

    public static void logWarning(Object id, String message, Throwable throwable) {
        LogUtility.log(2, id, message, throwable);
    }

    public static void logWarning(String message) {
        LogUtility.logWarning(null, message, null);
    }

    public static void logWarning(String message, Throwable throwable) {
        LogUtility.logWarning(null, message, throwable);
    }

    public static void setLoggingLevel(int level) {
        LogUtility instance = LogUtility.getInstance();
        instance.setLogLevel(level);
    }

    public static void setTracing(boolean tracing) {
        TRACING = tracing;
    }

    private LogUtility() {
        this.setProxy(new LogProxy());
        this.setLogLevel(LogUtility.getInitialLogLevelValue());
        this.setBuffer(new StringBuffer(1024));
    }

    private String formatId(Object object) {
        Class<?> clazz;
        String className;
        if (object instanceof String) {
            String name = (String)object;
            name = name.trim();
            return name;
        }
        if (object instanceof Class) {
            Class clazz2 = (Class)object;
            String name = clazz2.getName();
            name = this.getClassName(name);
            return name;
        }
        String name = object.toString();
        boolean match = (name = name.trim()).startsWith(className = (clazz = object.getClass()).getName());
        if (match) {
            name = this.getClassName(className);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatMessage(Object id, String message) {
        String formattedMessage = message;
        if (id != null) {
            StringBuffer buffer;
            String formattedId = this.formatId(id);
            StringBuffer stringBuffer = buffer = this.getBuffer();
            synchronized (stringBuffer) {
                int count = buffer.length();
                buffer.delete(0, count);
                int formattedIdLength = formattedId.length();
                if (formattedIdLength != 0) {
                    buffer.append(formattedId);
                    buffer.append(": ");
                }
                buffer.append(message);
                formattedMessage = buffer.toString();
            }
        }
        return formattedMessage;
    }

    private StringBuffer getBuffer() {
        return this.buffer;
    }

    private String getClassName(String fullyQualifiedClassName) {
        int index = fullyQualifiedClassName.lastIndexOf(46);
        String name = fullyQualifiedClassName.substring(index + 1);
        return name;
    }

    public LogService getLog() {
        LogProxy log = this.getProxy();
        return log;
    }

    private int getLogLevel() {
        LogProxy proxy = this.getProxy();
        int logLevel = proxy.getLogLevel();
        return logLevel;
    }

    private LogProxy getProxy() {
        return this.proxy;
    }

    private void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void setLog(LogService log) {
        LogProxy proxy = this.getProxy();
        proxy.setLog(log);
    }

    private void setLogLevel(int logLevel) {
        LogProxy proxy = this.getProxy();
        proxy.setLogLevel(logLevel);
    }

    private void setProxy(LogProxy proxy) {
        this.proxy = proxy;
    }
}

