/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.ui.internal.api.IActivatorWizard;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.AbstractActivatorWizardPage;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.SourceFolderSelectionStatusValidator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.SourceFolderViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NewActivatorWizardPage
extends AbstractActivatorWizardPage {
    private static final String BROWSE_KEY = "NewActivatorWizardPage.Browse";
    private static final String BROWSE_PACKAGES_TOOL_TIP_KEY = "NewActivatorWizardPage.BrowsePackagesToolTip";
    private static final String BROWSE_SOURCE_FOLDERS_TOOL_TIP_KEY = "NewActivatorWizardPage.BrowseSourceFoldersToolTip";
    private static final String CLASS_ALREADY_EXISTS_KEY = "NewActivatorWizardPage.ClassAlreadyExists";
    private static final String DESCRIPTION_KEY = "NewActivatorWizardPage.Description";
    private static final String INVALID_CLASS_NAME_KEY = "NewActivatorWizardPage.InvalidClassName";
    private static final String INVALID_PACKAGE_NAME_KEY = "NewActivatorWizardPage.InvalidPackageName";
    private static final String NAME_KEY = "NewActivatorWizardPage.Name";
    private static final String NAME_TOOL_TIP_KEY = "NewActivatorWizardPage.NameToolTip";
    private static final String PACKAGE_KEY = "NewActivatorWizardPage.Package";
    private static final String PACKAGE_TOOL_TIP_KEY = "NewActivatorWizardPage.PackageToolTip";
    private static final String PACKAGE_SELECTION_DIALOG_MESSAGE_KEY = "NewActivatorWizardPage.PackageSelectionDialogMessage";
    private static final String PACKAGE_SELECTION_DIALOG_TITLE_KEY = "NewActivatorWizardPage.PackageSelectionDialogTitle";
    private static final String SOURCE_FOLDER_KEY = "NewActivatorWizardPage.SourceFolder";
    private static final String SOURCE_FOLDER_DOES_NOT_EXIST_KEY = "NewActivatorWizardPage.SourceFolderDoesNotExist";
    private static final String SOURCE_FOLDER_SELECTION_DIALOG_MESSAGE_KEY = "NewActivatorWizardPage.SourceFolderSelectionDialogMessage";
    private static final String SOURCE_FOLDER_SELECTION_DIALOG_TITLE_KEY = "NewActivatorWizardPage.SourceFolderSelectionDialogTitle";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.activator.ui.newActivatorWizardPage";
    private static final String JAVA_FILENAME_EXTENSION = ".java";
    private static final IJavaElement[] NO_CHILDREN = new IJavaElement[0];
    public static final String PAGE_NAME = NewActivatorWizardPage.class.getName();
    private Text sourceFolderNameText;
    private Text packageNameText;
    private Text classNameText;

    public NewActivatorWizardPage(IActivatorWizard parent) {
        super(PAGE_NAME, parent);
    }

    private String appendBundleSuffix(String pkg) {
        if (pkg == null) {
            return null;
        }
        int length = pkg.length();
        if (length == 0) {
            return pkg;
        }
        IActivatorWizardPreferences preferences = this.getPreferences();
        String suffix = preferences.getPackageNameSuffix();
        int suffixLength = suffix.length();
        if (suffixLength == 0) {
            return pkg;
        }
        if (pkg.equals(suffix)) {
            return pkg;
        }
        String dotSuffix = String.valueOf('.') + suffix;
        if (pkg.endsWith(dotSuffix)) {
            return pkg;
        }
        String result = String.valueOf(pkg) + dotSuffix;
        return result;
    }

    private void buildClassNameRow(Composite parent) {
        final IActivatorWizardModel model = this.getModel();
        this.createLabel(parent, NAME_KEY);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                String value = text.getText();
                model.setClassName(value);
            }
        };
        Text text = this.createText(parent, modifyListener, NAME_TOOL_TIP_KEY);
        this.setClassNameText(text);
        KeyListener keyListener = this.createClassNameKeyListener();
        text.addKeyListener(keyListener);
        String value = model.getClassName();
        text.setText(value);
    }

    private void buildPackageNameRow(Composite parent) {
        final IActivatorWizardModel model = this.getModel();
        this.createLabel(parent, PACKAGE_KEY);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                String value = text.getText();
                model.setPackageName(value);
            }
        };
        Text text = this.createText(parent, modifyListener, PACKAGE_TOOL_TIP_KEY);
        this.setPackageNameText(text);
        KeyListener keyListener = this.createPackageNameKeyListener();
        text.addKeyListener(keyListener);
        String value = model.getPackageName();
        if (value != null && value.length() != 0) {
            value = this.appendBundleSuffix(value);
            text.setText(value);
        }
        SelectionAdapter browseButtonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewActivatorWizardPage.this.handleBrowseForPackage();
            }
        };
        this.createButton(parent, 8, BROWSE_KEY, BROWSE_PACKAGES_TOOL_TIP_KEY, (SelectionListener)browseButtonSelectionListener);
    }

    protected void buildPage(Composite parent) {
        this.buildSourceFolderNameRow(parent);
        this.buildPackageNameRow(parent);
        this.buildSeparator(parent);
        this.buildClassNameRow(parent);
        this.validatePage();
    }

    private void buildSourceFolderNameRow(Composite parent) {
        this.createLabel(parent, SOURCE_FOLDER_KEY);
        Text text = this.createText(parent, null, null);
        this.setSourceFolderNameText(text);
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        String sourceFolderName = this.getSourceFolderFromPackageFragmentRoot(root);
        text.setText(sourceFolderName);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewActivatorWizardPage.this.handleBrowseForSourceFolder();
            }
        };
        this.createButton(parent, 8, BROWSE_KEY, BROWSE_SOURCE_FOLDERS_TOOL_TIP_KEY, (SelectionListener)listener);
    }

    private IPackageFragmentRoot chooseSourceFolder() {
        IPackageFragmentRoot result = null;
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        String title = Messages.getString(SOURCE_FOLDER_SELECTION_DIALOG_TITLE_KEY);
        dialog.setTitle(title);
        String message = Messages.getString(SOURCE_FOLDER_SELECTION_DIALOG_MESSAGE_KEY);
        dialog.setMessage(message);
        ArrayList validTypes = new ArrayList(2);
        validTypes.add(IPackageFragmentRoot.class);
        validTypes.add(IJavaProject.class);
        SourceFolderSelectionStatusValidator validator = new SourceFolderSelectionStatusValidator(validTypes);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        ArrayList filteredTypes = new ArrayList(3);
        filteredTypes.add(IJavaModel.class);
        filteredTypes.add(IPackageFragmentRoot.class);
        filteredTypes.add(IJavaProject.class);
        SourceFolderViewerFilter filter = new SourceFolderViewerFilter(filteredTypes);
        dialog.addFilter((ViewerFilter)filter);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IJavaModel input = JavaCore.create((IWorkspaceRoot)workspaceRoot);
        dialog.setInput((Object)input);
        IPackageFragmentRoot initElement = this.getPackageFragmentRoot();
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                IProject project = jproject.getProject();
                result = jproject.getPackageFragmentRoot((IResource)project);
            } else if (element instanceof IPackageFragmentRoot) {
                result = (IPackageFragmentRoot)element;
            }
        }
        return result;
    }

    private KeyListener createClassNameKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                boolean valid;
                char ch = event.character;
                event.doit = valid = Character.isJavaIdentifierStart(ch) || Character.isJavaIdentifierPart(ch);
            }
        };
    }

    private KeyListener createPackageNameKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                boolean valid;
                char ch = event.character;
                event.doit = valid = ch == '.' || Character.isJavaIdentifierStart(ch) || Character.isJavaIdentifierPart(ch);
            }
        };
    }

    private IJavaElement[] getChildrenOfPackageFragmentRoot() {
        IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        IJavaElement[] children = null;
        try {
            if (packageFragmentRoot != null && packageFragmentRoot.exists()) {
                children = packageFragmentRoot.getChildren();
            }
        }
        catch (JavaModelException exception) {
            this.logError(exception);
        }
        if (children == null) {
            children = NO_CHILDREN;
        }
        return children;
    }

    private String getClassName() {
        Text text = this.getClassNameText();
        String value = text.getText();
        return value;
    }

    private Text getClassNameText() {
        return this.classNameText;
    }

    protected int getColumns() {
        return 3;
    }

    protected String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    protected String getMessageString() {
        return Messages.getString(DESCRIPTION_KEY);
    }

    private String getPackageName() {
        Text text = this.getPackageNameText();
        String value = text.getText();
        return value;
    }

    private Text getPackageNameText() {
        return this.packageNameText;
    }

    private String getSourceFolderFromPackageFragmentRoot(IPackageFragmentRoot root) {
        String projectName = null;
        String folderName = null;
        StringBuffer buffer = new StringBuffer(150);
        if (root != null) {
            IJavaElement project = root.getAncestor(2);
            if (project != null) {
                projectName = project.getElementName();
                buffer.append(projectName);
            }
            if ((folderName = root.getElementName()) != null && folderName.length() != 0) {
                buffer.append(File.separatorChar);
                buffer.append(folderName);
            }
        }
        String value = buffer.toString();
        return value;
    }

    private String getSourceFolderName() {
        Text text = this.getSourceFolderNameText();
        String value = text.getText();
        return value;
    }

    private Text getSourceFolderNameText() {
        return this.sourceFolderNameText;
    }

    private void handleBrowseForPackage() {
        IActivatorWizardModel model = this.getModel();
        String name = this.openPackageNameSelectionDialog();
        model.setPackageName(name);
    }

    private void handleBrowseForSourceFolder() {
        this.validatePage();
        String sourceFolderName = this.openSourceFolderNameSelectionDialog();
        Text text = this.getSourceFolderNameText();
        text.setText(sourceFolderName);
    }

    protected void handleClassNameChanged(String className) {
        this.validatePage();
        String value = this.getClassName();
        boolean equal = value.equals(className);
        if (equal) {
            return;
        }
        Text text = this.getClassNameText();
        text.setText(className);
    }

    protected void handlePackageNameChanged(String packageName) {
        this.validatePage();
        String value = this.getPackageName();
        boolean equal = value.equals(packageName);
        if (equal) {
            return;
        }
        Text text = this.getPackageNameText();
        text.setText(packageName);
    }

    private boolean isExistingClass() {
        IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        if (packageFragmentRoot == null) {
            return false;
        }
        boolean exists = packageFragmentRoot.exists();
        if (!exists) {
            return false;
        }
        IActivatorWizardModel model = this.getModel();
        String packageName = model.getPackageName();
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
        exists = packageFragment.exists();
        if (!exists) {
            return false;
        }
        String name = String.valueOf(model.getClassName()) + JAVA_FILENAME_EXTENSION;
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit(name);
        exists = compilationUnit.exists();
        return exists;
    }

    private boolean isValidClassName() {
        String className = this.getClassName();
        int length = className.length();
        if (length == 0) {
            return false;
        }
        boolean valid = OS.isNameValid((String)className);
        if (!valid) {
            return false;
        }
        char ch = className.charAt(0);
        valid = Character.isJavaIdentifierStart(ch);
        return valid;
    }

    private boolean isValidPackageName() {
        String packageName = this.getPackageName();
        int length = packageName.length();
        if (length == 0) {
            return true;
        }
        boolean valid = true;
        char ch = packageName.charAt(0);
        valid = valid && Character.isJavaIdentifierStart(ch);
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        while (valid && tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            valid = OS.isNameValid((String)token);
        }
        ch = packageName.charAt(length - 1);
        valid = valid && ch != '.';
        return valid;
    }

    private String openPackageNameSelectionDialog() {
        int rc;
        Shell shell = this.getShell();
        JavaElementLabelProvider provider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)provider);
        dialog.setIgnoreCase(false);
        String title = Messages.getString(PACKAGE_SELECTION_DIALOG_TITLE_KEY);
        dialog.setTitle(title);
        String message = Messages.getString(PACKAGE_SELECTION_DIALOG_MESSAGE_KEY);
        dialog.setMessage(message);
        Object[] children = this.getChildrenOfPackageFragmentRoot();
        dialog.setElements(children);
        String packageName = this.getPackageName();
        boolean found = false;
        int i = 0;
        IPackageFragment selectedPackageFragment = null;
        while (!found && i < children.length) {
            selectedPackageFragment = (IPackageFragment)children[i];
            String childName = selectedPackageFragment.getElementName();
            found = childName.equals(packageName);
            ++i;
        }
        if (found) {
            Object[] selectedElements = new Object[]{selectedPackageFragment};
            dialog.setInitialSelections(selectedElements);
        }
        if ((rc = dialog.open()) == 0) {
            IPackageFragment result = (IPackageFragment)dialog.getFirstResult();
            packageName = result.getElementName();
        }
        return packageName;
    }

    private String openSourceFolderNameSelectionDialog() {
        IPackageFragmentRoot root = this.chooseSourceFolder();
        this.setPackageFragmentRoot(root);
        String result = this.getSourceFolderFromPackageFragmentRoot(root);
        return result;
    }

    private void setClassNameText(Text classNameText) {
        this.classNameText = classNameText;
    }

    private void setPackageNameText(Text packageNameText) {
        this.packageNameText = packageNameText;
    }

    private void setSourceFolderNameText(Text sourceFolderNameText) {
        this.sourceFolderNameText = sourceFolderNameText;
    }

    private void validatePage() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            String pattern = Messages.getString(SOURCE_FOLDER_DOES_NOT_EXIST_KEY);
            String sourceFolderName = this.getSourceFolderName();
            Object[] values = new Object[]{sourceFolderName};
            String message = MessageFormat.format(pattern, values);
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        boolean validClassName = this.isValidClassName();
        if (!validClassName) {
            String pattern = Messages.getString(INVALID_CLASS_NAME_KEY);
            String className = this.getClassName();
            Object[] values = new Object[]{className};
            String message = MessageFormat.format(pattern, values);
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        boolean existingClass = this.isExistingClass();
        if (existingClass) {
            String pattern = Messages.getString(CLASS_ALREADY_EXISTS_KEY);
            String className = this.getClassName();
            Object[] values = new Object[]{className};
            String message = MessageFormat.format(pattern, values);
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        boolean validPackage = this.isValidPackageName();
        if (!validPackage) {
            String pattern = Messages.getString(INVALID_PACKAGE_NAME_KEY);
            String packageName = this.getPackageName();
            Object[] values = new Object[]{packageName};
            String message = MessageFormat.format(pattern, values);
            this.setErrorMessage(message);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

