/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.pages.ServicesActivatorWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ServicesCompositeBuilder {
    private static final String ADD_KEY = "ServicesCompositeBuilder.Add";
    private static final String ADD_SHORTCUT_KEY = "ServicesCompositeBuilder.AddShortcut";
    private static final String EDIT_KEY = "ServicesCompositeBuilder.Edit";
    private static final String EDIT_SHORTCUT_KEY = "ServicesCompositeBuilder.EditShortcut";
    private static final String MAXIMIZE_AND_RESTORE_KEY = "ServicesCompositeBuilder.MaximizeAndRestore";
    private static final String REMOVE_KEY = "ServicesCompositeBuilder.Remove";
    private static final String REMOVE_SHORTCUT_KEY = "ServicesCompositeBuilder.RemoveShortcut";
    private static final String SELECT_SERVICE_TYPE_DIALOG_MESSAGE_KEY = "ServicesCompositeBuilder.SelectServiceTypeDialogMessage";
    private static final String SELECT_SERVICE_TYPE_DIALOG_TITLE_KEY = "ServicesCompositeBuilder.SelectServiceTypeDialogTitle";
    protected static final String SERVICE_NAME_KEY = "ServicesCompositeBuilder.ServiceName";
    protected static final String SERVICE_NAME_COLUMN_ID = "serviceName";
    protected static final int SERVICE_NAME_COLUMN_INDEX = 0;
    protected static final int CHECKBOX_COLUMN_WIDTH = 70;
    protected static final int SERVICE_NAME_COLUMN_WIDTH = 200;
    private static final char ADD_SHORTCUT = Messages.getString("ServicesCompositeBuilder.AddShortcut").charAt(0);
    private static final char EDIT_SHORTCUT = Messages.getString("ServicesCompositeBuilder.EditShortcut").charAt(0);
    private static final char REMOVE_SHORTCUT = Messages.getString("ServicesCompositeBuilder.RemoveShortcut").charAt(0);
    private static final String[] NO_ITEMS = new String[0];
    private ServicesActivatorWizardPage page;
    private TableViewer tableViewer;
    private Button editButton;
    private Button removeButton;
    private MenuItem editMenuItem;
    private MenuItem removeMenuItem;

    ServicesCompositeBuilder(ServicesActivatorWizardPage page) {
        this.setPage(page);
    }

    final void addBundleDependencyFor(IType type) {
        ServicesActivatorWizardPage page = this.getPage();
        page.addBundleDependencyFor(type);
    }

    void addService(IType type) {
        this.addBundleDependencyFor(type);
    }

    final void build(SashForm parent) {
        Composite composite = this.createComposite((Composite)parent, 2);
        this.setVerticalSpacing(composite, 1);
        MouseListener listener = this.createSashFormMaximizerMouseListener(parent, (Control)composite);
        this.createLabelComposite(composite, listener);
        this.createTableViewer(composite);
        this.createButtons(composite);
    }

    final int calculateRemainingHorizontalSpace(Table table, int startColumn) {
        boolean visible;
        Rectangle bounds = table.getBounds();
        boolean bl = visible = bounds.width != 0 || bounds.height != 0;
        if (!visible) {
            return 0;
        }
        int width = bounds.width;
        int tableBorderWidth = table.getBorderWidth();
        width -= tableBorderWidth * 2;
        ScrollBar scrollbar = table.getVerticalBar();
        Point scrollbarSize = scrollbar.getSize();
        width -= scrollbarSize.x;
        TableColumn[] columns = table.getColumns();
        int count = columns.length;
        int cumulative = 0;
        int i = startColumn;
        while (i < count) {
            TableColumn column = columns[i];
            int columnWidth = column.getWidth();
            cumulative += columnWidth;
            ++i;
        }
        int remainder = width - cumulative + 10;
        return remainder;
    }

    private void createAddButton(Composite parent) {
        SelectionAdapter listener = this.createAddSelectionListener();
        String addToolTipKey = this.getAddButtonToolTipKey();
        this.createButton(parent, 8, ADD_KEY, addToolTipKey, (SelectionListener)listener);
    }

    private void createAddMenuItem(Menu menu) {
        SelectionAdapter listener = this.createAddSelectionListener();
        this.createMenuItem(menu, ADD_KEY, (SelectionListener)listener, 0x1000009);
    }

    private SelectionAdapter createAddSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesCompositeBuilder.this.handleAddButtonClicked();
            }
        };
    }

    private Button createButton(Composite parent, int style, String textKey, String toolTipKey, SelectionListener listener) {
        ServicesActivatorWizardPage page = this.getPage();
        Button button = page.createButton(parent, style, textKey, toolTipKey, listener);
        return button;
    }

    private void createButtons(Composite parent) {
        Composite composite = this.createComposite(parent, 1, false, true);
        this.createAddButton(composite);
        this.createEditButton(composite);
        this.createRemoveButton(composite);
    }

    abstract CellEditor[] createCellEditors(Table var1);

    private ICellModifier createCellModifier(final TableViewer viewer) {
        return new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return ServicesCompositeBuilder.this.handleCanModifyCellEditor(property);
            }

            public Object getValue(Object element, String property) {
                IServiceDetails details = (IServiceDetails)element;
                return ServicesCompositeBuilder.this.handleGetValueOfCellEditor(details, property);
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                IServiceDetails details = (IServiceDetails)item.getData();
                ServicesCompositeBuilder.this.handleModifyCellEditor(details, property, value);
                viewer.update((Object)details, null);
            }
        };
    }

    final CellEditor createCheckboxCellEditor(Table table) {
        return new CheckboxCellEditor((Composite)table);
    }

    abstract String[] createColumnProperties();

    final CellEditor createComboBoxCellEditor(Composite parent) {
        ComboBoxCellEditor editor = new ComboBoxCellEditor(parent, NO_ITEMS, 8);
        return editor;
    }

    private Composite createComposite(Composite parent, int columns) {
        ServicesActivatorWizardPage page = this.getPage();
        Composite composite = page.createComposite(parent, columns);
        return composite;
    }

    private Composite createComposite(Composite parent, int columns, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        ServicesActivatorWizardPage page = this.getPage();
        Composite composite = page.createComposite(parent, columns, grabExcessHorizontalSpace, grabExcessVerticalSpace);
        return composite;
    }

    private void createEditButton(Composite parent) {
        SelectionAdapter listener = this.createEditSelectionListener();
        String toolTipKey = this.getEditButtonToolTipKey();
        Button button = this.createButton(parent, 8, EDIT_KEY, toolTipKey, (SelectionListener)listener);
        this.setEditButton(button);
        this.enableEditButton(false);
        this.enableEditMenuItem(false);
    }

    private void createEditMenuItem(Menu menu) {
        SelectionAdapter listener = this.createEditSelectionListener();
        MenuItem menuItem = this.createMenuItem(menu, EDIT_KEY, (SelectionListener)listener, 0x100000B);
        this.setEditMenuItem(menuItem);
    }

    private SelectionAdapter createEditSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesCompositeBuilder.this.handleEditButtonClicked();
            }
        };
    }

    private Label createLabel(Composite parent, String textKey, int horizontalSpan) {
        ServicesActivatorWizardPage page = this.getPage();
        Label label = page.createLabel(parent, textKey, horizontalSpan);
        return label;
    }

    private Composite createLabelComposite(Composite parent, MouseListener listener) {
        Composite composite = this.createComposite(parent, 2, true, false);
        GridData data = new GridData(1, 0x1000000, true, false, 2, 1);
        composite.setLayoutData((Object)data);
        Activator activator = Activator.getDefault();
        String imageKey = this.getImageKey();
        Image image = activator.getImage(imageKey);
        Label label = this.createLabel(composite, null, 1);
        label.setImage(image);
        label.addMouseListener(listener);
        String toolTip = Messages.getString(MAXIMIZE_AND_RESTORE_KEY);
        label.setToolTipText(toolTip);
        String titleKey = this.getTitleKey();
        this.createLabel(composite, titleKey, 1);
        return composite;
    }

    private MenuItem createMenuItem(Menu menu, String textKey, SelectionListener listener, int accelerator) {
        MenuItem menuItem = new MenuItem(menu, 0);
        String value = this.createMenuItemText(textKey, accelerator);
        menuItem.setText(value);
        menuItem.addSelectionListener(listener);
        menuItem.setAccelerator(accelerator);
        return menuItem;
    }

    private String createMenuItemText(String textKey, int accelerator) {
        String acceleratorText = Action.convertAccelerator((int)accelerator);
        StringBuffer buffer = new StringBuffer(25);
        String text = Messages.getString(textKey);
        buffer.append(text);
        buffer.append('\t');
        buffer.append(acceleratorText);
        String value = buffer.toString();
        return value;
    }

    private void createRemoveButton(Composite parent) {
        SelectionAdapter listener = this.createRemoveSelectionListener();
        String toolTipKey = this.getRemoveButtonToolTipKey();
        Button button = this.createButton(parent, 8, REMOVE_KEY, toolTipKey, (SelectionListener)listener);
        this.setRemoveButton(button);
        this.enableRemoveButton(false);
        this.enableRemoveMenuItem(false);
    }

    private void createRemoveMenuItem(Menu menu) {
        SelectionAdapter listener = this.createRemoveSelectionListener();
        MenuItem menuItem = this.createMenuItem(menu, REMOVE_KEY, (SelectionListener)listener, 127);
        this.setRemoveMenuItem(menuItem);
    }

    private SelectionAdapter createRemoveSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ServicesCompositeBuilder.this.handleRemoveButtonClicked();
            }
        };
    }

    private MouseListener createSashFormMaximizerMouseListener(final SashForm form, final Control control) {
        return new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Control maximized = form.getMaximizedControl();
                Control maximizedControl = maximized == null ? control : null;
                form.setMaximizedControl(maximizedControl);
            }
        };
    }

    private int createServicesTableStyle() {
        return 67586;
    }

    final void createTableColumn(Table table, String columnLabelKey, int width) {
        TableColumn column = new TableColumn(table, 0);
        String text = Messages.getString(columnLabelKey);
        column.setText(text);
        column.setWidth(width);
    }

    void createTableColumns(Table table) {
        this.createTableColumn(table, SERVICE_NAME_KEY, 200);
    }

    private ControlListener createTableControlListener() {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ServicesCompositeBuilder.this.handleTableResized();
            }
        };
    }

    private KeyAdapter createTableKeyListener() {
        return new KeyAdapter(){

            private boolean isAltKeyDown(KeyEvent event) {
                return (event.stateMask & 0x10000) != 0;
            }

            public void keyReleased(KeyEvent event) {
                event.character = Character.toLowerCase(event.character);
                boolean altKeyDown = this.isAltKeyDown(event);
                ServicesCompositeBuilder.this.handleTableKeyPressed(event, altKeyDown);
            }
        };
    }

    abstract ITableLabelProvider createTableLabelProvider();

    private Menu createTableMenu() {
        Shell parent = this.getShell();
        Menu menu = new Menu((Control)parent);
        this.createTableMenuItems(menu);
        return menu;
    }

    private void createTableMenuItems(Menu menu) {
        this.createAddMenuItem(menu);
        this.createRemoveMenuItem(menu);
        this.createEditMenuItem(menu);
    }

    private void createTableViewer(Composite parent) {
        int style = this.createServicesTableStyle();
        ITableLabelProvider labelProvider = this.createTableLabelProvider();
        ArrayContentProvider contentProvider = new ArrayContentProvider();
        ISelectionChangedListener listener = this.createTableViewerSelectionChangedListener();
        TableViewer viewer = this.createTableViewer(parent, style, labelProvider, (IContentProvider)contentProvider, listener);
        this.setTableViewer(viewer);
        ControlListener controlListener = this.createTableControlListener();
        parent.addControlListener(controlListener);
        Table table = viewer.getTable();
        this.createTableColumns(table);
        KeyAdapter keyListener = this.createTableKeyListener();
        table.addKeyListener((KeyListener)keyListener);
        Menu menu = this.createTableMenu();
        table.setMenu(menu);
        String[] columnProperties = this.createColumnProperties();
        viewer.setColumnProperties(columnProperties);
        CellEditor[] editors = this.createCellEditors(table);
        viewer.setCellEditors(editors);
        ICellModifier modifier = this.createCellModifier(viewer);
        viewer.setCellModifier(modifier);
        Object list = this.createTableViewerInput();
        viewer.setInput(list);
    }

    private TableViewer createTableViewer(Composite parent, int style, ITableLabelProvider labelProvider, IContentProvider contentProvider, ISelectionChangedListener selectionChangedListener) {
        ServicesActivatorWizardPage page = this.getPage();
        TableViewer viewer = page.createTableViewer(parent, style, labelProvider, contentProvider, selectionChangedListener);
        return viewer;
    }

    abstract Object createTableViewerInput();

    private ISelectionChangedListener createTableViewerSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServicesCompositeBuilder.this.handleTableViewerSelectionChanged(event);
            }
        };
    }

    final CellEditor createTextCellEditor(Table table) {
        return new TextCellEditor((Composite)table);
    }

    boolean editService(IServiceDetails details, IType selectedType) {
        return true;
    }

    private void enableEditButton(boolean enable) {
        Button control = this.getEditButton();
        control.setEnabled(enable);
    }

    private void enableEditMenuItem(boolean enable) {
        MenuItem menuItem = this.getEditMenuItem();
        menuItem.setEnabled(enable);
    }

    private void enableRemoveButton(boolean enable) {
        Button control = this.getRemoveButton();
        control.setEnabled(enable);
    }

    private void enableRemoveMenuItem(boolean enable) {
        MenuItem menuItem = this.getRemoveMenuItem();
        menuItem.setEnabled(enable);
    }

    abstract String getAddButtonToolTipKey();

    final CellEditor getCellEditor(int index) {
        TableViewer viewer = this.getTableViewer();
        CellEditor[] editors = viewer.getCellEditors();
        CellEditor editor = editors[index];
        return editor;
    }

    private Button getEditButton() {
        return this.editButton;
    }

    abstract String getEditButtonToolTipKey();

    private MenuItem getEditMenuItem() {
        return this.editMenuItem;
    }

    abstract String getImageKey();

    final IJavaProject getJavaProject() {
        ServicesActivatorWizardPage page = this.getPage();
        IJavaProject project = page.getJavaProject();
        return project;
    }

    final IActivatorWizardModel getModel() {
        ServicesActivatorWizardPage page = this.getPage();
        IActivatorWizardModel model = page.getModel();
        return model;
    }

    final ServicesActivatorWizardPage getPage() {
        return this.page;
    }

    private Button getRemoveButton() {
        return this.removeButton;
    }

    abstract String getRemoveButtonToolTipKey();

    private MenuItem getRemoveMenuItem() {
        return this.removeMenuItem;
    }

    final Shell getShell() {
        ServicesActivatorWizardPage page = this.getPage();
        Shell shell = page.getShell();
        return shell;
    }

    final TableViewer getTableViewer() {
        return this.tableViewer;
    }

    final List<?> getTableViewerSelectionList() {
        TableViewer viewer = this.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        List list = selection.toList();
        return list;
    }

    abstract String getTitleKey();

    private void handleAddButtonClicked() {
        IType[] types;
        IType[] iTypeArray = types = this.openSelectServiceTypeDialog();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            this.addService(type);
            ++n2;
        }
    }

    abstract boolean handleCanModifyCellEditor(String var1);

    private void handleEditButtonClicked() {
        TableViewer viewer = this.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        IServiceDetails details = (IServiceDetails)selection.getFirstElement();
        String name = details.getName();
        String filter = this.toUnqualifiedTypeName(name);
        IType[] selectedTypes = this.openSelectServiceTypeDialog(filter, false);
        if (selectedTypes.length == 0) {
            return;
        }
        IType selectedType = selectedTypes[0];
        IType type = details.getType();
        if (selectedType == type) {
            return;
        }
        boolean state = this.editService(details, selectedType);
        if (!state) {
            return;
        }
        this.removeBundleDependencyFor(name);
        this.addBundleDependencyFor(selectedType);
        this.refreshTableViewer(details);
    }

    abstract Object handleGetValueOfCellEditor(IServiceDetails var1, String var2);

    abstract void handleModifyCellEditor(IServiceDetails var1, String var2, Object var3);

    private void handleRemoveButtonClicked() {
        TableViewer viewer = this.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        List list = selection.toList();
        for (Object object : list) {
            IServiceDetails details = (IServiceDetails)object;
            this.removeService(details);
        }
    }

    final void handleServiceDetailsChanged(List<? extends IServiceDetails> details) {
        TableViewer viewer = this.getTableViewer();
        viewer.setInput(details);
    }

    void handleTableKeyPressed(KeyEvent event, boolean altKeyDown) {
        if (this.isAddShortcutKeyPressed(event, altKeyDown)) {
            this.handleAddButtonClicked();
        } else if (this.isRemoveShortcutKeyPressed(event, altKeyDown)) {
            this.handleRemoveButtonClicked();
        } else if (this.isEditShortcutKeyPressed(event, altKeyDown)) {
            this.handleEditButtonClicked();
        }
    }

    abstract void handleTableResized();

    private void handleTableViewerSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        boolean empty = selection.isEmpty();
        boolean state = !empty;
        this.enableRemoveButton(state);
        this.enableRemoveMenuItem(state);
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        int size = structuredSelection.size();
        state = size == 1;
        this.enableEditButton(state);
        this.enableEditMenuItem(state);
    }

    private boolean isAddShortcutKeyPressed(KeyEvent event, boolean altKeyDown) {
        if (event.keyCode == 0x1000009) {
            return true;
        }
        return altKeyDown && event.character == ADD_SHORTCUT;
    }

    private boolean isEditShortcutKeyPressed(KeyEvent event, boolean altKeyDown) {
        if (event.keyCode == 0x100000B) {
            return true;
        }
        return altKeyDown && event.character == EDIT_SHORTCUT;
    }

    private boolean isRemoveShortcutKeyPressed(KeyEvent event, boolean altKeyDown) {
        if (event.keyCode == 127) {
            return true;
        }
        return altKeyDown && event.character == REMOVE_SHORTCUT;
    }

    final IType[] openSelectServiceTypeDialog() {
        String titleKey = SELECT_SERVICE_TYPE_DIALOG_TITLE_KEY;
        String messageKey = SELECT_SERVICE_TYPE_DIALOG_MESSAGE_KEY;
        IType[] types = this.openSelectTypeDialog(titleKey, messageKey);
        return types;
    }

    final IType[] openSelectServiceTypeDialog(String filter, boolean multipleSelection) {
        String titleKey = SELECT_SERVICE_TYPE_DIALOG_TITLE_KEY;
        String messageKey = SELECT_SERVICE_TYPE_DIALOG_MESSAGE_KEY;
        IType[] types = this.openSelectTypeDialog(titleKey, messageKey, filter, multipleSelection);
        return types;
    }

    private IType[] openSelectTypeDialog(String titleKey, String messageKey) {
        ServicesActivatorWizardPage page = this.getPage();
        IType[] types = page.openSelectTypeDialog(titleKey, messageKey);
        return types;
    }

    private IType[] openSelectTypeDialog(String titleKey, String messageKey, String filter, boolean multipleSelection) {
        ServicesActivatorWizardPage page = this.getPage();
        IType[] types = page.openSelectTypeDialog(titleKey, messageKey, filter, multipleSelection);
        return types;
    }

    final void refreshTableViewer() {
        TableViewer viewer = this.getTableViewer();
        viewer.refresh();
    }

    final void refreshTableViewer(Object element) {
        TableViewer viewer = this.getTableViewer();
        viewer.refresh(element);
    }

    final void removeBundleDependencyFor(String fullyQualifiedName) {
        ServicesActivatorWizardPage page = this.getPage();
        page.removeBundleDependencyFor(fullyQualifiedName);
    }

    void removeService(IServiceDetails details) {
        String fullyQualifiedName = details.getName();
        this.removeBundleDependencyFor(fullyQualifiedName);
    }

    private void setEditButton(Button editButton) {
        this.editButton = editButton;
    }

    private void setEditMenuItem(MenuItem editMenuItem) {
        this.editMenuItem = editMenuItem;
    }

    private void setPage(ServicesActivatorWizardPage page) {
        this.page = page;
    }

    private void setRemoveButton(Button removeButton) {
        this.removeButton = removeButton;
    }

    private void setRemoveMenuItem(MenuItem removeMenuItem) {
        this.removeMenuItem = removeMenuItem;
    }

    private void setTableViewer(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    private void setVerticalSpacing(Composite composite, int pixels) {
        ServicesActivatorWizardPage page = this.getPage();
        page.setVerticalSpacing(composite, pixels);
    }

    final String toUnqualifiedTypeName(String name) {
        ServicesActivatorWizardPage page = this.getPage();
        String result = page.toUnqualifiedTypeName(name);
        return result;
    }
}

