/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.util.List;
import org.eclipse.soda.devicekit.editor.dkml.DeviceKitFormPage;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitTagConstants;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;

public class ProtocolPage
extends DeviceKitFormPage {
    public ProtocolPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite parent = this.setup(managedForm, 2);
        DeviceKitTagModel dkFileModel = this.getTagModel();
        if (dkFileModel != null) {
            try {
                MainTagElement mainElement = dkFileModel.getMainElement();
                if (mainElement != null) {
                    List protocols = mainElement.getAllChildrenWithTagCode(101, false);
                    List filterList = mainElement.getAllSubChildrenWithTagCodeWithId(6, false);
                    List messageList = mainElement.getAllSubChildrenWithTagCodeWithId(DeviceKitTagConstants.ALL_MESSAGE_CODES, false);
                    SortedSet dataList = new SortedSet();
                    int i = 0;
                    while (i < protocols.size()) {
                        List dataLists = mainElement.getAllSubChildrenWithTagCodeWithId(76, false);
                        dataList.addAll(dataLists);
                        ++i;
                    }
                    List parameterList = mainElement.getAllSubChildrenWithTagCodeWithId(new int[]{5, 23}, false);
                    Section messagesSection = this.createTagsSection(parent, messageList, "message");
                    SectionPart messagesPart = new SectionPart(messagesSection);
                    managedForm.addPart((IFormPart)messagesPart);
                    Section parametersSection = this.createTagsSection(parent, parameterList, "parameter");
                    SectionPart parametersPart = new SectionPart(parametersSection);
                    managedForm.addPart((IFormPart)parametersPart);
                    Section filtersSection = this.createTagsSection(parent, filterList, "filter");
                    SectionPart filtersPart = new SectionPart(filtersSection);
                    managedForm.addPart((IFormPart)filtersPart);
                    Section datasSection = this.createTagsSection(parent, (List)dataList, "data");
                    SectionPart datasPart = new SectionPart(datasSection);
                    managedForm.addPart((IFormPart)datasPart);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

