/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.build.BuildModel;
import org.eclipse.soda.devicekit.generator.build.BuildSaver;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.generator.metadata.DeviceKitMetaDataException;
import org.eclipse.soda.devicekit.generator.metadata.MetaDataUtility;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomManifestInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.CustomTypeInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.FieldInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.MethodInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.TypeInformation;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.IDkGenerator;
import org.eclipse.soda.devicekit.generator.model.NewCodeGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.BlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.RootElement;
import org.eclipse.soda.devicekit.generator.model.elements.SegmentElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecReferenceElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.model.java.IField;
import org.eclipse.soda.devicekit.generator.model.java.IMethod;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.model.java.JavaModelException;
import org.eclipse.soda.devicekit.generator.print.XmlPrinter;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;
import org.eclipse.soda.devicekit.generator.save.java.IJavaSaver;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.soda.devicekit.util.HtmlHelper;
import org.eclipse.soda.devicekit.util.KeyValuePair;
import org.eclipse.soda.devicekit.util.Nls;

public abstract class AbstractDkGenerator
implements IDkGenerator {
    protected CustomInfo customInfo;
    protected CustomInfo existInfo;
    protected GeneratedInfo generatedInfo;
    protected JavaFileModel fBundleActivatorModel;
    private JavaFileModel messageModel;
    private HtmlHelper fHtmlHelper;
    private String fMainClassName;
    private String fMainPackage;
    private MainTagElement fMainTagElement;
    private ManifestModel fManifestModel;
    private IFileSaver fManifestSaver;
    private Map fMethodProperties;
    private DeviceKitTagModel fModel;
    private String fPackageBase;
    private RootElement fRoot;
    private IJavaSaver fSaver;
    protected JavaFileModel fServiceModel;
    protected boolean osgi = true;
    protected BuildModel buildModel;
    private IFileSaver buildSaver;
    protected Map otherManifestFiles = new HashMap();
    protected String sourceLevel = AbstractDkGenerator.getSourceLevelDefault();

    public static String getSourceLevelDefault() {
        String source = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        if (source != null && source.length() > 0) {
            return source;
        }
        return "1.4";
    }

    protected AbstractDkGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new HashMap());
    }

    protected AbstractDkGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Map methodProperties) {
        this.fModel = model;
        this.fMethodProperties = methodProperties;
        this.generatedInfo = generatedInfo;
        this.init();
    }

    public void addAdditionalBundles(String bundleId) {
        this.getBuildModel().addAdditionalBundles(bundleId);
    }

    private void addCustomManifestItems() {
        CustomManifestInformation manifest;
        if (this.customInfo != null && (manifest = this.customInfo.getManifestInformation(this.getSourceFolderName())) != null) {
            String[] keys = manifest.getCustomManifestKeys();
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String value = manifest.getCustomManifestValue(key);
                this.fManifestModel.setKeyValue(key, value);
                ++i;
            }
        }
    }

    private FieldInformation addFieldMetaData(IType type, IField field) {
        try {
            String fieldKey = MetaDataUtility.createFieldKey(field);
            String packageName = type.getPackage();
            String typeName = type.getName();
            TypeInformation typeInfo = this.generatedInfo.getTypeInformation(packageName, typeName);
            if (typeInfo != null) {
                FieldInformation info = typeInfo.addFieldInformation(fieldKey, null, this.getVersion());
                return info;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String[] addJavaDocToComment(String name, String[] comment, String returnType, KeyValuePair[] parameters, String[] exceptions) {
        boolean returns = returnType != null && !"void".equals(returnType);
        boolean getMethod = returns && name.startsWith("get") && name.length() > 3;
        boolean containsParam = false;
        boolean containsReturn = false;
        boolean containsThrow = false;
        ArrayList<String> buildComment = new ArrayList<String>();
        if (comment != null && comment.length > 0) {
            int i = 0;
            while (i < comment.length) {
                buildComment.add(comment[i]);
                if (comment[i].indexOf("@param ") != -1) {
                    containsParam = true;
                }
                if (comment[i].indexOf("@return ") != -1) {
                    containsReturn = true;
                }
                if (comment[i].indexOf("@throws ") != -1) {
                    containsThrow = true;
                }
                ++i;
            }
        } else if (getMethod) {
            String firstLine = "Gets the " + CodeUtilities.betterName(name, false) + " value.";
            buildComment.add(firstLine);
        } else {
            String firstLine = String.valueOf(CodeUtilities.betterName(name, true)) + '.';
            buildComment.add(firstLine);
        }
        if (parameters != null && !containsParam) {
            int i = 0;
            while (i < parameters.length) {
                String parameterLine = "@param " + parameters[i].getValue() + ' ' + CodeUtilities.betterName(parameters[i].getValue(), false) + '.';
                if (!buildComment.contains(parameterLine)) {
                    buildComment.add(parameterLine);
                }
                ++i;
            }
        }
        if (returns && !containsReturn) {
            if (getMethod) {
                String returnLine = "@return The " + CodeUtilities.betterName(name.substring(3), false) + " value.";
                if (!buildComment.contains(returnLine)) {
                    buildComment.add(returnLine);
                }
            } else if (!buildComment.contains("@return The results of this method.")) {
                buildComment.add("@return The results of this method.");
            }
        }
        if (exceptions != null && !containsThrow) {
            int i = 0;
            while (i < exceptions.length) {
                String exceptionLine = "@throws " + exceptions[i] + ' ' + CodeUtilities.betterName(exceptions[i], false) + '.';
                if (!buildComment.contains(exceptionLine)) {
                    buildComment.add(exceptionLine);
                }
                ++i;
            }
        }
        String[] newComment = new String[buildComment.size()];
        newComment = buildComment.toArray(newComment);
        return newComment;
    }

    private void addMethodMetaData(IType type, IMethod method) {
        try {
            String methodKey = MetaDataUtility.createMethodKey(method);
            String packageName = type.getPackage();
            String typeName = type.getName();
            TypeInformation typeInfo = this.generatedInfo.getTypeInformation(packageName, typeName);
            if (typeInfo != null) {
                typeInfo.addMethodInformation(methodKey, null, this.getVersion());
            }
        }
        catch (org.eclipse.jdt.core.JavaModelException e) {
            e.printStackTrace();
        }
        catch (DeviceKitMetaDataException e) {
            e.printStackTrace();
        }
    }

    private void addMethodMetaData(IType type, String methodKey) {
        try {
            String packageName = type.getPackage();
            String typeName = type.getName();
            TypeInformation typeInfo = this.generatedInfo.getTypeInformation(packageName, typeName);
            if (typeInfo != null) {
                typeInfo.addMethodInformation(methodKey, null, this.getVersion());
            }
        }
        catch (DeviceKitMetaDataException e) {
            e.printStackTrace();
        }
    }

    protected void codeBAClassNameField(IType ba) {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('\"');
        buffer.append(this.getBundleActivatorFqn());
        buffer.append('\"');
        this.codeField(ba, "CLASS_NAME", "String", 49L, "Defines the full class name.", buffer.toString());
    }

    protected void codeBACreateProperties(IType ba) {
        Map table = this.getOsgiProperties(this.fBundleActivatorModel);
        if (table != null) {
            String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_HASHTABLE);
            String comment = this.getBACreatePropertiesComment(table);
            String contents = this.getBACreatePropertiesContents(table);
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_HASHTABLE);
            this.codeMethod(ba, "createProperties", comment, returnType, 1L, contents);
        }
    }

    protected void codeBADeviceCategoryField(IType ba) {
        StringBuffer comment = new StringBuffer(64);
        comment.append("Defines the ");
        comment.append("org.osgi.service.device.Constants.DEVICE_CATEGORY");
        comment.append(" property.");
        StringBuffer value = new StringBuffer(64);
        value.append("new String[] {");
        value.append(this.quote(this.getDeviceCategory()));
        value.append('}');
        this.codeField(ba, "DEVICE_CATEGORY", "String []", 49L, comment.toString(), value.toString());
    }

    protected void codeBAExportedServiceNamesField(IType ba, String valueString, String comment) {
        StringBuffer valueBuffer = new StringBuffer(32);
        valueBuffer.append("new String[]{\n");
        valueBuffer.append(valueString);
        valueBuffer.append("};");
        this.codeField(ba, "EXPORTED_SERVICE_NAMES", "String [] ", 49L, comment, valueBuffer.toString());
    }

    protected void codeBAFields(IType ba) {
        this.codeBAClassNameField(ba);
    }

    protected void codeBAGetExportedServiceNames(IType ba, String comment) {
        String contents = this.getBAGetExportedServiceNameContents();
        if (ba.getName().endsWith("Factory")) {
            this.codeMethod(ba, "getExportedServiceNames", comment, "String[]", 1L, contents, this.getBundleFactoryParameters(), null);
        } else if (ba.getName().endsWith("Managed")) {
            this.codeMethod(ba, "getExportedServiceNames", comment, "String[]", 1L, contents, this.getBundleManagedParameters(), null);
        } else {
            this.codeMethod(ba, "getExportedServiceNames", comment, "String[]", 1L, contents);
        }
    }

    protected void codeBAGetImportedServiceNames(IType ba, String comment) {
        String contents = this.getBAGetImportedServiceNameContents();
        if (ba.getName().endsWith("Factory")) {
            this.codeMethod(ba, "getImportedServiceNames", comment, "String[]", 1L, contents, this.getBundleFactoryParameters(), null);
        } else if (ba.getName().endsWith("Managed")) {
            this.codeMethod(ba, "getImportedServiceNames", comment, "String[]", 1L, contents, this.getBundleManagedParameters(), null);
        } else {
            this.codeMethod(ba, "getImportedServiceNames", comment, "String[]", 1L, contents);
        }
    }

    protected void codeBAGetImportedServiceNames(String bundle, IType ba) {
        List services = this.getManifestImportServices();
        if (services.size() > 0) {
            this.codeBAImportedServiceNamesField(bundle, ba);
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("Return the imported service name(s) to be registered by the " + bundle + " bundle.\n");
            buffer.append("\n@return String[] The imported service names.\n");
            this.codeBAGetImportedServiceNames(ba, buffer.toString());
        }
    }

    protected void codeBAGetMatchingDevicesMethod(IType ba, String comment) {
        String contents = this.getBAGetMatchingDevicesContents();
        this.codeMethod(ba, "getMatchDeviceClasses", comment, "String[]", 1L, contents);
    }

    protected void codeBAImportedServiceNamesField(IType ba, String valueString, String comment) {
        StringBuffer valueBuffer = new StringBuffer(32);
        valueBuffer.append("new String[]{\n");
        valueBuffer.append(valueString);
        valueBuffer.append("};");
        this.codeField(ba, "IMPORTED_SERVICE_NAMES", "String [] ", 49L, comment, valueBuffer.toString());
    }

    protected void codeBAImportedServiceNamesField(String bundle, IType ba) {
        StringBuffer fieldComment = new StringBuffer(64);
        fieldComment.append("Defines the imported service name(s) to be registered by the " + bundle + " bundle.\n");
        List services = this.getManifestImportServices();
        int indentation = 0;
        if (services.size() > 0) {
            fieldComment.append(this.getHtmlHelper().startTable(0));
            ++indentation;
            int i = 0;
            while (i < services.size()) {
                fieldComment.append(this.getHtmlHelper().getTableRow(indentation, String.valueOf(services.get(i))));
                ++i;
            }
            fieldComment.append(this.getHtmlHelper().endTable(--indentation));
        }
        StringBuffer value = new StringBuffer(64);
        int i = 0;
        while (i < services.size()) {
            String curr;
            if (i > 0) {
                value.append(',');
            }
            if ((curr = String.valueOf(services.get(i))).equals(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE)) {
                value.append("\n\t");
                value.append(this.quote(curr));
            } else {
                value.append("\n\t");
                value.append(DeviceKitUtilities.stripPackage(curr));
                value.append('.');
                value.append("SERVICE_NAME");
            }
            ++i;
        }
        this.codeBAImportedServiceNamesField(ba, value.toString(), fieldComment.toString());
    }

    protected void codeBAMatchingDevicesField(IType ba, String valueString) {
        StringBuffer valueBuffer = new StringBuffer(32);
        valueBuffer.append("new String[]{\n");
        if (valueString != null) {
            valueBuffer.append(valueString);
        }
        valueBuffer.append('}');
        this.codeField(ba, "MATCHING_DEVICES", "String [] ", 49L, "The match strings.", valueBuffer.toString());
    }

    protected void codeBAMethods(IType bundleActivatorClass) {
        this.codeBACreateProperties(bundleActivatorClass);
    }

    protected void codeClassNameField(IType type, String classFqn) {
        String value = String.valueOf('\"') + classFqn + '\"';
        this.codeField(type, "CLASS_NAME", "String", 49L, "Defines the full class name.", value);
    }

    protected void codeConfigurationFieldDefaults(ConfigurationField[] fields, TagElement item, IType service) {
        int j = 0;
        while (j < fields.length) {
            ConfigurationField field = fields[j];
            String propertyNameQualified = field.getCodePropertyNameQualified();
            boolean isConnection = item instanceof ConnectionElement;
            if (isConnection) {
                propertyNameQualified = field.getCodePropertyName();
            }
            String codeDefaultName = isConnection ? field.getCodeDefaultName() : field.getCodeDefaultNameQualified();
            String deprecated = field.getDeprecated();
            String codeType = field.getCodeType();
            String value = field.getValue();
            String valueDefault = item.getConfigurationValue(field.getName(), value);
            EnumElement[] enumElements = field.getEnumElements();
            String codeValue = valueDefault;
            if (enumElements.length > 0) {
                String name;
                try {
                    int index = Integer.parseInt(valueDefault);
                    codeValue = enumElements[index].getLabel();
                }
                catch (Exception exception) {
                    codeValue = enumElements[0].getLabel();
                }
                StringBuffer codeBuffer = new StringBuffer(128);
                String serviceName = field.getServiceName();
                if (serviceName != null && serviceName.length() > 0) {
                    this.fServiceModel.addImport(serviceName);
                    codeBuffer.append(DeviceKitUtilities.stripPackage(serviceName));
                    codeBuffer.append('.');
                }
                String typeName = name = field.getName();
                codeBuffer.append(DeviceKitUtilities.capitalizeFirstLetter(typeName));
                codeBuffer.append('.');
                codeBuffer.append(CodeUtilities.validIdentifier(codeValue, true));
                codeValue = codeBuffer.toString();
            } else if ("String".equals(codeType)) {
                codeValue = this.quote(valueDefault);
            } else if (codeValue == null || codeValue.length() == 0) {
                codeValue = "new " + codeType + " {}";
            }
            String description = fields[j].getDescription();
            String comment = "";
            if (description != null && description.length() > 0) {
                comment = description.endsWith(".") ? description : String.valueOf(description) + '.';
                if (deprecated != null) {
                    comment = String.valueOf(comment) + '\n' + deprecated;
                }
            } else {
                comment = "Connection property " + CodeUtilities.betterName(field.getName(), false) + '.';
            }
            String seeProperty = "@see #" + propertyNameQualified;
            String seeDefault = "@see #" + field.getCodeDefaultNameQualified();
            String commentDefault = isConnection ? comment : String.valueOf(comment) + "\n" + seeProperty + '\n';
            String codeNameOld = fields[j].getCodeNameOld();
            if (codeNameOld == null) {
                codeNameOld = fields[j].getCodeDefaultName();
            }
            if (this.getGenerateOld() && codeNameOld.length() > 0) {
                this.codeFieldWithOld(service, codeDefaultName, codeNameOld, codeType, 49L, DeviceKitUtilities.convertStringToArrayComments(commentDefault), codeValue, true);
            } else {
                this.codeField(service, codeDefaultName, codeType, 49L, commentDefault, codeValue);
            }
            if (deprecated == null && !isConnection) {
                String codePropertyName = propertyNameQualified;
                String configurationName = field.getConfigurationName().toLowerCase();
                String codePropertyValue = this.quote(String.valueOf(this.getConfigurationKey(item).toLowerCase()) + '.' + configurationName);
                String commentProperty = String.valueOf(comment) + "\nThe key in the esc.property file must match this field.\n" + seeDefault + '\n';
                this.codeField(service, codePropertyName, "String", 49L, commentProperty, codePropertyValue);
            }
            String[] imports = item.getExtraImports();
            int k = 0;
            while (k < imports.length) {
                this.fServiceModel.addImport(imports[k]);
                this.getMainModel().addImport(imports[k]);
                ++k;
            }
            ++j;
        }
    }

    protected void codeCreateMessageMethod(IType messageType, String returnType, String methodName, long identifiers, String value, String fieldName) {
        StringBuffer valueBuffer = new StringBuffer(value.length() + 10);
        valueBuffer.append("return ");
        valueBuffer.append(value);
        valueBuffer.append(";\n");
        StringBuffer commentBuffer = new StringBuffer(64);
        commentBuffer.append("Creates and returns the ");
        commentBuffer.append(returnType);
        commentBuffer.append(' ');
        commentBuffer.append(fieldName);
        this.codeMethod(messageType, methodName, commentBuffer.toString(), returnType, identifiers, valueBuffer.toString());
    }

    protected void codeCustomParameterServiceDefaultValue(IType service, String name, String type, String defaultValue) {
        this.codeCustomParameterServiceDefaultValue(service, name, type, defaultValue, name);
    }

    protected void codeCustomParameterServiceDefaultValue(IType service, String name, String type, String defaultValue, String displayName) {
        String anotherOldName = name;
        if (defaultValue != null) {
            String commentName = displayName != null ? displayName.toLowerCase() : CodeUtilities.betterName(name, false);
            String[] comment = new String[]{"Custom parameter " + commentName + " configuration default value.", "@see #" + CodeUtilities.validStaticIdentifier(name)};
            anotherOldName = String.valueOf(name.toUpperCase()) + "_DEFAULT";
            String newName = String.valueOf(CodeUtilities.validStaticIdentifier(name)) + "_DEFAULT";
            String oldName = "DEFAULT_" + name.toUpperCase();
            String defaultValueCorrect = defaultValue;
            if (defaultValue.length() == 0) {
                defaultValueCorrect = "new " + type + " {}";
            }
            this.codeFieldWithOld(service, newName, oldName, type, 49L, comment, defaultValueCorrect, true);
            if (this.getGenerateOld() && !newName.equals(anotherOldName)) {
                String[] oldComment = new String[]{"Custom parameter " + anotherOldName + " configuration default value.", "@see #" + CodeUtilities.validStaticIdentifier(name), "@deprecated use " + newName};
                this.codeField(service, anotherOldName, type, 49L, oldComment, newName);
            }
        }
    }

    protected void codeCustomParameterServiceFields(IType service) {
        List parameters = this.getMainElement().getAllChildrenWithTagCode(46);
        if (parameters == null) {
            return;
        }
        int i = 0;
        while (i < parameters.size()) {
            boolean isString;
            CustomParameterElement parameter = (CustomParameterElement)parameters.get(i);
            String type = parameter.getAttribute("type");
            String defaultValue = parameter.getAttribute("defaultvalue");
            boolean bl = isString = "String".equals(type) || "java.lang.String".equals(type);
            if (defaultValue != null && isString) {
                defaultValue = this.quote(defaultValue);
            }
            this.codeCustomParameterServiceKey(service, parameter);
            ++i;
        }
        this.codeConfigurationFieldDefaults(this.getMainElement().getConfigurationOptions(), this.getMainElement(), service);
    }

    protected void codeCustomParameterServiceKey(IType service, CustomParameterElement element) {
        String[] stringArray;
        ConfigurationField field = new ConfigurationField(element);
        String name = field.getName();
        String value = this.quote(field.getConfigurationName());
        String displayName = field.getDisplayName();
        String commentName = displayName != null ? displayName.toLowerCase() : CodeUtilities.betterName(name, false);
        String comment = "Custom parameter " + commentName + " configuration key.\n";
        String deprecated = element.getDeprecated();
        String seeDefault = "@see #" + field.getCodeDefaultName();
        if (deprecated == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = comment;
            stringArray2[1] = "The key in the OSGI-INF/metatype/Metadata.xml file must match this field.";
            stringArray = stringArray2;
            stringArray2[2] = seeDefault;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = comment;
            stringArray3[1] = "The key in the OSGI-INF/metatype/Metadata.xml file must match this field.";
            stringArray3[2] = seeDefault;
            stringArray = stringArray3;
            stringArray3[3] = "@deprecated " + deprecated;
        }
        String[] comments = stringArray;
        String tname = String.valueOf(name.toUpperCase()) + "_KEY";
        String newName = CodeUtilities.validStaticIdentifier(name);
        this.codeFieldWithOld(service, newName, tname, "String", 49L, comments, value, true);
    }

    protected void codeCustomParameterServiceKey(IType service, String name, String value) {
        String tname = name;
        String comment = "Custom parameter " + CodeUtilities.betterName(name, false) + " configuration key.";
        tname = String.valueOf(tname.toUpperCase()) + "_KEY";
        String newName = CodeUtilities.validStaticIdentifier(name);
        this.codeFieldWithOld(service, newName, tname, "String", 49L, new String[]{comment}, value, true);
    }

    protected void codeDescriptionField(IType type) {
        this.codeDescriptionField(type, "DESCRIPTION");
    }

    protected void codeDescriptionField(IType type, String fieldName) {
        String description = this.getDescriptionShort();
        String value = String.valueOf('\"') + description + '\"';
        this.codeDescriptionField(type, fieldName, value);
    }

    protected void codeDescriptionField(IType type, String fieldName, String value) {
        this.codeField(type, fieldName, "String", 49L, "Description of the test.", value);
    }

    protected IField codeField(IType type, String fieldName, String fieldType, long identifiers, String comment, String value) {
        return this.codeField(type, fieldName, fieldType, identifiers, DeviceKitUtilities.convertStringToArrayComments(comment), value);
    }

    protected IField codeField(IType type, String fieldName, String fieldType, long identifiers, String[] comment, String value) {
        boolean cap = (0x10L & identifiers) != 0L;
        return this.codeField(type, fieldName, fieldType, identifiers, comment, value, cap);
    }

    protected IField codeField(IType type, String fieldName, String fieldType, long identifiers, String[] comment, String value, boolean cap) {
        String version;
        String tfieldName = CodeUtilities.validIdentifier(fieldName, cap);
        IField field = type.createField(fieldType, tfieldName);
        field.setIdentifiers(identifiers);
        FieldInformation info = this.getFieldMetaData(type, field);
        String string = version = info != null ? info.getDkmlVersion() : this.getVersion();
        if (comment != null && comment.length > 0) {
            String since = "@since " + this.formatVersionSince(version);
            String[] commentSince = new String[comment.length + 1];
            System.arraycopy(comment, 0, commentSince, 0, comment.length);
            commentSince[comment.length] = since;
            field.setComment(commentSince);
        } else {
            String javadoc = "Define " + CodeUtilities.betterName(tfieldName, false) + '.';
            if (version.length() > 0) {
                String since = "@since " + this.formatVersionSince(version);
                field.setComment(new String[]{javadoc, since});
            } else {
                field.setComment(new String[]{javadoc});
            }
        }
        field.setGenerated(true);
        field.setValue(value);
        this.addFieldMetaData(type, field);
        return field;
    }

    protected IField codeFieldWithOld(IType type, String fieldName, String fieldNameOld, String fieldType, long identifiers, String[] comment, String value, boolean cap) {
        IField newField = this.codeField(type, fieldName, fieldType, identifiers, comment, value, cap);
        if (!fieldName.equals(fieldNameOld) && this.getGenerateOld()) {
            String tfieldName = CodeUtilities.validIdentifier(fieldNameOld, cap);
            IField field = type.createField(fieldType, tfieldName);
            field.setIdentifiers(identifiers);
            String deprecated = "@deprecated use " + fieldName;
            FieldInformation info = this.getFieldMetaData(type, field);
            String version = info != null ? info.getDkmlVersion() : this.getVersion();
            String since = "@since " + this.formatVersionSince(version);
            if (comment != null && comment.length > 0) {
                String[] newComment = new String[comment.length + 2];
                System.arraycopy(comment, 0, newComment, 0, comment.length);
                newComment[comment.length] = deprecated;
                newComment[comment.length + 1] = since;
                field.setComment(newComment);
            } else {
                String javadoc = "Define " + CodeUtilities.betterName(tfieldName, false) + '.';
                if (version.length() > 0) {
                    field.setComment(new String[]{javadoc, deprecated, since});
                } else {
                    field.setComment(new String[]{javadoc, deprecated});
                }
            }
            field.setGenerated(true);
            field.setValue(value);
            this.addFieldMetaData(type, field);
        }
        return newField;
    }

    protected void codeMessageCommonElements(IType messageType, TagElement element, boolean lazy, boolean initWithMethods) {
        String fieldType = this.getMessageType(element);
        fieldType = DeviceKitUtilities.stripPackage(fieldType);
        String id = element.getId();
        if (id != null) {
            HashMap<String, String> segments = new HashMap<String, String>(101);
            List elements = this.getMessageClassElements();
            int i = 0;
            while (i < elements.size()) {
                TagElement tagElement = (TagElement)elements.get(i);
                List parameterElements = tagElement.getAllChildrenWithTagCode(5, true);
                int j = 0;
                while (j < parameterElements.size()) {
                    TagElement pelement = (TagElement)parameterElements.get(j);
                    if (id.equals(pelement.getIdRef()) && pelement instanceof SegmentElement) {
                        String key;
                        SegmentElement segmentElement = (SegmentElement)pelement;
                        String max = segmentElement.getOccursmaximumRaw();
                        String min = segmentElement.getOccursminimumRaw();
                        if ((min != null || max != null) && segments.get(key = String.valueOf(pelement.getIdRef()) + min + max) == null) {
                            this.codeMessageCommonElements(messageType, segmentElement, lazy, initWithMethods);
                            segments.put(key, key);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        String fieldName = "";
        if (id == null) {
            id = element.getIdRef();
            if (element instanceof SegmentElement) {
                SegmentElement segmentElement = (SegmentElement)element;
                String max = segmentElement.getOccursmaximumRaw();
                String min = segmentElement.getOccursminimumRaw();
                if (min != null || max != null) {
                    id = String.valueOf(id) + '_' + segmentElement.getOccursminimumStringName() + '_' + segmentElement.getOccursmaximumStringName();
                }
            }
            fieldName = CodeUtilities.staticFieldName(id);
        } else {
            fieldName = CodeUtilities.staticFieldName(id);
        }
        String[] comment = element.getFieldComment();
        if (comment != null && comment.length > 0 && !comment[0].trim().endsWith(".")) {
            comment[0] = String.valueOf(comment[0]) + '.';
        }
        long identifiers = 18L;
        String value = null;
        if (!lazy) {
            identifiers |= 0x20L;
            NewCodeGenerator gen = new NewCodeGenerator(this.getMessageFqn(), messageType, this.getMessageFqn(), this.getServiceFqn(), lazy);
            value = gen.getNewCode(0, element);
            if (initWithMethods) {
                String methodName = "create" + fieldName;
                this.codeCreateMessageMethod(messageType, fieldType, methodName, identifiers, value, fieldName);
                StringBuffer valueBuffer = new StringBuffer(methodName.length() + 2);
                valueBuffer.append(methodName);
                valueBuffer.append("()");
                value = valueBuffer.toString();
            }
            JavaFileModel messModel = this.getMessageModel();
            List newImports = gen.getImports();
            int j = 0;
            while (j < newImports.size()) {
                String importedItem = (String)newImports.get(j);
                messModel.addImport(importedItem);
                String importedPack = DeviceKitUtilities.extractPackage(importedItem);
                this.getManifestModel().addImportPackage(importedPack);
                ++j;
            }
        }
        this.codeField(messageType, fieldName, fieldType, identifiers, comment, value);
        this.codeMessageGetter(messageType, element, lazy, id);
    }

    protected void codeMessageGetter(IType messType, TagElement element, boolean lazy) {
        JavaFileModel messModel = this.getMessageModel();
        String type = this.getMessageType(element);
        messModel.addImport(type);
        type = DeviceKitUtilities.stripPackage(type);
        String getterName = "get" + CodeUtilities.staticFieldName(element.getId());
        String comment = this.getMessageGetterComment(element, type);
        String contents = this.getMessageGetterContents(element, lazy);
        this.codeMethod(messType, getterName, comment, type, 17L, contents);
    }

    protected void codeMessageGetter(IType messType, TagElement element, boolean lazy, String id) {
        JavaFileModel messModel = this.getMessageModel();
        String type = this.getMessageType(element);
        messModel.addImport(type);
        type = DeviceKitUtilities.stripPackage(type);
        String getterName = "get" + CodeUtilities.staticFieldName(id);
        String comment = this.getMessageGetterComment(element, type);
        String contents = this.getMessageGetterContents(element, lazy, id);
        this.codeMethod(messType, getterName, comment, type, 17L, contents);
    }

    protected IMethod codeMethod(IType type, String name, String comment, String returnType, long identifiers, String contents) {
        return this.codeMethod(type, name, comment, returnType, identifiers, contents, true);
    }

    protected IMethod codeMethod(IType type, String name, String comment, String returnType, long identifiers, String contents, boolean generatedMethodComment) {
        return this.codeMethod(type, name, comment, returnType, identifiers, contents, null, null, generatedMethodComment);
    }

    protected IMethod codeMethod(IType type, String name, String comment, String returnType, long identifiers, String contents, KeyValuePair[] parameters, String[] exceptions) {
        return this.codeMethod(type, name, comment, returnType, identifiers, contents, parameters, exceptions, true);
    }

    protected IMethod codeMethod(IType type, String name, String comment, String returnType, long identifiers, String contents, KeyValuePair[] parameters, String[] exceptions, boolean generatedMethodComment) {
        return this.codeMethod(type, name, DeviceKitUtilities.convertStringToArrayComments(comment), returnType, identifiers, contents, parameters, exceptions, generatedMethodComment);
    }

    protected IMethod codeMethod(IType type, String name, String[] comment, String returnType, long identifiers, String contents) {
        return this.codeMethod(type, name, comment, returnType, identifiers, contents, true);
    }

    protected IMethod codeMethod(IType type, String name, String[] comment, String returnType, long identifiers, String contents, boolean generatedMethodComment) {
        return this.codeMethod(type, name, comment, returnType, identifiers, contents, new KeyValuePair[0], null, generatedMethodComment);
    }

    protected IMethod codeMethod(IType type, String name, String[] comment, String returnType, long identifiers, String contents, KeyValuePair[] parameters, String[] exceptions) {
        return this.codeMethod(type, name, comment, returnType, identifiers, contents, parameters, exceptions, true);
    }

    protected IMethod codeMethod(IType type, String name, String[] comment, String returnType, long identifiers, String contents, KeyValuePair[] parameters, String[] exceptions, boolean generatedMethodComment) {
        int i;
        IMethod method = type.createMethod(name);
        method.setReturnType(returnType);
        method.setIdentifiers(identifiers);
        if (parameters != null) {
            i = 0;
            while (i < parameters.length) {
                method.addParameter(parameters[i].getKey(), parameters[i].getValue(), parameters[i].getDescription());
                ++i;
            }
        }
        if (exceptions != null) {
            i = 0;
            while (i < exceptions.length) {
                method.addThrownException(exceptions[i]);
                ++i;
            }
        }
        String[] newComment = this.addJavaDocToComment(name, comment, returnType, parameters, exceptions);
        MethodInformation methodInfo = this.getMethodMetaData(type, method);
        String version = methodInfo != null ? methodInfo.getDkmlVersion() : this.getVersion();
        String since = "@since " + this.formatVersionSince(version);
        String[] commentSince = new String[newComment.length + 1];
        System.arraycopy(newComment, 0, commentSince, 0, newComment.length);
        commentSince[newComment.length] = since;
        method.setComment(commentSince);
        if (contents != null) {
            StringBuffer buffer = new StringBuffer(1024);
            if (generatedMethodComment) {
                buffer.append("/* ");
                buffer.append(this.getGeneratedMethodComment());
                buffer.append(" */\r\n");
            }
            buffer.append(contents);
            method.setContents(buffer.toString());
        } else {
            method.setContents(this.getGeneratedMethodComment());
        }
        this.addMethodMetaData(type, method);
        return method;
    }

    protected IMethod codeMethodNoMetaData(IType type, String name, String[] comment, String returnType, long identifiers, String contents, KeyValuePair[] parameters, String[] exceptions) {
        int i;
        IMethod method = type.createMethod(name);
        String[] newComment = this.addJavaDocToComment(name, comment, returnType, parameters, exceptions);
        method.setComment(newComment);
        method.setReturnType(returnType);
        method.setIdentifiers(identifiers);
        if (parameters != null) {
            i = 0;
            while (i < parameters.length) {
                method.addParameter(parameters[i].getKey(), parameters[i].getValue(), parameters[i].getDescription());
                ++i;
            }
        }
        if (exceptions != null) {
            i = 0;
            while (i < exceptions.length) {
                method.addThrownException(exceptions[i]);
                ++i;
            }
        }
        if (contents != null) {
            method.setContents(contents);
        }
        return method;
    }

    protected IMethod codeMethodNoMetaDataOptional(IType type, String name, String[] comment, String returnType, long identifiers, String contents, KeyValuePair[] parameters, String[] exceptions) {
        IMethod[] methods = type.getMethods();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                IMethod method = methods[i];
                if (name.equals(method.getName())) {
                    return method;
                }
                ++i;
            }
        }
        return this.codeMethodNoMetaData(type, name, comment, returnType, identifiers, contents, parameters, exceptions);
    }

    protected void codeParameterAccess(ConfigurationField field, IType transport, TagElement element) {
        String name = field.getName();
        String capName = DeviceKitUtilities.capitalizeFirstLetter(name);
        String type = field.getCodeType();
        String defaultValue = field.getValue();
        String description = field.getDescription();
        boolean isString = "String".equals(type) || "java.lang.String".equals(type);
        String comment = null;
        if (description != null) {
            if (!description.trim().endsWith(".")) {
                description = String.valueOf(description) + ".";
            }
            comment = description;
        } else {
            comment = "Custom parameter " + CodeUtilities.betterName(field.getName(), false) + '.';
        }
        String value = null;
        if (defaultValue != null) {
            if (isString) {
                defaultValue = this.quote(defaultValue);
            }
            value = defaultValue;
        }
        StringBuffer buffer = new StringBuffer(128);
        String serviceName = element.getServiceName();
        if (serviceName != null && serviceName.length() > 0) {
            buffer.append(DeviceKitUtilities.stripPackage(serviceName));
            buffer.append('.');
            buffer.append(field.getCodeDefaultNameQualified());
        } else {
            buffer.append(value);
        }
        String fieldValue = buffer.toString();
        comment = String.valueOf(comment) + "\n@see " + fieldValue;
        this.codeField(transport, name, type, 2L, comment, fieldValue);
        String setName = "set" + capName;
        StringBuffer methDesc = new StringBuffer(64);
        String betterName = CodeUtilities.betterName(name, false);
        if (description != null) {
            methDesc.append(description);
        } else {
            methDesc.append("Sets the value of " + betterName + " custom parameter.");
        }
        methDesc.append("\n@param " + name + " The " + betterName + " custom parameter.");
        methDesc.append("\n@see #get" + capName);
        String setComment = methDesc.toString();
        KeyValuePair setParameter = new KeyValuePair(type, name);
        String setContents = "this." + CodeUtilities.fieldName(name) + " = " + name + ";\n";
        this.codeMethod(transport, setName, setComment, "void", 1L, setContents, new KeyValuePair[]{setParameter}, null);
        String getName = "get" + capName;
        methDesc = new StringBuffer(64);
        if (description != null) {
            methDesc.append(description);
        } else {
            methDesc.append("Gets the value of " + betterName + " custom parameter.");
        }
        methDesc.append("\n@return " + betterName + " custom parameter.");
        methDesc.append("\n@see #set" + capName);
        String getComment = methDesc.toString();
        String getReturnType = type;
        String getContents = "return this." + CodeUtilities.fieldName(name) + ";\n";
        this.codeMethod(transport, getName, getComment, getReturnType, 1L, getContents);
    }

    protected void codeParameterServiceFields(IType service) {
        HashMap<String, String> table = new HashMap<String, String>();
        List parameters = this.getMainElement().getAllSubChildrenWithTagCode(5, false);
        if (parameters == null) {
            return;
        }
        int i = 0;
        while (i < parameters.size()) {
            TagElement parameter = (TagElement)parameters.get(i);
            String name = parameter.getKey();
            if (name != null && table.get(name) == null) {
                boolean isString;
                table.put(name, name);
                String defaultValue = parameter.getAttribute("defaultvalue");
                boolean bl = isString = "String".equals("String") || "java.lang.String".equals("String");
                if (defaultValue != null && isString) {
                    defaultValue = this.quote(defaultValue);
                }
                this.codeParameterServiceKey(service, parameter, name, this.quote(name));
                List enums = parameter.getAllChildrenWithTagCode(77, false);
                if (enums.size() > 0) {
                    this.codeServiceEnumKeyField(service, enums, defaultValue);
                }
            }
            ++i;
        }
    }

    protected void codeParameterServiceKey(IType service, TagElement parameter, String name, String value) {
        if (service.getField(name) == null) {
            String unitsDocumentation;
            String fieldExtraComment = parameter.getFieldExtraComment("");
            StringBuffer buffer = new StringBuffer(512);
            buffer.append("Parameter ");
            buffer.append(name);
            buffer.append(" key");
            String dataTypeDocumentation = parameter.getParameterDataTypeDocumentation();
            if (dataTypeDocumentation != null && dataTypeDocumentation.length() > 0) {
                buffer.append(" <code>");
                buffer.append(dataTypeDocumentation);
                buffer.append("</code>");
            }
            if ((unitsDocumentation = parameter.getUnitsDocumentation()) != null && unitsDocumentation.length() > 0) {
                buffer.append(" ");
                buffer.append(unitsDocumentation);
            }
            buffer.append('.');
            if (fieldExtraComment != null && fieldExtraComment.length() > 0) {
                buffer.append("\n<p>\n");
                buffer.append(fieldExtraComment);
                buffer.append("\n</p>");
            }
            String[] comments = DeviceKitUtilities.convertStringToArray(buffer.toString());
            this.codeField(service, name, "String", 49L, comments, value, true);
        }
    }

    protected String codeServiceEnumKeyField(IType service, List list, String defaultValue) {
        return this.codeServiceEnumKeyField(service, list, defaultValue, false, false);
    }

    protected String codeServiceEnumKeyField(IType service, List list, String defaultValue, boolean allUpper, boolean inner) {
        String returnDefault = defaultValue;
        int size = list.size();
        int i = 0;
        while (i < size) {
            EnumElement element = (EnumElement)list.get(i);
            String fieldName = element.getLabel();
            if (fieldName == null) {
                fieldName = element.getKey();
            }
            if (fieldName != null) {
                TagElement parent = element.getParent();
                String parentKey = parent.getKey();
                if (parentKey != null && !fieldName.startsWith(parentKey) && !inner) {
                    fieldName = String.valueOf(parentKey) + '_' + fieldName;
                }
                fieldName = CodeUtilities.staticFieldName(fieldName, false);
                String fieldType = "int";
                String value = element.getValue();
                if (value == null) {
                    value = Integer.toString(i);
                } else if (value.startsWith("\"")) {
                    fieldType = "String";
                }
                String description = element.getDescription();
                String[] comment = new String[]{};
                comment = description == null || description.length() == 0 ? (parentKey != null && !inner ? new String[]{"Define the " + fieldName + " enumeration value.", "@see #" + CodeUtilities.staticFieldName(parentKey, allUpper)} : new String[]{"Define the " + fieldName + " enumeration value."}) : new String[]{description};
                if (size > 1) {
                    int commentSize = comment.length;
                    String[] newComment = new String[commentSize + size - 1];
                    System.arraycopy(comment, 0, newComment, 0, commentSize);
                    int index = commentSize;
                    int j = 0;
                    while (j < size) {
                        if (i != j) {
                            EnumElement seeElement = (EnumElement)list.get(j);
                            String seeValue = "";
                            String seeFieldName = seeElement.getLabel();
                            if (seeFieldName == null) {
                                seeFieldName = element.getKey();
                            }
                            if (seeFieldName != null) {
                                TagElement seeParent = seeElement.getParent();
                                String seeParentKey = seeParent.getKey();
                                if (seeParentKey != null && !seeFieldName.startsWith(seeParentKey) && !inner) {
                                    seeFieldName = String.valueOf(seeParentKey) + '_' + seeFieldName;
                                }
                                seeValue = seeFieldName = CodeUtilities.validIdentifier(seeFieldName, true);
                            }
                            String seeComment = "@see #" + seeValue;
                            newComment[index++] = seeComment;
                        }
                        ++j;
                    }
                    comment = newComment;
                }
                if (value.equals(defaultValue)) {
                    returnDefault = fieldName;
                }
                StringBuffer commentBuffer = new StringBuffer(128);
                if (comment.length > 0) {
                    if (!comment[0].trim().endsWith(".")) {
                        comment[0] = String.valueOf(comment[0]) + '.';
                    }
                    int j = 0;
                    while (j < comment.length) {
                        commentBuffer.append(comment[j]);
                        commentBuffer.append('\n');
                        ++j;
                    }
                }
                if (element.hasChildWithTagCode(65)) {
                    String specRefComment = this.getSpecReferenceComment(element);
                    commentBuffer.append(specRefComment);
                    comment = DeviceKitUtilities.convertStringToArrayComments(commentBuffer.toString());
                }
                comment = DeviceKitUtilities.convertStringToArrayComments(commentBuffer.toString());
                this.codeField(service, fieldName, fieldType, 49L, comment, value);
            }
            ++i;
        }
        return returnDefault;
    }

    protected void codeServiceFields(IType service) {
        boolean hasFactoryTag;
        boolean hasManagedTag;
        String comment = "Define the OSGi service name.";
        String value = String.valueOf('\"') + this.getServiceFqn() + '\"';
        this.codeServiceNameField(service, this.getServiceClass(), "SERVICE_NAME", comment, value);
        boolean bl = hasManagedTag = this.fMainTagElement.getAllChildrenWithTagCode(67).size() > 0;
        if (hasManagedTag) {
            String className = String.valueOf(this.getMainClassName()) + "Managed";
            comment = "Define the OSGi managed service name.";
            String packageName = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
            String fqn = String.valueOf(packageName) + '.' + className;
            value = this.quote(fqn);
            this.codeServiceNameField(service, className, "MANAGED_SERVICE_NAME", comment, value);
        }
        boolean bl2 = hasFactoryTag = this.fMainTagElement.getAllChildrenWithTagCode(68).size() > 0;
        if (hasFactoryTag) {
            String className = String.valueOf(this.getMainClassName()) + "Factory";
            comment = "Define the OSGi factory service name.";
            String packageName = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
            String fqn = String.valueOf(packageName) + '.' + className;
            value = this.quote(fqn);
            this.codeServiceNameField(service, className, "FACTORY_SERVICE_NAME", comment, value);
        }
    }

    public void codeServiceInnerTypes(IType serviceType) {
        List parameters = this.getMainElement().getAllChildrenWithTagCode(46);
        if (parameters == null) {
            return;
        }
        int i = 0;
        while (i < parameters.size()) {
            List enums;
            boolean isString;
            CustomParameterElement parameter = (CustomParameterElement)parameters.get(i);
            String name = parameter.getAttribute("name");
            String innerTypeName = CodeUtilities.validIdentifier(name, true);
            String type = parameter.getAttribute("type");
            String defaultValue = parameter.getAttribute("defaultvalue");
            boolean bl = isString = "String".equals(type) || "java.lang.String".equals(type);
            if (defaultValue != null && isString) {
                defaultValue = this.quote(defaultValue);
            }
            if ((enums = parameter.getAllChildrenWithTagCode(77)).size() > 0) {
                IType innerType = serviceType.createInnerType(innerTypeName);
                String innerComment = "Define the " + innerTypeName + " interface.";
                innerType.setComment(innerComment);
                this.codeServiceEnumKeyField(innerType, enums, defaultValue, false, true);
            }
            ++i;
        }
    }

    private void codeServiceNameField(IType service, String className, String fieldName, String comment, String value) {
        this.codeField(service, fieldName, "String", 49L, comment, value);
    }

    protected IType createClass(JavaFileModel model, String packageName, String typeName, String projectName) throws JavaModelException {
        return this.createType(model, packageName, typeName, 1, projectName);
    }

    protected IType createInterface(JavaFileModel model, String packageName, String typeName, String projectName) throws JavaModelException {
        return this.createType(model, packageName, typeName, 0, projectName);
    }

    protected IType createMessageType() throws Exception {
        String messagePackage = this.getMessagePackage();
        String messageClass = this.getMessageClass();
        JavaFileModel messModel = new JavaFileModel(messageClass);
        messModel.setComment(this.getCopyright());
        messModel.setPackage(messagePackage);
        IType messType = this.createClass(messModel, messagePackage, messageClass, this.getSourceFolderName());
        messType.setComment(this.getMessageClassComment());
        this.setMessageModel(messModel);
        return messType;
    }

    private IType createServiceType() throws Exception {
        String servicePackage = this.getServicePackage();
        String serviceClass = this.getServiceClass();
        this.fServiceModel = new JavaFileModel(serviceClass);
        this.fServiceModel.setComment(this.getCopyright());
        this.fServiceModel.setPackage(servicePackage);
        IType serviceType = this.createInterface(this.fServiceModel, servicePackage, serviceClass, this.getSourceFolderName());
        serviceType.setComment(this.getServiceFileComment());
        String[] interfaces = this.getServiceInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.fServiceModel.addImport(interfaces[i]);
            serviceType.addSuperInterface(DeviceKitUtilities.stripPackage(interfaces[i]));
            ++i;
        }
        return serviceType;
    }

    protected IType createType(JavaFileModel model, String packageName, String typeName, int kind, String projectName) throws JavaModelException {
        IType type = null;
        type = kind == 1 ? model.createClass(packageName, typeName) : model.createInterface(packageName, typeName);
        this.generatedInfo.addTypeInformation(packageName, typeName, this.getVersion(), projectName);
        return type;
    }

    protected boolean doGenerateBundleActivator() {
        return true;
    }

    protected boolean doGenerateService() {
        return true;
    }

    protected RuntimeException error(String message) {
        return new RuntimeException(message);
    }

    public String formatVersionSince(String version) {
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        int count = tokenizer.countTokens();
        if (count <= 2) {
            return version;
        }
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(tokenizer.nextToken());
        buffer.append('.');
        buffer.append(tokenizer.nextToken());
        return buffer.toString();
    }

    protected void generate() throws Exception {
        this.initialize();
        if (this.doGenerateService()) {
            this.generateServiceClass();
        }
        this.generateSpecificClass();
        if (!this.isAbstract() && this.doGenerateBundleActivator()) {
            this.generateBundleActivatorClass();
        }
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    protected void generateBundleActivatorClass() throws Exception {
    }

    protected void generateCustomBundleActivatorItems() {
        if (this.fBundleActivatorModel != null) {
            this.generateCustomItems(this.fBundleActivatorModel.getType());
        }
    }

    protected void generateCustomItems() {
        if (this.customInfo != null) {
            this.generateCustomMainItems();
            this.generateCustomServiceItems();
            this.generateCustomBundleActivatorItems();
        }
    }

    protected void generateCustomItems(IType type) {
        CustomTypeInformation customTypeInfo;
        if (this.customInfo != null && type != null && (customTypeInfo = this.customInfo.getTypeInformation(type.getPackage(), type.getName())) != null) {
            MethodInformation[] customMethods = customTypeInfo.getMethods();
            int i = 0;
            while (i < customMethods.length) {
                type.addExtraMethod(customMethods[i].getKey(), (String)customMethods[i].getData());
                ++i;
            }
            FieldInformation[] customFields = customTypeInfo.getFields();
            int i2 = 0;
            while (i2 < customFields.length) {
                type.addExtraField(customFields[i2].getKey(), (String)customFields[i2].getData());
                ++i2;
            }
        }
    }

    protected void generateCustomMainItems() {
        JavaFileModel mainModel = this.getMainModel();
        if (mainModel != null) {
            this.generateCustomItems(mainModel.getType());
        }
    }

    protected void generateCustomServiceItems() {
        if (this.fServiceModel != null) {
            this.generateCustomItems(this.fServiceModel.getType());
        }
    }

    protected void generateLaunchCfg(int bundleType) throws Exception {
        this.generateLaunchCfg(bundleType, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void generateLaunchCfg(int bundleType, IProgressMonitor progressMonitor) throws Exception {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        String name = this.getMainElement().getKey();
        if (name != null) {
            String baseType = "";
            String targetId = this.getMainElement().getProjectId();
            switch (bundleType) {
                case 0: {
                    break;
                }
                case 1: {
                    baseType = "bundle";
                    break;
                }
                case 2: {
                    baseType = "managed";
                    break;
                }
                case 3: {
                    baseType = "factory";
                }
            }
            String projectName = targetId;
            if (baseType.length() > 0) {
                projectName = String.valueOf(targetId) + '.' + baseType;
            }
            IProject project = CoreUtility.getProject(projectName);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("main_class", this.getMainFqn());
            map.put("main_name", this.getMainPackage().substring(this.getPackageBase().length() + 1));
            map.put("main_project", this.getMainPackage());
            if (project.exists()) {
                String content = GeneratorTemplates.getResults("testagent/testagent" + baseType + "_test.launch", map).trim();
                StringBuffer launchCfgPath = new StringBuffer();
                launchCfgPath.append(DeviceKitUtilities.getPackageFromClassName(this.getMainBaseName(), this.getPackageBase()));
                launchCfgPath.append(".test");
                launchCfgPath.append(baseType.length() > 0 ? "." + baseType : "");
                launchCfgPath.append(".launch");
                IFile launchCfgFile = project.getFile(launchCfgPath.toString());
                ByteArrayInputStream buildSamplesStringFileSource = new ByteArrayInputStream(content.getBytes());
                if (launchCfgFile.exists()) {
                    if (this.isOverride()) {
                        launchCfgFile.setContents((InputStream)buildSamplesStringFileSource, true, true, monitor);
                    }
                } else {
                    launchCfgFile.create((InputStream)buildSamplesStringFileSource, true, monitor);
                }
            }
        }
    }

    public void generateManifest() {
        String bundelActivator;
        String manifestBundleName = this.getManifestBundleName();
        this.fManifestModel.setBundleName(manifestBundleName);
        if (this.isIncubation()) {
            String manifestBundleNameNew = String.valueOf(manifestBundleName) + " (Incubation)";
            this.fManifestModel.setBundleName(manifestBundleNameNew);
        }
        String manifestBundleId = this.getManifestBundleId();
        this.fManifestModel.setSymbolicBundleName(manifestBundleId);
        this.fManifestModel.setBundleLocalization("OSGI-INF/l10n/bundle");
        this.fManifestModel.setKeyValue("Bundle-ManifestVersion", "2");
        String abs = this.getMainElement().getAttribute("abstract");
        if ((abs == null || abs.equals("false")) && (bundelActivator = this.getBundleActivatorFqn()) != null && bundelActivator.length() > 0) {
            this.fManifestModel.setBundleActivator(bundelActivator);
        }
        this.fManifestModel.setVendor(this.getProvider());
        this.fManifestModel.setVendors(this.getVendors());
        this.fManifestModel.setDescription(this.getManifestDescription());
        this.fManifestModel.setVersion(String.valueOf(this.getVersion()) + ".qualifier");
        String executionEnvironments = this.getMainElement().getExecutionEnvironments();
        if (executionEnvironments != null) {
            this.fManifestModel.setBundleRequiredExecutionEnvironments(executionEnvironments);
        }
        String[] categories = this.getManifestCategories();
        int i = 0;
        while (i < categories.length) {
            this.fManifestModel.addCategory(categories[i]);
            ++i;
        }
        List expServices = this.getManifestExportServices();
        int i2 = 0;
        while (i2 < expServices.size()) {
            this.fManifestModel.addExportedService((String)expServices.get(i2));
            ++i2;
        }
        List expPackages = this.getManifestExportPackages();
        int i3 = 0;
        while (i3 < expPackages.size()) {
            this.fManifestModel.addExportedPackage((String)expPackages.get(i3));
            ++i3;
        }
        List requiredBundles = this.getManifestRequiredBundles();
        int i4 = 0;
        while (i4 < requiredBundles.size()) {
            this.fManifestModel.addRequiredBundle((String)requiredBundles.get(i4));
            ++i4;
        }
        List impServices = this.getManifestImportServices();
        int i5 = 0;
        while (i5 < impServices.size()) {
            this.fManifestModel.addImportService((String)impServices.get(i5));
            String packageName = DeviceKitUtilities.extractPackage((String)impServices.get(i5));
            if (!expPackages.contains(packageName)) {
                this.fManifestModel.addImportPackage(packageName);
            }
            ++i5;
        }
        List impPackages = this.getManifestImportPackages();
        int i6 = 0;
        while (i6 < impPackages.size()) {
            String name = (String)impPackages.get(i6);
            if (!expPackages.contains(name)) {
                this.fManifestModel.addImportPackage(name);
            }
            ++i6;
        }
        i6 = 0;
        while (i6 < expServices.size()) {
            String packageName = DeviceKitUtilities.extractPackage((String)expServices.get(i6));
            if (!expPackages.contains(packageName)) {
                this.fManifestModel.addImportPackage(packageName);
            }
            ++i6;
        }
        this.fManifestModel.setCopyright(this.getManifestCopyright());
        this.addCustomManifestItems();
        this.getBuildModel().addPackages(this.getManifestModel().getImportedPackages());
    }

    protected void generateMessageClass(boolean lazy, boolean initWithMethod) throws Exception {
        List elements = this.getMessageClassElements();
        if (elements.size() == 0) {
            return;
        }
        IType messageType = this.createMessageType();
        int i = 0;
        while (i < elements.size()) {
            TagElement element = (TagElement)elements.get(i);
            this.codeMessageCommonElements(messageType, element, lazy, initWithMethod);
            ++i;
        }
        List parameterElements = this.getRootElement().getAllChildrenWithTagCode(5, false);
        int i2 = 0;
        while (i2 < parameterElements.size()) {
            TagElement element = (TagElement)parameterElements.get(i2);
            if (element.getIdRef() != null && element instanceof SegmentElement) {
                SegmentElement segmentElement = (SegmentElement)element;
                String max = segmentElement.getOccursmaximumRaw();
                String min = segmentElement.getOccursminimumRaw();
                if (min != null || max != null) {
                    this.codeMessageCommonElements(messageType, element, lazy, initWithMethod);
                }
            }
            ++i2;
        }
    }

    protected void generateOtherFiles() throws Exception {
        String properties = this.getMetaDataProperties();
        if (properties != null) {
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle.properties", properties);
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle_en.properties", properties);
        }
    }

    protected void generateServiceClass() throws Exception {
        IType serviceType = this.createServiceType();
        this.codeServiceInnerTypes(serviceType);
        this.codeServiceFields(serviceType);
        this.generateCustomServiceItems();
    }

    protected abstract void generateSpecificClass() throws Exception;

    protected void generateXml(int bundleType) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.generateXml(bundleType, (IProgressMonitor)monitor);
    }

    protected void generateXml(int bundleType, IProgressMonitor progressMonitor) throws Exception {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        Map map = this.getTemplateVariables();
        String name = this.getMainElement().getKey();
        if (name != null) {
            IProject project;
            String baseType = "";
            String targetId = this.getMainElement().getProjectId();
            switch (bundleType) {
                case 0: {
                    break;
                }
                case 1: {
                    baseType = "bundle";
                    break;
                }
                case 2: {
                    baseType = "managed";
                    break;
                }
                case 3: {
                    baseType = "factory";
                }
            }
            String projectName = targetId;
            if (baseType.length() > 0) {
                projectName = String.valueOf(targetId) + '.' + baseType;
            }
            if ((project = CoreUtility.getProject(projectName)).exists()) {
                map.put("copyright_properties", GeneratorTemplates.getCopyrightPropertyString(map));
                map.put("copyright_xml", GeneratorTemplates.getCopyrightXmlString(map));
                String[] warningStrings = GeneratorTemplates.getStrings(GeneratorTemplates.getWarning(map));
                XmlPrinter printer = new XmlPrinter();
                printer.printComments(warningStrings);
                map.put("warning_xml", printer.getContents());
                String string = GeneratorTemplates.getResults("testagent/testagent" + baseType + "_test.xml", map).trim();
                StringBuffer testXmlPath = new StringBuffer();
                testXmlPath.append(DeviceKitUtilities.getPackageFromClassName(this.getMainBaseName(), this.getPackageBase()));
                testXmlPath.append(".test");
                testXmlPath.append(baseType.length() > 0 ? "." + baseType : "");
                testXmlPath.append(".xml");
                IFile testXmlFile = project.getFile(testXmlPath.toString());
                ByteArrayInputStream buildSamplesStringFileSource = new ByteArrayInputStream(string.getBytes());
                if (testXmlFile.exists()) {
                    if (this.isOverride()) {
                        testXmlFile.setContents((InputStream)buildSamplesStringFileSource, true, true, monitor);
                    }
                } else {
                    testXmlFile.create((InputStream)buildSamplesStringFileSource, true, monitor);
                }
            }
        }
    }

    protected String getAuthor_Version() {
        String initialVersionSince;
        StringBuffer result = new StringBuffer(128);
        if (this.getVendors() != null) {
            result.append("@author ");
            result.append(this.getVendors());
            result.append('\n');
        }
        if (this.getVersion() != null) {
            result.append("@version ");
            result.append(this.getVersion());
            result.append('\n');
        }
        if ((initialVersionSince = this.getInitialVersionSince()) != null) {
            result.append("@since ");
            result.append(initialVersionSince);
            result.append('\n');
        }
        return result.toString();
    }

    protected String getBACreatePropertiesComment(Map table) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(DeviceKitGenerator.getResource("AbstractDkGenerator.ba.create.properties.comment1"));
        buffer.append('\n');
        buffer.append("@return Hashtable of properties.\n");
        buffer.append(" \n");
        int indentation = 0;
        buffer.append(this.getHtmlHelper().startTable(indentation, 100));
        ++indentation;
        Iterator iterator = table.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)table.get(key);
            String[] dataEntries = new String[]{this.unquote(key), this.unquote(value)};
            int[] percents = new int[]{50, 50};
            buffer.append(this.getHtmlHelper().getTableRow(indentation, dataEntries, percents));
        }
        buffer.append(this.getHtmlHelper().endTable(--indentation));
        return buffer.toString();
    }

    protected String getBACreatePropertiesContents(Map table) {
        HashMap<String, String> map = new HashMap<String, String>(101);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("final Hashtable properties = super.createProperties();\n");
        Iterator iterator = table.keySet().iterator();
        while (iterator.hasNext()) {
            String key = String.valueOf(iterator.next());
            Object value = table.get(key);
            buffer.append("properties.put(");
            if (key.indexOf(46) < 0) {
                buffer.append(key);
            } else {
                String className = DeviceKitUtilities.extractPackage(key);
                String smallKey = DeviceKitUtilities.stripPackage(className);
                Object current = map.get(smallKey);
                if (current == null || className.equals(current)) {
                    buffer.append(smallKey);
                    buffer.append('.');
                    buffer.append(DeviceKitUtilities.stripPackage(key));
                    this.fBundleActivatorModel.addImport(className);
                    map.put(smallKey, className);
                } else {
                    buffer.append(key);
                }
            }
            buffer.append(", ");
            if (key.endsWith("org.osgi.service.device.Constants.DEVICE_CATEGORY")) {
                buffer.append("DEVICE_CATEGORY");
            } else {
                buffer.append(value.toString());
            }
            buffer.append(");\n");
        }
        buffer.append("return properties;");
        return buffer.toString();
    }

    protected String getBAGetExportedServiceNameContents() {
        return "return EXPORTED_SERVICE_NAMES;\n";
    }

    protected String getBAGetImportedServiceNameContents() {
        return "return IMPORTED_SERVICE_NAMES;\n";
    }

    protected String getBAGetMatchingDevicesContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("return MATCHING_DEVICES;\n");
        return buffer.toString();
    }

    protected abstract String getBASuperClass();

    public BuildModel getBuildModel() {
        return this.buildModel;
    }

    public IFileSaver getBuildSaver() {
        return this.buildSaver;
    }

    protected String getBundleActivatorClass() {
        return "";
    }

    protected String getBundleActivatorComment() {
        return this.getCommonClassComment();
    }

    protected String getBundleActivatorFqn() {
        return "";
    }

    protected String getBundleActivatorPackage() {
        return String.valueOf(this.getMainPackage()) + "." + "bundle";
    }

    public KeyValuePair[] getBundleFactoryParameters() {
        KeyValuePair arg0 = new KeyValuePair(DkUtilities.stripPackage("String"), "pid");
        KeyValuePair arg1 = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "oldProperties");
        KeyValuePair arg2 = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "properties");
        KeyValuePair arg3 = new KeyValuePair(DkUtilities.stripPackage("org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager"), "manager");
        KeyValuePair[] parameters = new KeyValuePair[]{arg0, arg1, arg2, arg3};
        return parameters;
    }

    public KeyValuePair[] getBundleManagedParameters() {
        KeyValuePair arg0 = new KeyValuePair(DkUtilities.stripPackage("String"), "pid");
        KeyValuePair arg1 = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "oldProperties");
        KeyValuePair arg2 = new KeyValuePair(DkUtilities.stripPackage("java.util.Dictionary"), "properties");
        KeyValuePair arg3 = new KeyValuePair(DkUtilities.stripPackage("org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager"), "manager");
        KeyValuePair[] parameters = new KeyValuePair[]{arg0, arg1, arg2, arg3};
        return parameters;
    }

    protected String getCommonClassComment() {
        String specComment = this.getSpecComment();
        StringBuffer buffer = new StringBuffer(specComment.length() + 64);
        buffer.append(specComment);
        buffer.append(this.getAuthor_Version());
        return buffer.toString();
    }

    protected String getConfBoolean(TagElement element, String key, boolean defaultBoolean) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultBoolean);
        } else {
            buffer.append("getBoolean(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultBoolean);
            buffer.append(')');
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + key, defaultBoolean);
        }
        return buffer.toString();
    }

    protected String getConfBoolean(TagElement element, String key, String defaultBoolean) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultBoolean);
        } else {
            buffer.append("getBoolean(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultBoolean);
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String getConfigurationKey(TagElement element) {
        String key = element.getBundleId();
        if (key != null && key.length() > 0) {
            return key.toLowerCase();
        }
        TagElement parent = element.getParent();
        if (parent != null && (key = parent.getBundleId()) != null && key.length() > 0) {
            return key.toLowerCase();
        }
        key = element.getKey();
        if (key != null && key.length() > 0) {
            return key.toLowerCase();
        }
        return null;
    }

    protected String getConfInt(TagElement element, String key, String defaultValue) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultValue);
        } else {
            buffer.append("getInt(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultValue);
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String getConfLong(TagElement element, String key, String defaultValue) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultValue);
        } else {
            buffer.append("getLong(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultValue);
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String getConfStaticBoolean(TagElement element, String key, boolean defaultBoolean) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultBoolean);
        } else {
            buffer.append("getStaticBoolean(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultBoolean);
            buffer.append(')');
            EscPropertiesModel.getModel(this).addProperty(String.valueOf(configKey) + '.' + key, defaultBoolean);
        }
        return buffer.toString();
    }

    protected String getConfStaticInt(TagElement element, String key, String defaultValue) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultValue);
        } else {
            buffer.append("getStaticInt(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultValue);
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String getConfStaticLong(TagElement element, String key, String defaultValue) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultValue);
        } else {
            buffer.append("getStaticLong(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultValue);
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String getConfString(TagElement element, String key, String defaultString) {
        StringBuffer buffer = new StringBuffer(50);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultString);
        } else {
            buffer.append("getString(");
            String configKey = this.getConfigurationKey(element);
            buffer.append(this.quote(String.valueOf(configKey) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultString);
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String getCopyright() {
        return GeneratorTemplates.getCopyright(this.getTemplateVariables());
    }

    protected int getDefaultRanking() {
        return 6;
    }

    protected String getDescription() {
        String description = this.getMainElement().getDescription();
        if (description == null) {
            description = this.getMainElement().getTagName();
        }
        return description;
    }

    public String getDescriptionShort() {
        String description = this.getDescription().trim();
        int index = description.indexOf(46);
        if (index < 0) {
            return description;
        }
        return description.substring(0, index + 1).replace('\n', ' ').replace('\r', ' ');
    }

    protected String getDeviceCategory() {
        return "";
    }

    protected FieldInformation getFieldMetaData(IType type, IField field) {
        try {
            String fieldKey = MetaDataUtility.createFieldKey(field);
            String packageName = type.getPackage();
            String typeName = type.getName();
            TypeInformation typeInfo = this.generatedInfo.getTypeInformation(packageName, typeName);
            if (typeInfo != null) {
                FieldInformation info = typeInfo.getField(fieldKey);
                return info;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getGeneratedMethodComment() {
        return "Generated method and should not be changed.";
    }

    public boolean getGenerateOld() {
        return this.getMainElement().isOld();
    }

    protected String getGeneratorVersion() {
        return GeneratorPlugin.getVersion();
    }

    public HtmlHelper getHtmlHelper() {
        return this.fHtmlHelper;
    }

    protected String getImplementation(TagElement element, String name) {
        String imp;
        if (name.equals(element.getAttribute("service")) && (imp = element.getAttribute("implementation")) != null) {
            return imp;
        }
        return name;
    }

    protected String getIncubation() {
        String version = this.fModel.getIncubation();
        if (version != null) {
            return version;
        }
        return DeviceKitPlugin.getIncubation();
    }

    protected String getInitialVersion() {
        String initialVersion = this.fModel.getInitialVersion();
        if (initialVersion != null) {
            return initialVersion;
        }
        return "1.0";
    }

    protected String getInitialVersionSince() {
        String initialVersion = this.fModel.getInitialVersionSince();
        if (initialVersion != null) {
            return initialVersion;
        }
        return "1.0";
    }

    public IJavaProject getJavaProject() {
        IJavaProject javaProject = CoreUtility.getJavaProject(this.getSourceFolderName());
        return javaProject;
    }

    protected String getKey(TagElement element) {
        StringBuffer key = new StringBuffer(32);
        String id = element.getId();
        if (id != null) {
            if (this.getServiceFqn() != null && this.getServiceFqn().length() > 0 && id.length() > 0) {
                key.append(DeviceKitUtilities.stripPackage(this.getServiceFqn()));
                key.append('.');
                key.append(id);
            } else {
                key.append(this.quote(id));
            }
            return key.toString();
        }
        return "null";
    }

    protected String getMainBaseName() {
        return this.getTagBaseName(this.getMainElement());
    }

    public String getMainClassName() {
        return this.fMainClassName;
    }

    protected MainTagElement getMainElement() {
        return this.fMainTagElement;
    }

    protected String getMainFqn() {
        return String.valueOf(this.getMainPackage()) + '.' + this.getMainClassName();
    }

    public String getMainPackage() {
        return this.fMainPackage;
    }

    public String getMainTagName() {
        return this.getMainElement().getTagName();
    }

    protected String getManifestBundleId() {
        String id = this.getMainElement().getBundleId();
        if (id == null) {
            return this.getMainPackage();
        }
        if (id.indexOf(46) < 0) {
            return DeviceKitUtilities.getPackageFromClassName(id, this.getPackageBase());
        }
        return id;
    }

    protected String getManifestBundleName() {
        String name = this.getMainElement().getBundleName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return this.getMainElement().getKey();
    }

    protected abstract String[] getManifestCategories();

    protected String getManifestCopyright() {
        String[] strings = GeneratorTemplates.getCopyrightStrings(this.getTemplateVariables());
        if (strings.length > 0) {
            return strings[0];
        }
        return "";
    }

    protected String getManifestDescription() {
        return this.getDescriptionShort();
    }

    protected List getManifestExportPackages() {
        ArrayList vector = new ArrayList();
        return vector;
    }

    protected List getManifestExportServices() {
        return new ArrayList();
    }

    protected List getManifestImportPackages() {
        JavaFileModel messModel;
        String corePack;
        ArrayList<String> vector = new ArrayList<String>();
        List imports = this.fMainTagElement.getAllChildrenWithTagCode(29);
        int i = 0;
        while (i < imports.size()) {
            String string = ((TagElement)imports.get(i)).getTextData();
            if (string != null && string.length() > 0) {
                vector.add(string);
            }
            ++i;
        }
        if (!vector.contains(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR))) {
            vector.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR));
        }
        if (!vector.contains(corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT))) {
            vector.add(corePack);
        }
        if ((messModel = this.getMessageModel()) != null) {
            String[] imps = messModel.getImports();
            int i2 = 0;
            while (i2 < imps.length) {
                if (!this.inThisBundle(imps[i2])) {
                    vector.add(DeviceKitUtilities.extractPackage(imps[i2]));
                }
                ++i2;
            }
        }
        return vector;
    }

    protected List getManifestImportServices() {
        ArrayList vector = new ArrayList();
        return vector;
    }

    public ManifestModel getManifestModel() {
        return this.fManifestModel;
    }

    public List getManifestRequiredBundles() {
        ArrayList vector = new ArrayList();
        return vector;
    }

    protected IFileSaver getManifestSaver() {
        return this.fManifestSaver;
    }

    protected String getMessageClass() {
        return String.valueOf(this.getMainClassName()) + "Messages";
    }

    protected String getMessageClassComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        String comment = DeviceKitGenerator.getResource("DkDeviceGenerator.message.class.comment1");
        Object[] variables = new String[]{this.getType(), this.getMainClassName()};
        String nlsComment = Nls.format(comment, variables);
        buffer.append(nlsComment);
        buffer.append(" \n");
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected List getMessageClassElements() {
        List all = TagElement.collection.getIds();
        ArrayList<TagElement> elements = new ArrayList<TagElement>();
        int i = 0;
        while (i < all.size()) {
            TagElement e = (TagElement)all.get(i);
            if (e.isMessageClassElement()) {
                elements.add(e);
            }
            ++i;
        }
        return elements;
    }

    protected String getMessageFqn() {
        return String.valueOf(this.getMessagePackage()) + "." + this.getMessageClass();
    }

    protected String getMessageGetterComment(TagElement element, String type) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("Gets the ");
        buffer.append(element.getAnyId());
        buffer.append(" value.");
        buffer.append('\n');
        if (element.hasChildWithTagCode(65)) {
            String specRefComment = this.getSpecReferenceComment(element);
            buffer.append(specRefComment);
        }
        buffer.append("\n@return ");
        buffer.append(type);
        buffer.append(" The ");
        buffer.append(element.getAnyId());
        buffer.append(" message");
        return buffer.toString();
    }

    protected String getMessageGetterContents(TagElement element, boolean lazy) {
        JavaFileModel messModel = this.getMessageModel();
        String name = CodeUtilities.staticFieldName(element.getId());
        StringBuffer contents = new StringBuffer(64);
        if (lazy) {
            contents.append("if (" + name + " == null){\n");
            contents.append("\t" + name + " = \n");
            NewCodeGenerator gen = new NewCodeGenerator(this.getMessageFqn(), this.getMessageFqn(), this.getServiceFqn());
            contents.append(gen.getNewCode(2, element));
            List imports = gen.getImports();
            int j = 0;
            while (j < imports.size()) {
                String importedItem = (String)imports.get(j);
                messModel.addImport(importedItem);
                String importedPack = DeviceKitUtilities.extractPackage(importedItem);
                this.getManifestModel().addImportPackage(importedPack);
                ++j;
            }
            contents.append(";\n");
            contents.append("}\n");
        }
        contents.append("return " + name + ';');
        return contents.toString();
    }

    protected String getMessageGetterContents(TagElement element, boolean lazy, String id) {
        JavaFileModel messModel = this.getMessageModel();
        String name = CodeUtilities.staticFieldName(id);
        StringBuffer contents = new StringBuffer(64);
        if (lazy) {
            contents.append("if (" + name + " == null){\n");
            contents.append("\t" + name + " = \n");
            NewCodeGenerator gen = new NewCodeGenerator(this.getMessageFqn(), this.getMessageFqn(), this.getServiceFqn());
            contents.append(gen.getNewCode(2, element));
            List imports = gen.getImports();
            int j = 0;
            while (j < imports.size()) {
                String importedItem = (String)imports.get(j);
                messModel.addImport(importedItem);
                String importedPack = DeviceKitUtilities.extractPackage(importedItem);
                this.getManifestModel().addImportPackage(importedPack);
                ++j;
            }
            contents.append(";\n");
            contents.append("}\n");
        }
        contents.append("return " + name + ';');
        return contents.toString();
    }

    protected JavaFileModel getMessageModel() {
        return this.messageModel;
    }

    protected String getMessagePackage() {
        return String.valueOf(this.getMainPackage()) + "." + "Messages".toLowerCase();
    }

    protected String getMessageType(TagElement element) {
        JavaFileModel messModel = this.getMessageModel();
        String type = null;
        int tagCode = element.getTagCode();
        type = tagCode == 7 || tagCode == 152 || tagCode == 154 || tagCode == 153 ? DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE : (tagCode == 6 ? DeviceKitGenerationConstants.CLASS_FILTER_SERVICE : (tagCode == 12 || element.getTagCode() == 40 || element.getTagCode() == 25 ? element.getType() : (tagCode == 5 || element.getTagCode() == 23 ? (element instanceof SegmentElement ? DeviceKitGenerationConstants.CLASS_SEGMENT_SERVICE : (element instanceof BlockElement ? DeviceKitGenerationConstants.CLASS_BLOCK_SERVICE : DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE)) : element.getType())));
        messModel.addImport(type);
        return type;
    }

    protected String getMetaDataProperties() {
        return null;
    }

    protected MethodInformation getMethodMetaData(IType type, IMethod method) {
        try {
            String methodKey = MetaDataUtility.createMethodKey(method);
            String packageName = type.getPackage();
            String typeName = type.getName();
            TypeInformation typeInfo = this.generatedInfo.getTypeInformation(packageName, typeName);
            if (typeInfo != null) {
                return typeInfo.getMethod(methodKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected boolean getMethodProperty(String methodName) {
        if (this.fMethodProperties == null) {
            return false;
        }
        String b = (String)this.fMethodProperties.get(methodName);
        return b != null && b.equals("true");
    }

    protected DeviceKitTagModel getModel() {
        return this.fModel;
    }

    protected Map getOsgiProperties(JavaFileModel model) {
        HashMap table = new HashMap();
        return table;
    }

    public Map getOtherManifestFiles() {
        return this.otherManifestFiles;
    }

    protected String getPackageBase() {
        return this.fPackageBase;
    }

    public IPackageFragment[] getPackages() {
        ArrayList<IPackageFragment> vector = new ArrayList<IPackageFragment>(101);
        try {
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject.exists()) {
                IPackageFragment[] javaPackages = javaProject.getPackageFragments();
                int i = 0;
                while (i < javaPackages.length) {
                    ICompilationUnit[] compilationUnits = javaPackages[i].getCompilationUnits();
                    if (compilationUnits.length > 0) {
                        vector.add(javaPackages[i]);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IPackageFragment[] javaPackages = new IPackageFragment[vector.size()];
        javaPackages = vector.toArray(javaPackages);
        return javaPackages;
    }

    protected String getProvider() {
        String provider = this.fModel.getProvider();
        if (provider != null) {
            return provider;
        }
        return DeviceKitPlugin.getProvider();
    }

    protected RootElement getRootElement() {
        return this.fRoot;
    }

    protected IJavaSaver getSaver() {
        return this.fSaver;
    }

    protected String getServiceClass() {
        return String.valueOf(this.fMainClassName) + "Service";
    }

    protected String getServiceFileComment() {
        return "";
    }

    protected String getServiceFqn() {
        return String.valueOf(this.getServicePackage()) + "." + this.getServiceClass();
    }

    protected String[] getServiceInterfaces() {
        return new String[0];
    }

    protected String getServicePackage() {
        return String.valueOf(this.getMainPackage()) + "." + "Service".toLowerCase();
    }

    protected String getSetContents(TagElement element, String type, String name, String defValue) {
        if ("boolean".equals(type)) {
            boolean val = Boolean.getBoolean(defValue);
            return this.getConfBoolean(element, name, val);
        }
        if ("int".equals(type)) {
            return this.getConfInt(element, name, defValue);
        }
        if ("long".equals(type)) {
            return this.getConfLong(element, name, defValue);
        }
        if ("String".equals(type)) {
            return this.getConfString(element, name, defValue);
        }
        if ("byte".equals(type)) {
            return "(byte) " + this.getConfInt(element, name, defValue);
        }
        return defValue;
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.getMainPackage();
        return sfName;
    }

    public String getSourceLevel() {
        return this.sourceLevel;
    }

    protected String getSpecComment() {
        List specs = this.getSpecs();
        StringBuffer buffer = new StringBuffer(specs.size() * 64);
        if (specs.size() > 0) {
            int count = 0;
            int i = 0;
            while (i < specs.size()) {
                SpecElement se = (SpecElement)specs.get(i);
                String title = se.getSpecTitle();
                if (title != null) {
                    if (count == 0) {
                        buffer.append("<p>\n");
                        buffer.append("See the following specification(s) for more details:</p>\n");
                    } else {
                        buffer.append("<br>\n");
                    }
                    buffer.append(this.getHtmlHelper().startTable(0, 100, "border=\"2\""));
                    int[] percentages = new int[]{20, 80};
                    buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Title:", "<i>" + title + "</i>"}, percentages));
                    if (se.getSpecUrl() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"URL:", se.getSpecUrl()}, percentages));
                    }
                    if (se.getSpecVersion() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Version:", se.getSpecVersion()}, percentages));
                    }
                    if (se.getSpecDate() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Date:", se.getSpecDate()}, percentages));
                    }
                    if (se.getSpecVendor() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Vendor:", se.getSpecVendor()}, percentages));
                    }
                    if (se.getSpecComment() != null) {
                        buffer.append(this.getHtmlHelper().getTableRow(1, new String[]{"Comment:", se.getSpecComment()}, percentages));
                    }
                    buffer.append(this.getHtmlHelper().endTable(0));
                    ++count;
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    protected String getSpecReferenceComment(TagElement element) {
        List specReferences = element.getAllChildrenWithTagCode(65);
        StringBuffer commentBuffer = new StringBuffer(specReferences.size() * 32);
        int j = 0;
        while (j < specReferences.size()) {
            SpecReferenceElement srElement = (SpecReferenceElement)specReferences.get(j);
            commentBuffer.append(srElement.getSpecReferenceComment());
            commentBuffer.append('\n');
            ++j;
        }
        return commentBuffer.toString();
    }

    public List getSpecs() {
        return TagElement.collection.getSpecs();
    }

    protected String getTagBaseName(TagElement tag) {
        String type = tag.getTagName();
        String id = tag.getId();
        if (id.toLowerCase().endsWith(type.toLowerCase())) {
            return id.substring(0, id.length() - type.length());
        }
        return id;
    }

    public Map getTemplateVariables() {
        IFile file;
        String year = String.valueOf(Calendar.getInstance().get(1));
        HashMap<String, String> map = new HashMap<String, String>(101);
        map.put("class_name", this.getMainClassName());
        map.put("class_name_full", this.getMainFqn());
        map.put("description", this.fMainTagElement.getDescription());
        map.put("vendor", this.getVendor());
        map.put("vendors", this.getVendors());
        map.put("provider", this.getProvider());
        map.put("packagebase", this.getPackageBase());
        map.put("version", this.getVersion());
        map.put("year", year);
        map.put("years", year);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null && (file = javaProject.getProject().getFile("copyright.txt")).exists()) {
            try {
                InputStream is = file.getContents(true);
                String data = new String(BuildSaver.readData(is));
                int createYear = BuildSaver.containsCopyright(data);
                return GeneratorTemplates.updateMap(map, createYear);
            }
            catch (Exception exception) {}
        }
        return map;
    }

    protected String getType() {
        return null;
    }

    protected String getUserName(TagElement element) {
        String name = element.getBundleName();
        if (name != null && name.length() > 0) {
            return name;
        }
        return element.getKey();
    }

    protected String getVendor() {
        String vendor = this.fModel.getVendor();
        if (vendor != null) {
            return vendor;
        }
        return DeviceKitPlugin.getVendor();
    }

    protected String getVendors() {
        String vendors = this.fModel.getVendors();
        if (vendors != null) {
            return vendors;
        }
        return this.getVendor();
    }

    protected String getVersion() {
        String version = this.fModel.getVersion();
        if (version != null) {
            return version;
        }
        return DeviceKitPlugin.getVersion();
    }

    protected void init() {
        this.fRoot = this.fModel.getRoot();
        this.fHtmlHelper = new HtmlHelper();
        this.fManifestModel = new ManifestModel();
        if (this.generatedInfo == null) {
            this.generatedInfo = new GeneratedInfo();
        }
        this.buildModel = new BuildModel(this);
        EscPropertiesModel.getModel(this);
    }

    protected void initialize() {
        this.setupExportedPackages();
    }

    protected boolean inThisBundle(String string) {
        String packageOnly = DkUtilities.extractPackage(string);
        if (packageOnly.equals(this.getMainPackage())) {
            return true;
        }
        if (packageOnly.equals(this.getServicePackage())) {
            return true;
        }
        return packageOnly.equals(this.getBundleActivatorPackage());
    }

    protected boolean isAbstract() {
        return false;
    }

    protected boolean isIncubation() {
        String incubation = this.getIncubation();
        return incubation != null && ("true".equals(incubation) || "1".equals(incubation));
    }

    protected boolean isOverride() {
        return false;
    }

    public boolean isParameterizedTypes() {
        return this.isSource15orMore();
    }

    public boolean isSource15orMore() {
        return this.getSourceLevel().compareTo("1.5") >= 0;
    }

    private void organizeManifest(IProgressMonitor progressMonitor) throws Exception {
        this.fManifestModel.organize(progressMonitor);
    }

    protected String quote(String original) {
        StringBuffer buffer = new StringBuffer(original.length() + 2);
        buffer.append('\"');
        buffer.append(original);
        buffer.append('\"');
        return buffer.toString();
    }

    protected List save(IProgressMonitor progressMonitor) throws Exception {
        JavaFileModel messModel;
        this.saveBuildProperties(progressMonitor);
        this.saveManifest(progressMonitor);
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.fServiceModel != null) {
            this.fServiceModel.setSaver(this.getSaver());
            this.fServiceModel.setSortOrder(3L);
            Object service = this.fServiceModel.save(progressMonitor);
            if (service != null) {
                result.add(service);
            }
        }
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save(progressMonitor);
            if (ba != null) {
                result.add(ba);
            }
        }
        if ((messModel = this.getMessageModel()) != null) {
            messModel.setSaver(this.getSaver());
            messModel.setSortOrder(3L);
            Object message = messModel.save(progressMonitor);
            if (message != null) {
                result.add(message);
            }
        }
        this.organizeManifest(progressMonitor);
        return result;
    }

    protected void saveBuildProperties(IProgressMonitor progressMonitor) throws Exception {
        this.buildModel.setBuildSaver(this.buildSaver);
        this.buildModel.save(progressMonitor);
    }

    public void saveCommon(IProgressMonitor progressMonitor) throws Exception {
        this.saveBuildProperties(progressMonitor);
        this.saveManifest(progressMonitor);
    }

    protected void saveManifest(IProgressMonitor progressMonitor) throws Exception {
        this.fManifestModel.setAbstract(this.isAbstract());
        this.fManifestModel.setSaver(this.fManifestSaver);
        this.fManifestModel.save(progressMonitor);
    }

    public void setBuildSaver(IFileSaver buildSaver) {
        this.buildSaver = buildSaver;
    }

    public void setCustomInfo(CustomInfo customInfo) {
        this.customInfo = customInfo;
    }

    public void setExistInfo(CustomInfo existInfo) {
        this.existInfo = existInfo;
    }

    public void setGenerateManifest(boolean genManifest) {
        this.osgi = genManifest;
    }

    protected void setMainClassName(String mainClassName) {
        this.fMainClassName = mainClassName;
    }

    protected void setMainPackage(String mainPackage) {
        this.fMainPackage = mainPackage;
    }

    protected void setMainTagElement(MainTagElement mainElement) {
        this.fMainTagElement = mainElement;
    }

    public void setManifestSaver(IFileSaver manifestSaver) {
        this.fManifestSaver = manifestSaver;
    }

    protected void setMessageModel(JavaFileModel messModel) {
        this.messageModel = messModel;
    }

    protected void setOsgi(boolean osgi) {
        this.osgi = osgi;
    }

    protected void setPackageBase(String packageBase) {
        this.fPackageBase = packageBase;
    }

    public void setSaver(IJavaSaver saver) {
        this.fSaver = saver;
    }

    public void setSourceLevel(String sourceLevel) {
        this.sourceLevel = sourceLevel;
    }

    public void setupExportedPackages() {
        this.fManifestModel.setVersion(String.valueOf(this.getVersion()) + ".qualifier");
        List expPackages = this.getManifestExportPackages();
        int i = 0;
        while (i < expPackages.size()) {
            this.fManifestModel.addExportedPackage((String)expPackages.get(i));
            ++i;
        }
        List requiredBundles = this.getManifestRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.size()) {
            this.fManifestModel.addRequiredBundle((String)requiredBundles.get(i2));
            ++i2;
        }
        IPackageFragment[] javaPackages = this.getPackages();
        int i3 = 0;
        while (i3 < javaPackages.length) {
            this.fManifestModel.addExportedPackage(javaPackages[i3].getElementName());
            ++i3;
        }
    }

    protected String unquote(String string) {
        if (string.indexOf(34) == -1) {
            return string;
        }
        StringBuffer sb = new StringBuffer(string);
        while (sb.toString().indexOf(34) != -1) {
            int qIndex = sb.toString().indexOf(34);
            sb.replace(qIndex, qIndex + 1, "");
        }
        return sb.toString();
    }

    protected boolean useExistingMethod(IType type, String methodKey) {
        MethodInformation method;
        CustomTypeInformation existType;
        boolean result = false;
        if (this.existInfo != null && (existType = this.existInfo.getTypeInformation(type.getPackage(), type.getName())) != null && (method = existType.getMethod(methodKey)) != null) {
            type.addExtraMethod(methodKey, (String)method.getData());
            this.addMethodMetaData(type, methodKey);
            result = true;
        }
        return result;
    }
}

