/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter.testcase;

import java.util.Hashtable;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.IntegerParameter;
import org.eclipse.soda.dk.parameter.UnsignedIntegerParameter;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class IntegerParameterTestcase
extends TestCase {
    public static final String EMPTY_STRING = new String();
    static /* synthetic */ Class class$0;

    public IntegerParameterTestcase(String p1) {
        super(p1);
    }

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.parameter.testcase.IntegerParameterTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public ParameterService createParameter(String key, int offset, int length) {
        return new IntegerParameter(key, offset, length);
    }

    public ParameterService createUnsignedParameter(String key, int offset, int length) {
        return new UnsignedIntegerParameter(key, offset, length);
    }

    public int getMaxLength() {
        return 32;
    }

    public void testDecodeBytesInteger() {
        ParameterService parameter = this.createParameter("", 12, 1);
        Object result = parameter.decode((Object)new byte[]{90, 10, -1});
        IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
        IntegerParameterTestcase.assertEquals((long)-1L, (long)((Number)result).longValue());
    }

    public void testDecodeInteger() {
        ParameterService parameter = this.createParameter("", 12, 1);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decode((Object)message);
        IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
        IntegerParameterTestcase.assertEquals((long)-1L, (long)((Number)result).longValue());
    }

    public void testDecodeInteger8() {
        ParameterService parameter = this.createParameter("", 16, 8);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decode((Object)message);
        IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
        IntegerParameterTestcase.assertEquals((long)-1L, (long)((Number)result).longValue());
    }

    public void testDecodeInteger8FullByte() {
        ParameterService parameter = this.createParameter("", 16, 8);
        int i = -128;
        while (i <= 127) {
            Message message = new Message(new byte[]{90, 10, (byte)i});
            Object result = parameter.decode((Object)message);
            IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
            IntegerParameterTestcase.assertEquals((long)i, (long)((Number)result).longValue());
            ++i;
        }
    }

    public void testDecodeInteger8FullInteger() {
        if (this.getMaxLength() >= 32) {
            ParameterService parameter = this.createParameter("", 16, 32);
            long i = Integer.MIN_VALUE;
            while (i <= 32767L) {
                Message message = new Message(new byte[]{90, 10, (byte)(i >> 24 & 0xFFL), (byte)(i >> 16 & 0xFFL), (byte)(i >> 8 & 0xFFL), (byte)(i & 0xFFL)});
                Object result = parameter.decode((Object)message);
                IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
                IntegerParameterTestcase.assertEquals((long)i, (long)((Number)result).longValue());
                i += 64L;
            }
        }
    }

    public void testDecodeInteger8FullLong() {
        if (this.getMaxLength() >= 64) {
            ParameterService parameter = this.createParameter("", 16, 64);
            long i = Integer.MIN_VALUE;
            while (i <= 32767L) {
                Message message = new Message(new byte[]{90, 10, (byte)(i >> 56 & 0xFFL), (byte)(i >> 48 & 0xFFL), (byte)(i >> 40 & 0xFFL), (byte)(i >> 32 & 0xFFL), (byte)(i >> 24 & 0xFFL), (byte)(i >> 16 & 0xFFL), (byte)(i >> 8 & 0xFFL), (byte)(i & 0xFFL)});
                Object result = parameter.decode((Object)message);
                IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
                IntegerParameterTestcase.assertEquals((long)i, (long)((Number)result).longValue());
                i += 64L;
            }
        }
    }

    public void testDecodeInteger8FullShort() {
        if (this.getMaxLength() >= 16) {
            ParameterService parameter = this.createParameter("", 16, 16);
            int i = Short.MIN_VALUE;
            while (i <= Short.MAX_VALUE) {
                Message message = new Message(new byte[]{90, 10, (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)});
                Object result = parameter.decode((Object)message);
                IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
                IntegerParameterTestcase.assertEquals((long)i, (long)((Number)result).longValue());
                ++i;
            }
        }
    }

    public void testDecodeInteger8FullUnsignedByte() {
        ParameterService parameter = this.createUnsignedParameter("", 16, 8);
        int i = 0;
        while (i <= 128) {
            Message message = new Message(new byte[]{90, 10, (byte)i});
            Object result = parameter.decode((Object)message);
            IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
            IntegerParameterTestcase.assertEquals((long)i, (long)((Number)result).longValue());
            ++i;
        }
    }

    public void testDecodeInteger8FullUnsignedShort() {
        if (this.getMaxLength() >= 16) {
            ParameterService parameter = this.createUnsignedParameter("", 16, 16);
            int i = 0;
            while (i <= 32768) {
                Message message = new Message(new byte[]{90, 10, (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)});
                Object result = parameter.decode((Object)message);
                IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
                IntegerParameterTestcase.assertEquals((long)i, (long)((Number)result).longValue());
                ++i;
            }
        }
    }

    public void testEncodeBytesInteger() {
        ParameterService parameter = this.createParameter("", 12, 2);
        byte[] result = (byte[])parameter.encode((Object)new byte[]{90, -1, -1}, (Object)new Integer(2));
        IntegerParameterTestcase.assertEquals((byte)-5, (byte)result[1]);
    }

    public void testEncodeInteger() {
        ParameterService parameter = this.createParameter("", 12, 2);
        Message message = new Message(new byte[]{90, -1, -1});
        MessageService result = (MessageService)parameter.encode((Object)message, (Object)new Integer(2));
        IntegerParameterTestcase.assertEquals((byte)-5, (byte)result.getBytes()[1]);
    }

    public void testEncodeInteger4() {
        ParameterService parameter = this.createParameter("", 12, 4);
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        IntegerParameterTestcase.assertEquals((byte)2, (byte)result.getBytes()[1]);
    }

    public void testEncodeInteger8() {
        ParameterService parameter = this.createParameter("", 12, 8);
        byte[] byArray = new byte[3];
        byArray[0] = 90;
        Message message = new Message(byArray);
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        IntegerParameterTestcase.assertEquals((byte)0, (byte)result.getBytes()[1]);
        IntegerParameterTestcase.assertEquals((byte)32, (byte)result.getBytes()[2]);
    }

    public void testEncodeInteger8a() {
        ParameterService parameter = this.createParameter("", 12, 8);
        Message message = new Message(new byte[]{90, -1, -1});
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        IntegerParameterTestcase.assertEquals((byte)-16, (byte)result.getBytes()[1]);
        IntegerParameterTestcase.assertEquals((byte)47, (byte)result.getBytes()[2]);
    }

    public void testEncodeMap() {
        ParameterService parameter = this.createParameter("i0", 12, 2);
        Message message = new Message(new byte[]{90, -1, -1});
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        map.put("i0", new Integer(2));
        MessageService result = (MessageService)parameter.encode((Object)message, map);
        IntegerParameterTestcase.assertEquals((byte)-5, (byte)result.getBytes()[1]);
    }

    public void testEncodeString() {
        ParameterService parameter = this.createParameter("", 12, 2);
        Message message = new Message(new byte[]{90, -1, -1});
        MessageService result = (MessageService)parameter.encode((Object)message, (Object)"2");
        IntegerParameterTestcase.assertEquals((byte)-5, (byte)result.getBytes()[1]);
    }

    public void testEncodeValueInteger() {
        ParameterService parameter = this.createParameter("", 12, 2);
        Message message = new Message(new byte[]{90, -1, -1});
        MessageService result = parameter.encodeValue((MessageService)message, (Object)new Integer(2));
        IntegerParameterTestcase.assertEquals((byte)-5, (byte)result.getBytes()[1]);
    }

    public void testInteger() {
        ParameterService parameter = this.createParameter("", 12, 1);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
        IntegerParameterTestcase.assertEquals((long)-1L, (long)((Number)result).longValue());
    }

    public void testInteger2() {
        ParameterService parameter = this.createParameter("", 12, 2);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        IntegerParameterTestcase.assertTrue((String)"result instanceof Number", (boolean)(result instanceof Number));
        IntegerParameterTestcase.assertEquals((long)-2L, (long)((Number)result).longValue());
    }

    public void testInteger4() {
        ParameterService parameter = this.createParameter("", 12, 4);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        IntegerParameterTestcase.assertEquals((Object)new Integer(-6), (Object)result);
    }

    public void testInteger5() {
        ParameterService parameter = this.createParameter("", 12, 5);
        Message message = new Message(new byte[]{90, 10, -1});
        Object result = parameter.decodeValue((MessageService)message);
        IntegerParameterTestcase.assertEquals((Object)new Integer(-11), (Object)result);
    }
}

