/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.swt;

import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.swt.ControlWindow;
import org.eclipse.soda.dk.device.swt.DeviceSwt;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;

public class Bridge {
    protected TableItem tableItem;
    protected long count = 0L;
    protected long refreshCount = 0L;
    protected long errorCount = 0L;
    protected long timstamp = 0L;
    protected Object data = null;
    protected DeviceSwt parent;
    protected ControlService control;
    protected ControlWindow window;

    public Bridge(DeviceSwt parent, TableItem tableItem, ControlService control) {
        this.setParent(parent);
        this.setTableItem(tableItem);
        this.setControl(control);
    }

    public void closeWindow() {
        if (this.window != null) {
            this.window.getParent().close();
            this.setWindow(null);
        }
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        ++this.errorCount;
    }

    public ControlService getControl() {
        return this.control;
    }

    public long getCount() {
        return this.count;
    }

    public Object getData() {
        return this.data;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public Image getImage() {
        return this.getParent().getMeasurementImage();
    }

    public DeviceSwt getParent() {
        return this.parent;
    }

    public long getRefreshCount() {
        return this.refreshCount;
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public long getTimstamp() {
        return this.timstamp;
    }

    public ControlWindow getWindow() {
        return this.window;
    }

    public void openWindow() {
        if (this.window == null) {
            ControlWindow window = new ControlWindow(this);
            window.open();
            this.setWindow(window);
        } else if (this.window.getParent().isDisposed()) {
            ControlWindow window = new ControlWindow(this);
            window.open();
            this.setWindow(window);
        } else {
            this.window.getParent().forceFocus();
        }
    }

    public void refresh() {
        if (this.getRefreshCount() > 0L) {
            this.updateTable();
            if (this.window != null) {
                if (this.window.getParent().isDisposed()) {
                    this.setWindow(null);
                } else {
                    this.window.refresh();
                }
            }
        }
    }

    public void setControl(ControlService control) {
        this.control = control;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setErrorCount(long errorCount) {
        this.errorCount = errorCount;
    }

    public void setParent(DeviceSwt parent) {
        this.parent = parent;
    }

    public void setRefreshCount(long refreshCount) {
        this.refreshCount = refreshCount;
    }

    public void setTableItem(TableItem tableItem) {
        this.tableItem = tableItem;
    }

    public void setTimstamp(long timstamp) {
        this.timstamp = timstamp;
    }

    public void setTimstamp(Object timstamp) {
        if (timstamp instanceof Number) {
            Number timestampNumber = (Number)timstamp;
            this.setTimstamp(timestampNumber.longValue());
        }
    }

    public void setWindow(ControlWindow window) {
        this.window = window;
    }

    public void updateCount() {
        ++this.count;
    }

    public void updateRefreshCount() {
        ++this.refreshCount;
    }

    public void updateTable() {
        int dataIndex;
        int countIndex;
        String key = this.control.getKey();
        long timestampBaseline = this.getParent().getTimestamp();
        String timestamp = this.getTimstamp() > 0L ? Long.toString(this.getTimstamp() - timestampBaseline) : "";
        String countString = this.getCount() > 0L ? Long.toString(this.getCount()) : "";
        String dataString = Nls.formatData((Object)this.getData());
        this.tableItem.setText(0, key);
        int timestampIndex = this.getParent().getTimestampIndex();
        if (timestampIndex >= 0) {
            this.tableItem.setText(timestampIndex, timestamp);
        }
        if ((countIndex = this.getParent().getCountIndex()) >= 0) {
            this.tableItem.setText(countIndex, countString);
        }
        if ((dataIndex = this.getParent().getDataIndex()) >= 0) {
            this.tableItem.setText(dataIndex, dataString);
        }
        Image image = this.getImage();
        this.tableItem.setImage(image);
        if (this.getCount() > 0L) {
            this.tableItem.setFont(0, this.parent.getBoldFont());
            if (countIndex >= 0) {
                if (this.getCount() > 1L) {
                    this.tableItem.setBackground(countIndex, this.parent.getActiveColor());
                } else {
                    this.tableItem.setBackground(countIndex, this.parent.getLittleActiveColor());
                }
            }
        } else {
            this.tableItem.setFont(0, this.parent.getNormalFont());
        }
        if (dataIndex >= 0) {
            if (this.getData() == null) {
                this.tableItem.setFont(dataIndex, this.parent.getItalicFont());
            } else {
                this.tableItem.setFont(dataIndex, this.parent.getNormalFont());
            }
        }
        this.setRefreshCount(0L);
    }
}

