/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import org.eclipse.soda.dk.device.Queue;
import org.eclipse.soda.dk.device.TransportDevice;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.transport.service.MessageListener;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.TransportService;

public abstract class QueueDevice
extends TransportDevice
implements Runnable {
    private Queue receivedQueue;
    private Thread thread;
    private boolean isRunning;

    protected QueueDevice() {
        this.initialize();
    }

    public Queue getReceivedQueue() {
        return this.receivedQueue;
    }

    private void initialize() {
        this.receivedQueue = new Queue();
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        MessageListener messageListener;
        Object key = this.getMessageKey(message);
        if (key != null && (messageListener = (MessageListener)this.getMessageListeners().get(key)) != null) {
            try {
                this.getReceivedQueue().enqueue(new Object[]{transportService, timestamp, message});
            }
            catch (Throwable exception) {
                this.handleError(exception, 3012, message);
            }
        }
    }

    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            Object object = this.getReceivedQueue().dequeue();
            if (object instanceof Object[]) {
                Object[] objects = (Object[])object;
                super.messageReceived((TransportService)objects[0], objects[1], (MessageService)objects[2]);
                continue;
            }
            if (!(object instanceof MessageService)) continue;
            super.send((MessageService)object);
        }
    }

    public void send(MessageService message) {
        try {
            this.getReceivedQueue().enqueue(message.clone());
        }
        catch (Exception exception) {
            this.handleError(exception, 3010, message);
        }
    }

    public void send(ChannelService channel, MessageService message) {
        if (channel != null) {
            throw new RuntimeException(this.getResource(3017));
        }
        this.send(message);
    }

    public void send(ChannelService channel, MessageService message, ResponseListener responseListener) {
        this.send(channel, message);
    }

    public void send(MessageService message, ResponseListener responseListener) {
        this.send(message);
    }

    public void start() {
        super.start();
        this.thread = new Thread((Runnable)this, String.valueOf(this.getOutputName()) + "Queue");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.isRunning = false;
        super.stop();
        this.thread = null;
    }
}

