/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device;

import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.TransportDevice;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.signal.service.SignalService;

public abstract class ThreadDevice
extends TransportDevice
implements Runnable {
    private ControlService[] processingControls;
    private long processingTime;
    private long tolerance = -1L;

    protected ThreadDevice() {
    }

    public boolean isThreadNeeded() {
        return true;
    }

    public void process(ControlService control) {
        if (control instanceof CommandService) {
            ((CommandService)control).execute(null);
        }
        if (control instanceof MeasurementService) {
            ((MeasurementService)control).executeRead(null);
        }
        if (control instanceof SignalService) {
            ((SignalService)control).trigger(null);
        }
    }

    public void run() {
        super.run();
        if (this.processingControls == null || this.processingControls.length == 0) {
            return;
        }
        long lastTime = System.currentTimeMillis();
        long timeDelay = this.processingTime;
        if (this.tolerance == -1L) {
            this.tolerance = this.processingTime / 10L;
        }
        if (this.isBlockProcessing()) {
            while (this.isRunning()) {
                try {
                    int i = 0;
                    while (i < this.processingControls.length) {
                        this.transportStartedWait();
                        if (!this.isRunning()) break;
                        this.process(this.processingControls[i]);
                        ++i;
                    }
                    long time = System.currentTimeMillis();
                    if (time - lastTime < timeDelay) {
                        Thread.sleep(timeDelay - (time - lastTime));
                    } else {
                        this.handleError(null, 3011);
                    }
                    lastTime = time;
                }
                catch (Exception exception) {
                    this.handleError(exception, 3007);
                    this.setRunning(false);
                }
            }
        } else {
            if (this.processingControls.length <= 0) {
                return;
            }
            timeDelay = this.processingTime / (long)this.processingControls.length;
            long[] delays = new long[this.processingControls.length];
            long[] times = new long[this.processingControls.length];
            int i = 0;
            while (i < this.processingControls.length) {
                delays[i] = 0L;
                times[i] = timeDelay;
                ++i;
            }
            while (this.isRunning()) {
                try {
                    i = 0;
                    while (i < this.processingControls.length) {
                        if (!this.isRunning()) break;
                        this.transportStartedWait();
                        lastTime = System.currentTimeMillis();
                        this.process(this.processingControls[i]);
                        long time = System.currentTimeMillis();
                        long delay = delays[i];
                        if (delay > 0L) {
                            delay -= time - lastTime - times[i];
                        }
                        times[i] = time - lastTime;
                        if (delay > 0L) {
                            Thread.sleep(delay);
                        }
                        ++i;
                    }
                    if (this.tolerance <= 0L) continue;
                    long totalDelayTime = 0L;
                    long totalUsedTime = 0L;
                    int i2 = 0;
                    while (i2 < this.processingControls.length) {
                        totalUsedTime += times[i2];
                        totalDelayTime += delays[i2];
                        ++i2;
                    }
                    long freeTime = this.processingTime - totalUsedTime;
                    long newDelay = 0L;
                    if (totalDelayTime >= freeTime) continue;
                    long changeTime = freeTime - totalDelayTime;
                    if (changeTime > this.tolerance >> 1) {
                        changeTime = this.tolerance >> 1;
                    }
                    newDelay = changeTime / (long)this.processingControls.length;
                    int i3 = 0;
                    while (i3 < this.processingControls.length) {
                        int n = i3++;
                        delays[n] = delays[n] + newDelay;
                    }
                }
                catch (Exception exception) {
                    this.handleError(exception, 3007);
                    this.setRunning(false);
                }
            }
        }
    }

    public void setProcessingControls(ControlService[] processingControls) {
        this.processingControls = processingControls;
    }
}

