/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.measurement;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.measurement.service.MultiplexMeasurementListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;

public class MeasurementFieldMeasurement
extends Measurement
implements MultiplexMeasurementListener {
    protected String fieldName = "";
    protected MeasurementService measurement;

    public MeasurementFieldMeasurement(String key) {
        super(key);
    }

    public MeasurementFieldMeasurement(String key, MeasurementService measurement, String fieldName) {
        super(key);
        this.setMeasurement(measurement);
        this.setFieldName(fieldName);
    }

    public MeasurementFieldMeasurement(String key, Object value) {
        super(key, value);
    }

    public MeasurementFieldMeasurement(String key, Object value, MeasurementService measurement, String fieldName) {
        super(key);
        this.setMeasurement(measurement);
        this.setFieldName(fieldName);
        this.setValue(null, value, MeasurementFieldMeasurement.getCurrentTimestamp());
    }

    public void executeRead(ChannelService channel) {
        MeasurementService measurement = this.getMeasurement();
        if (measurement != null) {
            measurement.executeRead(channel);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public MeasurementService getMeasurement() {
        return this.measurement;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, ChannelService channel, Object newValue, Object oldValue) {
        Map map;
        Object value;
        if (newValue instanceof Map && (value = (map = (Map)newValue).get(this.getFieldName())) != null) {
            this.setValue(channel, value, timestamp);
        }
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        this.measurementChanged(source, timestamp, null, newValue, oldValue);
    }

    public Object read(ChannelService channel, long timeout) throws RuntimeException {
        MeasurementService measurement = this.getMeasurement();
        if (measurement != null) {
            measurement.read(channel, timeout);
        }
        return super.read(channel, timeout);
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public void setMeasurement(MeasurementService measurement) {
        if (this.measurement != null) {
            this.measurement.removeMeasurementListener((MeasurementListener)this);
        }
        this.measurement = measurement;
        if (this.measurement != null) {
            this.measurement.addMeasurementListener((MeasurementListener)this);
        }
    }

    public void setValue(ChannelService channel, Object value, Object timestamp) {
        Object currentValue = this.getValue(channel);
        if (this.equalsValue(currentValue, value)) {
            this.setTimestamp(channel, timestamp);
        } else {
            String key;
            Map map;
            Object currentMapValue;
            Object currentParentValue;
            super.setValue(channel, value, timestamp);
            MeasurementService measurement = this.getMeasurement();
            if (measurement != null && (currentParentValue = measurement.getValue(channel)) instanceof Map && !this.equalsValue(currentMapValue = (map = (Map)currentParentValue).get(key = this.getKey()), value)) {
                HashMap<String, Object> mapNew = new HashMap<String, Object>(map);
                mapNew.put(key, value);
                if (measurement instanceof Measurement) {
                    ((Measurement)measurement).setValue(channel, value, timestamp);
                } else {
                    measurement.setValue(channel, mapNew);
                }
            }
        }
    }
}

