/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.adapter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.soda.dk.adapter.DeviceAdapter;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.epcglobal.llrp.adapter.service.EpcglobalLlrpAdapterService;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.helper.idmanager.AccessSpecIdManager;
import org.eclipse.soda.dk.epcglobal.llrp.helper.idmanager.IIdManager;
import org.eclipse.soda.dk.epcglobal.llrp.helper.idmanager.ROSpecIdManager;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.ILLRPCapabilities;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_GET_READER_CAPABILITIES;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskManager;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.TaskManager;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class EpcglobalLlrpAdapter
extends DeviceAdapter
implements AdapterService,
EpcglobalLlrpAdapterService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.adapter.EpcglobalLlrpAdapter";
    private final InterestService interest = new InterestMask(new byte[]{4}, new byte[]{-4});
    private final MethodMeasurement readerCapabilities = new MethodMeasurement("LlrpAdapter/ReaderCapabilities", new HashMap());
    protected CommandService epcglobalLlrpDeviceServiceGetReaderCapabilities;
    protected SignalService epcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse;
    protected SignalService epcglobalLlrpDeviceServiceGetRospecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStartRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStopRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceRoAccessReport;
    protected SignalService epcglobalLlrpDeviceServiceGetAccessspecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableAccessspecResponse;
    private long lLRPCommandTimeout = 0L;
    private ITaskListener taskListner = new ITaskListener(){

        public void taskNotice(String taskName, int status, Object result) {
            if (status == 0) {
                String errorMsg = LLRPUtils.handleErrorResponse((String)taskName, (Map)((Map)result));
                EpcglobalLlrpAdapter.this.handleError(new RuntimeException(errorMsg), 1);
                return;
            }
            if (status == 1 && taskName.equals("Task_GET_READER_CAPABILITIES")) {
                EpcglobalLlrpAdapter.this.setReaderCapabilities();
                return;
            }
        }
    };
    private ITaskManager taskManager = new TaskManager("org.eclipse.soda.dk.epcglobal.llrp.adapter.EpcglobalLlrpAdapter.TaskManager");
    private IIdManager roSpecIdManager = new ROSpecIdManager();
    private IIdManager accessSpecIdManager = new AccessSpecIdManager();
    private Task_GET_READER_CAPABILITIES getReaderCapabilitiesTask;
    private boolean isReaderCapabilitiesReady = false;
    private Byte readerCapabilitiesReadyMonitor = new Byte(0);

    public EpcglobalLlrpAdapter() {
        super("Adapter/Capabilities", "Adapter/Status", "Adapter/Configuration", "Adapter/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void activate() {
        if (!this.isReaderCapabilitiesReady) {
            this.requestReaderCapabilities();
        }
        super.activate();
    }

    public IIdManager getAccessSpecIdManager() {
        return this.accessSpecIdManager;
    }

    public MeasurementService getCapabilities() {
        return super.getCapabilities();
    }

    public int getControlCapacity() {
        return 3;
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)EpcglobalLlrpAdapter.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.epcglobal.llrp.device.EpcglobalLlrpDevice");
    }

    public String getDefaultKey() {
        return "EpcglobalLlrpAdapter";
    }

    public InterestService getInterest() {
        return this.interest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILLRPCapabilities getLLRPCapabilities() {
        Byte by = this.readerCapabilitiesReadyMonitor;
        synchronized (by) {
            if (!this.isReaderCapabilitiesReady) {
                try {
                    if (this.isLogging(4)) {
                        this.log(4, "Waiting for LLRP Capabilities.");
                    }
                    this.readerCapabilitiesReadyMonitor.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.getReaderCapabilitiesTask;
    }

    public long getLLRPCommandTimeout() {
        return this.lLRPCommandTimeout;
    }

    public int getMessageCapacity() {
        return 2;
    }

    public IIdManager getROSpecIdManager() {
        return this.roSpecIdManager;
    }

    public ITaskManager getTaskManager() {
        return this.taskManager;
    }

    private void handleEpcglobalLlrpDeviceServiceAddAccessspecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceAddRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceDeleteAccessspecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceDeleteRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceDisableAccessspecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceDisableRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceEnableAccessspecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceEnableRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceGetAccessspecsResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceGetRospecsResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceRoAccessReport(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceStartRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceStopRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    public Object handleMethodReaderCapabilities(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                measurement.setValue(data, EpcglobalLlrpAdapter.getCurrentTimestamp());
            }
        }
        return null;
    }

    public void handleSignal(SignalService source, Object timestamp, Object data) {
        boolean isResponseExpected = this.getTaskManager().isResponseExpected(source, timestamp, data);
        if (isResponseExpected) {
            this.getTaskManager().handleResponse(source, timestamp, data);
        }
    }

    private void initialize() {
        MethodMeasurement readerCapabilities = this.readerCapabilities;
        this.put((ControlService)readerCapabilities);
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    private void requestReaderCapabilities() {
        this.getReaderCapabilitiesTask = new Task_GET_READER_CAPABILITIES(this.epcglobalLlrpDeviceServiceGetReaderCapabilities, null, this.epcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse, this.getLLRPCommandTimeout());
        this.getReaderCapabilitiesTask.addTaskListener(this.taskListner);
        this.getTaskManager().addTask((ITask)this.getReaderCapabilitiesTask);
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.epcglobalLlrpDeviceServiceGetReaderCapabilities != null) {
                this.epcglobalLlrpDeviceServiceGetReaderCapabilities.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse != null) {
                this.epcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetRospecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStartRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStopRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceRoAccessReport != null) {
                this.epcglobalLlrpDeviceServiceRoAccessReport.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
        }
        if (device != null) {
            this.epcglobalLlrpDeviceServiceGetReaderCapabilities = device.getCommand("GetReaderCapabilities");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetReaderCapabilities);
            this.epcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse = device.getSignal("GetReaderCapabilitiesResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse);
            this.epcglobalLlrpDeviceServiceGetRospecsResponse = device.getSignal("GetRospecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetRospecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteRospecResponse = device.getSignal("DeleteRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteRospecResponse);
            this.epcglobalLlrpDeviceServiceAddRospecResponse = device.getSignal("AddRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddRospecResponse);
            this.epcglobalLlrpDeviceServiceEnableRospecResponse = device.getSignal("EnableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableRospecResponse);
            this.epcglobalLlrpDeviceServiceDisableRospecResponse = device.getSignal("DisableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableRospecResponse);
            this.epcglobalLlrpDeviceServiceStartRospecResponse = device.getSignal("StartRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStartRospecResponse);
            this.epcglobalLlrpDeviceServiceStopRospecResponse = device.getSignal("StopRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStopRospecResponse);
            this.epcglobalLlrpDeviceServiceRoAccessReport = device.getSignal("RoAccessReport");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceRoAccessReport);
            this.epcglobalLlrpDeviceServiceGetAccessspecsResponse = device.getSignal("GetAccessspecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetAccessspecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse = device.getSignal("DeleteAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse);
            this.epcglobalLlrpDeviceServiceAddAccessspecResponse = device.getSignal("AddAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddAccessspecResponse);
            this.epcglobalLlrpDeviceServiceEnableAccessspecResponse = device.getSignal("EnableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableAccessspecResponse);
            this.epcglobalLlrpDeviceServiceDisableAccessspecResponse = device.getSignal("DisableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableAccessspecResponse);
        }
        super.setDevice(device);
    }

    public void setLLRPCommandTimeout(long LLRPCommandTimeout) {
        this.lLRPCommandTimeout = LLRPCommandTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReaderCapabilities() {
        if (this.isLogging(4)) {
            this.log(4, this.getReaderCapabilitiesTask.printAllCapabilities());
        }
        this.readerCapabilities.setValue((Object)this.getReaderCapabilitiesTask.getCapabilities(), EpcglobalLlrpAdapter.getCurrentTimestamp());
        Byte by = this.readerCapabilitiesReadyMonitor;
        synchronized (by) {
            this.readerCapabilitiesReadyMonitor.notifyAll();
            this.isReaderCapabilitiesReady = true;
        }
        int maxROSpecNum = this.getReaderCapabilitiesTask.getMaxNumROSpecs();
        this.roSpecIdManager.setMaxIdNum(maxROSpecNum);
        int maxAccessSpecNum = this.getReaderCapabilitiesTask.getMaxNumAccessSpecs();
        this.accessSpecIdManager.setMaxIdNum(maxAccessSpecNum);
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("epcgloballlrpadapter.notificationpriority", this.getNotificationPriority()));
        this.setLLRPCommandTimeout(this.getLong("epcgloballlrpadapter.llrpcommandtimeout", this.getLLRPCommandTimeout()));
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.epcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceGetReaderCapabilitiesResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceGetRospecsResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceGetRospecsResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceDeleteRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceDeleteRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceAddRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceAddRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceEnableRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceEnableRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceDisableRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceDisableRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceStartRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceStartRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceStopRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceStopRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceRoAccessReport == source) {
            this.handleEpcglobalLlrpDeviceServiceRoAccessReport(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceGetAccessspecsResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceGetAccessspecsResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceDeleteAccessspecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceAddAccessspecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceAddAccessspecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceEnableAccessspecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceEnableAccessspecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceDisableAccessspecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceDisableAccessspecResponse(source, timestamp, data);
            return;
        }
        super.signalOccurred(source, timestamp, data);
    }
}

