/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.servlet.operations.AbstractOperation;

public class History
extends AbstractOperation {
    private static final String SELECTED = "SELECTED";
    private static final int MAX_SIZE = 8;
    private List historyOperations = new ArrayList();
    private int selected = 0;

    public History() {
        super("History");
    }

    private void addOperations(String currOperations) {
        if (this.historyOperations.contains(currOperations)) {
            return;
        }
        this.historyOperations.add(currOperations);
    }

    private int getDisplaySize() {
        return this.historyOperations.size() > 8 ? 8 : this.historyOperations.size();
    }

    public String htmlOutput(String servletPath) {
        StringBuffer result = new StringBuffer();
        if (this.historyOperations.size() == 0) {
            return "History record is empty.";
        }
        result.append(this.getFormHeader(servletPath));
        result.append("<table border=\"0\">\n");
        result.append("<tr>\n");
        result.append("<td align=\"left\">\n");
        result.append("<h2>History</h2>\n");
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("<td align=\"left\">\n");
        result.append("<select size=\"" + this.getDisplaySize() + "\" name=\"" + SELECTED + "\">\n");
        int i = 0;
        while (i < this.historyOperations.size()) {
            String operation = (String)this.historyOperations.get(i);
            result.append("<option value=\"" + i + "\"" + (this.selected == i ? " selected=\"selected\"" : "") + ">" + operation + "</option>\n");
            ++i;
        }
        result.append("</select>\n");
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("<tr>\n");
        result.append("<td>\n");
        result.append(this.getFormTail());
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("</table>\n");
        return result.toString();
    }

    public String opOutput() {
        return this.historyOperations.size() > 0 ? (String)this.historyOperations.get(this.selected) : "";
    }

    public void setValues(HttpServletRequest request) {
        String actionId = request.getParameter("Action");
        if (actionId != null && Integer.valueOf(actionId) == 2) {
            String opName = request.getParameter("OPName");
            if (opName != null && opName.equals(this.getName())) {
                this.selected = Integer.valueOf(request.getParameter(SELECTED));
            }
        } else if (actionId != null && Integer.valueOf(actionId) == 3) {
            String currOperations = request.getParameter("CurrOperations");
            this.addOperations(currOperations);
        }
    }
}

