/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.epcglobal.llrp.write.profile;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.epcglobal.llrp.adapter.EpcglobalLlrpAdapter;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPConfigParser;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPDefaultParameters;
import org.eclipse.soda.dk.epcglobal.llrp.helper.LLRPUtils;
import org.eclipse.soda.dk.epcglobal.llrp.helper.ParameterFactory;
import org.eclipse.soda.dk.epcglobal.llrp.helper.idmanager.IIdManager;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_BLOCKERASE_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_BLOCKWRITE_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_INCREMENT_WRITE;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_KILL_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_LOCK_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_READ_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.task.Task_WRITE_TAG;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITask;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskListener;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.ITaskManager;
import org.eclipse.soda.dk.epcglobal.llrp.helper.taskmanager.TaskManager;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.LlrpWriteProfileTaskPool;
import org.eclipse.soda.dk.epcglobal.llrp.write.profile.service.EpcglobalLlrpWriteProfileService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.write.profile.RfidWriteProfile;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;

public class EpcglobalLlrpWriteProfile
extends RfidWriteProfile
implements ProfileService,
EpcglobalLlrpWriteProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.epcglobal.llrp.write.profile.EpcglobalLlrpWriteProfile";
    private final MethodMeasurement lLRPConfiguration = new MethodMeasurement("LLRPWriteProfile/LLRPConfiguration", (Object)"");
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory;
    protected CommandService epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration;
    protected CommandService epcglobalLlrpDeviceServiceGetRospecs;
    protected CommandService epcglobalLlrpDeviceServiceDeleteRospec;
    protected CommandService epcglobalLlrpDeviceServiceAddRospec;
    protected CommandService epcglobalLlrpDeviceServiceEnableRospec;
    protected CommandService epcglobalLlrpDeviceServiceDisableRospec;
    protected CommandService epcglobalLlrpDeviceServiceStartRospec;
    protected CommandService epcglobalLlrpDeviceServiceStopRospec;
    protected CommandService epcglobalLlrpDeviceServiceGetAccessspecs;
    protected CommandService epcglobalLlrpDeviceServiceDeleteAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceAddAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceEnableAccessspec;
    protected CommandService epcglobalLlrpDeviceServiceDisableAccessspec;
    protected SignalService epcglobalLlrpDeviceServiceSetReaderConfigResponse;
    protected SignalService epcglobalLlrpDeviceServiceGetRospecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStartRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceStopRospecResponse;
    protected SignalService epcglobalLlrpDeviceServiceRoAccessReport;
    protected SignalService epcglobalLlrpDeviceServiceGetAccessspecsResponse;
    protected SignalService epcglobalLlrpDeviceServiceDeleteAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceAddAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceEnableAccessspecResponse;
    protected SignalService epcglobalLlrpDeviceServiceDisableAccessspecResponse;
    private AdapterService adapter;
    private int rOSpecID = 1;
    private int accessSpecID = 1;
    protected static final String TASKARRAY_START_ROSPEC = "TaskArray_Start_ROSPEC";
    protected static final String TASKARRAY_END_ROSPEC = "TaskArray_End_ROSPEC";
    protected static final long DEFAULT_TASK_TIMEOUT = 5000L;
    private short accessOpId = 0;
    private final Byte accessOpIdLock = new Byte(0);
    private TaskManager taskManager = new TaskManager("org.eclipse.soda.dk.epcglobal.llrp.write.profile.EpcglobalLlrpWriteProfile.TaskManager");
    private Map targetTagFilterParameters;
    private List rOSpecParameters;
    private Byte operationsRunningMonitor = new Byte(0);
    private boolean llrpConfigurationChanged;
    private ITaskListener taskListener = new ITaskListener(){

        private String getErrorMsg(String taskName, Object result) {
            return result == null ? "Task Error: " + taskName : (result instanceof Map ? LLRPUtils.handleErrorResponse((String)taskName, (Map)((Map)result)) : result.toString());
        }

        public void taskNotice(String taskName, int status, Object result) {
            int rOSpecId;
            if (taskName.equals(EpcglobalLlrpWriteProfile.TASKARRAY_START_ROSPEC)) {
                switch (status) {
                    case 0: 
                    case 2: {
                        EpcglobalLlrpWriteProfile.this.startOperationsFailed(this.getErrorMsg(taskName, result));
                        return;
                    }
                    case 1: {
                        rOSpecId = ((Number)((Map)result).get("ROSpecID")).intValue();
                        EpcglobalLlrpWriteProfile.this.rOSpecStarted(rOSpecId);
                    }
                }
            }
            if (taskName.equals(EpcglobalLlrpWriteProfile.TASKARRAY_END_ROSPEC)) {
                rOSpecId = ((Number)((Map)result).get("ROSpecID")).intValue();
                EpcglobalLlrpWriteProfile.this.rOSpecEnded(rOSpecId);
                switch (status) {
                    case 0: 
                    case 2: {
                        EpcglobalLlrpWriteProfile.this.stopOperationsFailed(this.getErrorMsg(taskName, result));
                        return;
                    }
                    case 1: {
                        EpcglobalLlrpWriteProfile.this.stopOperationsSucceeded();
                        return;
                    }
                }
            }
            if (taskName.equals("Task_Read_Tag") || taskName.equals("Task_Write_Tag") || taskName.equals("Task_INCREMENT_WRITE") || taskName.equals("Task_Kill_Tag") || taskName.equals("Task_Lock_Tag") || taskName.equals("Task_BlockErase_Tag") || taskName.equals("Task_BlockWrite_Tag")) {
                int accessSpecId = ((Number)((Map)result).get("AccessSpecID")).intValue();
                switch (status) {
                    case 0: {
                        if (EpcglobalLlrpWriteProfile.this.isLogging(4)) {
                            EpcglobalLlrpWriteProfile.this.log(4, this.getErrorMsg(taskName, result));
                        }
                        EpcglobalLlrpWriteProfile.this.accessSpecFinished(accessSpecId);
                        return;
                    }
                    case 2: {
                        if (EpcglobalLlrpWriteProfile.this.isLogging(4)) {
                            EpcglobalLlrpWriteProfile.this.log(4, String.valueOf(taskName) + " timeout.");
                        }
                        EpcglobalLlrpWriteProfile.this.accessSpecFinished(accessSpecId);
                        return;
                    }
                    case 1: {
                        if (EpcglobalLlrpWriteProfile.this.isLogging(4)) {
                            EpcglobalLlrpWriteProfile.this.log(4, String.valueOf(taskName) + " finished.");
                        }
                        EpcglobalLlrpWriteProfile.this.accessSpecFinished(accessSpecId);
                        return;
                    }
                    case 3: {
                        if (EpcglobalLlrpWriteProfile.this.isLogging(4)) {
                            EpcglobalLlrpWriteProfile.this.log(4, String.valueOf(taskName) + " reports.");
                        }
                        if (result != null && result instanceof Map) {
                            EpcglobalLlrpWriteProfile.this.sendTagReport((Map)result, true);
                        }
                        return;
                    }
                }
            }
        }
    };
    private LlrpWriteProfileTaskPool taskPool = new LlrpWriteProfileTaskPool(this);

    public EpcglobalLlrpWriteProfile() {
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    protected void accessSpecFinished(int accessSpecId) {
        if (this.isLogging(4)) {
            this.log(4, "AccessSpec " + accessSpecId + " finished.");
        }
        this.getAccessSpecIdManager().setIdStatus(accessSpecId, this.getOwner(), 12);
    }

    public void activate() {
        this.taskManager.addTaskListener(this.taskListener);
        this.taskManager.reset();
        this.setLlrpConfigurationChanged(true);
        super.activate();
    }

    protected void disableROSpecs() {
        List currentROSpecIds = this.getROSpecIdManager().getIds(this.getOwner());
        int i = 0;
        while (i < currentROSpecIds.size()) {
            Map rOSpecIdParameter = (Map)currentROSpecIds.get(i);
            int status = this.getROSpecIdManager().getIdStatus((Object)rOSpecIdParameter, this.getOwner());
            if (status != -13) {
                ITask disableROSpecTask = this.taskPool.getEndROSpecTaskArray(i, rOSpecIdParameter, true);
                disableROSpecTask.start((ITaskManager)this.taskManager);
                if (this.isLogging(4)) {
                    this.log(4, "Disabling ROSpec " + rOSpecIdParameter.get("ROSpecID"));
                }
            }
            ++i;
        }
    }

    protected synchronized void endOperations() {
        if (this.isLogging(4)) {
            this.log(4, "LLRP Write Profile end operations, running state: " + this.isOperationsRunning());
        }
        if (this.isOperationsRunning()) {
            this.disableROSpecs();
        }
    }

    protected boolean executeBlockErase(String[] op_parameters) {
        int accessSpecId;
        block5: {
            if (op_parameters.length != 7 && op_parameters.length != 8) {
                this.handleWriteOperationsError("Invalid parameters number for the BlockErase command: " + op_parameters.length + ",Format: " + "BlockErase;MemoryBank;WordPointer;WordCount;Password;OpCount;Timeout[;OperationId]");
                return false;
            }
            if (this.getTargetTagFilterParameters() == null) {
                this.handleWriteOperationsError("Target Tag Filter can't be NULL for BlockErase");
                return false;
            }
            try {
                accessSpecId = this.getAccessSpecIdManager().registerNextId(this.getOwner());
                if (accessSpecId != -2) break block5;
                this.handleWriteOperationsError("Fail to start AccessSpec, Maximum number of supported AccessSpec has been reached.");
                return false;
            }
            catch (NumberFormatException e) {
                this.handleWriteOperationsError(e.toString());
                return false;
            }
        }
        int memoryBank = Integer.valueOf(op_parameters[1]);
        int wordPointer = Integer.valueOf(op_parameters[2]);
        int wordCount = Integer.valueOf(op_parameters[3]);
        int password = Integer.valueOf(op_parameters[4]);
        int opCount = Integer.valueOf(op_parameters[5]);
        long timeout = Long.valueOf(op_parameters[6], 10);
        short opId = this.getCurrAccessOpId();
        String operationId = op_parameters.length == 8 ? op_parameters[7] : String.valueOf(opId);
        Map blockEraseOpParameters = ParameterFactory.getC1G2BlockEraseParameter((int)opId, (int)password, (int)memoryBank, (int)wordPointer, (int)wordCount);
        Task_BLOCKERASE_TAG blockEraseTagTask = new Task_BLOCKERASE_TAG((int)opId, opCount, this.taskPool.getTask_DELETE_EXIST_ACCESSSPEC(accessSpecId), this.taskPool.getAddAccessSpecTask(accessSpecId, this.getTargetTagFilterParameters(), blockEraseOpParameters, 0), this.taskPool.getEnableAccessSpecTask(accessSpecId), this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
        blockEraseTagTask.start((ITaskManager)this.taskManager);
        return true;
    }

    protected boolean executeBlockWrite(String[] op_parameters) {
        int accessSpecId;
        block5: {
            if (op_parameters.length != 7 && op_parameters.length != 8) {
                this.handleWriteOperationsError("Invalid parameters number for the BlockWrite command: " + op_parameters.length + ",Format: " + "BlockWrite;MemoryBank;WordPointer;WriteData;Password;OpCount;Timeout[;OperationId]");
                return false;
            }
            if (this.getTargetTagFilterParameters() == null) {
                this.handleWriteOperationsError("Target Tag Filter can't be NULL for BlockWrite");
                return false;
            }
            try {
                accessSpecId = this.getAccessSpecIdManager().registerNextId(this.getOwner());
                if (accessSpecId != -2) break block5;
                this.handleWriteOperationsError("Fail to start AccessSpec, Maximum number of supported AccessSpec has been reached.");
                return false;
            }
            catch (NumberFormatException e) {
                this.handleWriteOperationsError(e.toString());
                return false;
            }
        }
        int memoryBank = Integer.valueOf(op_parameters[1]);
        int wordPointer = Integer.valueOf(op_parameters[2]);
        String writeData = op_parameters[3];
        int password = Integer.valueOf(op_parameters[4]);
        int opCount = Integer.valueOf(op_parameters[5]);
        long timeout = Long.valueOf(op_parameters[6], 10);
        short opId = this.getCurrAccessOpId();
        String operationId = op_parameters.length == 8 ? op_parameters[7] : String.valueOf(opId);
        Map writeOpParameters = ParameterFactory.getC1G2BlockWriteParameter((int)opId, (int)password, (int)memoryBank, (int)wordPointer, (String)writeData);
        Task_BLOCKWRITE_TAG writeTagTask = new Task_BLOCKWRITE_TAG((int)opId, this.taskPool.getTask_DELETE_EXIST_ACCESSSPEC(accessSpecId), this.taskPool.getAddAccessSpecTask(accessSpecId, this.getTargetTagFilterParameters(), writeOpParameters, opCount), this.taskPool.getEnableAccessSpecTask(accessSpecId), this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
        writeTagTask.start((ITaskManager)this.taskManager);
        return true;
    }

    protected boolean executeCleanFilter(String[] op_parameters) {
        this.setTargetTagFilterParameters(null);
        return true;
    }

    protected boolean executeFilter(String[] op_parameters) {
        if (op_parameters.length != 6 && op_parameters.length != 11) {
            this.handleWriteOperationsError("Invalid parameters number for the Set Filter command: " + op_parameters.length + ",Format: " + "Filter;MemoryBank;Match;BitPointer;TagMask;TagData[;MemoryBank;Match;BitPointer;TagMask;TagData]");
            return false;
        }
        try {
            int targetTag1_memoryBank = Integer.valueOf(op_parameters[1]);
            boolean targetTag1_match = Boolean.valueOf(op_parameters[2]);
            int targetTag1_pointer = Integer.valueOf(op_parameters[3]);
            String targetTag1_tagMask = op_parameters[4];
            String targetTag1_tagData = op_parameters[5];
            Map c1G2TargetTag1parameters = ParameterFactory.getC1G2TargetTagParameter((int)targetTag1_memoryBank, (boolean)targetTag1_match, (int)targetTag1_pointer, (String)targetTag1_tagMask, (String)targetTag1_tagData);
            switch (op_parameters.length) {
                case 11: {
                    int targetTag2_memoryBank = Integer.valueOf(op_parameters[6]);
                    boolean targetTag2_match = Boolean.valueOf(op_parameters[7]);
                    int targetTag2_pointer = Integer.valueOf(op_parameters[8]);
                    String targetTag2_tagMask = op_parameters[9];
                    String targetTag2_tagData = op_parameters[10];
                    Map c1G2TargetTag2parameters = ParameterFactory.getC1G2TargetTagParameter((int)targetTag2_memoryBank, (boolean)targetTag2_match, (int)targetTag2_pointer, (String)targetTag2_tagMask, (String)targetTag2_tagData);
                    this.setTargetTagFilterParameters(ParameterFactory.getC1G2TagSpecParameter((Map)c1G2TargetTag1parameters, (Map)c1G2TargetTag2parameters));
                    break;
                }
                case 6: {
                    this.setTargetTagFilterParameters(ParameterFactory.getC1G2TagSpecParameter((Map)c1G2TargetTag1parameters));
                }
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.handleWriteOperationsError(e.toString());
            return false;
        }
    }

    protected boolean executeIncrementWrite(String[] op_parameters) {
        int accessSpecId;
        block5: {
            if (op_parameters.length != 8 && op_parameters.length != 9) {
                this.handleWriteOperationsError("Invalid parameters number for the Increment Write command: " + op_parameters.length + ",Format: " + "Increment Write;MemoryBank;WordPointer;WriteData;Increment;Password;Repeat;Timeout[;OperationId]");
                return false;
            }
            if (this.getTargetTagFilterParameters() == null) {
                this.handleWriteOperationsError("Target Tag Filter can't be NULL for Increment Write");
                return false;
            }
            try {
                accessSpecId = this.getAccessSpecIdManager().registerNextId(this.getOwner());
                if (accessSpecId != -2) break block5;
                this.handleWriteOperationsError("Fail to start AccessSpec, Maximum number of supported AccessSpec has been reached.");
                return false;
            }
            catch (NumberFormatException e) {
                this.handleWriteOperationsError(e.toString());
                return false;
            }
        }
        int memoryBank = Integer.valueOf(op_parameters[1]);
        String baseWriteData = op_parameters[3];
        int wordPointer = Integer.valueOf(op_parameters[2]);
        int increment = Integer.valueOf(op_parameters[4]);
        int repeat = Integer.valueOf(op_parameters[6]);
        long timeout = Long.valueOf(op_parameters[7], 10);
        int password = Integer.valueOf(op_parameters[5]);
        short writeOpId = this.getCurrAccessOpId();
        String operationId = op_parameters.length == 9 ? op_parameters[8] : String.valueOf(writeOpId);
        Map incrementWriteOpParameters = ParameterFactory.getAccessCommandParameter((Map)this.getTargetTagFilterParameters(), new ArrayList());
        Task_INCREMENT_WRITE incrementWriteTask = new Task_INCREMENT_WRITE((int)writeOpId, memoryBank, wordPointer, password, baseWriteData, increment, repeat, timeout, this.taskPool.getTask_DELETE_EXIST_ACCESSSPEC(accessSpecId), this.taskPool.getAddAccessSpecTask(accessSpecId, this.getTargetTagFilterParameters(), incrementWriteOpParameters, 1), this.taskPool.getEnableAccessSpecTask(accessSpecId), this.epcglobalLlrpDeviceServiceRoAccessReport, operationId);
        incrementWriteTask.start((ITaskManager)this.taskManager);
        return true;
    }

    protected boolean executeKill(String[] op_parameters) {
        int accessSpecId;
        block4: {
            if (op_parameters.length != 4 && op_parameters.length != 5) {
                this.handleWriteOperationsError("Invalid parameters number for the Kill command: " + op_parameters.length + ",Format: " + "Kill;Password;OpCount;Timeout[;OperationId]");
                return false;
            }
            try {
                accessSpecId = this.getAccessSpecIdManager().registerNextId(this.getOwner());
                if (accessSpecId != -2) break block4;
                this.handleWriteOperationsError("Fail to start AccessSpec, Maximum number of supported AccessSpec has been reached.");
                return false;
            }
            catch (NumberFormatException e) {
                this.handleWriteOperationsError(e.toString());
                return false;
            }
        }
        int password = Integer.valueOf(op_parameters[1]);
        int opCount = Integer.valueOf(op_parameters[2]);
        long timeout = Long.valueOf(op_parameters[3], 10);
        short opId = this.getCurrAccessOpId();
        String operationId = op_parameters.length == 5 ? op_parameters[4] : String.valueOf(opId);
        Map killOpParameters = ParameterFactory.getC1G2KillParameter((int)opId, (int)password);
        Task_KILL_TAG killTagTask = new Task_KILL_TAG((int)opId, this.taskPool.getTask_DELETE_EXIST_ACCESSSPEC(accessSpecId), this.taskPool.getAddAccessSpecTask(accessSpecId, this.getTargetTagFilterParameters(), killOpParameters, opCount), this.taskPool.getEnableAccessSpecTask(accessSpecId), this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
        killTagTask.start((ITaskManager)this.taskManager);
        return true;
    }

    protected boolean executeLock(String[] op_parameters) {
        int accessSpecId;
        block6: {
            if (op_parameters.length < 6) {
                this.handleWriteOperationsError("Invalid parameters number for the Lock command: " + op_parameters.length + ",Format: " + "Lock;Password;OpCount;Timeout;Privilege;DataField[;Privilege;DataField...][;OperationId]");
                return false;
            }
            accessSpecId = this.getAccessSpecIdManager().registerNextId(this.getOwner());
            if (accessSpecId != -2) break block6;
            this.handleWriteOperationsError("Fail to start AccessSpec, Maximum number of supported AccessSpec has been reached.");
            return false;
        }
        try {
            int password = Integer.valueOf(op_parameters[1]);
            int opCount = Integer.valueOf(op_parameters[2]);
            long timeout = Long.valueOf(op_parameters[3], 10);
            short opId = this.getCurrAccessOpId();
            String operationId = String.valueOf(opId);
            int privilege = Integer.valueOf(op_parameters[4]);
            int datafield = Integer.valueOf(op_parameters[5]);
            ArrayList<Map> payloadParameter = new ArrayList<Map>();
            payloadParameter.add(ParameterFactory.getC1G2LockPayloadParameter((int)privilege, (int)datafield));
            int current_index = 6;
            while (op_parameters.length - current_index > 0) {
                if (op_parameters.length - current_index >= 2) {
                    privilege = Integer.valueOf(op_parameters[current_index++]);
                    datafield = Integer.valueOf(op_parameters[current_index++]);
                    payloadParameter.add(ParameterFactory.getC1G2LockPayloadParameter((int)privilege, (int)datafield));
                    continue;
                }
                operationId = op_parameters[current_index++];
            }
            Map lockOpParameters = ParameterFactory.getC1G2LockParameter((int)opId, (int)password, payloadParameter);
            Task_LOCK_TAG lockTagTask = new Task_LOCK_TAG((int)opId, this.taskPool.getTask_DELETE_EXIST_ACCESSSPEC(accessSpecId), this.taskPool.getAddAccessSpecTask(accessSpecId, this.getTargetTagFilterParameters(), lockOpParameters, opCount), this.taskPool.getEnableAccessSpecTask(accessSpecId), this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
            lockTagTask.start((ITaskManager)this.taskManager);
            return true;
        }
        catch (NumberFormatException e) {
            this.handleWriteOperationsError(e.toString());
            return false;
        }
    }

    protected boolean executeRead(String[] op_parameters) {
        if (op_parameters.length != 7 && op_parameters.length != 8) {
            this.handleWriteOperationsError("Invalid parameters number for the Read command: " + op_parameters.length + ",Format: " + "Read;MemoryBank;WordPointer;WordCount;Password;OpCount;Timeout[;OperationId]");
            return false;
        }
        int accessSpecId = this.getAccessSpecIdManager().registerNextId(this.getOwner());
        if (accessSpecId == -2) {
            this.handleWriteOperationsError("Fail to start AccessSpec, Maximum number of supported AccessSpec has been reached.");
            return false;
        }
        try {
            int memoryBank = Integer.valueOf(op_parameters[1]);
            int wordPointer = Integer.valueOf(op_parameters[2]);
            int wordCount = Integer.valueOf(op_parameters[3]);
            int password = Integer.valueOf(op_parameters[4]);
            int opCount = Integer.valueOf(op_parameters[5]);
            long timeout = Long.valueOf(op_parameters[6], 10);
            short opId = this.getCurrAccessOpId();
            String operationId = op_parameters.length == 8 ? op_parameters[7] : String.valueOf(opId);
            Map readOpParameters = ParameterFactory.getC1G2ReadParameter((int)opId, (int)password, (int)memoryBank, (int)wordPointer, (int)wordCount);
            Task_READ_TAG readTagTask = new Task_READ_TAG((int)opId, opCount, this.taskPool.getTask_DELETE_EXIST_ACCESSSPEC(accessSpecId), this.taskPool.getAddAccessSpecTask(accessSpecId, this.getTargetTagFilterParameters() != null ? this.getTargetTagFilterParameters() : LLRPDefaultParameters.getDefaultC1G2TagSpecParameter(), readOpParameters, 0), this.taskPool.getEnableAccessSpecTask(accessSpecId), this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
            readTagTask.start((ITaskManager)this.taskManager);
            return true;
        }
        catch (NumberFormatException e) {
            this.handleWriteOperationsError(e.toString());
            return false;
        }
    }

    protected void executeStop() {
        if (this.isLogging(4)) {
            this.log(4, "Stop all the WriteOperations.");
        }
        this.resetTaskManager();
        this.endOperations();
    }

    protected boolean executeWrite(String[] op_parameters) {
        int accessSpecId;
        block5: {
            if (op_parameters.length != 7 && op_parameters.length != 8) {
                this.handleWriteOperationsError("Invalid parameters number for the Write command: " + op_parameters.length + ",Format: " + "Write;MemoryBank;WordPointer;WriteData;Password;OpCount;Timeout[;OperationId]");
                return false;
            }
            if (this.getTargetTagFilterParameters() == null) {
                this.handleWriteOperationsError("Target Tag Filter can't be NULL for Write");
                return false;
            }
            try {
                accessSpecId = this.getAccessSpecIdManager().registerNextId(this.getOwner());
                if (accessSpecId != -2) break block5;
                this.handleWriteOperationsError("Fail to start AccessSpec, Maximum number of supported AccessSpec has been reached.");
                return false;
            }
            catch (NumberFormatException e) {
                this.handleWriteOperationsError(e.toString());
                return false;
            }
        }
        int memoryBank = Integer.valueOf(op_parameters[1]);
        int wordPointer = Integer.valueOf(op_parameters[2]);
        String writeData = op_parameters[3];
        int password = Integer.valueOf(op_parameters[4]);
        int opCount = Integer.valueOf(op_parameters[5]);
        long timeout = Long.valueOf(op_parameters[6], 10);
        short opId = this.getCurrAccessOpId();
        String operationId = op_parameters.length == 8 ? op_parameters[7] : String.valueOf(opId);
        Map writeOpParameters = ParameterFactory.getC1G2WriteParameter((int)opId, (int)password, (int)memoryBank, (int)wordPointer, (String)writeData);
        Task_WRITE_TAG writeTagTask = new Task_WRITE_TAG((int)opId, this.taskPool.getTask_DELETE_EXIST_ACCESSSPEC(accessSpecId), this.taskPool.getAddAccessSpecTask(accessSpecId, this.getTargetTagFilterParameters(), writeOpParameters, opCount), this.taskPool.getEnableAccessSpecTask(accessSpecId), this.epcglobalLlrpDeviceServiceRoAccessReport, timeout, operationId);
        writeTagTask.start((ITaskManager)this.taskManager);
        return true;
    }

    public int getAccessSpecID() {
        return this.accessSpecID;
    }

    protected IIdManager getAccessSpecIdManager() {
        return ((EpcglobalLlrpAdapter)this.getAdapter()).getAccessSpecIdManager();
    }

    public AdapterService getAdapter() {
        return this.adapter;
    }

    protected ITaskManager getAdapterTaskManager() {
        return ((EpcglobalLlrpAdapter)this.getAdapter()).getTaskManager();
    }

    protected int getAirProtocol() {
        return 1;
    }

    public int getControlCapacity() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getCurrAccessOpId() {
        Byte by = this.accessOpIdLock;
        synchronized (by) {
            this.accessOpId = this.accessOpId < Short.MAX_VALUE ? (short)(this.accessOpId + 1) : (short)0;
            return this.accessOpId;
        }
    }

    public DeviceService getDefaultDevice() {
        return (DeviceService)EpcglobalLlrpWriteProfile.loadService((String)DeviceService.SERVICE_NAME, (String)"org.eclipse.soda.dk.epcglobal.llrp.device.EpcglobalLlrpDevice");
    }

    public String getDefaultKey() {
        return "EpcglobalLlrpWriteProfile";
    }

    protected Object getLLRPConfigurationValue() {
        String value = (String)this.lLRPConfiguration.getValueRaw();
        if (value != null && value.trim().length() > 0) {
            return value;
        }
        Hashtable<String, List> lLRPConfigMap = new Hashtable<String, List>();
        lLRPConfigMap.put("ROSpecParameter", this.getROSpecParameters());
        String configStr = Nls.formatData(lLRPConfigMap);
        this.lLRPConfiguration.setValue((Object)configStr, EpcglobalLlrpWriteProfile.getCurrentTimestamp());
        return configStr;
    }

    public int getMessageCapacity() {
        return 2;
    }

    protected int getOpAntennaId() {
        MeasurementService antennaConfiguration = this.getAntennaConfiguration();
        Map antennaConfigs = (Map)antennaConfiguration.getValue();
        int antennaId_enabled = 0;
        if (antennaConfigs != null) {
            Iterator ids = antennaConfigs.entrySet().iterator();
            while (ids.hasNext()) {
                Boolean enabled;
                Map.Entry entry = ids.next();
                Number antennaId = (Number)entry.getKey();
                Map antennaConfig = (Map)entry.getValue();
                if (antennaConfig == null || (enabled = (Boolean)antennaConfig.get("ANTENNA_ENABLED")) == null || !enabled.booleanValue() || antennaId_enabled != 0) continue;
                antennaId_enabled = antennaId.intValue();
            }
        }
        return antennaId_enabled;
    }

    protected Object getOwner() {
        return this;
    }

    private Map getReportReadData(Number tagSeenCount, Number antennaId, Object timestamp, Number resultCode) {
        Hashtable<String, Object> readData = new Hashtable<String, Object>();
        if (antennaId != null) {
            readData.put("antenna", antennaId);
        }
        readData.put("reader", this.getId());
        readData.put("timestampFirst", timestamp);
        readData.put("timestampLast", timestamp);
        readData.put("count", tagSeenCount != null ? (Number)tagSeenCount : (Number)EpcglobalLlrpWriteProfile.createInteger((int)0));
        readData.put("resultCode", resultCode);
        return readData;
    }

    public int getROSpecID() {
        return this.rOSpecID;
    }

    protected IIdManager getROSpecIdManager() {
        return ((EpcglobalLlrpAdapter)this.getAdapter()).getROSpecIdManager();
    }

    protected List getROSpecParameters() {
        if (this.rOSpecParameters == null) {
            this.rOSpecParameters = new ArrayList();
            this.rOSpecParameters.add(LLRPDefaultParameters.getDefaultROSpecParameter((int)this.getROSpecID()));
        }
        return this.rOSpecParameters;
    }

    public Map getTargetTagFilterParameters() {
        return this.targetTagFilterParameters;
    }

    protected ITaskListener getTaskListener() {
        return this.taskListener;
    }

    private void handleEpcglobalLlrpDeviceServiceAddAccessspecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceAddRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceDeleteAccessspecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceDeleteRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceDisableAccessspecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceDisableRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceEnableAccessspecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceEnableRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceGetAccessspecsResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceGetRospecsResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceRoAccessReport(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceSetReaderConfigResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceStartRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    private void handleEpcglobalLlrpDeviceServiceStopRospecResponse(SignalService source, Object timestamp, Object data) {
        this.handleSignal(source, timestamp, data);
    }

    public Object handleMethodLLRPConfiguration(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return this.getLLRPConfigurationValue();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetLLRPConfiguration(measurement, data);
            }
        }
        return null;
    }

    protected void handleSetLLRPConfiguration(Measurement measurement, Object data) {
        measurement.setValue(data, EpcglobalLlrpWriteProfile.getCurrentTimestamp());
        String configStr = (String)data;
        if (configStr != null && configStr.trim().length() > 1) {
            Map llrpConfig = (Map)LLRPConfigParser.parseConfig((String)configStr);
            Object roSpecObjs = llrpConfig.get("ROSpecParameter");
            if (roSpecObjs instanceof List) {
                List roSpecParameters = (List)roSpecObjs;
                if (roSpecParameters.size() > 0) {
                    this.getROSpecParameters().clear();
                    this.getROSpecParameters().addAll(roSpecParameters);
                }
            } else if (roSpecObjs instanceof Map) {
                this.getROSpecParameters().clear();
                this.getROSpecParameters().add(roSpecObjs);
            }
            this.setLlrpConfigurationChanged(true);
        }
    }

    private void handleSignal(SignalService source, Object timestamp, Object data) {
        if (this.taskManager.isResponseExpected(source, timestamp, data)) {
            if (this.isLogging(4)) {
                this.log(4, "Process signal " + source + " at " + CLASS_NAME);
            }
            this.taskManager.handleResponse(source, timestamp, data);
        }
    }

    private void initialize() {
        MethodMeasurement lLRPConfiguration = this.lLRPConfiguration;
        this.put((ControlService)lLRPConfiguration);
    }

    public boolean isAdapterNeeded() {
        return true;
    }

    public boolean isDeviceNeeded() {
        return true;
    }

    public boolean isLlrpConfigurationChanged() {
        return this.llrpConfigurationChanged;
    }

    protected boolean isOperationsRunning() {
        MeasurementService writeOperationsExecuteStatus = this.getWriteOperationsExecuteStatus();
        return (Boolean)writeOperationsExecuteStatus.getValue();
    }

    protected boolean registerROSpecIds() {
        List rOSpecs = this.getROSpecParameters();
        int i = 0;
        while (i < rOSpecs.size()) {
            Map rOSpecParam = (Map)rOSpecs.get(i);
            int rOSpecId = ((Number)rOSpecParam.get("ROSpecID")).intValue();
            Map rOSpecIdParameter = ParameterFactory.getROSpecIDParameter((int)rOSpecId);
            int idResult = this.getROSpecIdManager().registerId((Object)rOSpecIdParameter, this.getOwner());
            switch (idResult) {
                case 0: {
                    if (!this.isLogging(4)) break;
                    this.log(4, "ROSpecID " + rOSpecId + " is registered.");
                    break;
                }
                case -1: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpWriteProfile.getCurrentTimestamp(), (Object)("ROSpecID " + rOSpecId + " is being used by another ROSpec."));
                    if (this.isLogging(4)) {
                        this.log(4, "ROSpecID " + rOSpecId + " is being used by another ROSpec.");
                    }
                    return false;
                }
                case -3: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpWriteProfile.getCurrentTimestamp(), (Object)("ROSpecID " + rOSpecId + " is not valid."));
                    if (this.isLogging(4)) {
                        this.log(4, "ROSpecID " + rOSpecId + " is not valid.");
                    }
                    return false;
                }
                case -2: {
                    this.lLRPConfiguration.fireErrorOccurred(EpcglobalLlrpWriteProfile.getCurrentTimestamp(), (Object)("Fail to start ROSpecID " + rOSpecId + ", Maximum number of supported ROSpec has been reached."));
                    if (this.isLogging(4)) {
                        this.log(4, "Fail to start ROSpecID " + rOSpecId + ", Maximum number of supported ROSpec has been reached.");
                    }
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected void resetTaskManager() {
        this.getAdapterTaskManager().clearTasksByOwner(this.getOwner());
        this.taskManager.reset();
    }

    protected void rOSpecEnded(int rOSpecId) {
        if (this.isLogging(4)) {
            this.log(4, "ROSpec " + rOSpecId + " Ended.");
        }
        this.getROSpecIdManager().setIdStatus(rOSpecId, this.getOwner(), 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rOSpecStarted(int rOSpecId) {
        if (this.isLogging(4)) {
            this.log(4, "ROSpec " + rOSpecId + " started.");
        }
        this.getROSpecIdManager().setIdStatus(rOSpecId, this.getOwner(), 11);
        this.setOperationsStatusStarted();
        Byte by = this.operationsRunningMonitor;
        synchronized (by) {
            this.operationsRunningMonitor.notifyAll();
        }
    }

    protected void sendTagReport(Map tagReport, boolean isReadOperation) {
        Map resultParam;
        String key;
        List accessCommandOpSpecResultChoices;
        Map tagReportData = (Map)tagReport.get("TagReportData_Key");
        Object timestamp = tagReport.get("Timestamp_Key");
        Number resultCode = (Number)tagReport.get("ResultCode_Key");
        String operationId = (String)tagReport.get("OperationId_Key");
        String tag = LLRPUtils.extractTag((Map)((Map)tagReportData.get("EPCParameterChoice")));
        if (tag == null) {
            this.handleError(new NullPointerException("EPC is null"), 3008);
            return;
        }
        Number tagSeenCount = LLRPUtils.extractTagSeenCount((Map)((Map)tagReportData.get("TagSeenCountParameter")));
        Number antennaId = LLRPUtils.extractAntennaId((Map)((Map)tagReportData.get("AntennaIDParameter")));
        Map readData = this.getReportReadData(tagSeenCount, antennaId, timestamp, resultCode);
        if (isReadOperation && (accessCommandOpSpecResultChoices = (List)tagReportData.get("AccessCommandOpSpecResultChoice")) != null && accessCommandOpSpecResultChoices.size() >= 1 && "C1G2ReadOpSpecResultParameter".equals(key = (String)(resultParam = (Map)accessCommandOpSpecResultChoices.get(0)).get("key"))) {
            List readDatas = (List)resultParam.get("ReadDatas");
            byte[] readDataBytes = LLRPUtils.convertIntListToBytes((List)readDatas);
            readData.put("readData", readDataBytes);
        }
        if (this.isLogging(4)) {
            this.log(4, "Report on tag " + tag + ", result code: " + resultCode);
        }
        this.notifyTagReport(tag, operationId, readData);
    }

    public void setAccessSpecID(int AccessSpecID) {
        this.accessSpecID = AccessSpecID;
    }

    public void setAdapter(AdapterService adapter) {
        this.adapter = adapter;
    }

    public void setDevice(DeviceService device) {
        if (this.getDevice() != null) {
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecs != null) {
                this.epcglobalLlrpDeviceServiceGetRospecs.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospec != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospec != null) {
                this.epcglobalLlrpDeviceServiceAddRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospec != null) {
                this.epcglobalLlrpDeviceServiceEnableRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospec != null) {
                this.epcglobalLlrpDeviceServiceDisableRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospec != null) {
                this.epcglobalLlrpDeviceServiceStartRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospec != null) {
                this.epcglobalLlrpDeviceServiceStopRospec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecs != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecs.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspec != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspec != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspec != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspec != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspec.removeCommandListener((CommandListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceSetReaderConfigResponse != null) {
                this.epcglobalLlrpDeviceServiceSetReaderConfigResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetRospecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetRospecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStartRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStartRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceStopRospecResponse != null) {
                this.epcglobalLlrpDeviceServiceStopRospecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceRoAccessReport != null) {
                this.epcglobalLlrpDeviceServiceRoAccessReport.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceGetAccessspecsResponse != null) {
                this.epcglobalLlrpDeviceServiceGetAccessspecsResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceAddAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceAddAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceEnableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceEnableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
            if (this.epcglobalLlrpDeviceServiceDisableAccessspecResponse != null) {
                this.epcglobalLlrpDeviceServiceDisableAccessspecResponse.removeSignalListener((SignalListener)this);
            }
        }
        if (device != null) {
            this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory = device.getCommand("SetReaderConfig_ForInventory");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_ForInventory);
            this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration = device.getCommand("SetReaderConfig_AntennaConfiguration");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceSetReaderConfig_AntennaConfiguration);
            this.epcglobalLlrpDeviceServiceGetRospecs = device.getCommand("GetRospecs");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetRospecs);
            this.epcglobalLlrpDeviceServiceDeleteRospec = device.getCommand("DeleteRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDeleteRospec);
            this.epcglobalLlrpDeviceServiceAddRospec = device.getCommand("AddRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceAddRospec);
            this.epcglobalLlrpDeviceServiceEnableRospec = device.getCommand("EnableRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceEnableRospec);
            this.epcglobalLlrpDeviceServiceDisableRospec = device.getCommand("DisableRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDisableRospec);
            this.epcglobalLlrpDeviceServiceStartRospec = device.getCommand("StartRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceStartRospec);
            this.epcglobalLlrpDeviceServiceStopRospec = device.getCommand("StopRospec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceStopRospec);
            this.epcglobalLlrpDeviceServiceGetAccessspecs = device.getCommand("GetAccessspecs");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceGetAccessspecs);
            this.epcglobalLlrpDeviceServiceDeleteAccessspec = device.getCommand("DeleteAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDeleteAccessspec);
            this.epcglobalLlrpDeviceServiceAddAccessspec = device.getCommand("AddAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceAddAccessspec);
            this.epcglobalLlrpDeviceServiceEnableAccessspec = device.getCommand("EnableAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceEnableAccessspec);
            this.epcglobalLlrpDeviceServiceDisableAccessspec = device.getCommand("DisableAccessspec");
            this.initializeCommand(this.epcglobalLlrpDeviceServiceDisableAccessspec);
            this.epcglobalLlrpDeviceServiceSetReaderConfigResponse = device.getSignal("SetReaderConfigResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceSetReaderConfigResponse);
            this.epcglobalLlrpDeviceServiceGetRospecsResponse = device.getSignal("GetRospecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetRospecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteRospecResponse = device.getSignal("DeleteRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteRospecResponse);
            this.epcglobalLlrpDeviceServiceAddRospecResponse = device.getSignal("AddRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddRospecResponse);
            this.epcglobalLlrpDeviceServiceEnableRospecResponse = device.getSignal("EnableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableRospecResponse);
            this.epcglobalLlrpDeviceServiceDisableRospecResponse = device.getSignal("DisableRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableRospecResponse);
            this.epcglobalLlrpDeviceServiceStartRospecResponse = device.getSignal("StartRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStartRospecResponse);
            this.epcglobalLlrpDeviceServiceStopRospecResponse = device.getSignal("StopRospecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceStopRospecResponse);
            this.epcglobalLlrpDeviceServiceRoAccessReport = device.getSignal("RoAccessReport");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceRoAccessReport);
            this.epcglobalLlrpDeviceServiceGetAccessspecsResponse = device.getSignal("GetAccessspecsResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceGetAccessspecsResponse);
            this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse = device.getSignal("DeleteAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse);
            this.epcglobalLlrpDeviceServiceAddAccessspecResponse = device.getSignal("AddAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceAddAccessspecResponse);
            this.epcglobalLlrpDeviceServiceEnableAccessspecResponse = device.getSignal("EnableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceEnableAccessspecResponse);
            this.epcglobalLlrpDeviceServiceDisableAccessspecResponse = device.getSignal("DisableAccessspecResponse");
            this.initializeSignal(this.epcglobalLlrpDeviceServiceDisableAccessspecResponse);
        }
        super.setDevice(device);
    }

    public void setLlrpConfigurationChanged(boolean llrpConfigurationChanged) {
        this.llrpConfigurationChanged = llrpConfigurationChanged;
    }

    public void setROSpecID(int ROSpecID) {
        this.rOSpecID = ROSpecID;
    }

    public void setTargetTagFilterParameters(Map targetTagFilterParameters) {
        this.targetTagFilterParameters = targetTagFilterParameters;
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("epcgloballlrpwriteprofile.notificationpriority", this.getNotificationPriority()));
        this.setROSpecID(this.getInt("epcgloballlrpwriteprofile.rospecid", this.getROSpecID()));
        this.setAccessSpecID(this.getInt("epcgloballlrpwriteprofile.accessspecid", this.getAccessSpecID()));
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
        if (this.epcglobalLlrpDeviceServiceSetReaderConfigResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceSetReaderConfigResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceGetRospecsResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceGetRospecsResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceDeleteRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceDeleteRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceAddRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceAddRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceEnableRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceEnableRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceDisableRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceDisableRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceStartRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceStartRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceStopRospecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceStopRospecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceRoAccessReport == source) {
            this.handleEpcglobalLlrpDeviceServiceRoAccessReport(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceGetAccessspecsResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceGetAccessspecsResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceDeleteAccessspecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceDeleteAccessspecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceAddAccessspecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceAddAccessspecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceEnableAccessspecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceEnableAccessspecResponse(source, timestamp, data);
            return;
        }
        if (this.epcglobalLlrpDeviceServiceDisableAccessspecResponse == source) {
            this.handleEpcglobalLlrpDeviceServiceDisableAccessspecResponse(source, timestamp, data);
            return;
        }
        super.signalOccurred(source, timestamp, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean startOperations() {
        if (this.isLogging(4)) {
            this.log(4, "startOperations");
        }
        if (this.getDevice() != null && this.getDevice().isStarted()) {
            this.resetTaskManager();
            this.getAccessSpecIdManager().removeIdsByOwner(this.getOwner());
            if (this.registerROSpecIds()) {
                this.startROSpecs();
                if (!this.isOperationsRunning()) {
                    if (this.isLogging(4)) {
                        this.log(4, "Waiting for ROSpecs to start.");
                    }
                    Byte by = this.operationsRunningMonitor;
                    synchronized (by) {
                        try {
                            this.operationsRunningMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.isLogging(4)) {
                        this.log(4, "All ROSpecs have started.");
                    }
                }
                this.setLlrpConfigurationChanged(false);
                return true;
            }
        }
        return false;
    }

    protected void startOperationsFailed(String errorMsg) {
        if (this.isLogging(4)) {
            this.log(4, errorMsg);
        }
        this.resetTaskManager();
        this.endOperations();
    }

    protected void startROSpecs() {
        List rOSpecs = this.getROSpecParameters();
        int i = 0;
        while (i < rOSpecs.size()) {
            Map rOSpecParam = (Map)rOSpecs.get(i);
            int rOSpecId = ((Number)rOSpecParam.get("ROSpecID")).intValue();
            Map rOSpecIdParameter = ParameterFactory.getROSpecIDParameter((int)rOSpecId);
            int idStatus = this.getROSpecIdManager().getIdStatus(rOSpecId, this.getOwner());
            if (idStatus == 10 || this.isLlrpConfigurationChanged()) {
                this.taskPool.getStartROSpecTaskArray(i, rOSpecIdParameter, ParameterFactory.getAddROSpecCommandParameters((Map)rOSpecParam)).start(this.getAdapterTaskManager());
            } else {
                this.taskPool.getStartROSpecTaskArray(i, rOSpecIdParameter, null).start(this.getAdapterTaskManager());
            }
            if (this.isLogging(4)) {
                this.log(4, "Starting ROSpec " + rOSpecId);
            }
            ++i;
        }
    }

    protected void stopOperationsFailed(String errorMsg) {
        if (this.isLogging(4)) {
            this.log(4, errorMsg);
        }
        this.setOperationsStatusFinished();
    }

    protected void stopOperationsSucceeded() {
        this.setOperationsStatusFinished();
    }
}

