/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.matrix.lcd.simulator.view;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.eclipse.soda.dk.matrix.lcd.simulator.view.AbstractPanelWithBackground;

public class ButtonWithBackground
extends AbstractPanelWithBackground
implements MouseListener {
    private static final long serialVersionUID = -5104331656191485463L;
    private Image upImage;
    private Image downImage;
    private boolean buttonPressed;

    public ButtonWithBackground(String upSrc, String dnSrc) {
        this.setUpImage(upSrc);
        this.setDownImage(dnSrc);
        this.addMouseListener(this);
        this.initialize();
    }

    public Image getDownImage() {
        return this.downImage;
    }

    public Image getUpImage() {
        return this.upImage;
    }

    protected void initialize() {
        this.setCurrentImage(this.getUpImage());
        this.setButtonPressed(false);
    }

    protected boolean isButtonPressed() {
        return this.buttonPressed;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setCurrentImage(this.getDownImage());
        this.setButtonPressed(true);
        this.refresh();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCurrentImage(this.getUpImage());
        this.setButtonPressed(false);
        this.refresh();
    }

    protected void setButtonPressed(boolean b) {
        this.buttonPressed = b;
    }

    public void setDownImage(Image image) {
        if (this.isButtonPressed()) {
            this.setCurrentImage(image);
        }
        this.downImage = image;
    }

    public void setDownImage(String string) {
        this.setDownImage(this.loadImage(string));
    }

    public void setUpImage(Image image) {
        if (!this.isButtonPressed()) {
            this.setCurrentImage(image);
        }
        this.upImage = image;
    }

    public void setUpImage(String string) {
        this.setUpImage(this.loadImage(string));
    }
}

