/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.write.profile;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.soda.dk.command.Command;
import org.eclipse.soda.dk.command.MethodCommand;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.core.Worker;
import org.eclipse.soda.dk.core.service.WorkerService;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.interest.InterestMask;
import org.eclipse.soda.dk.interest.InterestMasks;
import org.eclipse.soda.dk.interest.service.InterestService;
import org.eclipse.soda.dk.measurement.Measurement;
import org.eclipse.soda.dk.measurement.MethodMeasurement;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.Profile;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.rfid.write.profile.RfidWriteRequest;
import org.eclipse.soda.dk.rfid.write.profile.service.RfidWriteProfileService;
import org.eclipse.soda.dk.signal.Signal;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.sat.core.framework.interfaces.IQueue;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public abstract class RfidWriteProfile
extends Profile
implements ProfileService,
RfidWriteProfileService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.rfid.write.profile.RfidWriteProfile";
    public static final String CONTROL_PROFILE_PREFIX = "ControlProfilePrefix";
    public static final String GPIO_PROFILE_PREFIX = "GpioProfilePrefix";
    protected String gpioProfileServiceInputExternalKey = null;
    protected String gpioProfileServiceInputGetExternalKey = null;
    protected String gpioProfileServiceAnalogInputExternalKey = null;
    protected String gpioProfileServiceAnalogInputGetExternalKey = null;
    protected String controlProfileServiceBitsExternalKey = null;
    protected String controlProfileServiceBitsGetExternalKey = null;
    protected String controlProfileServiceLongsExternalKey = null;
    protected String controlProfileServiceLongsGetExternalKey = null;
    protected final MethodCommand writeOperationsExecuteRequest = new MethodCommand("RfidWrite/WriteOperationsExecuteRequest");
    protected final MethodCommand writeOperationsStopRequest = new MethodCommand("RfidWrite/WriteOperationsStopRequest");
    protected final MethodMeasurement antennaConfiguration = new MethodMeasurement("RfidWrite/AntennaConfiguration", new HashMap());
    protected final MethodMeasurement dataWriteExtensions = new MethodMeasurement("RfidWrite/DataWriteExtensions", new HashMap());
    protected final MethodMeasurement tagWriteMaskSetting = new MethodMeasurement("RfidWrite/TagWriteMaskSetting", (Object)"");
    protected final MethodMeasurement tagAggregationWriteMaskSetting = new MethodMeasurement("RfidWrite/TagAggregationWriteMaskSetting", (Object)"");
    protected final MethodMeasurement tagWriteAggregatingExpression = new MethodMeasurement("RfidWrite/TagWriteAggregatingExpression", (Object)"");
    protected final MethodMeasurement tagWriteAggregating = new MethodMeasurement("RfidWrite/TagWriteAggregating", (Object)Boolean.FALSE);
    protected final MethodMeasurement writeOperations = new MethodMeasurement("RfidWrite/WriteOperations", (Object)"");
    protected final MethodMeasurement writeOperationsExpression = new MethodMeasurement("RfidWrite/WriteOperationsExpression", (Object)"");
    protected final MethodMeasurement writeOperationsExecuteStatus = new MethodMeasurement("RfidWrite/WriteOperationsExecuteStatus", (Object)Boolean.FALSE);
    protected final MethodMeasurement tagWriteAntennaReporting = new MethodMeasurement("RfidWrite/TagWriteAntennaReporting", (Object)Boolean.FALSE);
    protected final Signal tagWriteReport = new Signal("RfidWrite/TagWriteReport");
    protected final Signal tagWriteAggregationReport = new Signal("RfidWrite/TagWriteAggregationReport");
    private boolean executeOnOperationChange = true;
    private Dictionary ldapMap = new Hashtable(67);
    private Filter writeOperationLdapFilter;
    private Map cachedTags = new Hashtable(1031);
    private Map aggregatedTags = new Hashtable(1031);
    protected InterestMasks tagInterest = new InterestMasks();
    protected InterestMasks aggregationInterest = new InterestMasks();
    private Filter tagWriteAggregatingLdapFilter;
    protected final MethodMeasurement dataExtensions = new MethodMeasurement("RfidWrite/DataWriteExtensions");
    private Object operationExecutingLock = new Object();
    private IQueue requestsQueue;
    private Worker writeRequestsConsumerWorker;

    public static boolean isValidTagId(String tagId) {
        try {
            char[] tagIdChars = tagId.toCharArray();
            int i = 0;
            while (i < tagIdChars.length) {
                Integer.valueOf(String.valueOf(tagIdChars[i]), 16);
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static String[] parseDelimitedByToken(String target, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(target, delimiter);
        String[] values = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            values[index++] = tokenizer.nextToken().trim();
        }
        return values;
    }

    public static byte[] parseHexSpaceDelimited(String spaceDelimitedHex) {
        StringTokenizer tokenizer = new StringTokenizer(spaceDelimitedHex);
        byte[] value = new byte[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String byteHex = tokenizer.nextToken();
            byte byteValue = 0;
            byteValue = (byte)Integer.parseInt(byteHex, 16);
            value[index++] = byteValue;
        }
        return value;
    }

    public static InterestMasks parseInterestMasks(String targetTagConfig) {
        InterestMasks interests = new InterestMasks();
        if (targetTagConfig != null) {
            try {
                String[] masksConfig = RfidWriteProfile.parseDelimitedByToken(targetTagConfig, ";");
                int i = 0;
                while (i < masksConfig.length) {
                    String[] configParam = RfidWriteProfile.parseDelimitedByToken(masksConfig[i], ",");
                    int offset = Integer.parseInt(configParam[1]);
                    int length = Integer.parseInt(configParam[2]);
                    byte[] pattern = RfidWriteProfile.parseHexSpaceDelimited(configParam[3]);
                    InterestMask interest = new InterestMask(offset, length, pattern);
                    interests.add((InterestService)interest);
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("parseInterestMasks: " + targetTagConfig);
            }
        }
        return interests;
    }

    public static byte[] toBytes(String string) throws RuntimeException {
        return Nls.parseCompressedHexString((String)string);
    }

    public RfidWriteProfile() {
        super("RfidWriteProfile/Capabilities", "RfidWriteProfile/Status", "RfidWriteProfile/Configuration", "RfidWriteProfile/Metrics");
        this.setKey(this.getDefaultKey());
        this.initialize();
    }

    public void activate() {
        this.setupWriteRequestsConsumerThreader();
        super.activate();
    }

    private void addRequest(RfidWriteRequest task) {
        if (this.isLogging(4)) {
            this.log(4, "Add " + task);
        }
        this.getRequestsQueue().add((Object)task);
    }

    protected void addTagToCache(String key, Map reads, Map cache) {
        cache.put(key, reads);
    }

    private void applyAggregating(String key, String operationId, Map reads, Object timestamp, boolean sendTag) {
        byte[] tagBytes = RfidWriteProfile.toBytes(key);
        boolean isAggregating = (Boolean)this.getTagWriteAggregating().getValue();
        if (isAggregating && this.aggregationInterest.isInterested(tagBytes)) {
            if (!sendTag) {
                this.improveReportMap(reads, timestamp);
            }
            this.updateTagInCache(key, operationId, reads, this.aggregatedTags, timestamp);
        }
    }

    protected void applyDataExtensions(Map rfidData) {
        Map extensions = (Map)this.dataExtensions.getValue();
        if (extensions == null || extensions.isEmpty()) {
            rfidData.put("dataExtensions", new Hashtable(11));
        } else {
            Map existingDataExtensions = (Map)rfidData.get("dataExtensions");
            Map mergedDataExt = this.mergeMapOverMap(extensions, existingDataExtensions);
            rfidData.put("dataExtensions", mergedDataExt);
        }
    }

    private boolean applyFiltering(String key, Map reads) {
        boolean passesFilter = false;
        byte[] tagBytes = RfidWriteProfile.toBytes(key);
        if (this.tagInterest.isInterested(tagBytes)) {
            passesFilter = true;
        }
        return passesFilter;
    }

    private void applyLdap() {
        this.evaluateTagAggregatingLdapFilter();
        this.evaluateWriteOperationLdapFilter();
    }

    protected Map buildOuterTagMessage(Map tags) {
        Hashtable<String, Map> tagMap = new Hashtable<String, Map>(13);
        tagMap.put("tags", tags);
        this.applyDataExtensions(tagMap);
        return tagMap;
    }

    protected Map buildTagMessage(String key, Map reads) {
        Hashtable<String, Map> tags = new Hashtable<String, Map>(7);
        tags.put(key, reads);
        Map tagMap = this.buildOuterTagMessage(tags);
        return tagMap;
    }

    protected void consumeRequests() throws InterruptedException {
        RfidWriteRequest task = (RfidWriteRequest)this.getRequestsQueue().remove();
        switch (task.getTaskType()) {
            case 1: {
                if (this.isLogging(4)) {
                    this.log(4, "Rfid Write Profile Task: execute.");
                }
                this.executeWriteOperations();
                this.waitForCurrentOperationsFinished();
                break;
            }
            case 2: {
                if (this.isLogging(4)) {
                    this.log(4, "Rfid Write Profile Task: set write operations.");
                }
                String writeOperations = (String)task.getTaskValue();
                this.waitForCurrentOperationsFinished();
                this.writeOperations.setValue((Object)writeOperations, RfidWriteProfile.getCurrentTimestamp());
                break;
            }
            default: {
                if (!this.isLogging(4)) break;
                this.log(4, "Unknown task type: " + task.getTaskType());
            }
        }
        if (this.isLogging(4)) {
            this.log(4, "Rfid Write Profile Task finished.");
        }
    }

    protected Filter createLdapFilter(String filterString) throws InvalidSyntaxException {
        Filter result = null;
        result = this.createFilter(filterString);
        return result;
    }

    public void deactivate() {
        if (this.writeRequestsConsumerWorker != null && this.writeRequestsConsumerWorker.isRunning()) {
            this.writeRequestsConsumerWorker.stop();
        }
        super.deactivate();
    }

    protected abstract void endOperations();

    protected void evaluateTagAggregatingLdapFilter() {
        if (this.tagWriteAggregatingLdapFilter != null) {
            boolean tagAggregatingResult = this.tagWriteAggregatingLdapFilter.match(this.ldapMap);
            this.tagWriteAggregating.setValue((Object)(tagAggregatingResult ? Boolean.TRUE : Boolean.FALSE), RfidWriteProfile.getCurrentTimestamp());
        }
    }

    protected void evaluateWriteOperationLdapFilter() {
        if (this.writeOperationLdapFilter != null) {
            boolean writeOperationResult = this.writeOperationLdapFilter.match(this.ldapMap);
            if (writeOperationResult) {
                this.addRequest(new RfidWriteRequest(1));
            } else {
                this.handleWriteOperationsStopRequest();
            }
        }
    }

    protected abstract boolean executeBlockErase(String[] var1);

    protected abstract boolean executeBlockWrite(String[] var1);

    protected abstract boolean executeFilter(String[] var1);

    protected abstract boolean executeIncrementWrite(String[] var1);

    protected abstract boolean executeKill(String[] var1);

    protected abstract boolean executeLock(String[] var1);

    protected abstract boolean executeRead(String[] var1);

    protected abstract void executeStop();

    protected abstract boolean executeWrite(String[] var1);

    protected void executeWriteOperations() {
        boolean isStarted;
        String[] operations;
        String writeOperations = (String)this.getWriteOperations().getValue();
        if (writeOperations == null) {
            this.handleWriteOperationsError("Fail to start the WriteOperations, WriteOperations string is null.");
        }
        if ((operations = RfidWriteProfile.parseDelimitedByToken(writeOperations, String.valueOf(':'))).length == 0) {
            this.handleWriteOperationsError("Fail to start the WriteOperations, WriteOperations string is empty.");
        }
        if (this.isOperationsRunning()) {
            this.handleWriteOperationsError("Fail to start the WriteOperations, an existing execution is in the process.");
        }
        if (!(isStarted = this.startOperations())) {
            this.handleWriteOperationsError("Fail to start the WriteOperations.");
            return;
        }
        if (this.isLogging(4)) {
            this.log(4, "Execute write operations: " + writeOperations);
        }
        int i = 0;
        while (i < operations.length) {
            if (!this.isOperationsRunning()) {
                if (!this.isLogging(4)) break;
                this.log(4, "Write operations interrupted: " + writeOperations);
                break;
            }
            if (this.isLogging(4)) {
                this.log(4, "Execute write operation: " + operations[i]);
            }
            String[] op_parameters = RfidWriteProfile.parseDelimitedByToken(operations[i], String.valueOf(';'));
            String command = op_parameters[0];
            boolean lastOperation = i == operations.length - 1;
            boolean opValid = false;
            if ("Filter".equals(command)) {
                opValid = this.executeFilter(op_parameters);
            } else if ("Increment Write".equals(command)) {
                opValid = this.executeIncrementWrite(op_parameters);
            } else if ("Read".equals(command)) {
                opValid = this.executeRead(op_parameters);
            } else if ("Write".equals(command)) {
                opValid = this.executeWrite(op_parameters);
            } else if ("Kill".equals(command)) {
                opValid = this.executeKill(op_parameters);
            } else if ("Lock".equals(command)) {
                opValid = this.executeLock(op_parameters);
            } else if ("BlockErase".equals(command)) {
                opValid = this.executeBlockErase(op_parameters);
            } else if ("BlockWrite".equals(command)) {
                opValid = this.executeBlockWrite(op_parameters);
            } else {
                this.endOperations();
                this.handleWriteOperationsError("Not supported operation: " + command);
            }
            if (!opValid) {
                this.endOperations();
                this.handleWriteOperationsError("Not valid operation: " + operations[i]);
            }
            if (lastOperation) {
                this.endOperations();
            }
            ++i;
        }
    }

    public void flushAggregatorCache() {
        this.aggregatedTags = new Hashtable(1031);
    }

    public void flushTagCache() {
        this.cachedTags = new Hashtable(1031);
    }

    public MeasurementService getAntennaConfiguration() {
        return this.antennaConfiguration;
    }

    public int getControlCapacity() {
        return 23;
    }

    public String getControlProfilePrefix() {
        return this.getString(CONTROL_PROFILE_PREFIX, this.getPrefix());
    }

    public MeasurementService getDataWriteExtensions() {
        return this.dataWriteExtensions;
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "RfidWriteProfile";
    }

    public boolean getExecuteOnOperationChange() {
        return this.executeOnOperationChange;
    }

    public String getGpioProfilePrefix() {
        return this.getString(GPIO_PROFILE_PREFIX, this.getPrefix());
    }

    public int getMessageCapacity() {
        return 2;
    }

    public String getReaderId() {
        String id = this.getId();
        if (id != null && id.length() > 0) {
            return id;
        }
        String idName = this.getIdName();
        if (idName != null && idName.length() > 0) {
            return idName;
        }
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            return prefix;
        }
        return this.getOutputName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQueue getRequestsQueue() {
        RfidWriteProfile rfidWriteProfile = this;
        synchronized (rfidWriteProfile) {
            if (this.requestsQueue == null) {
                FactoryUtility utility = FactoryUtility.getInstance();
                this.requestsQueue = utility.createQueue(13);
            }
            return this.requestsQueue;
        }
    }

    public MeasurementService getTagAggregationWriteMaskSetting() {
        return this.tagAggregationWriteMaskSetting;
    }

    public MeasurementService getTagWriteAggregating() {
        return this.tagWriteAggregating;
    }

    public MeasurementService getTagWriteAggregatingExpression() {
        return this.tagWriteAggregatingExpression;
    }

    public SignalService getTagWriteAggregationReport() {
        return this.tagWriteAggregationReport;
    }

    public MeasurementService getTagWriteAntennaReporting() {
        return this.tagWriteAntennaReporting;
    }

    public MeasurementService getTagWriteMaskSetting() {
        return this.tagWriteMaskSetting;
    }

    public SignalService getTagWriteReport() {
        return this.tagWriteReport;
    }

    public MeasurementService getWriteOperations() {
        return this.writeOperations;
    }

    public CommandService getWriteOperationsExecuteRequest() {
        return this.writeOperationsExecuteRequest;
    }

    public MeasurementService getWriteOperationsExecuteStatus() {
        return this.writeOperationsExecuteStatus;
    }

    public MeasurementService getWriteOperationsExpression() {
        return this.writeOperationsExpression;
    }

    public CommandService getWriteOperationsStopRequest() {
        return this.writeOperationsStopRequest;
    }

    private WorkerService getWriteRequestsConsumerWorker() {
        WorkerService work = new WorkerService(){

            public boolean doWork() throws InterruptedException {
                RfidWriteProfile.this.consumeRequests();
                return true;
            }
        };
        return work;
    }

    protected void handleControlProfileServiceBits(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleControlProfileServiceLongs(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleGetWriteOperationsExecuteStatus() {
        MethodMeasurement methodMeasurement = this.writeOperationsExecuteStatus;
        synchronized (methodMeasurement) {
            return (Boolean)this.writeOperationsExecuteStatus.getValue();
        }
    }

    protected void handleGpioProfileServiceAnalogInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    protected void handleGpioProfileServiceInput(String externalKey, Dictionary data) {
        this.storeMapInLdap(data);
    }

    public Object handleMethodAntennaConfiguration(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                return this.handleSetAntennaConfiguration(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodDataWriteExtensions(int code, Measurement measurement, Object data) {
        return null;
    }

    public Object handleMethodTagAggregationWriteMaskSetting(int code, Measurement measurement, Object data) {
        if (this.isLogging(4)) {
            this.log(4, "handleMethodTagAggregationWriteMaskSetting: " + data);
        }
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagAggregationWriteMaskSetting(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagWriteAggregating(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (this.tagWriteAggregatingLdapFilter != null) {
                    throw new IllegalArgumentException("handleMethodTagWriteAggregating, TagWriteAggregatingExpression has been applied.");
                }
                measurement.setValue((Object)this.getBooleanValue(data), RfidWriteProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagWriteAggregatingExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagWriteAggregatingExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodTagWriteAntennaReporting(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
            }
        }
        return null;
    }

    public Object handleMethodTagWriteMaskSetting(int code, Measurement measurement, Object data) {
        if (this.isLogging(4)) {
            this.log(4, "handleMethodTagWriteMaskSetting: " + data);
        }
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetTagWriteMaskSetting(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodWriteOperations(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetWriteOperations(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodWriteOperationsExecuteRequest(int code, Command command, Object data) {
        if (this.writeOperationLdapFilter != null) {
            throw new IllegalArgumentException("handleMethodWriteOperationsExecuteRequest, WriteOperationsExpression has been applied.");
        }
        this.addRequest(new RfidWriteRequest(1));
        return null;
    }

    public Object handleMethodWriteOperationsExecuteStatus(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                throw new IllegalArgumentException("WriteOperationsExecuteStatus: read-only measurement." + data);
            }
        }
        return null;
    }

    public Object handleMethodWriteOperationsExpression(int code, Measurement measurement, Object data) {
        switch (code) {
            case 0: {
                return measurement.getValueRaw();
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.handleSetWriteOperationExpression(measurement, data);
            }
        }
        return null;
    }

    public Object handleMethodWriteOperationsStopRequest(int code, Command command, Object data) {
        if (this.writeOperationLdapFilter != null) {
            throw new IllegalArgumentException("handleMethodWriteOperationsStopRequest, WriteOperationsExpression has been applied.");
        }
        this.handleWriteOperationsStopRequest();
        return null;
    }

    protected Object handleSetAntennaConfiguration(Measurement measurement, Object data) {
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("handleSetAntennaConfiguration: " + data);
        }
        measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
        return null;
    }

    protected void handleSetTagAggregationWriteMaskSetting(Measurement measurement, Object data) {
        if (data instanceof String) {
            this.aggregationInterest = RfidWriteProfile.parseInterestMasks((String)data);
            measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
            return;
        }
        throw new IllegalArgumentException("handleSetTagAggregationMaskSetting: " + data);
    }

    protected void handleSetTagWriteAggregatingExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter aggFilter = this.createLdapFilter((String)data);
                    this.setTagWriteAggregatingLdapFilter(aggFilter);
                    measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setTagWriteAggregatingLdapFilter(null);
                measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleTagAggregatingExpression: " + data);
    }

    protected void handleSetTagWriteMaskSetting(Measurement measurement, Object data) {
        if (data instanceof String) {
            if (this.isLogging(4)) {
                this.log(4, "Tag Write Mask Setting: " + data);
            }
            this.tagInterest = RfidWriteProfile.parseInterestMasks((String)data);
            measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
            return;
        }
        throw new IllegalArgumentException("handleSetTagMaskSetting: " + data);
    }

    protected void handleSetWriteOperationExpression(Measurement measurement, Object data) {
        if (data instanceof String) {
            String newLdap = (String)data;
            if (newLdap.length() > 0) {
                try {
                    Filter writeOpFilter = this.createLdapFilter((String)data);
                    this.setWriteOperationLdapFilter(writeOpFilter);
                    measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
                    return;
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.setWriteOperationLdapFilter(null);
                measurement.setValue(data, RfidWriteProfile.getCurrentTimestamp());
                return;
            }
        }
        throw new IllegalArgumentException("handleSetTagReadingExpression: " + data);
    }

    protected Object handleSetWriteOperations(Measurement measurement, Object data) {
        if (data instanceof String) {
            this.addRequest(new RfidWriteRequest(2, data));
            if (this.getExecuteOnOperationChange()) {
                this.addRequest(new RfidWriteRequest(1));
            }
        } else {
            throw new IllegalArgumentException("handleSetWriteOperations: " + data);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSetWriteOperationsExecuteStatus(Boolean status) {
        MethodMeasurement methodMeasurement = this.writeOperationsExecuteStatus;
        synchronized (methodMeasurement) {
            boolean currentStatus = (Boolean)this.writeOperationsExecuteStatus.getValue();
            if (currentStatus && status.booleanValue()) {
                throw new IllegalArgumentException("Fail to start the WriteOperations, one execution is in the process.");
            }
            this.writeOperationsExecuteStatus.setValue((Object)status, RfidWriteProfile.getCurrentTimestamp());
        }
    }

    protected void handleTagWriteAggregating(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        boolean newState = this.getBooleanValue(newValue);
        if (oldValue != null) {
            this.applyDataExtensions(this.cachedTags);
            this.applyDataExtensions(this.aggregatedTags);
            if (!newState) {
                this.notifyTagAggregation();
                this.flushAggregatorCache();
            }
        }
    }

    protected void handleWriteOperationsError(String errorMsg) {
        this.writeOperationsExecuteRequest.fireErrorOccurred(RfidWriteProfile.getCurrentTimestamp(), (Object)errorMsg);
        this.handleError(new RuntimeException(errorMsg), 3008);
    }

    protected void handleWriteOperationsStopRequest() {
        if (this.isOperationsRunning()) {
            this.executeStop();
        }
    }

    protected void improveReportMap(Map reads, Object timestamp) {
        String antennaKey;
        int antenna;
        Object antennaObject;
        Object readerObject;
        Object timestampLast;
        Object timestampFirst;
        reads.put("timestamp", timestamp);
        Object countObject = reads.get("count");
        if (!(countObject instanceof Number)) {
            reads.put("count", RfidWriteProfile.createInteger((int)1));
        }
        if ((timestampFirst = reads.get("timestampFirst")) == null) {
            reads.put("timestampFirst", timestamp);
        }
        if ((timestampLast = reads.get("timestampLast")) == null) {
            reads.put("timestampLast", timestamp);
        }
        if ((readerObject = reads.get("reader")) == null) {
            reads.put("reader", this.getReaderId());
        }
        if (this.isTagWriteAntennaReporting() && (antennaObject = reads.get("antenna")) instanceof Number && (antenna = ((Number)antennaObject).intValue()) > 0 && !reads.containsKey(antennaKey = "antenna" + Integer.toString(antenna))) {
            HashMap antennaMap = new HashMap(17);
            antennaMap.putAll(reads);
            reads.put(antennaKey, antennaMap);
        }
    }

    private void initialize() {
        this.put((ControlService)this.writeOperationsExecuteRequest);
        this.put((ControlService)this.writeOperationsStopRequest);
        this.put((ControlService)this.antennaConfiguration);
        this.put((ControlService)this.dataWriteExtensions);
        this.put((ControlService)this.tagWriteMaskSetting);
        this.put((ControlService)this.tagAggregationWriteMaskSetting);
        this.put((ControlService)this.tagWriteAggregatingExpression);
        this.put((ControlService)this.tagWriteAggregating);
        this.tagWriteAggregating.addMeasurementListener((MeasurementListener)this);
        this.put((ControlService)this.writeOperations);
        this.put((ControlService)this.writeOperationsExpression);
        this.put((ControlService)this.writeOperationsExecuteStatus);
        this.put((ControlService)this.tagWriteAntennaReporting);
        this.put((ControlService)this.tagWriteReport);
        this.put((ControlService)this.tagWriteAggregationReport);
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    protected boolean isOperationsRunning() {
        return this.handleGetWriteOperationsExecuteStatus();
    }

    public boolean isTagWriteAntennaReporting() {
        Object isTagAntennaReportingObject = this.getTagWriteAntennaReporting().getValue();
        if (isTagAntennaReportingObject instanceof Boolean) {
            boolean isTagAntennaReporting = (Boolean)isTagAntennaReportingObject;
            return isTagAntennaReporting;
        }
        return false;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
        if (this.tagWriteAggregating == source) {
            this.handleTagWriteAggregating(source, timestamp, newValue, oldValue);
            return;
        }
        super.measurementChanged(source, timestamp, newValue, oldValue);
    }

    public void mergeAntennaInfo(Map cacheReadData, Map reads) {
        Object countObject = reads.get("count");
        Object timestampLast = reads.get("timestampLast");
        int newCount = countObject instanceof Number ? ((Number)countObject).intValue() : 1;
        Object previousCountObject = cacheReadData.get("count");
        int previousCount = previousCountObject instanceof Number ? ((Number)previousCountObject).intValue() : 1;
        Object cachePeakRssiObject = cacheReadData.get("peakRSSI");
        Object cacheTimestampFirstObject = cacheReadData.get("timestampFirst");
        cacheReadData.putAll(reads);
        Object peakRssiObject = reads.get("peakRSSI");
        if (peakRssiObject instanceof Number) {
            if (cachePeakRssiObject instanceof Number) {
                long cachePeakRssi;
                long peakRssi = ((Number)peakRssiObject).longValue();
                if (peakRssi > (cachePeakRssi = ((Number)cachePeakRssiObject).longValue())) {
                    cacheReadData.put("peakRSSI", peakRssiObject);
                }
            } else {
                cacheReadData.put("peakRSSI", peakRssiObject);
            }
        }
        cacheReadData.put("count", RfidWriteProfile.createInteger((int)(newCount + previousCount)));
        cacheReadData.put("timestampLast", timestampLast);
        cacheReadData.put("timestampFirst", cacheTimestampFirstObject);
    }

    protected Map mergeMapOverMap(Map additionalValues, Map existingValues) {
        Object value;
        Object key;
        Iterator i;
        Hashtable newExtensions = new Hashtable(17);
        if (existingValues != null) {
            i = existingValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                value = existingValues.get(key);
                newExtensions.put(key, value);
            }
        }
        if (additionalValues != null) {
            i = additionalValues.keySet().iterator();
            while (i.hasNext()) {
                key = i.next();
                value = additionalValues.get(key);
                newExtensions.put(key, value);
            }
        }
        return newExtensions;
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        if (externalKey.equals(this.gpioProfileServiceInputExternalKey)) {
            this.handleGpioProfileServiceInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.gpioProfileServiceAnalogInputExternalKey)) {
            this.handleGpioProfileServiceAnalogInput(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceBitsExternalKey)) {
            this.handleControlProfileServiceBits(externalKey, data);
            return;
        }
        if (externalKey.equals(this.controlProfileServiceLongsExternalKey)) {
            this.handleControlProfileServiceLongs(externalKey, data);
            return;
        }
        super.notificationReceived(externalKey, data);
    }

    public void notifyTagAggregation() {
        Map tagMap = this.buildOuterTagMessage(this.aggregatedTags);
        this.triggerTagAggregationReport(tagMap, false);
    }

    public void notifyTagReport(String key, String operationId, Map reads) {
        this.notifyTagReport(key, operationId, reads, RfidWriteProfile.getCurrentTimestamp());
    }

    public void notifyTagReport(String key, String operationId, Map reads, Object timestamp) {
        boolean sendTag = false;
        sendTag = this.applyFiltering(key, reads);
        if (sendTag) {
            this.improveReportMap(reads, timestamp);
            Hashtable<String, Map> reportData = new Hashtable<String, Map>(7);
            reportData.put(operationId, reads);
            Map tagMap = this.buildTagMessage(key, reportData);
            tagMap.put("timestamp", timestamp);
            this.triggerTagReport(tagMap, false);
        } else if (this.isLogging(4)) {
            this.log(4, "Tag " + key + " is not reported.");
        }
        this.applyAggregating(key, operationId, reads, timestamp, sendTag);
    }

    protected void operationsInterrupted(String errorMsg) {
        if (this.isOperationsRunning()) {
            this.handleError(new RuntimeException(errorMsg), 1);
            this.setOperationsStatusFinished();
        }
    }

    public void setExecuteOnOperationChange(boolean executeOnOperationChange) {
        this.executeOnOperationChange = executeOnOperationChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOperationsStatusFinished() {
        this.handleSetWriteOperationsExecuteStatus(Boolean.FALSE);
        Object object = this.operationExecutingLock;
        synchronized (object) {
            this.operationExecutingLock.notifyAll();
        }
    }

    protected void setOperationsStatusStarted() {
        this.handleSetWriteOperationsExecuteStatus(Boolean.TRUE);
    }

    protected void setTagWriteAggregatingLdapFilter(Filter tagAggregatingLdapFilter) {
        this.tagWriteAggregatingLdapFilter = tagAggregatingLdapFilter;
        this.evaluateTagAggregatingLdapFilter();
    }

    public void setup() {
        super.setup();
        this.setNotificationPriority(this.getInt("rfidwriteprofile.notificationpriority", this.getNotificationPriority()));
        this.setExecuteOnOperationChange(this.getBoolean("rfidwriteprofile.executeonoperationchange", this.getExecuteOnOperationChange()));
    }

    public void setupNotification() {
        String gpioProfilePrefix = this.getGpioProfilePrefix();
        this.gpioProfileServiceInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input");
        this.gpioProfileServiceInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/Input/get");
        this.gpioProfileServiceAnalogInputExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/AnalogInput");
        this.gpioProfileServiceAnalogInputGetExternalKey = this.prependPrefix(gpioProfilePrefix, "Gpio/AnalogInput/get");
        String controlProfilePrefix = this.getControlProfilePrefix();
        this.controlProfileServiceBitsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits");
        this.controlProfileServiceBitsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Bits/get");
        this.controlProfileServiceLongsExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs");
        this.controlProfileServiceLongsGetExternalKey = this.prependPrefix(controlProfilePrefix, "Control/Longs/get");
        this.register(new String[]{this.gpioProfileServiceInputExternalKey, this.gpioProfileServiceAnalogInputExternalKey, this.controlProfileServiceBitsExternalKey, this.controlProfileServiceLongsExternalKey});
        super.setupNotification();
        this.broadcast(this.gpioProfileServiceInputGetExternalKey, new Hashtable());
        this.broadcast(this.gpioProfileServiceAnalogInputGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceBitsGetExternalKey, new Hashtable());
        this.broadcast(this.controlProfileServiceLongsGetExternalKey, new Hashtable());
    }

    private void setupWriteRequestsConsumerThreader() {
        WorkerService work = this.getWriteRequestsConsumerWorker();
        this.writeRequestsConsumerWorker = new Worker("RfidWriteProfileRSC", work);
        this.writeRequestsConsumerWorker.start();
    }

    protected void setWriteOperationLdapFilter(Filter writeOperationLdapFilter) {
        this.writeOperationLdapFilter = writeOperationLdapFilter;
        this.evaluateWriteOperationLdapFilter();
    }

    protected abstract boolean startOperations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMapInLdap(Dictionary data) {
        Dictionary dictionary = this.ldapMap;
        synchronized (dictionary) {
            Map values = (Map)data.get("value");
            if (values == null) {
                return;
            }
            Iterator i = values.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Object value = values.get(key);
                this.ldapMap.put(key, value);
            }
            this.applyLdap();
        }
    }

    private void triggerTagAggregationReport(Map tagMap, boolean withError) {
        if (withError) {
            this.tagWriteAggregationReport.fireErrorOccurred(RfidWriteProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagWriteAggregationReport.trigger((Object)tagMap);
        }
    }

    private void triggerTagReport(Map tagMap, boolean withError) {
        if (withError || !this.isOperationsRunning()) {
            this.tagWriteReport.fireErrorOccurred(RfidWriteProfile.getCurrentTimestamp(), (Object)tagMap);
        } else {
            this.tagWriteReport.trigger((Object)tagMap);
        }
    }

    protected void updateTagInCache(String key, String operationId, Map reads, Map cache, Object timestamp) {
        Map cacheReadData;
        Object countObject = reads.get("count");
        Object timestampLast = reads.get("timestampLast");
        if (timestampLast == null) {
            timestampLast = timestamp;
        }
        if ((cacheReadData = (Map)cache.get(key)) == null) {
            HashMap<String, Map> cacheOpResults = new HashMap<String, Map>();
            cacheOpResults.put(operationId, reads);
            this.addTagToCache(key, cacheOpResults, cache);
        } else {
            Map cacheOpResult = (Map)cacheReadData.get(operationId);
            if (cacheOpResult == null) {
                cacheReadData.put(operationId, reads);
            } else {
                String antennaKey;
                Object antennaInfoObject;
                int antenna;
                Object antennaObject;
                int newCount = countObject instanceof Number ? ((Number)countObject).intValue() : 1;
                Object previousCountObject = cacheOpResult.get("count");
                int previousCount = previousCountObject instanceof Number ? ((Number)previousCountObject).intValue() : 1;
                Object cachePeakRssiObject = cacheOpResult.get("peakRSSI");
                Object timestampFirst = cacheOpResult.get("timestampFirst");
                Iterator iterator = reads.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String ekey = String.valueOf(entry.getKey());
                    Object evalue = entry.getValue();
                    if (ekey.length() > "antenna".length() && ekey.startsWith("antenna")) continue;
                    cacheOpResult.put(ekey, evalue);
                }
                cacheOpResult.put("count", RfidWriteProfile.createInteger((int)(newCount + previousCount)));
                cacheOpResult.put("timestampLast", timestampLast);
                if (timestampFirst != null) {
                    cacheOpResult.put("timestampFirst", timestampFirst);
                } else {
                    cacheOpResult.put("timestampFirst", timestamp);
                }
                Object peakRssiObject = reads.get("peakRSSI");
                if (peakRssiObject instanceof Number) {
                    if (cachePeakRssiObject instanceof Number) {
                        long cachePeakRssi;
                        long peakRssi = ((Number)peakRssiObject).longValue();
                        if (peakRssi > (cachePeakRssi = ((Number)cachePeakRssiObject).longValue())) {
                            cacheOpResult.put("peakRSSI", peakRssiObject);
                        }
                    } else {
                        cacheOpResult.put("peakRSSI", peakRssiObject);
                    }
                }
                if (this.isTagWriteAntennaReporting() && (antennaObject = reads.get("antenna")) instanceof Number && (antenna = ((Number)antennaObject).intValue()) > 0 && (antennaInfoObject = reads.get(antennaKey = "antenna" + Integer.toString(antenna))) instanceof Map) {
                    Map antennaMap = (Map)antennaInfoObject;
                    Object antennaObjectCache = cacheOpResult.get(antennaKey);
                    if (antennaObjectCache instanceof Map) {
                        this.mergeAntennaInfo((Map)antennaObjectCache, antennaMap);
                    } else {
                        Hashtable newAntennaMap = new Hashtable();
                        newAntennaMap.putAll(antennaMap);
                        cacheOpResult.put(antennaKey, newAntennaMap);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCurrentOperationsFinished() throws InterruptedException {
        if (this.isOperationsRunning()) {
            Object object = this.operationExecutingLock;
            synchronized (object) {
                this.log(4, "Waiting for the current ongoing operations to stop.");
                this.operationExecutingLock.wait();
            }
        }
    }
}

