/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.tcpip.server.connection;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.StreamConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Os;
import org.eclipse.soda.dk.tcpip.connection.TcpipConnection;
import org.eclipse.soda.dk.tcpip.server.connection.service.TcpipServerConnectionService;

public class TcpipServerConnection
extends StreamConnection
implements ConnectionService,
TcpipServerConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.tcpip.server.connection.TcpipServerConnection";
    protected static final char[] TOSTRING_NAME = "TcpipServerConnection[".toCharArray();
    private ServerSocket serverSocket = null;
    private Socket client = null;

    public TcpipServerConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public TcpipServerConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public TcpipServerConnection(String localhost, int localport, int readtimeout, int readsize, int writesize, int queuelength, int linger) throws IllegalArgumentException {
        Hashtable<String, Object> table = new Hashtable<String, Object>(23);
        if (localhost != null && !"0.0.0.0".equals(localhost)) {
            table.put("localhost", localhost);
        }
        if (localport != 8901) {
            table.put("localport", TcpipServerConnection.createInteger((int)localport));
        }
        if (readtimeout != 1000) {
            table.put("readtimeout", TcpipServerConnection.createInteger((int)readtimeout));
        }
        if (readsize != -1) {
            table.put("readsize", TcpipServerConnection.createInteger((int)readsize));
        }
        if (writesize != -1) {
            table.put("writesize", TcpipServerConnection.createInteger((int)writesize));
        }
        if (queuelength != -1) {
            table.put("queuelength", TcpipServerConnection.createInteger((int)queuelength));
        }
        if (linger != -1) {
            table.put("linger", TcpipServerConnection.createInteger((int)linger));
        }
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public TcpipServerConnection(int port) {
        this(port, -1);
    }

    public TcpipServerConnection(int port, int queueLength) {
        this(port, queueLength, -1);
    }

    public TcpipServerConnection(int port, int queueLength, int timeout) {
        this(port, queueLength, timeout, -1);
    }

    public TcpipServerConnection(int port, int queueLength, int timeout, int linger) {
        Hashtable<String, Integer> table = new Hashtable<String, Integer>(23);
        table.put("localport", TcpipServerConnection.createInteger((int)port));
        table.put("queuelength", TcpipServerConnection.createInteger((int)queueLength));
        table.put("timeout", TcpipServerConnection.createInteger((int)timeout));
        table.put("linger", TcpipServerConnection.createInteger((int)linger));
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public synchronized void close() throws IOException {
        Exception exception;
        super.close();
        if (this.client != null) {
            exception = null;
            try {
                this.client.close();
            }
            catch (Exception e) {
                exception = e;
            }
            this.report(exception, 1002, this.client.toString());
            this.client = null;
        }
        if (this.serverSocket != null) {
            exception = null;
            try {
                this.serverSocket.close();
            }
            catch (Exception e) {
                exception = e;
            }
            this.serverSocket = null;
            this.report(exception, 1002, this.toString());
        }
    }

    public TcpipConnection getClient() {
        return new TcpipConnection(this.client);
    }

    private void initServer() throws IOException {
        int port = this.getInt("localport", this.getInt("port", 8901));
        int queueLength = this.getInt("queuelength", -1);
        int timeout = this.getInt("timeout", -1);
        if (timeout != -1) {
            this.serverSocket = new ServerSocket(port, queueLength);
            this.serverSocket.setSoTimeout(timeout);
        } else {
            this.serverSocket = queueLength != -1 ? new ServerSocket(port, queueLength) : new ServerSocket(port);
        }
    }

    public boolean isOpen() {
        return this.serverSocket != null;
    }

    public synchronized void open() throws IOException {
        if (this.serverSocket == null) {
            this.initServer();
        } else if (this.client == null) {
            this.initServer();
        }
        int timeout = this.getInt("readtimeout", 1000);
        if (timeout == -1) {
            this.report(null, 1007, null);
        }
        this.client = this.serverSocket.accept();
        if (this.client != null) {
            this.client.setTcpNoDelay(true);
            int linger = this.getInt("linger", -1);
            if (linger >= 0) {
                if (linger == 0) {
                    this.client.setSoLinger(false, 0);
                } else {
                    this.client.setSoLinger(true, linger);
                }
            }
            int receiveBufferSize = this.getInt("readsize", -1);
            int sendBufferSize = this.getInt("writesize", -1);
            if (receiveBufferSize > 0 && !Os.isNeutrino()) {
                this.client.setReceiveBufferSize(receiveBufferSize);
            }
            if (sendBufferSize > 0 && !Os.isNeutrino()) {
                this.client.setSendBufferSize(sendBufferSize);
            }
            this.setInputStream(this.client.getInputStream());
            this.setOutputStream(this.client.getOutputStream());
            super.open();
        }
    }

    public void toStringInfo(StringBuffer buffer) {
        super.toStringInfo(buffer);
        buffer.append(',');
        if (this.client != null) {
            buffer.append(this.client);
        } else if (this.serverSocket != null) {
            buffer.append(this.serverSocket);
        } else {
            int port = this.getInt("localport", this.getInt("port", 8901));
            buffer.append(port);
        }
    }
}

