/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testagent.service.TestAgentService;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.soda.dk.testcontroller.TestController;
import org.eclipse.soda.dk.testcontroller.TestGroupRunner;
import org.eclipse.soda.dk.testcontroller.service.TestConfigurationService;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.osgi.framework.InvalidSyntaxException;

public class TestSession
implements TestSessionService {
    private TestConfigurationService testConfigurationService;
    private TestSynchronizationService syncService;
    private List globalRunListeners;
    private boolean interrupted;
    private Set testGroupRunners;

    public TestSession(TestConfigurationService testConfigurationService, TestSynchronizationService syncService) {
        this.testConfigurationService = testConfigurationService;
        this.syncService = syncService;
        this.globalRunListeners = new ArrayList();
        this.testGroupRunners = Collections.synchronizedSet(new HashSet());
    }

    public synchronized void addGlobalTestRunListener(TestRunListenerService runListener) {
        this.globalRunListeners.add(runListener);
    }

    public void close() {
        try {
            Iterator iterator = this.testGroupRunners.iterator();
            while (iterator.hasNext()) {
                TestGroupRunner runner = (TestGroupRunner)iterator.next();
                runner.getRunnerThread().join();
            }
        }
        catch (InterruptedException interruptedException) {}
        this.globalRunListeners.clear();
    }

    private synchronized TestRunListenerService[] getRunListeners(TestRunListenerService runListener) {
        int size = this.globalRunListeners.size();
        TestRunListenerService[] listeners = new TestRunListenerService[runListener == null ? size : size + 1];
        this.globalRunListeners.toArray(listeners);
        if (runListener != null) {
            listeners[size] = runListener;
        }
        return listeners;
    }

    public TestConfigurationService getTestConfigurationService() {
        return this.testConfigurationService;
    }

    public void interrupt() {
        this.interrupted = true;
        Iterator iterator = this.testGroupRunners.iterator();
        while (iterator.hasNext()) {
            TestGroupRunner runner = (TestGroupRunner)iterator.next();
            runner.getRunnerThread().interrupt();
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized void removeGlobalTestRunListener(TestRunListenerService runListener) {
        this.globalRunListeners.remove(runListener);
    }

    public void runMultipleTests(String actionId, String runId, String filter, String className, Dictionary properties, TestRunListenerService runListener) throws InvalidSyntaxException, IOException {
        TestAgentService[] agents = this.testConfigurationService.findTests(filter, className);
        this.runTests(actionId, runId, properties, runListener, agents);
    }

    public void runSingleTest(String actionId, String runId, String filter, String className, Dictionary properties, TestRunListenerService runListener) throws InvalidSyntaxException, IOException {
        TestAgentService[] agents = this.testConfigurationService.findTests(filter, className);
        if (agents.length == 1) {
            TestGroupRunner runner = new TestGroupRunner(actionId, runId, agents, properties, this.syncService, this.getRunListeners(runListener));
            runner.runTests();
        } else {
            TestRunListenerService[] listeners = this.getRunListeners(runListener);
            int i = 0;
            while (i < listeners.length) {
                Object[] parms1 = new Object[]{new Integer(agents.length)};
                Object[] parms2 = new Object[]{filter, className};
                listeners[i].testRunStarted(actionId, runId);
                listeners[i].testRunError(runId, Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7050)), (Object[])parms1), Nls.format((String)TestController.DefaultResourceBundle.getString(Integer.toString(7069)), (Object[])parms2));
                listeners[i].testRunEnded(runId);
                ++i;
            }
        }
    }

    private void runTests(String actionId, String runId, Dictionary properties, TestRunListenerService runListener, TestAgentService[] agents) {
        TestGroupRunner runner = new TestGroupRunner(actionId, runId, agents, properties, this.syncService, this.getRunListeners(runListener));
        this.testGroupRunners.add(runner);
        runner.runTests();
        this.testGroupRunners.remove(runner);
    }
}

