/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.io.IOException;
import java.util.Map;
import org.eclipse.soda.dk.connection.TraceConnection;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionService;
import org.eclipse.soda.dk.transport.ThreadTransport;
import org.eclipse.soda.dk.transport.service.ConnectionTransportService;

public abstract class ConnectionTransport
extends ThreadTransport
implements ConnectionTransportService {
    private ConnectionService connection;

    protected ConnectionTransport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConnectionTransport connectionTransport = this;
        synchronized (connectionTransport) {
            super.close();
            try {
                ConnectionService connection = this.getConnection();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                this.handleError(exception, 2017);
            }
            this.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws Exception {
        ConnectionTransport connectionTransport = this;
        synchronized (connectionTransport) {
            ConnectionService connection = this.getConnection();
            if (!connection.isOpen()) {
                connection.open();
            }
            super.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        ConnectionTransport connectionTransport = this;
        synchronized (connectionTransport) {
            super.exit();
            this.setConnection(null);
        }
    }

    public Map getChannels() {
        return this.isMultiplexing() ? this.getMultiplexConnection().getChannels() : null;
    }

    public ConnectionService getConnection() {
        return this.connection;
    }

    public abstract ConnectionService getDefaultConnection();

    public MultiplexConnectionService getMultiplexConnection() {
        return (MultiplexConnectionService)this.getConnection();
    }

    public ChannelService openChannel(Map parameters) throws IOException {
        return this.getMultiplexConnection().openChannel(parameters);
    }

    protected void processEvents() throws Exception {
        this.getMultiplexConnection().processEvents();
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.getConnection().read(buffer, offset, length);
    }

    protected int read(ChannelService channel, byte[] bytes, int offset, int length) throws IOException {
        return this.getMultiplexConnection().read(channel, bytes, offset, length);
    }

    public void setConnection(ConnectionService connection) throws IllegalArgumentException {
        this.setMultiplexing(connection instanceof MultiplexConnectionService);
        if (ConnectionTransport.getTraceLevel() >= 7 && !(connection instanceof TraceConnection) && connection != null) {
            this.connection = new TraceConnection(connection);
            return;
        }
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        ConnectionTransport connectionTransport = this;
        synchronized (connectionTransport) {
            super.setup();
            if (this.getConnection() == null) {
                this.setConnection(this.getDefaultConnection());
            }
            if (this.isMultiplexing()) {
                this.getMultiplexConnection().setConnectionListener((MultiplexConnectionListener)this);
            }
        }
    }

    public void write(ChannelService channel, byte[] sendBytes) throws Exception {
        if (channel == null) {
            this.getConnection().write(sendBytes);
        } else {
            this.getMultiplexConnection().write(channel, sendBytes);
        }
        this.addHistory(ConnectionTransport.createInteger((int)(-sendBytes.length)), sendBytes);
    }
}

