/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.transport.ChannelSchedule;
import org.eclipse.soda.dk.transport.ChannelState;
import org.eclipse.soda.dk.transport.ControllerQueue;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.TransportNotificationThreadMaster;
import org.eclipse.soda.dk.transport.service.ChannelStateService;
import org.eclipse.soda.dk.transport.service.ControllerService;
import org.eclipse.soda.dk.transport.service.MultiplexMessageListener;
import org.eclipse.soda.dk.transport.service.MultiplexTransportListener;
import org.eclipse.soda.dk.transport.service.TransportListener;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.osgi.service.log.LogService;

public class Controller
extends ControllerQueue
implements ControllerService,
Runnable {
    private static final long serialVersionUID = -8946351256395220870L;
    public static final Integer TRANSPORT_STARTED_NO_OUTPUT = EscObject.createInteger((int)-5);
    public static final Integer TRANSPORT_STARTED_VALUE = EscObject.createInteger((int)5);
    public static final int MESSAGE_STATUS_UNKNOWN = 0;
    public static final int MESSAGE_STATUS_OK = 1;
    public static final int MESSAGE_STATUS_ERROR = 2;
    protected static final String CONTROLLER_OPERATION_CLOSE_CHANNEL = "CLOSE_CHANNEL";
    private HashMap channelStates = new HashMap();
    private int queueSizeProblem = 2048;
    protected boolean running = false;
    protected Thread thread;
    protected Transport transport;
    private ChannelSchedule channelSchedule = new ChannelSchedule();

    public Controller(Transport transport, int priority) {
        this.transport = transport;
        ThreadGroup threadGroup = TransportNotificationThreadMaster.getThreadGroupInstance();
        this.thread = new Thread(threadGroup, this, transport.getOutputName());
        this.thread.setDaemon(true);
        this.thread.setPriority(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTransportChannel(ChannelService channel) {
        HashMap hashMap = this.channelStates;
        synchronized (hashMap) {
            ChannelStateService channelState = this.transport.createChannelState(channel);
            this.channelStates.put(channel, channelState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelChanged(TransportService source, Object timestamp, ChannelService channel, int newState, int oldState) {
        ChannelStateService channelState = this.getChannelState(channel);
        if (newState != 0 && channelState == null) {
            this.addTransportChannel(channel);
        }
        if (channelState != null) {
            if (newState < 3 && oldState >= 3) {
                this.channelSchedule.remove(channelState);
            }
            if (Thread.currentThread() == this.thread) {
                this.channelChangedSend(source, timestamp, channelState, newState, oldState);
            } else {
                this.enqueue(timestamp, new Object[]{channelState, Controller.createInteger((int)newState), Controller.createInteger((int)oldState)});
                Controller controller = this;
                synchronized (controller) {
                    this.notifyAll();
                }
            }
        }
        if (newState == 0) {
            this.removeTransportChannel(channelState);
        }
    }

    public void channelChangedSend(TransportService source, Object timestamp, ChannelStateService channelState, int newState, int oldState) {
        block10: {
            MultiplexTransportListener listener = (MultiplexTransportListener)this.transport.getTransportListener();
            ChannelService channel = channelState.getChannel();
            if (newState >= 3 && oldState < 3) {
                this.scheduleTimeout(channelState, timestamp, this.transport.getNoActivityTimeout());
            }
            if (listener != null) {
                try {
                    listener.channelChanged(source, timestamp, channel, newState, oldState);
                }
                catch (RuntimeException exception) {
                    this.transport.handleError(exception, 2018);
                }
            }
            if (newState == 4 && oldState < 4) {
                try {
                    int startupState = this.transport.startup(channel);
                    if (startupState == 5) {
                        channel.setState(5);
                    }
                    break block10;
                }
                catch (Exception exception) {
                    if (EscObject.isTrace()) {
                        this.transport.handleError(exception, 2009);
                    }
                    break block10;
                }
            }
            if (newState == 1 && oldState >= 1 && channel.isReconnectable()) {
                channelState.setState(4);
                this.scheduleTimeout(channelState, timestamp, this.transport.getRetryTime());
            }
        }
    }

    public void closeTransportChannel(ChannelStateService channelState, boolean force) {
        if (channelState != null) {
            if (Thread.currentThread() == this.thread) {
                this.doCloseTransportChannel(channelState, force);
            } else {
                this.enqueue(EscObject.getCurrentTimestamp(), new Object[]{channelState, CONTROLLER_OPERATION_CLOSE_CHANNEL});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTransportChannels() {
        try {
            HashMap hashMap = this.channelStates;
            synchronized (hashMap) {
                int count = this.transport.getTransmitRetries() + 1;
                while (!this.channelStates.isEmpty() && count-- > 0) {
                    Map clone = (Map)this.channelStates.clone();
                    Iterator iterator = clone.values().iterator();
                    while (iterator.hasNext()) {
                        ChannelState channelState = (ChannelState)iterator.next();
                        this.closeTransportChannel(channelState, count == 0);
                    }
                    if (this.channelStates.isEmpty()) continue;
                    this.channelStates.wait(this.transport.getRetryTime());
                }
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCloseTransportChannel(ChannelStateService channelState, boolean force) {
        ChannelStateService channelStateService = channelState;
        synchronized (channelStateService) {
            if (channelState.getPendingResponseCount() <= 0 || force) {
                ChannelService channel = channelState.getChannel();
                if (channel == null) {
                    this.removeTransportChannel(channelState);
                } else {
                    channel.exit();
                }
            }
        }
    }

    protected void enqueueRestartTransport() {
        this.enqueue(EscObject.getCurrentTimestamp(), TRANSPORT_STARTED_VALUE);
    }

    protected void enqueueRestartTransportNoOutput() {
        this.enqueue(EscObject.getCurrentTimestamp(), TRANSPORT_STARTED_NO_OUTPUT);
    }

    public void errorOccurred(Object source, Object timestamp, Object data) {
        if (data == null) {
            this.enqueue(timestamp, source);
        } else {
            this.enqueue(timestamp, new Object[]{source, data});
        }
    }

    public void errorOccurredSend(Object source, Object timestamp, Object data) {
        TransportListener listener = this.transport.getTransportListener();
        if (listener != null) {
            try {
                listener.errorOccurred((Object)this, timestamp, data);
            }
            catch (RuntimeException exception) {
                this.transport.handleError(exception, 2022);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelStateService getChannelState(ChannelService channel) {
        HashMap hashMap = this.channelStates;
        synchronized (hashMap) {
            return (ChannelStateService)this.channelStates.get(channel);
        }
    }

    public int getQueueSizeProblem() {
        return this.queueSizeProblem;
    }

    public void messageReceived(TransportService transportService, Object timestamp, ChannelService channel, MessageService message) {
        block18: {
            try {
                if (channel == null) {
                    if (this.transport.getState() < 5) {
                        this.transport.startupMessageReceived(transportService, timestamp, channel, message);
                        if (EscObject.getTraceLevel() >= 5) {
                            this.transport.report(null, 2025, message, this.transport.getHistory());
                        }
                    } else if (this.transport.getTransportListener() != null) {
                        if (this.transport.getInterestMask().isInterested(message)) {
                            this.enqueue(timestamp, message);
                        } else if (EscObject.getTraceLevel() >= 5) {
                            this.transport.report(null, 2026, message);
                        }
                    }
                } else {
                    ChannelStateService channelState = this.getChannelState(channel);
                    if (channelState == null || channel.getState() < 5) {
                        this.transport.startupMessageReceived(transportService, timestamp, channel, message);
                        if (EscObject.getTraceLevel() >= 5) {
                            this.transport.report(null, 2025, message, this.transport.getHistory());
                        }
                    } else if (this.transport.getTransportListener() != null) {
                        if (this.transport.getInterestMask().isInterested(message)) {
                            this.enqueue(timestamp, new Object[]{channelState, message});
                        } else if (EscObject.getTraceLevel() >= 5) {
                            this.transport.report(null, 2026, message);
                        }
                    }
                }
            }
            catch (RuntimeException exception) {
                if (!this.transport.isLogging(1)) break block18;
                this.transport.handleError(exception, 2019);
            }
        }
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        this.messageReceived(transportService, timestamp, null, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTransportChannel(ChannelStateService channelState) {
        HashMap hashMap = this.channelStates;
        synchronized (hashMap) {
            if (channelState != null) {
                channelState.setState(6);
                this.channelStates.remove(channelState.getChannel());
            }
            if (this.channelStates.isEmpty()) {
                this.channelStates.notify();
            }
        }
    }

    private void restart(ChannelStateService channelState) {
        channelState.setState(2);
        ChannelService channel = channelState.getChannel();
        if (channel == null) {
            this.channelSchedule.removeAll();
            this.restartTransport();
        } else {
            this.channelSchedule.remove(channelState);
            if (channel.isReconnectable()) {
                channel.close();
            } else {
                channel.exit();
            }
        }
    }

    public void restartTransport() {
        int count = this.size();
        if (count > 0) {
            Object[] objects = new Object[2];
            int index = 0;
            while (index < count) {
                this.getFirst(objects);
                if (objects[0] != null && (objects[1] instanceof Boolean || objects[1] instanceof Integer)) {
                    return;
                }
                ++index;
            }
        }
        this.enqueueRestartTransport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object[] objects = new Object[2];
        while (this.running) {
            this.getFirst(objects);
            if (objects[0] == null) {
                try {
                    Controller controller = this;
                    synchronized (controller) {
                        this.getFirst(objects);
                        if (objects[0] == null) {
                            ChannelStateService channelState = this.channelSchedule.getFirst();
                            if (channelState == null) {
                                this.wait(this.transport.getNoActivityTimeout());
                            } else {
                                long delay = channelState.getTimeout() - System.currentTimeMillis();
                                if (delay > 0L) {
                                    this.wait(delay);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                if (!this.running) {
                    return;
                }
                this.getFirst(objects);
                if (objects[0] == null) {
                    ChannelStateService channelState;
                    if (this.running && (channelState = this.channelSchedule.getFirst()) != null && channelState.getTimeout() - System.currentTimeMillis() <= 0L) {
                        ChannelService channel = channelState.getChannel();
                        block6 : switch (channelState.getState()) {
                            case 1: {
                                this.restart(channelState);
                                break;
                            }
                            case 3: {
                                try {
                                    int status = this.transport.noResponseProcessing(channel);
                                    switch (status) {
                                        case 1: {
                                            break block6;
                                        }
                                    }
                                    this.restart(channelState);
                                }
                                catch (RuntimeException exception) {
                                    this.handleError(exception, 1);
                                }
                                break;
                            }
                            case 4: {
                                this.scheduleTimeout(channelState, null, this.transport.getRetryTime());
                                if (channel == null) break;
                                channel.open();
                                break;
                            }
                            case 5: {
                                this.channelSchedule.remove(channelState);
                                this.doCloseTransportChannel(channelState, true);
                                break;
                            }
                            case 6: {
                                this.channelSchedule.remove(channelState);
                                break;
                            }
                            default: {
                                int status = this.transport.noActivityProcessing(channel);
                                switch (status) {
                                    case 0: {
                                        this.channelSchedule.remove(channelState);
                                        channelState.setState(2);
                                        this.transport.report(null, 2037, Controller.createNumber((long)this.transport.getNoActivityTimeout()), this.transport.getHistory());
                                        if (channel == null) {
                                            this.transportChangedSend(this.transport, EscObject.getCurrentTimestamp(), 5, 5);
                                            break block6;
                                        }
                                        if (channel.getState() != 5) break block6;
                                        this.channelChangedSend(this.transport, EscObject.getCurrentTimestamp(), channelState, 5, 5);
                                        break block6;
                                    }
                                    case 1: {
                                        this.scheduleTimeout(channelState, null, this.transport.getRetryTime());
                                        channelState.setState(1);
                                        break block6;
                                    }
                                    default: {
                                        this.restart(channelState);
                                    }
                                }
                            }
                        }
                    }
                    this.getFirst(objects);
                }
            }
            while (objects[0] != null) {
                TransportListener listener;
                if (!this.running) {
                    return;
                }
                Object timestamp = objects[0];
                Object object = objects[1];
                if (object instanceof Object[]) {
                    Object[] complexEvent = (Object[])object;
                    Object source = complexEvent[0];
                    Object data = complexEvent[1];
                    if (source instanceof ChannelState) {
                        ChannelState channelState = (ChannelState)source;
                        ChannelService channel = channelState.getChannel();
                        if (data instanceof MessageService) {
                            MessageService message = (MessageService)data;
                            channelState.setState(0);
                            if (timestamp == null) {
                                this.transport.send(channel, message);
                            } else {
                                MultiplexTransportListener listener2 = (MultiplexTransportListener)this.transport.getTransportListener();
                                if (listener2 != null) {
                                    try {
                                        listener2.messageReceived((TransportService)this.transport, timestamp, channel, message);
                                    }
                                    catch (RuntimeException exception) {
                                        this.handleError(exception, 1);
                                    }
                                    if (EscObject.getTraceLevel() >= 5 && this.transport.isLogging(this.transport.getErrorSeverity(2023, null))) {
                                        this.transport.report(null, 2023, message, this.transport.getHistory());
                                    }
                                }
                            }
                        } else if (data instanceof Integer) {
                            int newState = (Integer)data;
                            int oldState = (Integer)complexEvent[2];
                            this.channelChangedSend(this.transport, timestamp, channelState, newState, oldState);
                        } else if (data instanceof String && data == CONTROLLER_OPERATION_CLOSE_CHANNEL) {
                            if (channelState.getState() < 5) {
                                channelState.setState(5);
                            }
                            this.doCloseTransportChannel(channelState, true);
                        }
                    } else {
                        TransportListener listener3 = this.transport.getTransportListener();
                        if (listener3 != null) {
                            this.errorOccurredSend(source, timestamp, data);
                        }
                    }
                } else if (object instanceof MessageService) {
                    MessageService message = (MessageService)objects[1];
                    if (timestamp == null) {
                        this.transport.send(message);
                    } else {
                        TransportListener listener4 = this.transport.getTransportListener();
                        if (listener4 != null) {
                            try {
                                if (listener4 instanceof MultiplexMessageListener) {
                                    ((MultiplexMessageListener)listener4).messageReceived((TransportService)this.transport, timestamp, null, message);
                                } else {
                                    listener4.messageReceived((TransportService)this.transport, timestamp, message);
                                }
                            }
                            catch (RuntimeException exception) {
                                this.handleError(exception, 1);
                            }
                            if (EscObject.getTraceLevel() >= 5 && this.transport.isLogging(this.transport.getErrorSeverity(2023, null))) {
                                this.transport.report(null, 2023, message, this.transport.getHistory());
                            }
                        }
                    }
                } else if (object instanceof Boolean) {
                    boolean output = (Boolean)object;
                    this.dequeueFirst();
                    object = null;
                    this.startProcessing(output);
                } else if (object instanceof String) {
                    LogService logService = this.transport.getLogService();
                    logService.log(4, object.toString());
                } else if (object instanceof Integer) {
                    boolean output = (Integer)object >= 0;
                    this.dequeueFirst();
                    object = null;
                    this.transport.restartProcessing(output);
                } else if (object instanceof int[]) {
                    int[] intData = (int[])object;
                    int newState = intData[0];
                    int oldState = intData[1];
                    this.transportChangedSend(this.transport, timestamp, newState, oldState);
                } else if (object instanceof TransportService && (listener = this.transport.getTransportListener()) != null) {
                    this.errorOccurredSend(object, timestamp, null);
                }
                if (object != null) {
                    this.dequeueFirst();
                }
                this.getFirst(objects);
            }
        }
    }

    public void scheduleTimeout(ChannelStateService channelState, Object startTime, long timeout) {
        Object timestamp = startTime == null ? Controller.getCurrentTimestamp() : startTime;
        this.channelSchedule.scheduleTimeout(channelState, timestamp, timeout);
    }

    public void setQueueSizeProblem(int queueSizeProblem) {
        this.queueSizeProblem = queueSizeProblem;
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    public void start(boolean output) {
        this.addTransportChannel(null);
        this.enqueue(EscObject.getCurrentTimestamp(), output ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * Exception decompiling
     */
    public void startProcessing(boolean output) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join(10000L);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (InterruptedException interruptedException) {}
            this.thread = null;
        }
    }

    public void stop(boolean output) {
    }

    public void trace(String debugMessage) {
        this.enqueue(EscObject.getCurrentTimestamp(), debugMessage);
    }

    public void transportChanged(TransportService transportService, Object timestamp, int newState, int oldState) {
        if (Thread.currentThread() == this.thread) {
            this.transportChangedSend(transportService, timestamp, newState, oldState);
        } else {
            this.enqueue(timestamp, new int[]{newState, oldState});
        }
    }

    public void transportChangedSend(TransportService source, Object timestamp, int newState, int oldState) {
        TransportListener listener = this.transport.getTransportListener();
        if (listener != null) {
            try {
                listener.transportChanged(source, timestamp, newState, oldState);
            }
            catch (RuntimeException exception) {
                this.transport.handleError(exception, 2018);
            }
        }
        if (newState == 0) {
            this.stop();
        }
    }
}

