/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.container.test;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainer;
import org.eclipse.soda.sat.core.record.container.interfaces.IImportServiceRecordContainerOwner;
import org.eclipse.soda.sat.core.record.container.interfaces.IServiceRecordAction;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IServiceRecord;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;

public class ImportServiceRecordContainerTestCase
extends AbstractServiceTestCase {
    private static final String COMPANY_KEY = "company";
    private static final String IBM_ORG = "IBM";
    private static final String ECLIPSE_ORG = "Eclipse";
    private static final String OTI_ORG = "OTI";
    private IImportServiceRecordContainer container;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static Test suite() {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.test.ImportServiceRecordContainerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ImportServiceRecordContainerTestCase(String name) {
        super(name);
    }

    private IImportServiceRecordContainerOwner createNoOpImportServiceRecordContainerOwner() {
        return new ImportServiceRecordContainerOwnerAdapter();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.container = AbstractSatTestCase.FACTORY.createImportServiceRecordContainer();
    }

    protected void tearDown() throws Exception {
        this.container = null;
        super.tearDown();
    }

    public void test_acquire() {
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service1 = new TestServiceImplementation();
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        TestServiceImplementation service2 = new TestServiceImplementation();
        ServiceRegistration registration2 = context.registerService(TestService2.SERVICE_NAME, (Object)service2, null);
        IImportServiceRecord record1 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        this.container.add(record1);
        IImportServiceRecord record2 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
        this.container.add(record2);
        final ValueHolder holder = ValueHolder.nullValue();
        ImportServiceRecordContainerOwnerAdapter owner = new ImportServiceRecordContainerOwnerAdapter(){

            public void acquired(IImportServiceRecordContainer container) {
                holder.setValue((Object)container);
            }
        };
        this.container.setOwner((IImportServiceRecordContainerOwner)owner);
        this.container.acquire();
        IImportServiceRecordContainer expected = this.container;
        Object actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        holder.setNull();
        registration1.unregister();
        expected = null;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        expected = this.container;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        holder.setNull();
        ServiceRegistration registration3 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        expected = null;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        registration1.unregister();
        expected = this.container;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        registration3.unregister();
        this.container.release();
        this.container.setOwner(null);
        this.container.acquire();
        registration2.unregister();
    }

    public void test_add() {
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service1 = new TestServiceImplementation();
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        TestServiceImplementation service2 = new TestServiceImplementation();
        ServiceRegistration registration2 = context.registerService(TestService2.SERVICE_NAME, (Object)service2, null);
        IImportServiceRecord record1 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        boolean added = this.container.add(record1);
        Assert.assertTrue((boolean)added);
        int expectedSize = 1;
        int actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        added = this.container.add(record1);
        Assert.assertFalse((boolean)added);
        expectedSize = 1;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        final ValueHolder acquiredHolder = ValueHolder.falseValue();
        final ValueHolder releasedHolder = ValueHolder.falseValue();
        IImportServiceRecordContainerOwner owner = new IImportServiceRecordContainerOwner(){

            public void acquired(IImportServiceRecordContainer container) {
                acquiredHolder.setTrue();
                releasedHolder.setFalse();
            }

            public void released(IImportServiceRecordContainer container) {
                acquiredHolder.setFalse();
                releasedHolder.setTrue();
            }
        };
        this.container.setOwner(owner);
        this.container.acquire();
        IImportServiceRecord record2 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
        this.container.add(record2);
        boolean acquired = acquiredHolder.isTrue();
        Assert.assertTrue((boolean)acquired);
        boolean released = releasedHolder.isFalse();
        Assert.assertTrue((boolean)released);
        acquired = record2.isAcquired();
        Assert.assertTrue((boolean)acquired);
        boolean removed = this.container.remove(record2);
        Assert.assertTrue((boolean)removed);
        acquired = acquiredHolder.isTrue();
        Assert.assertTrue((boolean)acquired);
        released = releasedHolder.isFalse();
        Assert.assertTrue((boolean)released);
        acquired = record2.isAcquired();
        Assert.assertFalse((boolean)acquired);
        this.container.add(record2);
        acquired = acquiredHolder.isTrue();
        Assert.assertTrue((boolean)acquired);
        released = releasedHolder.isFalse();
        Assert.assertTrue((boolean)released);
        acquired = record2.isAcquired();
        Assert.assertTrue((boolean)acquired);
        expectedSize = 2;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        this.container.release();
        IImportServiceRecord record3 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService3.SERVICE_NAME, null);
        added = this.container.add(record3);
        Assert.assertTrue((boolean)added);
        expectedSize = 3;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        registration1.unregister();
        registration2.unregister();
    }

    public void test_contains() {
        BundleContext context = this.getBundleContext();
        IImportServiceRecord record1 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        this.container.add(record1);
        IImportServiceRecord record2 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
        this.container.add(record2);
        IImportServiceRecord record3 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService3.SERVICE_NAME, null);
        this.container.add(record3);
        boolean exists = this.container.contains((IServiceRecord)record1);
        Assert.assertTrue((boolean)exists);
        exists = this.container.contains((IServiceRecord)record2);
        Assert.assertTrue((boolean)exists);
        exists = this.container.contains((IServiceRecord)record3);
        Assert.assertTrue((boolean)exists);
        IImportServiceRecord record4 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService3.SERVICE_NAME, null);
        exists = this.container.contains((IServiceRecord)record4);
        Assert.assertFalse((boolean)exists);
        this.container.remove(record2);
        exists = this.container.contains((IServiceRecord)record2);
        Assert.assertFalse((boolean)exists);
    }

    public void test_doForEach() {
        BundleContext context = this.getBundleContext();
        int count = 3;
        int i = 0;
        while (i < count) {
            IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
            this.container.add(record);
            ++i;
        }
        IServiceRecordAction action = new IServiceRecordAction(){

            public boolean execute(IServiceRecord record, Object parameter) {
                List list = (List)parameter;
                list.add(record);
                return true;
            }
        };
        ArrayList list = new ArrayList(3);
        this.container.doForEach(action, list);
        int expectedSize = count;
        int actualSize = list.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void test_empty() {
        BundleContext context = this.getBundleContext();
        int count = 3;
        int i = 0;
        while (i < count) {
            IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
            this.container.add(record);
            ++i;
        }
        this.container.empty();
        boolean empty = this.container.isEmpty();
        Assert.assertTrue((boolean)empty);
    }

    public void test_get() throws InvalidSyntaxException {
        BundleContext context = this.getBundleContext();
        IImportServiceRecord record1 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        this.container.add(record1);
        IImportServiceRecord record2 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
        this.container.add(record2);
        IImportServiceRecord expected = record1;
        IServiceRecord actual = this.container.get(TestService1.SERVICE_NAME);
        Assert.assertSame((Object)expected, (Object)actual);
        expected = record2;
        actual = this.container.get(TestService2.SERVICE_NAME);
        Assert.assertSame((Object)expected, (Object)actual);
        TestServiceImplementation service = new TestServiceImplementation();
        ServiceRegistration registration = context.registerService(TestService1.SERVICE_NAME, (Object)service, null);
        Filter filter = context.createFilter("(company=IBM)");
        IImportServiceRecord record3 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, filter);
        this.container.add(record3);
        IImportServiceRecordContainerOwner owner = this.createNoOpImportServiceRecordContainerOwner();
        this.container.setOwner(owner);
        this.container.acquire();
        expected = record1;
        actual = this.container.get(TestService1.SERVICE_NAME, (Object)service);
        Assert.assertSame((Object)expected, (Object)actual);
        try {
            this.container.get(TestService1.SERVICE_NAME, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        this.container.release();
        registration.unregister();
    }

    public void test_getAll() {
        IImportServiceRecord record;
        BundleContext context = this.getBundleContext();
        int count = 3;
        int i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
            this.container.add(record);
            record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
            this.container.add(record);
            ++i;
        }
        record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        this.container.add(record);
        IServiceRecord[] objects = this.container.getAll();
        int expectedLength = count * 2 + 1;
        int actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        objects = this.container.getAll(TestService1.SERVICE_NAME);
        expectedLength = count + 1;
        actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        objects = this.container.getAll(TestService2.SERVICE_NAME);
        expectedLength = count;
        actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        objects = this.container.getAll(TestService3.SERVICE_NAME);
        expectedLength = 0;
        actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
        this.container.empty();
        objects = this.container.getAll(TestService1.SERVICE_NAME);
        expectedLength = 0;
        actualLength = objects.length;
        Assert.assertEquals((int)expectedLength, (int)actualLength);
    }

    public void test_getWithFilter() throws InvalidSyntaxException {
        BundleContext context = this.getBundleContext();
        Filter filter1 = context.createFilter("(company=IBM)");
        Filter filter2 = context.createFilter("(company=Eclipse)");
        Filter filter3 = context.createFilter("(company=OTI)");
        IImportServiceRecord record1 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, filter1);
        this.container.add(record1);
        IImportServiceRecord record2 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, filter2);
        this.container.add(record2);
        IImportServiceRecord expected = record1;
        IImportServiceRecord actual = this.container.getWithFilter(TestService1.SERVICE_NAME, filter1);
        Assert.assertSame((Object)expected, (Object)actual);
        expected = record2;
        actual = this.container.getWithFilter(TestService1.SERVICE_NAME, filter2);
        Assert.assertSame((Object)expected, (Object)actual);
        expected = null;
        actual = this.container.getWithFilter(TestService1.SERVICE_NAME, filter3);
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public void test_isAcquired() {
        BundleContext context = this.getBundleContext();
        final ValueHolder holder = ValueHolder.nullValue();
        ImportServiceRecordContainerOwnerAdapter owner = new ImportServiceRecordContainerOwnerAdapter(){

            public void acquired(IImportServiceRecordContainer container) {
                holder.setValue((Object)container);
            }
        };
        this.container.setOwner((IImportServiceRecordContainerOwner)owner);
        this.container.acquire();
        IImportServiceRecordContainer expected = this.container;
        Object actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        holder.setNull();
        this.container.release();
        IImportServiceRecord record1 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        boolean added = this.container.add(record1);
        Assert.assertTrue((boolean)added);
        IImportServiceRecord record2 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
        added = this.container.add(record2);
        Assert.assertTrue((boolean)added);
        this.container.acquire();
        expected = null;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        TestServiceImplementation service1 = new TestServiceImplementation();
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        TestServiceImplementation service2 = new TestServiceImplementation();
        ServiceRegistration registration2 = context.registerService(TestService2.SERVICE_NAME, (Object)service2, null);
        expected = this.container;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        holder.setNull();
        registration2.unregister();
        expected = null;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        registration1.unregister();
        this.container.release();
    }

    public void test_isEmpty() {
        BundleContext context = this.getBundleContext();
        int count = 3;
        boolean empty = this.container.isEmpty();
        Assert.assertTrue((boolean)empty);
        int i = 0;
        while (i < count) {
            IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
            this.container.add(record);
            ++i;
        }
        empty = this.container.isEmpty();
        Assert.assertFalse((boolean)empty);
    }

    public void test_release() {
        BundleContext context = this.getBundleContext();
        TestServiceImplementation service1 = new TestServiceImplementation();
        ServiceRegistration registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        TestServiceImplementation service2 = new TestServiceImplementation();
        ServiceRegistration registration2 = context.registerService(TestService2.SERVICE_NAME, (Object)service2, null);
        IImportServiceRecord record1 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        this.container.add(record1);
        IImportServiceRecord record2 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
        this.container.add(record2);
        final ValueHolder holder = ValueHolder.nullValue();
        ImportServiceRecordContainerOwnerAdapter owner = new ImportServiceRecordContainerOwnerAdapter(){

            public void released(IImportServiceRecordContainer container) {
                holder.setValue((Object)container);
            }
        };
        this.container.setOwner((IImportServiceRecordContainerOwner)owner);
        this.container.acquire();
        registration1.unregister();
        IImportServiceRecordContainer expected = this.container;
        Object actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        holder.setNull();
        this.container.release();
        expected = null;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        this.container.acquire();
        registration1 = context.registerService(TestService1.SERVICE_NAME, (Object)service1, null);
        this.container.release();
        expected = this.container;
        actual = holder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        registration2.unregister();
        registration1.unregister();
    }

    public void test_remove() {
        BundleContext context = this.getBundleContext();
        IImportServiceRecord record1 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
        this.container.add(record1);
        IImportServiceRecord record2 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
        this.container.add(record2);
        IImportServiceRecord record3 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService3.SERVICE_NAME, null);
        this.container.add(record3);
        int expectedSize = 3;
        int actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        IImportServiceRecord record4 = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService3.SERVICE_NAME, null);
        boolean removed = this.container.remove(record4);
        Assert.assertFalse((boolean)removed);
        expectedSize = 3;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        removed = this.container.remove(record1);
        Assert.assertTrue((boolean)removed);
        expectedSize = 2;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        removed = this.container.remove(record2);
        Assert.assertTrue((boolean)removed);
        expectedSize = 1;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        removed = this.container.remove(record3);
        Assert.assertTrue((boolean)removed);
        expectedSize = 0;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    public void test_removeAll() {
        boolean added;
        IImportServiceRecord record;
        BundleContext context = this.getBundleContext();
        int count = 3;
        int i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
            added = this.container.add(record);
            Assert.assertTrue((boolean)added);
            ++i;
        }
        int expectedSize = count;
        int actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.removeAll(TestService1.SERVICE_NAME);
        expectedSize = 0;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        i = 0;
        while (i < count) {
            record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
            added = this.container.add(record);
            Assert.assertTrue((boolean)added);
            record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService2.SERVICE_NAME, null);
            added = this.container.add(record);
            Assert.assertTrue((boolean)added);
            ++i;
        }
        expectedSize = count * 2;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.removeAll(TestService1.SERVICE_NAME);
        expectedSize = count;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.removeAll(TestService3.SERVICE_NAME);
        expectedSize = count;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
        this.container.removeAll(TestService2.SERVICE_NAME);
        expectedSize = 0;
        actualSize = this.container.size();
        Assert.assertEquals((int)actualSize, (int)expectedSize);
    }

    public void test_size() {
        BundleContext context = this.getBundleContext();
        int count = 3;
        int expectedSize = 0;
        int actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
        int i = 0;
        while (i < count) {
            IImportServiceRecord record = AbstractSatTestCase.FACTORY.createImportServiceRecord(context, TestService1.SERVICE_NAME, null);
            this.container.add(record);
            ++i;
        }
        expectedSize = count;
        actualSize = this.container.size();
        Assert.assertEquals((int)expectedSize, (int)actualSize);
    }

    private static class ImportServiceRecordContainerOwnerAdapter
    implements IImportServiceRecordContainerOwner {
        private ImportServiceRecordContainerOwnerAdapter() {
        }

        public void acquired(IImportServiceRecordContainer container) {
        }

        public void released(IImportServiceRecordContainer container) {
        }

        /* synthetic */ ImportServiceRecordContainerOwnerAdapter(ImportServiceRecordContainerOwnerAdapter importServiceRecordContainerOwnerAdapter, ImportServiceRecordContainerOwnerAdapter importServiceRecordContainerOwnerAdapter2) {
            this();
        }
    }

    private static interface TestService1 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.test.ImportServiceRecordContainerTestCase$TestService1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static interface TestService2 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.test.ImportServiceRecordContainerTestCase$TestService2");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static interface TestService3 {
        public static final String SERVICE_NAME;

        static {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.soda.sat.core.internal.record.container.test.ImportServiceRecordContainerTestCase$TestService3");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SERVICE_NAME = clazz.getName();
        }
    }

    private static class TestServiceImplementation
    implements TestService1,
    TestService2 {
        private TestServiceImplementation() {
        }
    }
}

