/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.record.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Dictionary;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.ProxyServiceHandlerAdapter;
import org.eclipse.soda.sat.core.framework.interfaces.IProxyServiceHandler;
import org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;
import org.eclipse.soda.sat.core.record.interfaces.IExportProxyServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IExportServiceRecord;
import org.eclipse.soda.sat.core.util.MiscUtility;
import org.osgi.framework.BundleContext;

public class ExportProxyServiceRecordTestCase
extends AbstractExportServiceRecordTestCase {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.ExportProxyServiceRecordTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ExportProxyServiceRecordTestCase(String name) {
        super(name);
    }

    protected IExportServiceRecord createExportServiceRecord(BundleContext context, Class[] types, Dictionary properties) {
        ProxyServiceHandlerAdapter handler = new ProxyServiceHandlerAdapter(){

            public Object createService() {
                return ExportProxyServiceRecordTestCase.this.getService();
            }
        };
        IExportProxyServiceRecord record = AbstractSatTestCase.FACTORY.createExportProxyServiceRecord(context, types, (IProxyServiceHandler)handler, properties);
        return record;
    }

    public void test_getService() {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        IExportProxyServiceRecord record = (IExportProxyServiceRecord)this.createExportServiceRecord(context, types, null);
        Object expected = this.getService();
        Object actual = record.getRealService();
        Assert.assertSame((Object)expected, (Object)actual);
        record.register();
        actual = record.getRealService();
        Assert.assertSame((Object)expected, (Object)actual);
        record.unregister();
        actual = record.getRealService();
        Assert.assertSame((Object)expected, (Object)actual);
    }

    public void test_isProxy() {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        IExportServiceRecord record = this.createExportServiceRecord(context, types, null);
        boolean isProxy = record.isProxy();
        Assert.assertTrue((boolean)isProxy);
    }

    public void test_ProxyEquality() {
        Object service1;
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        IExportProxyServiceRecord record = (IExportProxyServiceRecord)this.createExportServiceRecord(context, types, null);
        Object service2 = service1 = record.getService();
        boolean equal = service1.equals(service1);
        Assert.assertTrue((boolean)equal);
        equal = service1.equals(service2);
        Assert.assertTrue((boolean)equal);
        equal = service1.equals(new Object());
        Assert.assertFalse((boolean)equal);
        equal = service1.equals(null);
        Assert.assertFalse((boolean)equal);
        Object realService = record.getRealService();
        equal = service1.equals(realService);
        Assert.assertTrue((boolean)equal);
    }

    public void test_ProxyHashcode() {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        IExportServiceRecord record = this.createExportServiceRecord(context, types, null);
        Object service1 = record.getService();
        int hashCode1 = service1.hashCode();
        int hashCode2 = service1.hashCode();
        Assert.assertEquals((int)hashCode1, (int)hashCode2);
        Object service2 = service1;
        hashCode2 = service2.hashCode();
        Assert.assertEquals((int)hashCode1, (int)hashCode2);
    }

    public void test_ProxyUnwrapping() {
        BundleContext context = this.getBundleContext();
        Class[] classArray = new Class[1];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] types = classArray;
        IExportProxyServiceRecord record = (IExportProxyServiceRecord)this.createExportServiceRecord(context, types, null);
        Object realService = record.getRealService();
        Object service = record.getService();
        MiscUtility utility = MiscUtility.getInstance();
        Object unwrappedService = utility.unwrapExportedServiceProxy(service);
        Assert.assertSame((Object)realService, (Object)unwrappedService);
        try {
            utility.unwrapExportedServiceProxy(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            utility.unwrapExportedServiceProxy(new Object());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        final AbstractExportServiceRecordTestCase.TestService1 testService1 = (AbstractExportServiceRecordTestCase.TestService1)this.getService();
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
                return method.invoke((Object)testService1, parameters);
            }
        };
        Class<?> clazz2 = testService1.getClass();
        ClassLoader classLoader = clazz2.getClassLoader();
        Class[] classArray2 = new Class[1];
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.soda.sat.core.internal.record.test.AbstractExportServiceRecordTestCase$TestService1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz3;
        Class[] interfaces = classArray2;
        Object proxy = Proxy.newProxyInstance(classLoader, interfaces, handler);
        try {
            utility.unwrapExportedServiceProxy(proxy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
    }
}

