/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.ILineWriter;
import org.eclipse.soda.sat.core.junit.internal.AbstractSatTestCase;

public class LineWriterTestCase
extends AbstractSatTestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.util.test.LineWriterTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public LineWriterTestCase(String name) {
        super(name);
    }

    private ILineWriter createLineWriter(OutputStream outputStream) {
        ILineWriter writer = AbstractSatTestCase.FACTORY.createLineWriter(outputStream);
        return writer;
    }

    private ILineWriter createLineWriter(OutputStream outputStream, String characterEncoding) {
        ILineWriter writer = AbstractSatTestCase.FACTORY.createLineWriter(outputStream, characterEncoding);
        return writer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_flush() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ILineWriter writer = this.createLineWriter(outputStream);
        try {
            writer.write("one");
            String expected = new String();
            String value = outputStream.toString();
            Assert.assertEquals((Object)expected, (Object)value);
            writer.flush();
            expected = "one";
            value = outputStream.toString();
            Assert.assertEquals((Object)expected, (Object)value);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        writer.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_newLine() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ILineWriter writer = this.createLineWriter(outputStream);
        try {
            writer.write("one");
            writer.newLine();
            writer.write("two");
            writer.newLine();
            writer.flush();
            String value = outputStream.toString();
            String newline = "\r\n";
            String expected = "one" + newline + "two" + newline;
            Assert.assertEquals((String)expected, (String)value);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        writer.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_write() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ILineWriter writer = this.createLineWriter(outputStream);
        try {
            writer.write("one");
            writer.write("two");
            writer.flush();
            String value = outputStream.toString();
            String expected = "onetwo";
            Assert.assertEquals((Object)expected, (Object)value);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        writer.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_write_japanese() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ILineWriter writer = this.createLineWriter(outputStream, "UTF-8");
        String yamadaTaro = "\u00e5\u00b1\u00b1\u00e7\u201d\u00b0\u00e5\u00a4\u00aa\u00e9\u0192\u017d";
        try {
            writer.write(yamadaTaro);
            writer.flush();
            String value = outputStream.toString();
            Assert.assertEquals((Object)yamadaTaro, (Object)value);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        writer.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_writeLine() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ILineWriter writer = this.createLineWriter(outputStream);
        try {
            writer.writeLine("one");
            writer.writeLine("two");
            writer.flush();
            String value = outputStream.toString();
            String newline = "\r\n";
            String expected = "one" + newline + "two" + newline;
            Assert.assertEquals((Object)expected, (Object)value);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            writer.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        writer.close();
    }
}

