/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.junit.util;

public class ValueHolder {
    private static final Object ZERO = new Integer(0);
    private volatile Object value;

    public static ValueHolder falseValue() {
        return ValueHolder.valueOf(Boolean.FALSE);
    }

    public static ValueHolder nullValue() {
        return ValueHolder.valueOf(null);
    }

    public static ValueHolder trueValue() {
        return ValueHolder.valueOf(Boolean.TRUE);
    }

    public static ValueHolder valueOf(int value) {
        Integer object = new Integer(value);
        ValueHolder holder = new ValueHolder(object);
        return holder;
    }

    public static ValueHolder valueOf(Object value) {
        ValueHolder holder = new ValueHolder(value);
        return holder;
    }

    public static ValueHolder zeroValue() {
        return ValueHolder.valueOf(ZERO);
    }

    protected ValueHolder() {
    }

    protected ValueHolder(Object value) {
        this.setValue(value);
    }

    public void decrement() {
        int value = this.getIntValue();
        this.setValue(value - 1);
    }

    public int getIntValue() {
        Integer wrapper = (Integer)this.getValue();
        int value = wrapper;
        return value;
    }

    public Object getValue() {
        return this.value;
    }

    public void increment() {
        int value = this.getIntValue();
        this.setValue(value + 1);
    }

    public boolean isFalse() {
        boolean result = !this.isTrue();
        return result;
    }

    public boolean isNotNull() {
        boolean result = !this.isNull();
        return result;
    }

    public boolean isNotZero() {
        boolean result = !this.isZero();
        return result;
    }

    public boolean isNull() {
        Object value = this.getValue();
        boolean result = value == null;
        return result;
    }

    public boolean isTrue() {
        Object value = this.getValue();
        boolean result = value == Boolean.TRUE;
        return result;
    }

    public boolean isZero() {
        Object value = this.getValue();
        boolean result = ZERO.equals(value);
        return result;
    }

    public void setFalse() {
        this.setValue(Boolean.FALSE);
    }

    public void setNull() {
        this.setValue(null);
    }

    public void setTrue() {
        this.setValue(Boolean.TRUE);
    }

    public void setValue(boolean value) {
        if (value) {
            this.setTrue();
        } else {
            this.setFalse();
        }
    }

    public void setValue(int value) {
        if (value == 0) {
            this.setZero();
        } else {
            Integer object = new Integer(value);
            this.setValue(object);
        }
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setZero() {
        this.setValue(ZERO);
    }

    public String toString() {
        Object value = this.getValue();
        String result = String.valueOf(value);
        return result;
    }
}

