/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.soda.sat.plugin.activator.ActivatorWizardModelListener;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IExportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.IServiceDetails;
import org.eclipse.soda.sat.plugin.activator.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.internal.ActivatorGenerator;
import org.eclipse.soda.sat.plugin.activator.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.activator.util.ITypeModel;
import org.eclipse.soda.sat.plugin.activator.util.TypeNameSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivatorWizardModel
implements IActivatorWizardModel {
    private static final String INVALID_FILTER_ERROR_KEY = "ActivatorWizardModel.InvalidFilterError";
    private static final short ALL_IMPORTED_SERVICE = 0;
    private static final short REQUIRED_IMPORTED_SERVICE = 1;
    private static final short OPTIONAL_IMPORTED_SERVICE = 2;
    private static final String OSGI_BUNDLE = "org.eclipse.osgi";
    private static final String OSGI_SERVICES_BUNDLE = "org.eclipse.osgi.services";
    private static final String SAT_CORE_BUNDLE = "org.eclipse.soda.sat.core";
    private ITypeModel typeModel;
    private String packageName;
    private String className;
    private String bundleSymbolicName;
    private String propertiesFilename;
    private String lazyBundleActivatorPropertiesFilename;
    private Map<String, String> bundleDependenciesMap;
    private List<ActivatorWizardModelListener> listeners;
    private Map<String, IExportedServiceDetails> exportedServiceDetailsMap;
    private Map<String, IImportedServiceDetails> importedServiceDetailsMap;
    private boolean customActivateAndDeactivate;
    private boolean customStartAndStop;
    private boolean startAsynchronously;
    private boolean createBundleActivatorLazily;
    private int loadPropertiesPolicy;
    private int startAsynchronouslyNormalPriorityDelta;
    private int uninstallPolicy;

    public ActivatorWizardModel(ITypeModel typeModel) {
        this.setTypeModel(typeModel);
        this.setListeners(new ArrayList<ActivatorWizardModelListener>(5));
        this.setBundleDependenciesMap(new HashMap<String, String>(37));
        this.setExportedServiceDetailsMap(new HashMap<String, IExportedServiceDetails>(17));
        this.setImportedServiceDetailsMap(new HashMap<String, IImportedServiceDetails>(17));
        this.setCustomStartAndStop(false);
        this.setCustomActivateAndDeactivate(true);
        this.setStartAsynchronously(false);
        this.setCreateBundleActivatorLazily(false);
        this.setLoadPropertiesPolicy(0);
        this.setStartAsynchronouslyNormalPriorityDelta(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActivatorWizardModelListener(ActivatorWizardModelListener listener) {
        List<ActivatorWizardModelListener> listeners;
        List<ActivatorWizardModelListener> list = listeners = this.getListeners();
        synchronized (list) {
            boolean exists = listeners.contains(listener);
            if (exists) {
                return;
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBundleDependency(String fullyQualifiedName, String bundleSymbolicName) {
        Map<String, String> map;
        Map<String, String> map2 = map = this.getBundleDependenciesMap();
        synchronized (map2) {
            boolean exists = map.containsKey(fullyQualifiedName);
            if (exists) {
                return;
            }
            map.put(fullyQualifiedName, bundleSymbolicName);
        }
        this.notifyListenersOfBundleDependenciesChange();
    }

    @Override
    public void addExportedServiceDetails(IExportedServiceDetails details) {
        Map<String, IExportedServiceDetails> map = this.getExportedServiceDetailsMap();
        boolean added = this.addServiceDetails(map, details);
        if (!added) {
            return;
        }
        this.notifyListenersOfExportedServiceDetailsChange();
    }

    @Override
    public void addImportedServiceDetails(IImportedServiceDetails details) {
        Map<String, IImportedServiceDetails> map = this.getImportedServiceDetailsMap();
        boolean added = this.addServiceDetails(map, details);
        if (!added) {
            return;
        }
        this.notifyListenersOfImportedServiceDetailsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IServiceDetails> boolean addServiceDetails(Map<String, T> map, T details) {
        String key = details.getName();
        Map<String, T> map2 = map;
        synchronized (map2) {
            block4: {
                boolean exists = map.containsKey(key);
                if (!exists) break block4;
                return false;
            }
            map.put(key, details);
        }
        return true;
    }

    @Override
    public boolean containsExportedService(String name) {
        Map<String, IExportedServiceDetails> map = this.getExportedServiceDetailsMap();
        boolean exists = map.containsKey(name);
        return exists;
    }

    @Override
    public boolean containsImportedService(String name) {
        Map<String, IImportedServiceDetails> map = this.getImportedServiceDetailsMap();
        boolean exists = map.containsKey(name);
        return exists;
    }

    @Override
    public String generate() {
        ITypeModel typeModel = this.getTypeModel();
        ActivatorGenerator generator = new ActivatorGenerator(this, typeModel);
        String value = generator.generate();
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getBundleDependencies() {
        Map<String, String> map;
        Map<String, String> map2 = map = this.getBundleDependenciesMap();
        synchronized (map2) {
            Collection<String> values = map.values();
            HashSet<String> set = new HashSet<String>(values);
            int size = set.size() + 3;
            ArrayList<String> list = new ArrayList<String>(size);
            list.add(OSGI_BUNDLE);
            list.add(OSGI_SERVICES_BUNDLE);
            list.add(SAT_CORE_BUNDLE);
            list.addAll(set);
            return list;
        }
    }

    private Map<String, String> getBundleDependenciesMap() {
        return this.bundleDependenciesMap;
    }

    @Override
    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClassName() {
        ActivatorWizardModel activatorWizardModel = this;
        synchronized (activatorWizardModel) {
            if (this.className == null) {
                IActivatorWizardPreferences preferences = this.getPreferences();
                String className = preferences.getClassName();
                this.setClassName(className);
            }
        }
        return this.className;
    }

    @Override
    public boolean getCreateBundleActivatorLazily() {
        return this.createBundleActivatorLazily;
    }

    @Override
    public boolean getCustomActivateAndDeactivate() {
        return this.customActivateAndDeactivate;
    }

    @Override
    public boolean getCustomStartAndStop() {
        return this.customStartAndStop;
    }

    @Override
    public String getDefaultLazyBundleActivatorPropertiesFilename() {
        return "LazyBundleActivator.properties";
    }

    private String getDefaultPropertiesFilename() {
        StringBuffer buffer = new StringBuffer(50);
        String bundleSymbolicName = this.getBundleSymbolicName();
        if (bundleSymbolicName != null) {
            buffer.append(bundleSymbolicName);
            buffer.append(".properties");
        }
        String filename = buffer.toString();
        return filename;
    }

    private Map<String, IExportedServiceDetails> getExportedServiceDetailsMap() {
        return this.exportedServiceDetailsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IExportedServiceDetails> getExportedServicesDetails() {
        Map<String, IExportedServiceDetails> map;
        Map<String, IExportedServiceDetails> map2 = map = this.getExportedServiceDetailsMap();
        synchronized (map2) {
            Collection<IExportedServiceDetails> values = map.values();
            ArrayList<IExportedServiceDetails> list = new ArrayList<IExportedServiceDetails>(values);
            Collections.sort(list);
            return list;
        }
    }

    private Map<String, String> getFilteredImportedServices(boolean optional) {
        Map<String, IImportedServiceDetails> map = this.getImportedServiceDetailsMap();
        int size = map.size();
        int capacity = size * 3;
        Hashtable<String, String> results = new Hashtable<String, String>(capacity);
        Collection<IImportedServiceDetails> values = map.values();
        for (IImportedServiceDetails details : values) {
            boolean match;
            String filter = details.getFilter();
            boolean bl = match = filter != null && filter.length() != 0;
            if (!match) continue;
            boolean isOptional = details.isOptional();
            boolean bl2 = match = isOptional == optional;
            if (!match) continue;
            String key = details.getName();
            results.put(key, filter);
        }
        return results;
    }

    @Override
    public Map<String, String> getFilteredOptionalImportedServices() {
        Map<String, String> map = this.getFilteredImportedServices(true);
        return map;
    }

    @Override
    public Map<String, String> getFilteredRequiredImportedServices() {
        Map<String, String> map = this.getFilteredImportedServices(false);
        return map;
    }

    private Map<String, IImportedServiceDetails> getImportedServiceDetailsMap() {
        return this.importedServiceDetailsMap;
    }

    private List<String> getImportedServices(short type) {
        Map<String, IImportedServiceDetails> map = this.getImportedServiceDetailsMap();
        Collection<IImportedServiceDetails> values = map.values();
        int size = values.size();
        ArrayList<String> list = new ArrayList<String>(size);
        for (IImportedServiceDetails details : values) {
            boolean match = false;
            if (type == 0) {
                match = true;
            } else if (type == 1 && !details.isOptional()) {
                match = true;
            } else if (type == 2 && details.isOptional()) {
                match = true;
            }
            if (!match) continue;
            String name = details.getName();
            list.add(name);
        }
        list.trimToSize();
        TypeNameSorter.sort(list);
        return list;
    }

    @Override
    public List<IImportedServiceDetails> getImportedServicesDetails() {
        Map<String, IImportedServiceDetails> map = this.getImportedServiceDetailsMap();
        Collection<IImportedServiceDetails> values = map.values();
        ArrayList<IImportedServiceDetails> list = new ArrayList<IImportedServiceDetails>(values);
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLazyBundleActivatorPropertiesFilename() {
        ActivatorWizardModel activatorWizardModel = this;
        synchronized (activatorWizardModel) {
            if (this.lazyBundleActivatorPropertiesFilename == null) {
                String filename = this.getDefaultLazyBundleActivatorPropertiesFilename();
                this.setLazyBundleActivatorPropertiesFilename(filename);
            }
        }
        return this.lazyBundleActivatorPropertiesFilename;
    }

    private List<ActivatorWizardModelListener> getListeners() {
        return this.listeners;
    }

    @Override
    public int getLoadPropertiesPolicy() {
        return this.loadPropertiesPolicy;
    }

    @Override
    public List<String> getOptionalImportedServices() {
        return this.getImportedServices((short)2);
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private IActivatorWizardPreferences getPreferences() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IActivatorWizardPreferences preferences = utility.getPreferences();
        return preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPropertiesFilename() {
        ActivatorWizardModel activatorWizardModel = this;
        synchronized (activatorWizardModel) {
            if (this.propertiesFilename == null) {
                String filename = this.getDefaultPropertiesFilename();
                this.setPropertiesFilename(filename);
            }
        }
        return this.propertiesFilename;
    }

    @Override
    public List<String> getRequiredImportedServices() {
        return this.getImportedServices((short)1);
    }

    @Override
    public boolean getStartAsynchronously() {
        return this.startAsynchronously;
    }

    @Override
    public int getStartAsynchronouslyNormalPriorityDelta() {
        return this.startAsynchronouslyNormalPriorityDelta;
    }

    private ITypeModel getTypeModel() {
        return this.typeModel;
    }

    @Override
    public int getUninstallPolicy() {
        return this.uninstallPolicy;
    }

    @Override
    public boolean hasExportedServices() {
        Map<String, IExportedServiceDetails> map = this.getExportedServiceDetailsMap();
        boolean result = !map.isEmpty();
        return result;
    }

    @Override
    public boolean hasImportedServices() {
        Map<String, IImportedServiceDetails> map = this.getImportedServiceDetailsMap();
        boolean result = !map.isEmpty();
        return result;
    }

    @Override
    public boolean isUsingDefaultPropertiesFilename() {
        String defaultPropertiesFilename = this.getDefaultPropertiesFilename();
        String propertiesFilename = this.getPropertiesFilename();
        boolean usingDefault = defaultPropertiesFilename.equals(propertiesFilename);
        return usingDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfBundleDependenciesChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        List<String> bundleDependencies = this.getBundleDependencies();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleBundleDependenciesChanged(bundleDependencies);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfBundleSymbolicNameChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        String value = this.getBundleSymbolicName();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleBundleSymbolicNameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfClassNameChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        String value = this.getClassName();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleClassNameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfCreateBundleActivatorLazilyChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        boolean state = this.getCreateBundleActivatorLazily();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleCreateBundleActivatorLazilyChanged(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfCustomActivateAndDeactivateChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        boolean state = this.getCustomActivateAndDeactivate();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleCustomActivateAndDeactivateChanged(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfCustomStartAndStopChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        boolean state = this.getCustomStartAndStop();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleCustomStartAndStopChanged(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfExportedServiceDetailsChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        boolean empty = listeners.isEmpty();
        if (empty) {
            return;
        }
        List<IExportedServiceDetails> details = this.getExportedServicesDetails();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleExportedServicesChanged(details);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfImportedServiceDetailsChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        boolean empty = listeners.isEmpty();
        if (empty) {
            return;
        }
        List<IImportedServiceDetails> details = this.getImportedServicesDetails();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleImportedServicesChanged(details);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfLazyBundleActivatorPropertiesFilenameChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        String value = this.getLazyBundleActivatorPropertiesFilename();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleLazyBundleActivatorPropertiesFilenameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfLoadPropertiesPolicyChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        int value = this.getLoadPropertiesPolicy();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleLoadPropertiesPolicyChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfPackageNameChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        String value = this.getPackageName();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handlePackageNameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfPropertiesFilenameChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        String value = this.getPropertiesFilename();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handlePropertiesFilenameChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfStartAsynchronouslyChange() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        boolean state = this.getStartAsynchronously();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleStartAsynchronouslyChanged(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfStartAsynchronouslyNormalPriorityDeltaChanged() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        int value = this.getStartAsynchronouslyNormalPriorityDelta();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleStartAsynchronouslyNormalPriorityDeltaChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersOfUninstallPolicyChanged() {
        List<ActivatorWizardModelListener> listeners = this.getListeners();
        int value = this.getUninstallPolicy();
        List<ActivatorWizardModelListener> list = listeners;
        synchronized (list) {
            for (ActivatorWizardModelListener listener : listeners) {
                listener.handleUninstallPolicyChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActivatorWizardModelListener(ActivatorWizardModelListener listener) {
        List<ActivatorWizardModelListener> listeners;
        List<ActivatorWizardModelListener> list = listeners = this.getListeners();
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleDependency(String fullyQualifiedName) {
        Map<String, String> map;
        Map<String, String> map2 = map = this.getBundleDependenciesMap();
        synchronized (map2) {
            boolean removed;
            String value = map.remove(fullyQualifiedName);
            boolean bl = removed = value != null;
            if (!removed) {
                return;
            }
        }
        this.notifyListenersOfBundleDependenciesChange();
    }

    @Override
    public void removeExportedServiceDetails(IExportedServiceDetails details) {
        Map<String, IExportedServiceDetails> map = this.getExportedServiceDetailsMap();
        this.removeServiceDetails(map, details);
        this.notifyListenersOfExportedServiceDetailsChange();
    }

    @Override
    public void removeImportedServiceDetails(IImportedServiceDetails details) {
        Map<String, IImportedServiceDetails> map = this.getImportedServiceDetailsMap();
        this.removeServiceDetails(map, details);
        this.notifyListenersOfImportedServiceDetailsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IServiceDetails> void removeServiceDetails(Map<String, T> map, T details) {
        String key = details.getName();
        Map<String, T> map2 = map;
        synchronized (map2) {
            map.remove(key);
        }
    }

    private void setBundleDependenciesMap(Map<String, String> bundleDependenciesMap) {
        this.bundleDependenciesMap = bundleDependenciesMap;
    }

    @Override
    public void setBundleSymbolicName(String bundleSymbolicName) {
        if (this.bundleSymbolicName != null && this.bundleSymbolicName.equals(bundleSymbolicName)) {
            return;
        }
        this.bundleSymbolicName = bundleSymbolicName;
        this.notifyListenersOfBundleSymbolicNameChange();
    }

    @Override
    public void setClassName(String className) {
        if (this.className != null && this.className.equals(className)) {
            return;
        }
        this.className = className;
        this.notifyListenersOfClassNameChange();
    }

    @Override
    public void setCreateBundleActivatorLazily(boolean createBundleActivatorLazily) {
        if (this.createBundleActivatorLazily == createBundleActivatorLazily) {
            return;
        }
        this.createBundleActivatorLazily = createBundleActivatorLazily;
        this.notifyListenersOfCreateBundleActivatorLazilyChange();
    }

    @Override
    public void setCustomActivateAndDeactivate(boolean customActivateAndDeactivate) {
        if (this.customActivateAndDeactivate == customActivateAndDeactivate) {
            return;
        }
        this.customActivateAndDeactivate = customActivateAndDeactivate;
        this.notifyListenersOfCustomActivateAndDeactivateChange();
    }

    @Override
    public void setCustomStartAndStop(boolean customStartAndStop) {
        if (this.customStartAndStop == customStartAndStop) {
            return;
        }
        this.customStartAndStop = customStartAndStop;
        this.notifyListenersOfCustomStartAndStopChange();
    }

    private void setExportedServiceDetailsMap(Map<String, IExportedServiceDetails> exportedServiceDetailsMap) {
        this.exportedServiceDetailsMap = exportedServiceDetailsMap;
    }

    private void setImportedServiceDetailsMap(Map<String, IImportedServiceDetails> importedServiceDetailsMap) {
        this.importedServiceDetailsMap = importedServiceDetailsMap;
    }

    @Override
    public void setLazyBundleActivatorPropertiesFilename(String lazyBundleActivatorPropertiesFilename) {
        if (this.lazyBundleActivatorPropertiesFilename != null && this.lazyBundleActivatorPropertiesFilename.equals(lazyBundleActivatorPropertiesFilename)) {
            return;
        }
        this.lazyBundleActivatorPropertiesFilename = lazyBundleActivatorPropertiesFilename;
        this.notifyListenersOfLazyBundleActivatorPropertiesFilenameChange();
    }

    private void setListeners(List<ActivatorWizardModelListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void setLoadPropertiesPolicy(int loadPropertiesPolicy) {
        if (this.loadPropertiesPolicy == loadPropertiesPolicy) {
            return;
        }
        this.loadPropertiesPolicy = loadPropertiesPolicy;
        this.notifyListenersOfLoadPropertiesPolicyChange();
    }

    @Override
    public void setPackageName(String packageName) {
        if (this.packageName != null && this.packageName.equals(packageName)) {
            return;
        }
        this.packageName = packageName;
        this.notifyListenersOfPackageNameChange();
    }

    @Override
    public void setPropertiesFilename(String propertiesFilename) {
        if (this.propertiesFilename != null && this.propertiesFilename.equals(propertiesFilename)) {
            return;
        }
        this.propertiesFilename = propertiesFilename;
        this.notifyListenersOfPropertiesFilenameChange();
    }

    @Override
    public void setStartAsynchronously(boolean startAsynchronously) {
        if (this.startAsynchronously == startAsynchronously) {
            return;
        }
        this.startAsynchronously = startAsynchronously;
        this.notifyListenersOfStartAsynchronouslyChange();
    }

    @Override
    public void setStartAsynchronouslyNormalPriorityDelta(int startAsynchronouslyNormalPriorityDelta) {
        if (this.startAsynchronouslyNormalPriorityDelta == startAsynchronouslyNormalPriorityDelta) {
            return;
        }
        this.startAsynchronouslyNormalPriorityDelta = startAsynchronouslyNormalPriorityDelta;
        this.notifyListenersOfStartAsynchronouslyNormalPriorityDeltaChanged();
    }

    private void setTypeModel(ITypeModel typeModel) {
        this.typeModel = typeModel;
    }

    @Override
    public void setUninstallPolicy(int uninstallPolicy) {
        if (this.uninstallPolicy == uninstallPolicy) {
            return;
        }
        this.uninstallPolicy = uninstallPolicy;
        this.notifyListenersOfUninstallPolicyChanged();
    }

    @Override
    public IStatus validateImportedServiceFilters() {
        List<IImportedServiceDetails> list = this.getImportedServicesDetails();
        Iterator<IImportedServiceDetails> iterator = list.iterator();
        boolean valid = true;
        IImportedServiceDetails details = null;
        while (valid && iterator.hasNext()) {
            details = iterator.next();
            valid = details.isValidFilter();
        }
        String message = null;
        if (!valid && details != null) {
            String filter = details.getFilter();
            String pattern = Messages.getString(INVALID_FILTER_ERROR_KEY);
            message = MessageFormat.format(pattern, filter);
        }
        int severity = valid ? 0 : 4;
        String id = Activator.getDefault().getSymbolicName();
        Status status = new Status(severity, id, message);
        return status;
    }
}

