/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DeviceKitTextHover
extends DefaultTextHover {
    private Map hoverElementMap = new HashMap(101);
    private Map hoverAttributeMap = new HashMap(101);

    public DeviceKitTextHover(ISourceViewer sourceViewer) {
        super(sourceViewer);
    }

    public Map getHoverAttributeMap() {
        return this.hoverAttributeMap;
    }

    public String getHoverElement(String elementName) {
        Object data = this.getHoverElementMap().get(elementName);
        if (data != null) {
            return data.toString();
        }
        try {
            String name = String.valueOf(elementName) + "Element.txt";
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(name);
            String hoverString = DeviceKitUtilities.getStringFromStream((InputStream)stream);
            this.getHoverElementMap().put(elementName, hoverString);
            return hoverString;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return elementName;
        }
    }

    public Map getHoverElementMap() {
        return this.hoverElementMap;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            String text = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
            return this.getHoverElement(text);
        }
        catch (BadLocationException exception) {
            exception.printStackTrace();
            return super.getHoverInfo(textViewer, hoverRegion);
        }
    }

    public void setHoverAttributeMap(Map hoverAttribute) {
        this.hoverAttributeMap = hoverAttribute;
    }

    public void setHoverElementMap(Map hoverElement) {
        this.hoverElementMap = hoverElement;
    }
}

