/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.html;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class PackageHtmlGenerator {
    private IPackageFragment packageFragment;
    private Map map = new HashMap();

    public PackageHtmlGenerator(IPackageFragment packageFragment) {
        this.setPackageFragment(packageFragment);
    }

    public void generate(IProgressMonitor progressMonitor) {
        Map map = GeneratorTemplates.getTemplateVariables(-1);
        map.put("package", this.getPackageFragment().getElementName());
        StringBuffer buffer = new StringBuffer();
        map.put("contents", buffer.toString());
        this.getPackageFragment().getResource().getRawLocation();
        IJavaProject javaProject = this.getJavaProject();
        String name = String.valueOf(this.getPackageFragment().getResource().getProjectRelativePath().toPortableString()) + "/package.html";
        IFile file = javaProject.getProject().getFile(name);
        map.put("project", javaProject.getElementName());
        String contents = GeneratorTemplates.getPackageHtml(map);
        this.save(file, contents, progressMonitor);
    }

    public IJavaProject getJavaProject() {
        return this.getJavaProject((IJavaElement)this.getPackageFragment());
    }

    public IJavaProject getJavaProject(IJavaElement javaElement) {
        if (javaElement instanceof IJavaProject || javaElement == null) {
            return (IJavaProject)javaElement;
        }
        return this.getJavaProject(javaElement.getParent());
    }

    public Map getMap() {
        return this.map;
    }

    public IPackageFragment getPackageFragment() {
        return this.packageFragment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(IFile file, String data, IProgressMonitor progressMonitor) {
        SubProgressMonitor subMonitor = progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1, 4) : new NullProgressMonitor();
        try {
            block7: {
                try {
                    subMonitor.subTask(file.getFullPath().toString());
                    if (data == null) break block7;
                    ByteArrayInputStream source = new ByteArrayInputStream(data.getBytes());
                    if (file.exists()) {
                        InputStream stream = file.getContents(true);
                        String oldContents = DeviceKitUtilities.getStringFromStream(stream);
                        stream.close();
                        if (!oldContents.equals(data)) {
                            file.setContents((InputStream)source, true, true, (IProgressMonitor)subMonitor);
                        }
                        break block7;
                    }
                    file.create((InputStream)source, true, (IProgressMonitor)subMonitor);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            subMonitor.done();
            throw throwable;
        }
        subMonitor.done();
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public void setPackageFragment(IPackageFragment packageFragment) {
        this.packageFragment = packageFragment;
    }
}

