/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.java;

import org.eclipse.soda.devicekit.generator.internal.print.java.JavaPrinter;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;

public class JavaFileModelPrinter
extends JavaPrinter {
    private JavaFileModel fModel;

    public JavaFileModelPrinter(JavaFileModel model) {
        this.fModel = model;
        this.printFile();
    }

    private void printComment() {
        if (this.fModel.getComment() != null) {
            this.printJavaCopyrightComment(this.fModel.getComment());
            this.printNewLine();
        }
    }

    protected void printFile() {
        this.printPackage();
        this.printComment();
        this.printImports();
        this.printType();
    }

    private void printImports() {
        String[] imports = this.fModel.getImports();
        int i = 0;
        while (i < imports.length) {
            this.printImport(imports[i]);
            ++i;
        }
        if (imports.length > 0) {
            this.printNewLine();
        }
    }

    private void printPackage() {
        if (this.fModel.getPackage() != null && this.fModel.getPackage().length() > 0) {
            this.printPackageStatment(this.fModel.getPackage());
            this.printNewLine();
        }
    }

    private void printType() {
        IType type = this.fModel.getType();
        type.setSortOrder(this.fModel.getSortOrder());
        this.printWithIndent(type.print(this.getCurrentIndentenation()));
    }
}

