/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.SendElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class TransportTestElement
extends TestElement {
    public TransportTestElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_SERVICE;
    }

    public String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("send".equals(childNodeName)) {
            this.handleSend(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleSend(Node node) {
        SendElement element = new SendElement(node, this);
        this.addChild(element);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addSend(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        } else if (!ParserUtilities.containsAttribute("idref", node)) {
            throw this.error("The <send> tag must contain the attribute \"id\" or \"idref\".");
        }
    }
}

