/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.sim;

import java.util.List;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.MonitorElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.sim.DkDeviceSimGenerator;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkDeviceMonitorTestGenerator
extends DkDeviceSimGenerator {
    public DkDeviceMonitorTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    protected void codeBACreateService(IType ba) {
        String[] comment = new String[]{"Creates the monitor test.", "", "@return Object The monitor test.", "@see " + this.getMainFqn()};
        KeyValuePair param = new KeyValuePair(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "deviceService");
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this.getMainClassName());
        buffer.append(" monitor = new ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append("();\n");
        buffer.append("monitor.setDevice(deviceService);\n");
        buffer.append("return monitor;\n");
        String contents = buffer.toString();
        this.codeMethod(ba, "createService", comment, "Object", 1L, contents, new KeyValuePair[]{param}, null);
    }

    protected void codeBADeactivate(IType ba) {
        String contents = this.getBADeactivateContents();
        this.codeMethod(ba, "deactivate", "Stop the test case and the bundle.", "void", 4L, contents);
    }

    protected void codeBAFields(IType ba) {
    }

    protected void codeBASetInterest(IType ba) {
        KeyValuePair param = new KeyValuePair("Object", "interest");
        String contents = this.getBASetInterestContents();
        this.codeMethod(ba, "setInterest", "Sets the interest object.", "void", 1L, contents, new KeyValuePair[]{param}, null);
    }

    private void codeDeviceField(IType test) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.codeField(test, "device", fieldType, 2L, "Define the device service to tested.", "null");
    }

    private void codeDeviceMonitorField(IType test) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MONITOR);
        String value = null;
        this.codeField(test, "deviceMonitor", fieldType, 2L, "Field deviceMonitor.", value);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_MONITOR);
    }

    private void codeDeviceRecFileNameField(IType test) {
        String value = this.getBaseName();
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("getStaticString(\"");
        buffer.append(value.toLowerCase());
        buffer.append(".devicerec\", \"");
        buffer.append(value);
        buffer.append("DeviceRec.xml\");");
        value = buffer.toString();
        this.codeField(test, "DEVICE_REC_FILENAME", "String", 50L, "Field DEVICE_REC_FILENAME.", value);
    }

    protected void codeFields(IType test) {
        super.codeFields(test);
        this.codeDeviceRecFileNameField(test);
        this.codeMonitorConnectionField(test);
        this.codeMonitorTransportField(test);
        this.codeDeviceMonitorField(test);
        this.codeDeviceField(test);
    }

    protected void codeGetDevice(IType test) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.codeMethod(test, "getDevice", "Gets the device to be tested.", returnType, 1L, "return this.device;\n");
    }

    protected void codeMethods(IType test) {
        super.codeMethods(test);
        this.codeSetUp(test);
        this.codeGetDevice(test);
        this.codeSetDevice(test);
    }

    private void codeMonitorConnectionField(IType test) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION);
        String value = null;
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION);
        this.codeField(test, "monitorConnection", fieldType, 2L, "Field monitorConnection.", value);
    }

    private void codeMonitorTransportField(IType test) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT);
        String value = null;
        this.codeField(test, "monitorTransport", fieldType, 2L, "Field monitorTransport.", value);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT);
    }

    protected void codeSetDevice(IType test) {
        KeyValuePair param = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "device");
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("this.device = device;\n");
        String contents = buffer.toString();
        this.codeMethod(test, "setDevice", "Sets the device to be tested.", "void", 1L, contents, new KeyValuePair[]{param}, null);
    }

    protected void codeSetUp(IType test) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE);
        buffer.append(" testDevice = (");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE));
        buffer.append(") getDevice();\n");
        buffer.append("testDevice.setup();\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT);
        buffer.append(" defaultTransport = (");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT));
        buffer.append(") testDevice.getTransport();\n");
        buffer.append("defaultTransport.setup();\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        buffer.append(" defaultConnection = defaultTransport.getConnection();\n");
        buffer.append("try {\n");
        buffer.append("\tmonitorConnection = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION);
        buffer.append("(defaultConnection, new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_FILE_OUTPUT_HANDLER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_FILE_OUTPUT_HANDLER);
        buffer.append('(');
        buffer.append("CONNECTION_REC_FILENAME");
        buffer.append("));\n");
        buffer.append("} catch (IOException e){\n");
        this.fTestModel.addImport("java.io.IOException");
        buffer.append("\te.printStackTrace();\n");
        buffer.append("}\n");
        buffer.append("if (defaultTransport instanceof ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE);
        buffer.append(") {\n");
        buffer.append("\t((");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE));
        buffer.append(") defaultTransport).setConnection(monitorConnection);\n");
        buffer.append("}\n");
        buffer.append("try {\n");
        buffer.append("\tmonitorTransport = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT);
        buffer.append("(defaultTransport, new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_FILE_OUTPUT_HANDLER));
        buffer.append('(');
        buffer.append("TRANSPORT_REC_FILENAME");
        buffer.append("));\n");
        buffer.append("} catch (IOException e) {\n");
        buffer.append("\te.printStackTrace();\n");
        buffer.append("}\n");
        buffer.append("testDevice.setTransport(monitorTransport);\n");
        buffer.append("try {\n");
        buffer.append("\tdeviceMonitor = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MONITOR));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_MONITOR);
        buffer.append("(testDevice, new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_FILE_OUTPUT_HANDLER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_FILE_OUTPUT_HANDLER);
        buffer.append('(');
        buffer.append("DEVICE_REC_FILENAME");
        buffer.append("));\n");
        String baseName = this.getBaseName();
        buffer.append("\tdeviceMonitor.setMonitorCommand(getBoolean(\"");
        buffer.append(baseName.toLowerCase());
        buffer.append(".monitorcommand\", true));\n");
        buffer.append("\tdeviceMonitor.setMonitorSignal(getBoolean(\"");
        buffer.append(baseName.toLowerCase());
        buffer.append(".monitorsignal\", true));\n");
        buffer.append("\tdeviceMonitor.setMonitorMeasurement(getBoolean(\"");
        buffer.append(baseName.toLowerCase());
        buffer.append(".monitormeasurement\", true));\n");
        buffer.append("} catch (IOException e) {\n");
        buffer.append("\te.printStackTrace();\n");
        buffer.append("}\n");
        String contents = buffer.toString();
        this.codeMethod(test, "setup", "setup.", "void", 1L, contents);
    }

    protected boolean doGenerateBundleActivator() {
        return true;
    }

    protected boolean doGenerateService() {
        return true;
    }

    protected String getBAActivateContents() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("if (monitor != null)\n");
        buffer.append("monitor.start();\n");
        return buffer.toString();
    }

    protected String getBADeactivateContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("if (this.");
        buffer.append("monitor");
        buffer.append(" != null) {\n");
        buffer.append('\t');
        buffer.append("monitor");
        buffer.append(".stop();\n");
        buffer.append('\t');
        buffer.append("}\n");
        buffer.append("monitor");
        buffer.append(" = null;\n");
        buffer.append("super.deactivate();\n");
        return buffer.toString();
    }

    protected String getBASetInterestContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("super.setInterest(interest);\n");
        buffer.append("if (this.");
        buffer.append("monitor");
        buffer.append(" != null) {\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getBaseName() {
        return DeviceKitUtilities.removeLastOccurence(this.getMainClassName(), "Monitor");
    }

    protected String getConstructorContents() {
        return "super();\n";
    }

    protected String getMainContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append("final ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        buffer.append(" device = new ");
        buffer.append(String.valueOf(DeviceKitUtilities.stripPackage(this.getTestElement().getTargetClass())) + "();\n");
        this.fTestModel.addImport(this.getTestElement().getTargetClass());
        buffer.append('\t');
        buffer.append(this.getMainClassName());
        buffer.append(' ');
        buffer.append("monitor");
        buffer.append(" = new ");
        buffer.append(this.getMainClassName());
        buffer.append("();\n");
        buffer.append("\tmonitor.setDevice(device);\n");
        buffer.append('\t');
        buffer.append("monitor");
        buffer.append(".start();\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(getStaticLong(\"");
        buffer.append(this.getMainClassName().toLowerCase());
        String monitorTime = this.getMonitorTime("30000");
        buffer.append(".maintime\", ");
        buffer.append(monitorTime);
        buffer.append("));\n");
        buffer.append('\t');
        buffer.append("monitor");
        buffer.append(".stop();\n");
        buffer.append("} catch (final Exception exception) {\n");
        buffer.append("\texception.printStackTrace(System.out);\n");
        buffer.append("}\n");
        buffer.append("System.exit(0);\n");
        return buffer.toString();
    }

    protected String getManifestDescription() {
        List monitor = this.getTestElement().getAllChildrenWithTagCode(48);
        MonitorElement element = (MonitorElement)monitor.get(0);
        if (element.getDescription() != null) {
            return element.getDescription();
        }
        return String.valueOf(this.getMainElement().getId()) + " Monitor";
    }

    protected String getMonitorTime(String defaultTime) {
        List monitor = this.getTestElement().getAllChildrenWithTagCode(48);
        if (monitor.size() > 0) {
            TagElement element = (TagElement)monitor.get(0);
            if (element.getAttribute("monitortime") != null) {
                return element.getAttribute("monitortime");
            }
            return defaultTime;
        }
        return defaultTime;
    }

    protected String getSimTestName(String defaultName) {
        String className = DeviceKitUtilities.removeLastOccurence(defaultName, "Test");
        className = String.valueOf(className) + "Monitor";
        return className;
    }

    protected String getStartContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("setup();\n");
        buffer.append("monitorConnection.startMonitoring();\n");
        buffer.append("monitorTransport.startMonitoring();\n");
        buffer.append("deviceMonitor.startMonitoring();\n");
        buffer.append("if (getDevice() != null) {\n");
        buffer.append("\tgetDevice().start();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getStopContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("monitorConnection.stopMonitoring();\n");
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("\t} catch (InterruptedException e) {\n");
        buffer.append("\te.printStackTrace();\n");
        buffer.append("}\n");
        buffer.append("if (getDevice() != null) {\n");
        buffer.append("\tgetDevice().exit();\n");
        buffer.append("}\n");
        buffer.append("monitorTransport.stopMonitoring();\n");
        buffer.append("deviceMonitor.stopMonitoring();\n");
        return buffer.toString();
    }

    protected String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT;
    }
}

