/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.utilty;

public class BitField {
    private static final long CLEAR_ALL_BITS = 0L;
    private static final long SET_ALL_BITS = -1L;
    private long bits;

    public BitField() {
        this(0L);
    }

    public BitField(long initial) {
        this.set(initial);
    }

    public void clear(long bits) {
        this.setBits(this.getBits() & (bits ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public void clearAll() {
        this.setBits(0L);
    }

    public long getBits() {
        return this.bits;
    }

    public boolean isClear() {
        return this.getBits() == 0L;
    }

    public boolean isClear(long bits) {
        return !this.isSet(bits);
    }

    public boolean isSet(long bits) {
        return (this.getBits() & bits) != 0L;
    }

    public void set(long bits) {
        this.setBits(this.getBits() | bits);
    }

    public void setAll() {
        this.setBits(-1L);
    }

    private void setBits(long bits) {
        this.bits = bits;
    }

    public void toggle(long bits) {
        this.setBits(this.getBits() ^ bits);
    }

    public void toggleAll() {
        this.toggle(-1L);
    }
}

