/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.utilty.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlParserFormatDoc
extends DefaultHandler
implements EntityResolver,
DeclHandler,
LexicalHandler,
DTDHandler,
ContentHandler,
ErrorHandler {
    public static final char[] AMP = "&amp;".toCharArray();
    public static final char[] COMMENT_BEGIN = "!--".toCharArray();
    public static final char[] COMMENT_END = " --".toCharArray();
    public static final char[] CR_LF = "\r\n".toCharArray();
    public static final InputSource EMPTY_INPUTSOURCE = new InputSource(new StringReader(""));
    public static final char[] ENTITY = "!ENTITY ".toCharArray();
    public static final char[] GT = "&gt;".toCharArray();
    public static final char[][] INDENT_TABLE = XmlParserFormatDoc.createIndentTable();
    public static final char[] LT = "&lt;".toCharArray();
    public static final char[] QUOT = "&quot;".toCharArray();
    protected Document baselineDocument = null;
    protected HashMap baselineIds = new HashMap();
    private StringBuffer buffer = new StringBuffer(0x100000);
    private boolean closeTag = false;
    private boolean compact = true;
    private StringBuffer content = new StringBuffer(4096);
    public String[] CONTENT_TAGS = XmlParserFormatDoc.createContentTags();
    public String[] ENTITIES = XmlParserFormatDoc.createSystemEntities();
    protected HashMap ids = new HashMap();
    private int indent = 0;
    protected InputSource inputSource = null;
    private String lastTag = "";
    protected boolean lowercase = false;
    private boolean newCommentLine = false;
    private boolean newLine = false;
    private boolean pre = false;
    private String prefixMapping = "";
    private String prefixMappingValue = "";
    private boolean preFound = false;
    protected boolean quiet = false;
    protected boolean raw = false;
    protected boolean skip = false;
    private boolean startMapping = false;
    static /* synthetic */ Class class$0;

    private static final String[] createContentTags() {
        Object[] entities = new String[]{"tt", "b", "img", "a", "em", "font", "h1", "h2", "h3", "h4", "i"};
        Arrays.sort(entities);
        return entities;
    }

    private static final char[][] createIndentTable() {
        char[][] result = new char[16][0];
        int i = 1;
        while (i <= 16) {
            char[] indent = new char[i];
            Arrays.fill(indent, '\t');
            result[i - 1] = indent;
            ++i;
        }
        return result;
    }

    private static final String[] createSystemEntities() {
        Object[] entities = new String[]{"[dtd]", "amp", "gt", "lt"};
        Arrays.sort(entities);
        return entities;
    }

    public static String getXmlString(Object value) {
        return XmlParserFormatDoc.getXmlString(String.valueOf(value));
    }

    public static String getXmlString(String string) {
        boolean mod = false;
        int length = string.length();
        StringBuffer buffer = new StringBuffer(length + 32);
        int i = 0;
        while (i < length) {
            char character = string.charAt(i);
            if (character == '&') {
                buffer.append(AMP);
                mod = true;
            } else if (character == '<') {
                buffer.append(LT);
                mod = true;
            } else if (character == '>') {
                buffer.append(GT);
                mod = true;
            } else if (character == '\"') {
                buffer.append(QUOT);
                mod = true;
            } else {
                buffer.append(character);
            }
            ++i;
        }
        if (mod) {
            return buffer.toString();
        }
        return string;
    }

    public static void main(String[] arguments) {
        long start = System.currentTimeMillis();
        XmlParserFormatDoc xmlFormat = new XmlParserFormatDoc();
        String name = "dkml.xsd";
        name = "package.txt";
        name = "dkml.xsd";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.utilty.xml.XmlParserFormatDoc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream is = clazz.getResourceAsStream(name);
        InputSource inputSource = new InputSource(new BufferedInputStream(is, 4096));
        String string = null;
        try {
            string = xmlFormat.format(inputSource, 0);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        System.out.println("done after " + (end - start));
        if (string != null) {
            System.out.println(string);
        }
        try {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.soda.devicekit.generator.utilty.xml.XmlParserFormatDoc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream stream = clazz2.getResourceAsStream(name);
            xmlFormat.setBaseline(stream);
            Document document = xmlFormat.getBaselineDocument();
            System.out.println("document " + document);
            HashMap baselineIds = xmlFormat.getBaselineIds();
            System.out.println("baseline ids " + baselineIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static final Document parse(InputStream stream, ErrorHandler errorHandler) throws Exception {
        Document document;
        block5: {
            Reader reader = null;
            try {
                Document doc;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                reader = new BufferedReader(new InputStreamReader(stream));
                factory.setValidating(false);
                try {
                    factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                }
                catch (Exception exception) {
                    factory.setValidating(false);
                }
                DocumentBuilder builder = factory.newDocumentBuilder();
                if (errorHandler != null) {
                    builder.setErrorHandler(errorHandler);
                }
                document = doc = builder.parse(new InputSource(reader));
                Object var6_7 = null;
                if (reader == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_8 = null;
                    if (reader == null) break block6;
                    reader.close();
                    reader = null;
                }
                throw throwable;
            }
            reader.close();
            reader = null;
        }
        return document;
    }

    public void attributeDecl(String arg0, String arg1, String arg2, String arg3, String arg4) throws SAXException {
    }

    public void buildBaselineIds(Node node) {
        String value;
        Node idNode;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (idNode = attributes.getNamedItem("id")) != null && (value = idNode.getNodeValue()) != null) {
            this.baselineIds.put(value, node);
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child != null) {
                this.buildBaselineIds(child);
            }
            ++i;
        }
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        String rawData = new String(arg0, arg1, arg2);
        this.contentString(rawData);
    }

    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        this.printCloseTag();
        if (this.newCommentLine) {
            this.println();
            this.newCommentLine = false;
        }
        this.printComment(new String(arg0, arg1, arg2));
    }

    public void contentString(String content) {
        int length = content.length();
        String data = content.trim();
        int dataLength = data.length();
        if (dataLength != length) {
            if (dataLength == 0) {
                data = " ";
            } else {
                char[] characters;
                if (data.charAt(dataLength - 1) != content.charAt(length - 1)) {
                    characters = new char[length + 1];
                    characters[length] = 32;
                    System.arraycopy(content.toCharArray(), 0, characters, 0, length);
                    data = new String(characters);
                }
                if (data.charAt(0) != content.charAt(0)) {
                    characters = new char[length + 1];
                    characters[0] = 32;
                    System.arraycopy(content.toCharArray(), 0, characters, 1, length);
                    data = new String(characters);
                }
            }
        }
        if ((data = XmlParserFormatDoc.getXmlString(data)).length() > 0) {
            if (this.isCloseTag()) {
                this.printCloseTag();
            }
            if (this.raw) {
                this.printRawContent(content);
            } else {
                this.content.append(content);
            }
        }
    }

    public void contentStringQuick(char[] content) {
        if (this.isCloseTag()) {
            this.printCloseTag();
        }
        if (this.raw) {
            this.printRawContent(new String(content));
        } else {
            this.content.append(content);
        }
    }

    public void elementDecl(String arg0, String arg1) throws SAXException {
    }

    public void endCDATA() {
        this.print("]]");
        this.printEnd();
        this.setLastTag("");
        this.raw = false;
    }

    public void endDocument() throws SAXException {
        this.printCloseTag();
    }

    public void endDTD() {
        try {
            this.printEnd();
            this.println();
        }
        catch (Exception exception) {}
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        String elementName = arg2;
        if (this.isLowercase()) {
            elementName = elementName.toLowerCase();
        }
        if (elementName.equals("pre")) {
            this.setPre(false);
        }
        this.printContent(true, false);
        boolean skip = false;
        if (this.isCloseTag()) {
            if (elementName.equals(this.getLastTag())) {
                this.print('/');
                skip = true;
            }
            this.printCloseTag();
        }
        --this.indent;
        if (!skip) {
            if (elementName.equals(this.getLastTag())) {
                String prefixMapping;
                this.printBegin();
                this.print('/');
                String prefix = arg0;
                if (prefix != null && prefix.length() > 0 && prefix.equals(prefixMapping = this.getPrefixMapping())) {
                    this.printPrefix(this.getPrefixMappingValue());
                }
                this.printElement(elementName);
                this.printEnd();
            } else {
                String prefixMapping;
                this.println();
                this.printIndent();
                this.printBegin();
                this.print('/');
                String prefix = arg0;
                if (prefix != null && prefix.length() > 0 && prefix.equals(prefixMapping = this.getPrefixMapping())) {
                    this.printPrefix(this.getPrefixMappingValue());
                }
                this.printElement(elementName);
                this.printEnd();
            }
        }
        this.setNewLine(!this.isContentTag(elementName) || !elementName.equals(this.getLastTag()));
        this.setLastTag("");
    }

    public void endEntity(String arg0) throws SAXException {
    }

    public void endPrefixMapping(String arg0) throws SAXException {
    }

    public void error(SAXParseException e) {
        System.out.println(e);
        System.out.println("error column number=" + e.getColumnNumber());
        System.out.println("error line number=" + e.getLineNumber());
        if (!this.isQuiet()) {
            System.out.println("source " + this.buffer.toString());
        }
    }

    public void externalEntityDecl(String arg0, String arg1, String arg2) throws SAXException {
        this.newCommentLine = true;
        this.printCloseTag();
        this.printBegin();
        this.print(ENTITY);
        this.print(arg0);
        this.print(" \"");
        this.print(arg1);
        this.print("\" ");
        this.printEnd();
        this.println();
    }

    public void fatalError(SAXParseException e) {
        System.out.println(e);
        System.out.println("error line number=" + e.getLineNumber());
        System.out.println("error line number=" + e.getLineNumber());
        System.out.println("source " + this.buffer.toString());
    }

    public String format(InputSource input, int indent) throws Exception {
        return this.format(input, indent, false);
    }

    public String format(InputSource input, int indent, boolean quiet) throws Exception {
        this.setInputSource(input);
        this.setQuiet(quiet);
        this.setIndent(indent);
        this.buffer = new StringBuffer(0x100000);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            SAXParser parser = factory.newSAXParser();
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            parser.setProperty("http://xml.org/sax/properties/declaration-handler", this);
            this.setIndent(indent);
            this.printStartDoc();
            parser.parse(input, (DefaultHandler)this);
            this.printEndDoc();
            return this.buffer.toString();
        }
        catch (Exception exception) {
            if (!quiet) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public String format(InputStream input, int indent, boolean quiet) throws Exception {
        return this.format(new InputSource(input), indent, quiet);
    }

    public String format(String oldString, int indent) {
        InputSource input = new InputSource(new StringReader(oldString));
        try {
            String newString = this.format(input, indent);
            if (this.isPreFound()) {
                return oldString;
            }
            return newString;
        }
        catch (Exception exception) {
            return oldString;
        }
    }

    public void formatContent(String content) {
        int length = content.length();
        if (length < 50) {
            this.print(content);
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(content, ".", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(".")) {
                this.println(token);
                this.printIndent();
                continue;
            }
            this.print(token);
        }
    }

    public Document getBaselineDocument() {
        return this.baselineDocument;
    }

    public HashMap getBaselineIds() {
        return this.baselineIds;
    }

    public HashMap getIds() {
        return this.ids;
    }

    public int getIndent() {
        return this.indent;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public String getLastTag() {
        return this.lastTag;
    }

    public String getNewIcon() {
        return "<img src=\"../icons/new.gif\" alt=\"New\"/>&nbsp;";
    }

    public String getPrefixMapping() {
        return this.prefixMapping;
    }

    public String getPrefixMappingValue() {
        return this.prefixMappingValue;
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void internalEntityDecl(String arg0, String arg1) throws SAXException {
        this.newCommentLine = true;
        this.printCloseTag();
        this.printBegin();
        this.print(ENTITY);
        this.print(arg0);
        this.print(" \"");
        this.print(arg1);
        this.print("\" ");
        this.printEnd();
        this.println();
    }

    public boolean isCloseTag() {
        return this.closeTag;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public boolean isContentTag(String tagName) {
        return Arrays.binarySearch(this.CONTENT_TAGS, tagName) >= 0;
    }

    public boolean isLowercase() {
        return this.lowercase;
    }

    public boolean isNewLine() {
        return this.newLine;
    }

    public boolean isPre() {
        return this.pre;
    }

    public boolean isPreFound() {
        return this.preFound;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void markLocation() {
    }

    public void newCode() {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setErrorHandler(this);
            reader.setContentHandler(this);
            reader.setDTDHandler(this);
            reader.setEntityResolver(this);
            reader.parse("test.dkml");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void notationDecl(String arg0, String arg1, String arg2) throws SAXException {
        this.println("not" + arg0 + arg1);
    }

    public void old() {
        try {
            DocumentBuilder docParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docParser.parse("test.dkml");
            System.out.println(doc);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String parse(InputSource input, int indent, boolean quiet) throws Exception {
        this.setQuiet(quiet);
        String newString = this.format(input, indent, quiet);
        return newString;
    }

    public String parse(String oldString, int indent, boolean quiet) throws Exception {
        this.setQuiet(quiet);
        InputSource input = new InputSource(new StringReader(oldString));
        String newString = this.format(input, indent, quiet);
        if (this.isPreFound()) {
            return oldString;
        }
        return newString;
    }

    public void print(char data) {
        this.buffer.append(data);
    }

    private void print(char[] characters) {
        this.buffer.append(characters);
    }

    public void print(String data) {
        this.buffer.append(data);
    }

    public void printAttribute(String element) {
        this.print(element);
    }

    public void printAttribute(String attribute, String value) {
        this.print(attribute);
        this.print('=');
        this.printAttributeValue(value);
    }

    public void printAttributeValue(String attribute) {
        this.print('\"');
        this.printXmlString(attribute);
        this.print('\"');
    }

    public void printBegin() {
        this.print('<');
    }

    public void printCloseTag() {
        if (this.isCloseTag()) {
            this.printEnd();
            this.setCloseTag(false);
        }
    }

    public void printComment(String data) {
        this.printBegin();
        this.print(COMMENT_BEGIN);
        this.print(data);
        this.print(COMMENT_END);
        this.printEnd();
        this.println();
    }

    public void printCommentChar(char character) {
        if (!this.isSkip()) {
            switch (character) {
                case '<': {
                    this.print("&lt;");
                    break;
                }
                case '>': {
                    this.print("&gt;");
                    break;
                }
                case ' ': {
                    this.print("&nbsp;");
                    break;
                }
                case '\t': {
                    this.print("&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                default: {
                    this.print(character);
                }
            }
        }
    }

    public boolean printContent(boolean trim, boolean indent) {
        boolean hasData = false;
        int length = this.content.length();
        if (length > 0) {
            String data = this.content.toString();
            if (data.trim().length() > 0) {
                if (this.isCloseTag()) {
                    this.printCloseTag();
                }
                if (indent && !this.isNewLine()) {
                    this.println();
                    this.printIndent();
                }
                this.printContent(data);
                hasData = true;
            }
            this.content.delete(0, length);
        }
        return hasData;
    }

    public void printContent(String content) {
        this.printXmlString(content);
    }

    public void printElement(String element) {
        this.print(element);
    }

    public void printEnd() {
        this.print('>');
    }

    public void printEndDoc() {
    }

    public void printIndent() {
        int indent;
        if (!this.isPre() && (indent = this.getIndent()) > 0) {
            if (indent > 16) {
                int i = 0;
                while (i < indent) {
                    this.print('\t');
                    ++i;
                }
            } else {
                this.print(INDENT_TABLE[indent - 1]);
            }
        }
    }

    public void println() {
        this.buffer.append(CR_LF);
    }

    public void println(String data) {
        this.print(data);
        this.println();
    }

    public void printPrefix(String prefix) {
        this.print(prefix);
        this.print(':');
    }

    public void printRawContent(String content) {
        this.printContent(content);
    }

    public void printStartDoc() {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public void printXmlChar(char character) {
        if (!this.isSkip()) {
            switch (character) {
                case '<': {
                    this.print("&lt;");
                    break;
                }
                case '>': {
                    this.print("&gt;");
                    break;
                }
                case '&': {
                    this.print("&amp;");
                    break;
                }
                default: {
                    this.print(character);
                }
            }
        }
    }

    public void printXmlString(String string) {
        char[] characters = string.toCharArray();
        int i = 0;
        while (i < characters.length) {
            this.printXmlChar(characters[i]);
            ++i;
        }
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.print("<?");
        this.print(arg0);
        if (arg1.length() > 0) {
            this.print(' ');
            this.print(arg1);
        }
        this.println("?>");
    }

    public InputSource resolveEntity(String arg0, String arg1) {
        this.print('\"');
        this.print(arg1);
        this.print('\"');
        return new InputSource(new StringReader(""));
    }

    public void setBaseline(InputStream stream) throws Exception {
        try {
            Document baselineDocument = XmlParserFormatDoc.parse(stream, null);
            this.setBaselineDocument(baselineDocument);
            if (baselineDocument != null) {
                this.buildBaselineIds(baselineDocument);
            }
        }
        catch (Exception exception) {}
    }

    public void setBaselineDocument(Document baselineDocument) {
        this.baselineDocument = baselineDocument;
    }

    public void setBaselineIds(HashMap baselineIds) {
        this.baselineIds = baselineIds;
    }

    public void setCloseTag(boolean closeTag) {
        this.closeTag = closeTag;
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public void setDocumentLocator(Locator arg0) {
    }

    public void setIds(HashMap map) {
        this.ids = map;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setInputSource(InputSource source) {
        this.inputSource = source;
    }

    public void setLastTag(String lastTag) {
        this.lastTag = lastTag;
    }

    public void setLowercase(boolean b) {
        this.lowercase = b;
    }

    public void setNewLine(boolean newLine) {
        this.newLine = newLine;
    }

    public void setPre(boolean pre) {
        this.pre = pre;
        if (pre) {
            this.setPreFound(true);
        }
    }

    public void setPrefixMapping(String prefixMapping) {
        this.prefixMapping = prefixMapping;
    }

    public void setPrefixMappingValue(String prefixMappingValue) {
        this.prefixMappingValue = prefixMappingValue;
    }

    public void setPreFound(boolean preFound) {
        this.preFound = preFound;
    }

    public void setQuiet(boolean b) {
        this.quiet = b;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void skippedEntity(String arg0) throws SAXException {
        this.println("skipped" + arg0);
    }

    public void startCDATA() {
        this.newCommentLine = true;
        this.printCloseTag();
        if (!this.isCompact()) {
            this.println();
            this.printIndent();
        }
        this.printBegin();
        this.print("![CDATA[");
        this.raw = true;
    }

    public void startDocument() throws SAXException {
    }

    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        this.print("<!DOCTYPE ");
        this.print(arg0);
        this.print(" SYSTEM ");
    }

    public void startElement(String arg0, String arg1, String arg2, Attributes attributes) throws SAXException {
        int count;
        String prefixMapping;
        String elementName = arg2;
        if (this.isLowercase()) {
            elementName = elementName.toLowerCase();
        }
        if (elementName.equals("pre")) {
            this.setPre(true);
            this.setPreFound(true);
            this.markLocation();
        }
        this.printContent(true, false);
        this.newCommentLine = true;
        this.printCloseTag();
        this.println();
        this.printIndent();
        String prefix = arg0;
        this.printBegin();
        if (prefix != null && prefix.length() > 0 && prefix.equals(prefixMapping = this.getPrefixMapping())) {
            this.printPrefix(this.getPrefixMappingValue());
        }
        this.printElement(elementName);
        if (this.startMapping) {
            this.startMapping = false;
            this.print(" xmlns:");
            this.printAttribute(this.getPrefixMappingValue(), this.getPrefixMapping());
        }
        if ((count = attributes.getLength()) < 2) {
            int i = 0;
            while (i < count) {
                String name = attributes.getQName(i);
                if (this.isLowercase()) {
                    name = name.toLowerCase();
                }
                String value = attributes.getValue(i);
                this.print(' ');
                if ("id".equals(name.toLowerCase())) {
                    Object oldId;
                    if (this.ids.get(value) == null) {
                        this.ids.put(value, elementName);
                    }
                    boolean flagIns = false;
                    if (this.getBaselineDocument() != null && (oldId = this.getBaselineIds().get(value)) == null) {
                        flagIns = true;
                    }
                    if (flagIns) {
                        this.print("<ins>");
                        this.printAttribute(name, value);
                        this.print("</ins>");
                    } else {
                        this.printAttribute(name, value);
                    }
                } else {
                    this.printAttribute(name, value);
                }
                ++i;
            }
        } else {
            this.indent += 2;
            int size = 0;
            int i = 0;
            while (i < count) {
                String name = attributes.getQName(i);
                if (this.isLowercase()) {
                    name = name.toLowerCase();
                }
                String value = attributes.getValue(i);
                if ((size = size + name.length() + value.length()) > 60) {
                    this.println();
                    this.printIndent();
                    size = 0;
                } else {
                    this.print(' ');
                }
                if ("id".equals(name.toLowerCase())) {
                    Object oldId;
                    if (this.ids.get(value) == null) {
                        this.ids.put(value, elementName);
                    }
                    boolean flagIns = false;
                    if (this.getBaselineDocument() != null && (oldId = this.getBaselineIds().get(value)) == null) {
                        flagIns = true;
                    }
                    if (flagIns) {
                        this.print("<ins>");
                        this.printAttribute(name, value);
                        this.print("</ins>");
                    } else {
                        this.printAttribute(name, value);
                    }
                } else {
                    this.printAttribute(name, value);
                }
                ++i;
            }
            this.indent -= 2;
        }
        this.setCloseTag(true);
        this.setLastTag(elementName);
        this.setNewLine(true);
        ++this.indent;
    }

    public void startEntity(String arg0) throws SAXException {
        if (Arrays.binarySearch(this.ENTITIES, arg0) < 0) {
            int length = arg0.length();
            char[] chars = new char[length + 2];
            chars[0] = 38;
            System.arraycopy(arg0.toCharArray(), 0, chars, 1, length);
            chars[length + 1] = 59;
            this.contentStringQuick(chars);
        }
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.setPrefixMappingValue(arg0);
        this.setPrefixMapping(arg1);
        this.startMapping = true;
    }

    public void unparsedEntityDecl(String arg0, String arg1, String arg2, String arg3) throws SAXException {
        this.println("upar" + arg0 + arg1 + arg2 + arg3);
    }

    public void warning(SAXParseException e) {
        System.out.println(e);
        System.out.println("warning line number=" + e.getLineNumber());
    }
}

