/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.barcode.reader.simulator;

import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.data.Degree;
import org.eclipse.soda.dk.data.LatitudeData;
import org.eclipse.soda.dk.data.LongitudeData;
import org.eclipse.soda.dk.message.AsciiMessage;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.tcpip.server.connection.TcpipServerConnection;
import org.eclipse.soda.dk.tcpip.server.connection.service.TcpipServerConnectionService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class BarcodeReaderSimulator
extends ConnectionTransport
implements TransportService,
BundleActivator {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.gps.nmea.transport.GpsNmeaTransport";
    public static final byte[] HEX_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    protected BarcodeReaderSimulator barcodeReaderSimulator;

    public static void main(String[] arguments) {
        BarcodeReaderSimulator barcodeReaderSimulator = new BarcodeReaderSimulator();
        barcodeReaderSimulator.start();
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
    }

    public ConnectionService getDefaultConnection() {
        return this.getDefaultTcpipServerConnection();
    }

    public TcpipServerConnectionService getDefaultTcpipServerConnection() {
        return new TcpipServerConnection(this.getInt("barcodereadersimulator.remoteport", 8901));
    }

    public LatitudeData getLatitude(String nmeaString) {
        try {
            int lenght = nmeaString.length();
            String data = nmeaString.substring(0, lenght - 1);
            int value = Degree.parseNmeaDegree((String)data);
            if (nmeaString.endsWith("S")) {
                value = -value;
            }
            return new LatitudeData(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public LongitudeData getLongitude(String nmeaString) {
        try {
            int lenght = nmeaString.length();
            String data = nmeaString.substring(0, lenght - 1);
            int value = Degree.parseNmeaDegree((String)data);
            if (nmeaString.endsWith("W")) {
                value = -value;
            }
            return new LongitudeData(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void processInput() {
        while (this.isRunning()) {
            long timenow = System.currentTimeMillis();
            long delay = 10000L - timenow % 10000L;
            if (delay > 10L) {
                this.sleep(delay);
            }
            StringBuffer buffer = new StringBuffer(100);
            long time = System.currentTimeMillis();
            buffer.append(time);
            AsciiMessage message = new AsciiMessage(buffer.toString());
            try {
                this.write((MessageService)message);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.setRunning(false);
            }
        }
    }

    public int processInput(byte[] bytes, int length) throws Exception {
        return length;
    }

    public void setup() {
        super.setup();
        this.setRetryTime(this.getLong("barcodereadertransport.retrytime", this.getRetryTime()));
        this.setNoActivityTimeout(this.getLong("barcodereadertransport.noactivitytimeout", this.getNoActivityTimeout()));
    }

    public void start(BundleContext context) throws Exception {
        this.barcodeReaderSimulator = new BarcodeReaderSimulator();
        this.barcodeReaderSimulator.start();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.barcodeReaderSimulator != null) {
            try {
                this.barcodeReaderSimulator.stop();
            }
            catch (Exception exception) {}
            this.barcodeReaderSimulator = null;
        }
    }

    protected void write(MessageService message) throws Exception {
        byte[] obytes = message.getBytes();
        this.write(obytes);
    }
}

