/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.barcode.reader.transport.testcase;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.soda.dk.barcode.reader.transport.testcase.BarcodeReaderExtendedTransport;
import org.eclipse.soda.dk.barcode.reader.transport.testcase.service.BarcodeReaderTransportTestcaseService;
import org.eclipse.soda.dk.message.service.MessageService;

public class BarcodeReaderTransportExtendedTestcase
extends TestCase
implements BarcodeReaderTransportTestcaseService {
    static /* synthetic */ Class class$0;

    public static void main(String[] arguments) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.barcode.reader.transport.testcase.BarcodeReaderTransportExtendedTestcase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
        System.exit(0);
    }

    public BarcodeReaderTransportExtendedTestcase() {
    }

    public BarcodeReaderTransportExtendedTestcase(String name) {
        super(name);
    }

    public BarcodeReaderExtendedTransport createTransportExtended() {
        BarcodeReaderExtendedTransport barcodeReaderExtendedTransport = new BarcodeReaderExtendedTransport();
        barcodeReaderExtendedTransport.setup();
        barcodeReaderExtendedTransport.setupCustom();
        return barcodeReaderExtendedTransport;
    }

    public void test01() {
        try {
            BarcodeReaderExtendedTransport barcodeReaderExtendedTransport = new BarcodeReaderExtendedTransport();
            byte[] bytes = new byte[]{97};
            int length = bytes.length;
            barcodeReaderExtendedTransport.processInputExtended(bytes, length);
            MessageService message = barcodeReaderExtendedTransport.getMessage();
            byte[] result = message.getBytes();
            byte[] bytesExpected = new byte[]{97};
            int i = 0;
            while (i < bytesExpected.length) {
                BarcodeReaderTransportExtendedTestcase.assertEquals((byte)bytesExpected[i], (byte)result[i]);
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void test02() {
        try {
            BarcodeReaderExtendedTransport barcodeReaderExtendedTransport = new BarcodeReaderExtendedTransport();
            barcodeReaderExtendedTransport.setMessageMinimumSize(2);
            byte[] bytes = new byte[]{97};
            int length = bytes.length;
            int size = barcodeReaderExtendedTransport.processInputExtended(bytes, length);
            BarcodeReaderTransportExtendedTestcase.assertEquals((int)0, (int)size);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void test03() {
        try {
            BarcodeReaderExtendedTransport barcodeReaderExtendedTransport = new BarcodeReaderExtendedTransport();
            byte[] bytes = new byte[]{97};
            int length = bytes.length;
            barcodeReaderExtendedTransport.processInputExtended(bytes, length);
            MessageService message = barcodeReaderExtendedTransport.getMessage();
            byte[] result = message.getBytes();
            byte[] bytesExpected = new byte[]{97};
            int i = 0;
            while (i < bytesExpected.length) {
                BarcodeReaderTransportExtendedTestcase.assertEquals((byte)bytesExpected[i], (byte)result[i]);
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void test04() {
        try {
            BarcodeReaderExtendedTransport barcodeReaderExtendedTransport = new BarcodeReaderExtendedTransport();
            byte[] bytes = new byte[]{97, 98};
            int length = bytes.length;
            byte[] messageBegin = new byte[]{98};
            barcodeReaderExtendedTransport.setMessageBegin(messageBegin);
            barcodeReaderExtendedTransport.processInputExtended(bytes, length);
            MessageService message = barcodeReaderExtendedTransport.getMessage();
            byte[] result = message.getBytes();
            byte[] bytesExpected = new byte[]{98};
            int i = 0;
            while (i < bytesExpected.length) {
                BarcodeReaderTransportExtendedTestcase.assertEquals((byte)bytesExpected[i], (byte)result[i]);
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

