/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.List;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.Parameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.transform.service.TransformService;

public class SimpleParameter
extends Parameter {
    private int index;
    private int size;

    public SimpleParameter(String key, int index, int size) {
        this(key, null, index, size, SimpleParameter.getDefaultStyle());
    }

    public SimpleParameter(String key, int index, int size, short style) {
        this(key, null, index, size, style);
    }

    public SimpleParameter(String key, TransformService transform, int index, int size) {
        this(key, transform, index, size, SimpleParameter.getDefaultStyle());
    }

    public SimpleParameter(String key, TransformService transform, int index, int size, short style) {
        super(key, transform, style);
        this.index = index;
        this.size = size;
    }

    public Object decodeBytes(byte[] mbytes, int index, int size) {
        int dataLength = mbytes.length;
        int tsize = size;
        if (tsize == 0 || tsize + index > dataLength) {
            tsize = dataLength - index;
        }
        switch (this.getTypeStyle()) {
            case 64: 
            case 96: {
                return new String(mbytes, index, tsize);
            }
            case 144: {
                int max = index + tsize;
                int i = index;
                while (i < max) {
                    if (mbytes[i] == 0) {
                        tsize = i - index;
                        break;
                    }
                    ++i;
                }
            }
            case 112: 
            case 128: 
            case 192: 
            case 208: {
                char[] chars = new char[tsize];
                int i = 0;
                while (i < tsize) {
                    chars[i] = (char)mbytes[index + i];
                    ++i;
                }
                return new String(chars);
            }
            case 80: {
                byte[] bytes = new byte[tsize];
                System.arraycopy(mbytes, index, bytes, 0, tsize);
                return bytes;
            }
            case 32: {
                return this.decodeShortObject(mbytes, index, size);
            }
            case 0: {
                return this.decodeIntegerObject(mbytes, index, size);
            }
            case 224: {
                return this.decodeLongObject(mbytes, index, size);
            }
            case 160: {
                return this.decodeFloatObject(mbytes, index, size);
            }
            case 176: {
                return this.decodeDoubleObject(mbytes, index, size);
            }
        }
        if (size <= 4) {
            return this.decodeIntegerObject(mbytes, index, size);
        }
        return this.decodeLongObject(mbytes, index, size);
    }

    public Object decodeBytes(byte[] mbytes, ParameterCursorService cursor) {
        return this.decodeBytes(mbytes, 0, mbytes.length);
    }

    public double decodeDouble(byte[] bytes, int index, int size) {
        long value = this.decodeLong(bytes, index, size);
        return Double.longBitsToDouble(value);
    }

    public Object decodeDoubleObject(byte[] bytes, int index, int size) {
        if (this.isArray()) {
            int arrayLength = size >> 3;
            double[] returnValue = new double[arrayLength];
            int tindex = index;
            int i = 0;
            while (i < arrayLength) {
                returnValue[i] = this.decodeDouble(bytes, tindex, 8);
                tindex += 8;
                ++i;
            }
            return returnValue;
        }
        double returnValue = this.decodeDouble(bytes, index, size);
        return new Double(returnValue);
    }

    public float decodeFloat(byte[] bytes, int index, int size) {
        int value = this.decodeInt(bytes, index, size);
        return Float.intBitsToFloat(value);
    }

    public Object decodeFloatObject(byte[] bytes, int index, int size) {
        if (this.isArray()) {
            int arrayLength = size >> 2;
            float[] returnValue = new float[arrayLength];
            int tindex = index;
            int i = 0;
            while (i < arrayLength) {
                returnValue[i] = this.decodeFloat(bytes, tindex, 4);
                tindex += 4;
                ++i;
            }
            return returnValue;
        }
        float returnValue = this.decodeFloat(bytes, index, size);
        return new Float(returnValue);
    }

    public int decodeInt(byte[] bytes, int index, int size) {
        int returnValue = 0;
        if (this.isLittleEndian()) {
            returnValue = bytes[index + size - 1] & this.getMask();
            int i = size - 2;
            while (i >= 0) {
                returnValue <<= 8;
                returnValue += bytes[index + i] & 0xFF;
                --i;
            }
        } else {
            returnValue = bytes[index] & this.getMask();
            int i = 1;
            while (i < size) {
                returnValue <<= 8;
                returnValue += bytes[index + i] & 0xFF;
                ++i;
            }
        }
        return returnValue;
    }

    public Object decodeIntegerObject(byte[] bytes, int index, int size) {
        if (this.isArray()) {
            int arrayLength = size >> 2;
            int[] returnValue = new int[arrayLength];
            int tindex = index;
            int i = 0;
            while (i < arrayLength) {
                returnValue[i] = this.decodeInt(bytes, tindex, 4);
                tindex += 4;
                ++i;
            }
            return returnValue;
        }
        int returnValue = this.decodeInt(bytes, index, size);
        return SimpleParameter.createNumber(returnValue);
    }

    public long decodeLong(byte[] bytes, int index, int size) {
        long returnValue = 0L;
        if (this.isLittleEndian()) {
            returnValue = bytes[index + size - 1] & this.getMask();
            int i = size - 2;
            while (i >= 0) {
                returnValue <<= 8;
                returnValue += (long)(bytes[index + i] & 0xFF);
                --i;
            }
        } else {
            returnValue = bytes[index] & this.getMask();
            int i = 1;
            while (i < size) {
                returnValue <<= 8;
                returnValue += (long)(bytes[index + i] & 0xFF);
                ++i;
            }
        }
        return returnValue;
    }

    public Object decodeLongObject(byte[] bytes, int index, int size) {
        if (this.isArray()) {
            int arrayLength = size >> 3;
            long[] returnValue = new long[arrayLength];
            int tindex = index;
            int i = 0;
            while (i < arrayLength) {
                returnValue[i] = this.decodeInt(bytes, tindex, 8);
                tindex += 8;
                ++i;
            }
            return returnValue;
        }
        long returnValue = this.decodeLong(bytes, index, size);
        return SimpleParameter.createNumber(returnValue);
    }

    public Object decodeMessage(MessageService message, ParameterCursorService cursor) {
        byte[] mbytes = message.getDataBytes();
        int dataLength = this.getSize();
        int dataIndex = this.getIndex(cursor);
        return this.decodeBytes(mbytes, dataIndex, dataLength);
    }

    public Object decodeShortObject(byte[] bytes, int index, int size) {
        if (this.isArray()) {
            int arrayLength = size >> 1;
            short[] returnValue = new short[arrayLength];
            int tindex = index;
            int i = 0;
            while (i < arrayLength) {
                returnValue[i] = (short)this.decodeInt(bytes, tindex, 2);
                tindex += 2;
                ++i;
            }
            return returnValue;
        }
        int returnValue = this.decodeInt(bytes, index, size);
        return SimpleParameter.createNumber(returnValue);
    }

    public Object encodeBytes(byte[] mbytes, Object value, int offset, int index, int dataLength, ParameterCursorService cursor) {
        byte[] returnBytes = mbytes;
        int tsize = this.getSize();
        if (tsize == 0 || tsize + index > dataLength) {
            tsize = dataLength - index;
        }
        int toffset = 0;
        toffset = index > 0 ? index : offset;
        switch (this.getTypeStyle()) {
            case 64: 
            case 96: 
            case 112: 
            case 128: 
            case 144: 
            case 192: 
            case 208: {
                if (value == null) break;
                byte[] svalue = null;
                svalue = value instanceof byte[] ? (byte[])value : String.valueOf(value).getBytes();
                if (this.isInsert()) {
                    returnBytes = this.insert(mbytes, toffset, svalue, cursor);
                    break;
                }
                System.arraycopy(svalue, 0, returnBytes, toffset, tsize);
                break;
            }
            case 80: {
                byte[] bytes = (byte[])value;
                if (this.isInsert() || this.getSize() == 0) {
                    byte[] ivalue = bytes;
                    returnBytes = this.insert(mbytes, toffset, ivalue, cursor);
                    break;
                }
                if (tsize > bytes.length) {
                    tsize = bytes.length;
                }
                System.arraycopy(bytes, 0, returnBytes, toffset, tsize);
                break;
            }
            case 32: {
                returnBytes = (byte[])this.encodeShortObject(mbytes, value, toffset, tsize);
                break;
            }
            case 0: {
                returnBytes = (byte[])this.encodeIntObject(mbytes, value, toffset, tsize);
                break;
            }
            case 224: {
                returnBytes = (byte[])this.encodeLongObject(mbytes, value, toffset, tsize);
            }
        }
        return returnBytes;
    }

    public Object encodeBytes(byte[] container, Object data, ParameterCursorService cursor) {
        return this.encodeBytes(container, data, this.getIndex(cursor), 0, container.length, cursor);
    }

    public Object encodeInt(byte[] bytes, int value, int offset, int length) {
        int tempValue = value;
        if (this.isLittleEndian()) {
            int i = 0;
            while (i < length) {
                bytes[offset + i] = (byte)tempValue;
                tempValue >>= 8;
                ++i;
            }
        } else {
            int i = length - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)tempValue;
                tempValue >>= 8;
                --i;
            }
        }
        return bytes;
    }

    public Object encodeIntObject(byte[] bytes, Object value, int offset, int length) {
        if (this.isArray()) {
            int[] array = (int[])value;
            int toffset = offset;
            int i = 0;
            while (i < array.length) {
                this.encodeInt(bytes, array[i], toffset, 4);
                toffset += 4;
                ++i;
            }
        } else {
            int tvalue = this.getInt(value);
            this.encodeInt(bytes, tvalue, offset, length);
        }
        return bytes;
    }

    public Object encodeLong(byte[] bytes, long value, int offset, int length) {
        long tempValue = value;
        if (this.isLittleEndian()) {
            int i = 0;
            while (i < length) {
                bytes[offset + i] = (byte)tempValue;
                tempValue >>= 8;
                ++i;
            }
        } else {
            int i = length - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)tempValue;
                tempValue >>= 8;
                --i;
            }
        }
        return bytes;
    }

    public Object encodeLongObject(byte[] bytes, Object value, int offset, int length) {
        if (this.isArray()) {
            long[] array = (long[])value;
            int toffset = offset;
            int i = 0;
            while (i < array.length) {
                this.encodeLong(bytes, array[i], toffset, 8);
                toffset += 8;
                ++i;
            }
        } else {
            long tvalue = this.getLong(value);
            this.encodeLong(bytes, tvalue, offset, length);
        }
        return bytes;
    }

    protected MessageService encodeMessage(MessageService message, byte[] value, int offset) {
        byte[] mbytes = message.getBytes();
        System.arraycopy(value, 0, mbytes, offset, this.getSize());
        message.setBytes(mbytes);
        return message;
    }

    public MessageService encodeMessage(MessageService message, Object value, int offset, ParameterCursorService cursor) {
        int dataLength = message.getDataLength();
        int dataIndex = this.getIndex(cursor);
        byte[] mbytes = message.getBytes();
        byte[] returnBytes = (byte[])this.encodeBytes(mbytes, value, offset, dataIndex, dataLength, cursor);
        message.setBytes(returnBytes);
        return message;
    }

    public Object encodeShort(byte[] bytes, int value, int offset, int length) {
        int tempValue = value;
        if (this.isLittleEndian()) {
            int i = 0;
            while (i < length) {
                bytes[offset + i] = (byte)tempValue;
                tempValue >>= 8;
                ++i;
            }
        } else {
            int i = length - 1;
            while (i >= 0) {
                bytes[offset + i] = (byte)tempValue;
                tempValue >>= 8;
                --i;
            }
        }
        return bytes;
    }

    public Object encodeShortObject(byte[] bytes, Object value, int offset, int length) {
        if (this.isArray()) {
            int toffset = offset;
            if (value instanceof short[]) {
                short[] array = (short[])value;
                int i = 0;
                while (i < array.length) {
                    this.encodeShort(bytes, array[i], toffset, 2);
                    toffset += 2;
                    ++i;
                }
            } else if (value instanceof List) {
                List list = (List)value;
                int i = 0;
                while (i < list.size()) {
                    this.encodeShort(bytes, this.getShort(list.get(i)), toffset, 2);
                    toffset += 2;
                    ++i;
                }
            }
        } else {
            short tvalue = this.getShort(value);
            this.encodeShort(bytes, tvalue, offset, length);
        }
        return bytes;
    }

    public byte[] expand(byte[] bytes, int offset, int length) {
        byte[] returnBytes = new byte[length + bytes.length];
        System.arraycopy(bytes, 0, returnBytes, 0, offset);
        System.arraycopy(bytes, offset, returnBytes, offset + length, bytes.length - offset);
        return returnBytes;
    }

    public int getIndex(ParameterCursorService cursor) {
        if (this.index < 0) {
            return cursor.getOffset() >> 3;
        }
        if (cursor != null) {
            return this.index + (cursor.getOffsetDelta() >> 3);
        }
        return this.index;
    }

    public int getInt(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            String stringValue = String.valueOf(value);
            if (stringValue.startsWith("0x")) {
                return Integer.decode(stringValue);
            }
            return Integer.parseInt(stringValue);
        }
        return 0;
    }

    public long getLong(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            String stringValue = String.valueOf(value);
            if (stringValue.startsWith("0x")) {
                return Integer.decode(stringValue).longValue();
            }
            return Long.parseLong(stringValue);
        }
        return 0L;
    }

    protected int getMask() {
        if (this.isUnsigned()) {
            return 255;
        }
        return -1;
    }

    public short getShort(Object value) {
        if (value != null) {
            if (value instanceof Short) {
                return ((Number)value).shortValue();
            }
            String stringValue = String.valueOf(value);
            if (stringValue.startsWith("0x")) {
                return Short.parseShort(stringValue.substring(2), 16);
            }
            return Short.parseShort(stringValue);
        }
        return 0;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] insert(byte[] bytes, int offset, byte[] insertBytes, ParameterCursorService cursor) {
        int length = insertBytes.length;
        byte[] returnBytes = new byte[length + bytes.length];
        System.arraycopy(bytes, 0, returnBytes, 0, offset);
        System.arraycopy(bytes, offset, returnBytes, offset + length, bytes.length - offset);
        System.arraycopy(insertBytes, 0, returnBytes, offset, insertBytes.length);
        if (cursor != null) {
            cursor.setOffsetDelta(cursor.getOffsetDelta() + (length << 3));
            cursor.updateMessageLength(length << 3);
        }
        return returnBytes;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    protected void updateCursor(ParameterCursorService cursor) {
        super.updateCursor(cursor);
        int length = this.getSize() << 3;
        if (cursor != null) {
            cursor.setOffset((this.getIndex(cursor) << 3) + length);
        }
    }
}

