/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.Parameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.transform.service.TransformService;

public class TagParameter
extends Parameter {
    private String endTag;
    private String startTag;

    public TagParameter(String key, String tag) {
        this(key, null, tag, TagParameter.getDefaultStyle());
    }

    public TagParameter(String key, String tag, short style) {
        this(key, null, tag, style);
    }

    public TagParameter(String key, TransformService transform, String tag, short style) {
        super(key, transform, style);
        this.startTag = "<" + tag;
        this.endTag = "</" + tag;
    }

    public TagParameter(String key, TransformService transform, String tag) {
        this(key, transform, tag, TagParameter.getDefaultStyle());
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        int endIndex;
        String inputString = new String(message.getDataBytes());
        int startIndex = inputString.indexOf(this.getStartTag(), 0);
        if (startIndex != -1 && (startIndex = inputString.indexOf(62, startIndex + 1)) != -1 && (endIndex = inputString.indexOf(this.getEndTag(), startIndex + 1)) != -1) {
            return inputString.substring(startIndex + 1, endIndex);
        }
        return "";
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        int endIndex;
        String inputString = new String(message.getBytes());
        int startIndex = inputString.indexOf(this.getStartTag(), 0);
        if (startIndex != -1 && (startIndex = inputString.indexOf(62, startIndex + 1)) != -1 && (endIndex = inputString.indexOf(this.getEndTag(), startIndex + 1)) != -1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(inputString.substring(0, startIndex + 1));
            buffer.append(value);
            buffer.append(inputString.substring(endIndex, inputString.length()));
            return new Message(buffer.toString());
        }
        return message;
    }

    public String getEndTag() {
        return this.endTag;
    }

    public String getStartTag() {
        return this.startTag;
    }
}

