/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.device.swt;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.device.Control;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.swt.Bridge;
import org.eclipse.soda.dk.device.swt.Messages;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ControlWindow
extends Dialog {
    private int index = 0;
    protected Object data = null;
    private Composite composite;
    private String[] items = new String[0];
    protected Bridge bridge;
    protected Text countText;
    protected Text timestampText;
    protected Text timeText;
    protected Text dataText;
    private Map controls = new Hashtable();

    public ControlWindow(Bridge bridge) {
        super(new Shell(1264));
        this.setBridge(bridge);
    }

    public Button createButton(Composite contents, String fieldName, boolean value) {
        Button text = new Button(contents, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        text.setToolTipText(this.getResourceString(String.valueOf(fieldName) + ".hint"));
        text.setText(this.getResourceString(String.valueOf(fieldName) + ".label"));
        return text;
    }

    protected org.eclipse.swt.widgets.Control createDialogArea(Composite parent) {
        Object[] buttonNames = this.getButtonNames();
        Arrays.sort(buttonNames);
        String key = this.getBridge().getControl().getKey();
        this.put("key", (org.eclipse.swt.widgets.Control)this.createText(parent, "key", key, true));
        long timestamp = this.getBridge().getTimstamp();
        String timestampString = timestamp > 0L ? Nls.formatTimestamp((long)timestamp) : "";
        Text timestampText = this.createText(parent, "timestamp", timestampString, true);
        this.setTimestampText(timestampText);
        this.put("timestamp", (org.eclipse.swt.widgets.Control)timestampText);
        long timestampBaseline = this.getBridge().getParent().getTimestamp();
        String timeString = timestamp > 0L ? Long.toString(timestamp - timestampBaseline) : "";
        Text timeText = this.createText(parent, "time", timeString, true);
        this.setTimeText(timeText);
        this.put("timestamp", (org.eclipse.swt.widgets.Control)timeText);
        long count = this.getBridge().getCount();
        Text countText = this.createText(parent, "count", Nls.formatData((Object)new Long(count)), true);
        this.setCountText(countText);
        this.put("count", (org.eclipse.swt.widgets.Control)countText);
        Object data = this.getBridge().getData();
        Text dataText = this.createText(parent, "data", data, true);
        this.setDataText(dataText);
        this.put("data", (org.eclipse.swt.widgets.Control)dataText);
        this.createButton(parent, "refresh", true);
        return this.composite;
    }

    public List createListBox(Composite contents, String fieldName, String[] items) {
        List list = new List(contents, 2816);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        list.setLayoutData((Object)data);
        list.setToolTipText(this.getResourceString(String.valueOf(fieldName) + ".hint"));
        list.setItems(items);
        list.select(this.getIndex());
        list.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ControlWindow.this.setIndex(((List)e.widget).getSelectionIndex());
            }

            public void widgetSelected(SelectionEvent e) {
                ControlWindow.this.setIndex(((List)e.widget).getSelectionIndex());
            }
        });
        return list;
    }

    public Text createText(Composite contents, String fieldName, Object value, boolean readOnly) {
        Label label = new Label(contents, 16384);
        GridData dataLabel = new GridData(768);
        dataLabel.horizontalSpan = 2;
        dataLabel.horizontalAlignment = 4;
        dataLabel.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)dataLabel);
        label.setText(this.getResourceString(fieldName));
        Text text = readOnly ? new Text(contents, 2056) : new Text(contents, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        text.setToolTipText(this.getResourceString(String.valueOf(fieldName) + ".hint"));
        text.setText(String.valueOf(value));
        return text;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public String[] getButtonNames() {
        return new String[]{"items"};
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Map getControls() {
        return this.controls;
    }

    public Text getCountText() {
        return this.countText;
    }

    public Object getData() {
        return this.data;
    }

    public Text getDataText() {
        return this.dataText;
    }

    public int getIndex() {
        return this.index;
    }

    public String[] getItems() {
        return this.items;
    }

    public String getResourceString(String string) {
        return Messages.getString(string);
    }

    public Text getTimestampText() {
        return this.timestampText;
    }

    public Text getTimeText() {
        return this.timeText;
    }

    public void open() {
        Shell shell = this.getParent();
        ControlService control = this.getBridge().getControl();
        StringBuffer buffer = new StringBuffer(512);
        String key = control.getKey();
        buffer.append(key);
        if (control instanceof Control) {
            String externalKey = ((Control)control).getQualifiedKey();
            buffer.append(' ');
            buffer.append('(');
            buffer.append(externalKey);
            buffer.append(')');
        }
        shell.setText(buffer.toString());
        Shell composite = shell;
        GridLayout layout = new GridLayout(6, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        GridData data = new GridData();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.createDialogArea((Composite)shell);
        shell.pack(true);
        shell.layout(true);
        shell.open();
        this.saveGif();
    }

    public void put(String key, org.eclipse.swt.widgets.Control control) {
        this.controls.put(key, control);
    }

    public void refresh() {
        this.updateValues();
    }

    public void saveGif() {
        String filename = "test";
        Shell shell = this.getParent();
        ImageLoader imageLoader = new ImageLoader();
        Display display = Display.getDefault();
        Point size = shell.getSize();
        Point location = shell.getLocation();
        ImageData iimageData = new ImageData(size.x, size.y, 24, new PaletteData(255, 65280, 0xFF0000));
        Image image = new Image((Device)display, iimageData);
        GC displayGC = new GC((Drawable)display);
        displayGC.copyArea(image, location.x, location.y);
        imageLoader.data = new ImageData[]{image.getImageData()};
        imageLoader.save(String.valueOf(filename.toLowerCase()) + ".jpeg", 4);
    }

    public void setBridge(Bridge bridge) {
        this.bridge = bridge;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setControls(Map controls) {
        this.controls = controls;
    }

    public void setCountText(Text countText) {
        this.countText = countText;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setDataText(Text dataText) {
        this.dataText = dataText;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setItems(String[] items) {
        this.items = items;
    }

    public void setTimestampText(Text timestampText) {
        this.timestampText = timestampText;
    }

    public void setTimeText(Text timeText) {
        this.timeText = timeText;
    }

    public void updateValues() {
        long count = this.getBridge().getCount();
        this.getCountText().setText(Long.toString(count));
        long timestamp = this.getBridge().getTimstamp();
        long timestampBaseline = this.getBridge().getParent().getTimestamp();
        String timestampString = timestamp > 0L ? Nls.formatTimestamp((long)timestamp) : "";
        this.getTimestampText().setText(timestampString);
        String timeString = timestamp > 0L ? Long.toString(timestamp - timestampBaseline) : "";
        this.getTimeText().setText(timeString);
        Object data = this.getBridge().getData();
        this.getDataText().setText(Nls.formatData((Object)data));
    }
}

