/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.gpio.profile.test.agent;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileAbstractTestCase;
import org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileTestAgent;
import org.eclipse.soda.dk.testagent.TestAgent;

public class GpioProfileInputTestCase
extends GpioProfileAbstractTestCase {
    static /* synthetic */ Class class$0;

    public GpioProfileInputTestCase(String name) {
        super(name);
    }

    public static void main(String[] arguments) {
        String[] stringArray = new String[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.gpio.profile.test.agent.GpioProfileInputTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        TestAgent.main((String[])stringArray);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.waitForProfileStart("GpioProfile");
    }

    public void test000_SwitchAllOn() throws InterruptedException, IOException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        if (inputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= inputCount) {
            Boolean v = Boolean.TRUE;
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7502))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test010_SwitchAllOff() throws InterruptedException, IOException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        if (inputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i <= inputCount) {
            Boolean v = Boolean.FALSE;
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7503))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test020_SwitchFirstOn() throws InterruptedException, IOException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        if (inputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        expectedValue.put(new String("i1"), Boolean.TRUE);
        int i = 2;
        while ((long)i <= inputCount) {
            Boolean v = Boolean.FALSE;
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7504))));
        Map changeValue = this.getInputSignal();
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)changeValue);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test030_SwitchFirstOff() throws InterruptedException, IOException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        if (inputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        expectedValue.put(new String("i1"), Boolean.FALSE);
        int i = 2;
        while ((long)i <= inputCount) {
            Boolean v = Boolean.TRUE;
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7505))));
        Map changeValue = this.getInputSignal();
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)changeValue);
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test040_SwitchLastOn() throws InterruptedException, IOException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        if (inputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i < inputCount) {
            Boolean v = Boolean.FALSE;
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        expectedValue.put(new String("i" + inputCount), Boolean.TRUE);
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7506))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }

    public void test050_SwitchLastOff() throws InterruptedException, IOException {
        long inputCount = Long.parseLong(this.getMeasurement(this.gpioProfileServiceInputCountExternalKey).toString());
        if (inputCount < 1L) {
            return;
        }
        Hashtable<String, Boolean> expectedValue = new Hashtable<String, Boolean>();
        int i = 1;
        while ((long)i < inputCount) {
            Boolean v = Boolean.TRUE;
            expectedValue.put(new String("i" + i), v);
            ++i;
        }
        expectedValue.put(new String("i" + inputCount), Boolean.FALSE);
        GpioProfileInputTestCase.assertEquals((boolean)true, (boolean)this.requestConfirmation(GpioProfileTestAgent.DefaultResourceBundle.getString(Integer.toString(7507))));
        Map realValue = (Map)this.getMeasurement(this.gpioProfileServiceInputExternalKey);
        GpioProfileInputTestCase.assertEquals(expectedValue, (Object)realValue);
    }
}

