/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.platform.validation.test.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.platform.validation.test.checker.ClassLibValidator;
import org.eclipse.soda.dk.platform.validation.test.checker.LogService;
import org.eclipse.soda.dk.platform.validation.test.parser.ClassLibParser;

public class ClassInfoBuilder
extends EscObject
implements LogService {
    private static final int BUILD_FAILED = 7450;
    private static final int CLASSES_VALIDATED = 7455;
    private static final int LOADED_CLASSES = 7453;
    private static final int PARSING_FROM = 7452;
    private static final int PLUGIN_NOT_FOUND = 7454;
    private static final int USAGE = 7451;
    public static ResourceBundle DefaultResourceBundle;
    private String targetPlatformPath;
    private String cinfoOutputPath;
    private ClassLibValidator validator = new ClassLibValidator((LogService)this);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.platform.validation.test.builder.ClassInfoBuilderResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public ClassInfoBuilder(String targetPlatform, String cinfoOutputDir) {
        this.targetPlatformPath = targetPlatform;
        this.cinfoOutputPath = cinfoOutputDir;
    }

    public static void main(String[] arguments) {
        if (arguments.length == 2) {
            ClassInfoBuilder builder = new ClassInfoBuilder(arguments[0], arguments[1]);
            try {
                builder.buildFromJar("ee.foundation11.zip", "ee.foundation11", "java");
                builder.buildFromJar("ee.foundation11.zip", "ee.foundation11-min", "java.");
                builder.buildFromJar("ee.minimum11.zip", "ee.minimum11", "java");
                builder.buildFromPlugin("org.eclipse.osgi", "osgi.r4.core", "org.osgi");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.cm", "org.osgi.service.cm");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.component", "org.osgi.service.component");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.device", "org.osgi.service.device");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.event", "org.osgi.service.event");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.http", "org.osgi.service.http");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.io", "org.osgi.service.io");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.log", "org.osgi.service.log");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.metatype", "org.osgi.service.metatype");
                builder.buildFromPlugin("org.eclipse.equinox.preferences", "osgi.r4.service.prefs", "org.osgi.service.prefs");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.provisioning", "org.osgi.service.provisioning");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.useradmin", "org.osgi.service.useradmin");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.wireadmin", "org.osgi.service.wireadmin");
                builder.buildFromPlugin("org.eclipse.osgi.services", "osgi.r4.service.upnp", "org.osgi.service.upnp");
                builder.buildFromPlugin("org.eclipse.osgi.util", "osgi.r4.util.measurement", "org.osgi.util.measurement");
                builder.buildFromPlugin("org.eclipse.osgi.util", "osgi.r4.util.position", "org.osgi.util.position");
                builder.buildFromPlugin("org.eclipse.osgi.util", "osgi.r4.util.xml", "org.osgi.util.xml");
                builder.buildFromPlugin("javax.servlet", "javax.servlet", "javax");
                builder.buildFromPlugin("org.eclipse.soda.dk.comm", "javax.comm", "javax");
                builder.checkClasses();
            }
            catch (Exception e) {
                builder.log(1, DefaultResourceBundle.getString(Integer.toString(7450)), e);
                e.printStackTrace();
            }
        } else {
            System.err.println(DefaultResourceBundle.getString(Integer.toString(7451)));
        }
    }

    private void buildFromJar(String jarPath, String libName, String packageName) throws IOException, ClassFormatException, ClassNotFoundException {
        Object[] parms = new Object[]{libName, jarPath};
        this.log(3, Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7452)), (Object[])parms));
        List classInfos = this.parseClassLib(jarPath, libName, packageName);
        this.log(3, Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7453)), (Object)Integer.toString(classInfos.size())));
        String cinfoName = String.valueOf(libName) + ".cinfo";
        File cinfoFile = new File(this.cinfoOutputPath, cinfoName);
        FileOutputStream out = new FileOutputStream(cinfoFile);
        this.toOutputStream(classInfos, out);
        out.close();
        this.validator.loadClassLib((InputStream)new FileInputStream(cinfoFile));
    }

    private void buildFromPlugin(String pluginName, String libName, String packageName) throws IOException, ClassFormatException, ClassNotFoundException {
        File pluginsDir = new File(this.targetPlatformPath, "plugins");
        File[] jarFiles = pluginsDir.listFiles();
        String jarPath = null;
        int i = 0;
        while (i < jarFiles.length) {
            String fileName = jarFiles[i].getName();
            if (fileName.startsWith(pluginName) && fileName.endsWith(".jar")) {
                String pathname = jarFiles[i].getCanonicalPath();
                if (jarPath == null || pathname.compareTo(jarPath) > 0) {
                    jarPath = pathname;
                }
            }
            ++i;
        }
        if (jarPath == null) {
            Object[] parms = new Object[]{pluginName, this.targetPlatformPath};
            throw new IOException(Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7454)), (Object[])parms));
        }
        this.buildFromJar(jarPath, libName, packageName);
    }

    private void checkClasses() {
        int passed = this.validator.checkClasses();
        Object[] parms = new Object[]{Integer.toString(passed), Integer.toString(this.validator.getClassCount())};
        this.log(3, Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7455)), (Object[])parms));
    }

    private List parseClassLib(String jarPath, String libName, String packageName) throws IOException, ClassFormatException {
        List list;
        FileInputStream in = new FileInputStream(jarPath);
        ClassLibParser parser = new ClassLibParser((LogService)this);
        try {
            List classInfos;
            list = classInfos = parser.parseClassLib((InputStream)in, packageName);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
        return list;
    }

    private void toOutputStream(List classInfos, OutputStream out) throws IOException {
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        int objCount = classInfos.size();
        objOut.writeInt(objCount);
        Iterator iter = classInfos.iterator();
        while (iter.hasNext()) {
            objOut.writeObject(iter.next());
        }
        objOut.close();
    }
}

