/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.profile;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.adapter.service.AdapterService;
import org.eclipse.soda.dk.command.service.CommandListener;
import org.eclipse.soda.dk.command.service.CommandService;
import org.eclipse.soda.dk.command.service.MultiplexCommandListener;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.device.Device;
import org.eclipse.soda.dk.device.service.ControlService;
import org.eclipse.soda.dk.device.service.DeviceListener;
import org.eclipse.soda.dk.device.service.DeviceService;
import org.eclipse.soda.dk.device.service.MultiplexDeviceListener;
import org.eclipse.soda.dk.measurement.service.MeasurementListener;
import org.eclipse.soda.dk.measurement.service.MeasurementService;
import org.eclipse.soda.dk.measurement.service.MultiplexMeasurementListener;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.profile.ProfileListeners;
import org.eclipse.soda.dk.profile.ProfileResourceBundle;
import org.eclipse.soda.dk.profile.service.MultiplexProfileListener;
import org.eclipse.soda.dk.profile.service.ProfileListener;
import org.eclipse.soda.dk.profile.service.ProfileService;
import org.eclipse.soda.dk.signal.service.MultiplexSignalListener;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.signal.service.SignalService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class Profile
extends Device
implements ProfileService,
MultiplexCommandListener,
MultiplexSignalListener,
MultiplexMeasurementListener,
MultiplexDeviceListener {
    private static ResourceBundle DefaultResourceBundle;
    protected DeviceService device;
    protected ProfileListener profileListener;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.profile.ProfileResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public Profile() {
        super("Profile/Capabilities", "Profile/Status", "Profile/Configuration", "Profile/Metrics", "Profile/Channels", "Profile/ChannelChanged", "Profile/OpenChannel", "Profile/CloseChannel");
    }

    protected Profile(String capabilities, String status, String configuration) {
        super(capabilities, status, configuration, "Profile/Metrics");
    }

    protected Profile(String capabilities, String status, String configuration, String metrics) {
        super(capabilities, status, configuration, metrics);
    }

    protected Profile(String capabilities, String status, String configuration, String metrics, String channels, String channelChanged, String openChannel, String closeChannel) {
        super(capabilities, status, configuration, metrics, channels, channelChanged, openChannel, closeChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProfileListener(ProfileListener profileListener) {
        Map channels;
        Object currentTimestamp = null;
        if (profileListener != null) {
            int state = this.getState();
            currentTimestamp = Profile.getCurrentTimestamp();
            profileListener.profileChanged((ProfileService)this, currentTimestamp, state, state);
        }
        this.setProfileListener(ProfileListeners.add(this.getProfileListener(), profileListener));
        DeviceService device = this.getDevice();
        if (device != null && (channels = (Map)device.getMeasurement("Device/Channels").getValue(null)) != null) {
            Map map = channels;
            synchronized (map) {
                Iterator iterator = channels.values().iterator();
                while (iterator.hasNext()) {
                    ChannelService channel = (ChannelService)iterator.next();
                    if (currentTimestamp == null) {
                        currentTimestamp = Profile.getCurrentTimestamp();
                    }
                    this.channelChanged(device, currentTimestamp, channel, channel.getState(), channel.getState());
                }
            }
        }
    }

    public void channelChanged(DeviceService source, Object timestamp, ChannelService channel, int newState, int oldState) {
        this.channelChanged(timestamp, channel, newState, oldState);
    }

    public void commandExecuted(CommandService source, Object timestamp, ChannelService channel, Object data) {
        if (channel == null) {
            this.commandExecuted(source, timestamp, data);
        }
    }

    public void commandExecuted(CommandService source, Object timestamp, Object data) {
    }

    public void controlAdded(EscObject container, Object currentTimestamp, ControlService control) {
        ProfileListener profileListener = this.getProfileListener();
        if (profileListener != null) {
            profileListener.controlChanged((ProfileService)this, currentTimestamp != null ? currentTimestamp : Profile.getCurrentTimestamp(), control, 1);
        }
    }

    public void controlChanged(DeviceService device, Object timestamp, ControlService control, int code) {
    }

    public void controlRemoved(EscObject container, Object timestamp, ControlService control) {
        ProfileListener profileListener = this.getProfileListener();
        if (profileListener != null) {
            profileListener.controlChanged((ProfileService)this, timestamp != null ? timestamp : Profile.getCurrentTimestamp(), control, 0);
        }
    }

    public void deviceChanged(DeviceService source, Object timestamp, int newState, int oldState) {
        int mystate = this.getState();
        if (mystate != newState) {
            if (mystate > 1) {
                if (newState == 5) {
                    this.restart();
                } else if (newState > 1) {
                    super.setState(newState);
                } else {
                    super.setState(2);
                }
            }
            this.deviceChangedCustom(source, timestamp, newState, oldState);
        }
    }

    public void deviceChangedCustom(DeviceService source, Object timestamp, int newState, int oldState) {
    }

    public void exit() {
        this.removeListeners(this.getDevice());
        this.setDevice(null);
        super.exit();
    }

    public void fireChannelChanged(Object timestamp, ChannelService channel, int newState, int oldState) {
        try {
            MultiplexProfileListener profileListener = this.getMultiplexProfileListener();
            if (profileListener != null) {
                profileListener.channelChanged((ProfileService)this, timestamp, channel, newState, oldState);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 3020, this.getMultiplexProfileListener(), channel);
        }
    }

    public void fireContainerChanged(Object timestamp, int newState, int oldState) {
        try {
            ProfileListener profileListener = this.getProfileListener();
            if (profileListener != null) {
                profileListener.profileChanged((ProfileService)this, timestamp, newState, oldState);
            }
        }
        catch (RuntimeException exception) {
            this.handleError(exception, 3006, this.profileListener);
        }
        this.broadcastStatus(timestamp, newState, oldState);
    }

    public AdapterService getAdapter() {
        return null;
    }

    public Long getAnalogValue(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return Profile.createLong((long)((Number)value).longValue());
        }
        if (value != null) {
            String valueString = value.toString();
            return new Long(valueString);
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public Boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value != null) {
            String valueString = value.toString();
            if (valueString.equals("1") || valueString.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (valueString.equals("0") || valueString.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public DeviceService getDefaultDevice() {
        return null;
    }

    public String getDefaultKey() {
        return "Profile";
    }

    public DeviceService getDevice() {
        return this.device;
    }

    public Object getLogDetails6() {
        return String.valueOf(this.getDevice());
    }

    public Long getLongValue(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return Profile.createLong((long)((Number)value).longValue());
        }
        if (value != null) {
            String valueString = value.toString();
            return Long.valueOf(valueString, 10);
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public MultiplexProfileListener getMultiplexProfileListener() {
        return (MultiplexProfileListener)this.getProfileListener();
    }

    public int getNotificationPriorityDefault() {
        return 5;
    }

    public ProfileListener getProfileListener() {
        return this.profileListener;
    }

    public String getResource(int resourceId) {
        try {
            if (resourceId >= 3000 && resourceId < 4000) {
                return DefaultResourceBundle.getString(ProfileResourceBundle.getKey(resourceId + 2000));
            }
            return DefaultResourceBundle.getString(ProfileResourceBundle.getKey(resourceId));
        }
        catch (RuntimeException runtimeException) {
            return super.getResource(resourceId);
        }
    }

    public TransportService getTransport() {
        DeviceService device = this.getDevice();
        if (device != null) {
            return device.getTransport();
        }
        return super.getTransport();
    }

    public void initialize(String capabilities, String status, String configuration) {
        this.initialize(capabilities, status, configuration, "Profile/Metrics");
    }

    public void initializeCommand(CommandService command) {
        if (command != null) {
            command.addCommandListener((CommandListener)this);
        }
    }

    public void initializeMeasurement(MeasurementService measurement) {
        if (measurement != null) {
            measurement.addMeasurementListener((MeasurementListener)this);
        }
    }

    public void initializeSignal(SignalService signal) {
        if (signal != null) {
            signal.addSignalListener((SignalListener)this);
        }
    }

    public boolean isAdapterNeeded() {
        return this.isDeviceNeeded();
    }

    public boolean isDeviceNeeded() {
        return false;
    }

    public boolean isStarted() {
        return this.getState() >= 5;
    }

    public void measurementChanged(MeasurementService source, Object timestamp, ChannelService channel, Object newValue, Object oldValue) {
        if (channel == null) {
            this.measurementChanged(source, timestamp, newValue, oldValue);
        }
    }

    public void measurementChanged(MeasurementService source, Object timestamp, Object newValue, Object oldValue) {
    }

    public ChannelService openChannel(Map parameters) throws IOException {
        return this.getDevice().openChannel(parameters);
    }

    public void removeDeviceListener(ProfileListener profileListener) {
        this.setProfileListener(ProfileListeners.remove(this.getProfileListener(), profileListener));
    }

    public void removeProfileListener(ProfileListener profileListener) {
        this.setProfileListener(ProfileListeners.remove(this.getProfileListener(), profileListener));
    }

    public void setDevice(DeviceService device) {
        if (this == device) {
            throw new RuntimeException(String.valueOf(device));
        }
        if (this.device != null) {
            this.device.removeDeviceListener((DeviceListener)this);
        }
        this.device = device;
        if (this.device != null) {
            this.device.addDeviceListener((DeviceListener)this);
        }
        this.setDeviceCustom(device);
    }

    public void setDeviceCustom(DeviceService device) {
    }

    public void setProfileListener(ProfileListener profileListener) {
        this.profileListener = profileListener;
    }

    public void setState(int state) {
        if (this.isDeviceNeeded()) {
            int deviceState;
            if (state < 2) {
                super.setState(state);
                return;
            }
            DeviceService device = this.getDevice();
            if (device != null && (deviceState = device.getState()) > 2) {
                AdapterService adapter;
                if (this.isAdapterNeeded() && (adapter = this.getAdapter()) != null) {
                    int adapterState = adapter.getState();
                    if (adapterState > 2) {
                        super.setState(deviceState);
                        return;
                    }
                    super.setState(2);
                    return;
                }
                super.setState(deviceState);
                return;
            }
            super.setState(2);
        } else {
            super.setState(state);
        }
    }

    public void setup() {
        super.setup();
        if (this.getDevice() == null) {
            this.setDevice(this.getDefaultDevice());
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, ChannelService channel, Object data) {
        if (channel == null) {
            this.signalOccurred(source, timestamp, data);
        }
    }

    public void signalOccurred(SignalService source, Object timestamp, Object data) {
    }
}

