/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller.remote.rmi;

import java.io.IOException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Dictionary;
import org.eclipse.soda.dk.testcontroller.remote.rmi.LocalTestRunListener;
import org.eclipse.soda.dk.testcontroller.remote.rmi.LocalTestSession;
import org.eclipse.soda.dk.testcontroller.remote.rmi.RemoteTestSession;
import org.eclipse.soda.dk.testcontroller.remote.rmi.TestConfigurationSkeleton;
import org.eclipse.soda.dk.testcontroller.service.TestConfigurationService;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.osgi.framework.InvalidSyntaxException;

public class TestSessionSkeleton
extends UnicastRemoteObject
implements LocalTestSession,
RemoteTestSession {
    private static final long serialVersionUID = 4188753784229563055L;
    private TestSessionService delegate;
    private TestConfigurationService wrappedConfigurationService;

    public TestSessionSkeleton(TestSessionService delegate) throws IOException {
        this.delegate = delegate;
        this.wrappedConfigurationService = new TestConfigurationSkeleton(delegate.getTestConfigurationService());
    }

    public void addGlobalTestRunListener(TestRunListenerService globalRunListener) throws IOException {
        this.delegate.addGlobalTestRunListener(globalRunListener);
    }

    public void addGlobalTestRunListener(LocalTestRunListener globalRunListener) throws IOException {
        this.delegate.addGlobalTestRunListener((TestRunListenerService)globalRunListener);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public TestConfigurationService getTestConfigurationService() throws IOException {
        return this.wrappedConfigurationService;
    }

    public void interrupt() throws IOException {
        this.delegate.interrupt();
    }

    public boolean isInterrupted() throws IOException {
        return this.delegate.isInterrupted();
    }

    public void removeGlobalTestRunListener(TestRunListenerService globalRunListener) throws IOException {
        this.delegate.removeGlobalTestRunListener(globalRunListener);
    }

    public void removeGlobalTestRunListener(LocalTestRunListener globalRunListener) throws IOException {
        this.delegate.removeGlobalTestRunListener((TestRunListenerService)globalRunListener);
    }

    public void runMultipleTests(String actionId, String runId, String filter, String className, Dictionary properties, TestRunListenerService runListener) throws InvalidSyntaxException, IOException {
        this.delegate.runMultipleTests(actionId, runId, filter, className, properties, runListener);
    }

    public void runMultipleTests(String actionId, String runId, String filter, String className, Dictionary properties, LocalTestRunListener runListener) throws InvalidSyntaxException, IOException {
        this.delegate.runMultipleTests(actionId, runId, filter, className, properties, (TestRunListenerService)runListener);
    }

    public void runSingleTest(String actionId, String runId, String filter, String className, Dictionary properties, TestRunListenerService runListener) throws InvalidSyntaxException, IOException {
        this.delegate.runSingleTest(actionId, runId, filter, className, properties, runListener);
    }

    public void runSingleTest(String actionId, String runId, String filter, String className, Dictionary properties, LocalTestRunListener runListener) throws InvalidSyntaxException, IOException {
        this.delegate.runSingleTest(actionId, runId, filter, className, properties, (TestRunListenerService)runListener);
    }
}

