/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.eclipse.soda.sat.core.framework.interfaces.ILineReader;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.LogUtility;

public class LineReader
implements ILineReader {
    private static final int EIGHT_K_BYTES = 8192;
    private static final String UTF8_CHARACTER_ENCODING = "UTF-8";
    private static final String DEFAULT_CHARACTER_ENCODING = System.getProperty("file.encoding", "UTF-8");
    private BufferedReader bufferedReader;
    private String nextLine;
    private ILineReader.IAdvisor advisor;

    private static ILineReader.IAdvisor createAdvisor() {
        return new ILineReader.IAdvisor(){

            public boolean isValid(String line) {
                return true;
            }

            public String transform(String line) {
                return line;
            }
        };
    }

    public LineReader(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public LineReader(InputStream inputStream, ILineReader.IAdvisor advisor) {
        this(inputStream, 8192, advisor);
    }

    public LineReader(InputStream inputStream, int size) {
        this(inputStream, DEFAULT_CHARACTER_ENCODING, size);
    }

    public LineReader(InputStream inputStream, int size, ILineReader.IAdvisor advisor) {
        this(inputStream, DEFAULT_CHARACTER_ENCODING, size, advisor);
    }

    public LineReader(InputStream inputStream, String characterEncoding) {
        this(inputStream, characterEncoding, 8192);
    }

    public LineReader(InputStream inputStream, String characterEncoding, ILineReader.IAdvisor advisor) {
        this(inputStream, characterEncoding, 8192, advisor);
    }

    public LineReader(InputStream inputStream, String characterEncoding, int size) {
        this(inputStream, characterEncoding, size, LineReader.createAdvisor());
    }

    public LineReader(InputStream inputStream, String characterEncoding, int size, ILineReader.IAdvisor advisor) {
        this.setBufferedReader(this.createBufferedReader(inputStream, characterEncoding, size));
        this.setAdvisor(advisor);
    }

    private String basicReadLine() throws IOException {
        BufferedReader bufferedReader = this.getBufferedReader();
        String line = bufferedReader.readLine();
        return line;
    }

    public void close() throws IOException {
        BufferedReader bufferedReader = this.getBufferedReader();
        bufferedReader.close();
    }

    private BufferedReader createBufferedReader(InputStream inputStream, String characterEncoding, int size) {
        InputStreamReader inputStreamReader;
        Assertion.checkArgumentIsNotNull(inputStream, "inputStream");
        Assertion.checkArgumentIsNotNull(characterEncoding, "characterEncoding");
        try {
            inputStreamReader = new InputStreamReader(inputStream, characterEncoding);
        }
        catch (UnsupportedEncodingException exception) {
            String message = exception.getMessage();
            LogUtility.logError(this, message, exception);
            inputStreamReader = new InputStreamReader(inputStream);
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, size);
        return bufferedReader;
    }

    private ILineReader.IAdvisor getAdvisor() {
        return this.advisor;
    }

    private BufferedReader getBufferedReader() {
        return this.bufferedReader;
    }

    private String getNextLine() {
        return this.nextLine;
    }

    private boolean hasMoreLines() {
        String line = null;
        try {
            line = this.readLine();
            this.setNextLine(line);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        boolean result = line != null;
        return result;
    }

    public Enumeration lines() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return LineReader.this.hasMoreLines();
            }

            public Object nextElement() {
                return LineReader.this.getNextLine();
            }
        };
    }

    public String readLine() throws IOException {
        String line = null;
        boolean valid = false;
        ILineReader.IAdvisor advisor = this.getAdvisor();
        while ((line = this.basicReadLine()) != null && !(valid = advisor.isValid(line))) {
        }
        if (line != null) {
            line = advisor.transform(line);
        }
        return line;
    }

    private void setAdvisor(ILineReader.IAdvisor advisor) {
        Assertion.checkArgumentIsNotNull(advisor, "advisor");
        this.advisor = advisor;
    }

    private void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    private void setNextLine(String nextLine) {
        this.nextLine = nextLine;
    }
}

