/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.record.ExportProxyServiceRecord;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.eclipse.soda.sat.core.util.MessageFormatter;

public class MiscUtility {
    private static final String CANNOT_CONVERT_TO_PRIMITIVE_KEY = "MiscUtility.CannotConvertToPrimitive";
    private static final MiscUtility INSTANCE = new MiscUtility();

    public static MiscUtility getInstance() {
        return INSTANCE;
    }

    private MiscUtility() {
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        Assertion.checkArgumentIsNotNull(key, "key");
        boolean value = defaultValue;
        String propertyValue = System.getProperty(key);
        if (propertyValue != null) {
            if (propertyValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
                value = true;
            } else if (propertyValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                value = false;
            } else {
                String type = Boolean.TYPE.getName();
                this.logCannotConvertToPrimitiveError(key, propertyValue, type);
            }
        }
        return value;
    }

    public int getIntProperty(String key, int defaultValue) {
        Assertion.checkArgumentIsNotNull(key, "key");
        int value = defaultValue;
        String propertyValue = System.getProperty(key);
        if (propertyValue != null) {
            try {
                value = Integer.valueOf(propertyValue, 10);
            }
            catch (NumberFormatException numberFormatException) {
                String type = Integer.TYPE.getName();
                this.logCannotConvertToPrimitiveError(key, propertyValue, type);
            }
        }
        return value;
    }

    public long getLongProperty(String key, long defaultValue) {
        Assertion.checkArgumentIsNotNull(key, "key");
        long value = defaultValue;
        String propertyValue = System.getProperty(key);
        if (propertyValue != null) {
            try {
                value = Long.valueOf(propertyValue, 10);
            }
            catch (NumberFormatException numberFormatException) {
                String type = Long.TYPE.getName();
                this.logCannotConvertToPrimitiveError(key, propertyValue, type);
            }
        }
        return value;
    }

    private void logCannotConvertToPrimitiveError(String key, String value, String type) {
        String pattern = Messages.getString(CANNOT_CONVERT_TO_PRIMITIVE_KEY);
        Object[] values = new Object[]{key, value, type};
        String message = MessageFormatter.format(pattern, values);
        LogUtility.logError(this, message);
    }

    public Object unwrapExportedServiceProxy(Object serviceProxy) throws IllegalArgumentException {
        Object object = ExportProxyServiceRecord.unwrapProxy(serviceProxy);
        return object;
    }
}

